/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes.scopes;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.statements.BreakStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ContinueStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ForEachStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ForStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.WhileStatement;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.scopes.Breakable;
import de.fraunhofer.aisec.cpg.passes.scopes.Continuable;
import de.fraunhofer.aisec.cpg.passes.scopes.ValueDeclarationScope;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001fB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0014H\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\bR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000b\"\u0004\b\u0019\u0010\u0012\u00a8\u0006 "}, d2={"Lde/fraunhofer/aisec/cpg/passes/scopes/LoopScope;", "Lde/fraunhofer/aisec/cpg/passes/scopes/ValueDeclarationScope;", "Lde/fraunhofer/aisec/cpg/passes/scopes/Breakable;", "Lde/fraunhofer/aisec/cpg/passes/scopes/Continuable;", "loopStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/Statement;", "(Lde/fraunhofer/aisec/cpg/graph/statements/Statement;)V", "breakStatements", "", "Lde/fraunhofer/aisec/cpg/graph/statements/BreakStatement;", "getBreakStatements", "()Ljava/util/List;", "breaks", "", "conditions", "Lde/fraunhofer/aisec/cpg/graph/Node;", "getConditions", "setConditions", "(Ljava/util/List;)V", "continueStatements", "Lde/fraunhofer/aisec/cpg/graph/statements/ContinueStatement;", "getContinueStatements", "continues", "starts", "getStarts", "setStarts", "addBreakStatement", "", "breakStatement", "addContinueStatement", "continueStatement", "Companion", "cpg-core"})
public final class LoopScope
extends ValueDeclarationScope
implements Breakable,
Continuable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<? extends Node> starts;
    @NotNull
    private List<? extends Node> conditions;
    @NotNull
    private final List<BreakStatement> breaks;
    @NotNull
    private final List<ContinueStatement> continues;
    private static final Logger LOGGER = LoggerFactory.getLogger(LoopScope.class);

    public LoopScope(@NotNull Statement loopStatement) {
        Intrinsics.checkNotNullParameter((Object)loopStatement, (String)"loopStatement");
        super(loopStatement);
        this.starts = new ArrayList();
        this.conditions = new ArrayList();
        this.breaks = new ArrayList();
        this.continues = new ArrayList();
    }

    @NotNull
    public final List<Node> getStarts() {
        return this.starts;
    }

    public final void setStarts(@NotNull List<? extends Node> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.starts = list2;
    }

    @NotNull
    public final List<Node> getConditions() {
        return this.conditions;
    }

    public final void setConditions(@NotNull List<? extends Node> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.conditions = list2;
    }

    @Override
    public void addBreakStatement(@NotNull BreakStatement breakStatement) {
        Intrinsics.checkNotNullParameter((Object)breakStatement, (String)"breakStatement");
        this.breaks.add(breakStatement);
    }

    @Override
    public void addContinueStatement(@NotNull ContinueStatement continueStatement) {
        Intrinsics.checkNotNullParameter((Object)continueStatement, (String)"continueStatement");
        this.continues.add(continueStatement);
    }

    @Override
    @NotNull
    public List<BreakStatement> getBreakStatements() {
        return this.breaks;
    }

    @Override
    @NotNull
    public List<ContinueStatement> getContinueStatements() {
        return this.continues;
    }

    @NotNull
    public final List<Node> starts() {
        List<Node> list2;
        Node node = this.getAstNode();
        if (node instanceof WhileStatement) {
            Node node2 = this.getAstNode();
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.WhileStatement");
            WhileStatement ws = (WhileStatement)node2;
            if (ws.getConditionDeclaration() != null) {
                List<Node> list3 = SubgraphWalker.getEOGPathEdges(ws.getConditionDeclaration()).getEntries();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"getEOGPathEdges(ws.conditionDeclaration).entries");
                return list3;
            }
            if (ws.getCondition() != null) {
                List<Node> list4 = SubgraphWalker.getEOGPathEdges(ws.getCondition()).getEntries();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"getEOGPathEdges(ws.condition).entries");
                return list4;
            }
            List<Node> list5 = SubgraphWalker.getEOGPathEdges(ws.getStatement()).getEntries();
            Intrinsics.checkNotNullExpressionValue(list5, (String)"{\n                val ws\u2026nt).entries\n            }");
            list2 = list5;
        } else if (node instanceof ForStatement) {
            Node node3 = this.getAstNode();
            Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.ForStatement");
            ForStatement fs = (ForStatement)node3;
            if (fs.getConditionDeclaration() != null) {
                List<Node> list6 = SubgraphWalker.getEOGPathEdges(fs.getConditionDeclaration()).getEntries();
                Intrinsics.checkNotNullExpressionValue(list6, (String)"getEOGPathEdges(fs.conditionDeclaration).entries");
                return list6;
            }
            if (fs.getCondition() != null) {
                List<Node> list7 = SubgraphWalker.getEOGPathEdges(fs.getCondition()).getEntries();
                Intrinsics.checkNotNullExpressionValue(list7, (String)"getEOGPathEdges(fs.condition).entries");
                return list7;
            }
            List<Node> list8 = SubgraphWalker.getEOGPathEdges(fs.getStatement()).getEntries();
            Intrinsics.checkNotNullExpressionValue(list8, (String)"{\n                val fs\u2026nt).entries\n            }");
            list2 = list8;
        } else if (node instanceof ForEachStatement) {
            Node node4 = this.getAstNode();
            Intrinsics.checkNotNull((Object)node4, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.ForEachStatement");
            ForEachStatement fs = (ForEachStatement)node4;
            List<Node> list9 = SubgraphWalker.getEOGPathEdges(fs).getEntries();
            Intrinsics.checkNotNullExpressionValue(list9, (String)"{\n                val fs\u2026fs).entries\n            }");
            list2 = list9;
        } else if (node instanceof DoStatement) {
            Node node5 = this.getAstNode();
            Intrinsics.checkNotNull((Object)node5, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.DoStatement");
            List<Node> list10 = SubgraphWalker.getEOGPathEdges(((DoStatement)node5).getStatement()).getEntries();
            Intrinsics.checkNotNullExpressionValue(list10, (String)"{\n                Subgra\u2026nt).entries\n            }");
            list2 = list10;
        } else {
            Node node6 = this.getAstNode();
            Intrinsics.checkNotNull((Object)node6);
            LOGGER.error("Currently the component {} is not supported as loop scope.", node6.getClass());
            list2 = new ArrayList();
        }
        return list2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fraunhofer/aisec/cpg/passes/scopes/LoopScope$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

