/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes.order;

import de.fraunhofer.aisec.cpg.ConfigurationException;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.order.PassWithDependencies;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bJ\u0018\u0010\r\u001a\u00020\b2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0002J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0016J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0016J\u0018\u0010\u0019\u001a\u00020\n2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/fraunhofer/aisec/cpg/passes/order/PassWithDepsContainer;", "", "()V", "isEmpty", "", "()Z", "workingList", "", "Lde/fraunhofer/aisec/cpg/passes/order/PassWithDependencies;", "addMissingDependencies", "", "addToWorkingList", "newElement", "createNewPassWithDependency", "cls", "Ljava/lang/Class;", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "dependencyPresent", "dep", "getAndRemoveFirstPass", "getAndRemoveFirstPassWithoutDependencies", "getFirstPasses", "", "getLastPasses", "getWorkingList", "removeDependencyByClass", "size", "", "toString", "", "cpg-core"})
public final class PassWithDepsContainer {
    @NotNull
    private final List<PassWithDependencies> workingList = new ArrayList();

    @NotNull
    public final List<PassWithDependencies> getWorkingList() {
        return this.workingList;
    }

    public final void addToWorkingList(@NotNull PassWithDependencies newElement) {
        Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
        this.workingList.add(newElement);
    }

    public final boolean isEmpty() {
        return this.workingList.isEmpty();
    }

    public final int size() {
        return this.workingList.size();
    }

    private final void removeDependencyByClass(Class<? extends Pass> cls) {
        Iterator<PassWithDependencies> iterator = this.workingList.iterator();
        while (iterator.hasNext()) {
            Set<Class<? extends Pass>> value = iterator.next().component2();
            value.remove(cls);
        }
    }

    @NotNull
    public String toString() {
        return this.workingList.toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PassWithDependencies> getFirstPasses() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.workingList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PassWithDependencies it = (PassWithDependencies)element$iv$iv;
            boolean bl = false;
            Boolean bl2 = it.getPass().isFirstPass();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"it.pass.isFirstPass");
            if (!bl2.booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PassWithDependencies> getLastPasses() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.workingList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PassWithDependencies it = (PassWithDependencies)element$iv$iv;
            boolean bl = false;
            Boolean bl2 = it.getPass().isLastPass();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"it.pass.isLastPass");
            if (!bl2.booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean dependencyPresent(Class<? extends Pass> dep) {
        boolean result = false;
        for (PassWithDependencies currentElement : this.workingList) {
            if (!Intrinsics.areEqual(dep, currentElement.getPass().getClass())) continue;
            result = true;
            break;
        }
        return result;
    }

    private final PassWithDependencies createNewPassWithDependency(Class<? extends Pass> cls) {
        Pass pass;
        try {
            pass = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException(e);
        }
        Pass newPass = pass;
        Set deps = new HashSet();
        Set<Class<? extends Pass>> set = newPass.getHardDependencies();
        Intrinsics.checkNotNullExpressionValue(set, (String)"newPass.hardDependencies");
        deps.addAll((Collection)set);
        Set<Class<? extends Pass>> set2 = newPass.getSoftDependencies();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"newPass.softDependencies");
        deps.addAll((Collection)set2);
        Intrinsics.checkNotNullExpressionValue((Object)newPass, (String)"newPass");
        return new PassWithDependencies(newPass, deps);
    }

    public final void addMissingDependencies() {
        ListIterator<PassWithDependencies> it = this.workingList.listIterator();
        while (it.hasNext()) {
            PassWithDependencies current = it.next();
            for (Class clazz : current.getPass().getHardDependencies()) {
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"dependency");
                if (this.dependencyPresent(clazz)) continue;
                Pass.log.info("Registering a required hard dependency which was not registered explicitly: {}", (Object)clazz);
                it.add(this.createNewPassWithDependency(clazz));
            }
        }
        List missingPasses = new ArrayList();
        for (PassWithDependencies passWithDependencies : this.workingList) {
            for (Class<? extends Pass> dependency : passWithDependencies.getPass().getHardDependencies()) {
                Intrinsics.checkNotNullExpressionValue(dependency, (String)"dependency");
                if (this.dependencyPresent(dependency)) continue;
                missingPasses.add(dependency);
            }
        }
    }

    @Nullable
    public final Pass getAndRemoveFirstPassWithoutDependencies() {
        Pass result = null;
        for (PassWithDependencies currentElement : this.workingList) {
            if (this.workingList.size() > 1) {
                Boolean bl = currentElement.getPass().isLastPass();
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"currentElement.pass.isLastPass");
                if (bl.booleanValue()) continue;
            }
            if (!currentElement.getDependencies().isEmpty()) continue;
            result = currentElement.getPass();
            this.removeDependencyByClass(result.getClass());
            this.workingList.remove(currentElement);
            break;
        }
        return result;
    }

    @Nullable
    public final Pass getAndRemoveFirstPass() {
        Pass pass;
        List<PassWithDependencies> firstPasses = this.getFirstPasses();
        if (firstPasses.size() > 1) {
            String string = "More than one pass requires to be run as first pass: {}";
            Object[] objectArray = new Object[]{firstPasses};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            throw new ConfigurationException(string2);
        }
        if (!((Collection)firstPasses).isEmpty()) {
            PassWithDependencies firstPass = (PassWithDependencies)CollectionsKt.first(firstPasses);
            Set<Class<? extends Pass>> set = firstPass.getPass().getHardDependencies();
            Intrinsics.checkNotNullExpressionValue(set, (String)"firstPass.pass.hardDependencies");
            if (!((Collection)set).isEmpty()) {
                throw new ConfigurationException("The first pass has a hard dependency.");
            }
            this.removeDependencyByClass(firstPass.getPass().getClass());
            this.workingList.remove(firstPass);
            pass = firstPass.getPass();
        } else {
            pass = null;
        }
        return pass;
    }
}

