/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.InferenceConfiguration;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.ExtensionsKt;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumConstantDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.SymbolResolverPass;
import de.fraunhofer.aisec.cpg.passes.TypeHierarchyResolver;
import de.fraunhofer.aisec.cpg.passes.order.DependsOn;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DependsOn(value=TypeHierarchyResolver.class)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\"\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010 \u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\u00142\b\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006&"}, d2={"Lde/fraunhofer/aisec/cpg/passes/VariableUsageResolver;", "Lde/fraunhofer/aisec/cpg/passes/SymbolResolverPass;", "()V", "accept", "", "result", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "getEnclosingTypeOf", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "current", "Lde/fraunhofer/aisec/cpg/graph/Node;", "handleUnknownField", "Lde/fraunhofer/aisec/cpg/graph/declarations/FieldDeclaration;", "base", "name", "", "type", "handleUnknownFunction", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "declarationHolder", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "fctPtrType", "Lde/fraunhofer/aisec/cpg/graph/types/FunctionPointerType;", "resolveBase", "Lde/fraunhofer/aisec/cpg/graph/declarations/Declaration;", "reference", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/DeclaredReferenceExpression;", "resolveFieldUsages", "curClass", "resolveFunctionPtr", "Lde/fraunhofer/aisec/cpg/graph/declarations/ValueDeclaration;", "containingClassArg", "resolveLocalVarUsage", "currentClass", "parent", "resolveMember", "containingClass", "Companion", "cpg-core"})
public class VariableUsageResolver
extends SymbolResolverPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(VariableUsageResolver.class);

    @Override
    public void accept(@NotNull TranslationResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (this.lang == null) {
            log.error("No language frontend specified. Can't resolve anything.");
            return;
        }
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        this.scopeManager = languageFrontend.getScopeManager();
        LanguageFrontend languageFrontend2 = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend2);
        this.config = languageFrontend2.getConfig();
        this.setWalker(new SubgraphWalker.ScopedWalker(this.scopeManager));
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            Intrinsics.checkNotNullExpressionValue((Object)tu, (String)"tu");
            this.setCurrentTU(tu);
            this.getWalker().clearCallbacks();
            this.getWalker().registerHandler((arg_0, arg_1, arg_2) -> VariableUsageResolver.accept$lambda$0(this, arg_0, arg_1, arg_2));
            this.getWalker().registerHandler((arg_0, arg_1) -> VariableUsageResolver.accept$lambda$1(this, arg_0, arg_1));
            this.getWalker().registerHandler((arg_0, arg_1) -> VariableUsageResolver.accept$lambda$2(this, arg_0, arg_1));
            this.getWalker().iterate(this.getCurrentTU());
        }
        this.collectSupertypes();
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            this.getWalker().clearCallbacks();
            this.getWalker().registerHandler((arg_0, arg_1, arg_2) -> VariableUsageResolver.accept$lambda$3(this, arg_0, arg_1, arg_2));
            this.getWalker().iterate(tu);
        }
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            this.getWalker().clearCallbacks();
            this.getWalker().registerHandler(this::resolveLocalVarUsage);
            this.getWalker().iterate(tu);
        }
    }

    private final ValueDeclaration resolveFunctionPtr(Type containingClassArg, DeclaredReferenceExpression reference) {
        Type containingClass = containingClassArg;
        Type type = reference.getType();
        FunctionPointerType functionPointerType = type instanceof FunctionPointerType ? (FunctionPointerType)type : null;
        if (functionPointerType == null) {
            return null;
        }
        FunctionPointerType fptrType = functionPointerType;
        String functionName = reference.getName();
        Matcher matcher = Pattern.compile("(?:(?<class>.*)(?:\\.|::))?(?<function>.*)").matcher(reference.getName());
        if (matcher.matches()) {
            String cls = matcher.group("class");
            String string = matcher.group("function");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(\"function\")");
            functionName = string;
            if (cls == null) {
                log.error("Resolution of pointers to functions inside the current scope should have been done by the ScopeManager");
            } else {
                containingClass = TypeParser.createFrom(cls, true);
            }
        }
        return this.handleUnknownFunction(containingClass != null ? this.getRecordMap().get(containingClass.getTypeName()) : (RecordDeclaration)null, functionName, fptrType);
    }

    private final void resolveLocalVarUsage(RecordDeclaration currentClass, Node parent, Node current) {
        ValueDeclaration field;
        if (!(current instanceof DeclaredReferenceExpression) || current instanceof MemberExpression) {
            return;
        }
        if (parent instanceof MemberCallExpression && current == ((MemberCallExpression)parent).getMember() && !(((DeclaredReferenceExpression)current).getType() instanceof FunctionPointerType)) {
            return;
        }
        if (parent instanceof CallExpression && ((CallExpression)parent).getCallee() == current) {
            return;
        }
        Declaration declaration = ((DeclaredReferenceExpression)current).getRefersTo();
        if (declaration == null) {
            ScopeManager scopeManager = this.scopeManager;
            declaration = scopeManager != null ? ScopeManager.resolveReference$default(scopeManager, (DeclaredReferenceExpression)current, null, 2, null) : null;
        }
        Declaration refersTo = declaration;
        Type recordDeclType = null;
        if (currentClass != null) {
            recordDeclType = TypeParser.createFrom(currentClass.getName(), true);
        }
        if (((DeclaredReferenceExpression)current).getType() instanceof FunctionPointerType && refersTo == null) {
            refersTo = this.resolveFunctionPtr(recordDeclType, (DeclaredReferenceExpression)current);
        }
        if (refersTo == null && !((DeclaredReferenceExpression)current).isStaticAccess() && recordDeclType != null && this.getRecordMap().containsKey(recordDeclType.getTypeName())) {
            if (StringsKt.contains$default((CharSequence)current.getName(), (CharSequence)this.getDelimiter(current), (boolean)false, (int)2, null)) {
                recordDeclType = this.getEnclosingTypeOf(current);
            }
            if ((field = this.resolveMember(recordDeclType, (DeclaredReferenceExpression)current)) != null) {
                refersTo = field;
            }
        }
        if (refersTo == null && StringsKt.contains$default((CharSequence)current.getName(), (CharSequence)this.getDelimiter(current), (boolean)false, (int)2, null) && (field = this.resolveMember(recordDeclType = this.getEnclosingTypeOf(current), (DeclaredReferenceExpression)current)) != null) {
            refersTo = field;
        }
        if (refersTo != null) {
            ((DeclaredReferenceExpression)current).setRefersTo(refersTo);
        } else {
            Util.warnWithFileLocation(current, log, "Did not find a declaration for " + current.getName(), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Type getEnclosingTypeOf(Node current) {
        void $this$toTypedArray$iv;
        List list2;
        Collection $this$dropLastWhile$iv;
        Object object = current.getName();
        String string = Pattern.quote(this.getDelimiter(current));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"quote(current.delimiter)");
        String string2 = string;
        string2 = new Regex(string2);
        int n = 0;
        object = string2.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list2;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] stringArray2 = stringArray;
        List path = CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray2, stringArray2.length));
        Type type = TypeParser.createFrom(String.join((CharSequence)this.getDelimiter(current), path.subList(0, path.size() - 1)), true);
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"createFrom(\n            \u2026           true\n        )");
        return type;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void resolveFieldUsages(RecordDeclaration curClass, Node current) {
        block19: {
            Declaration baseTarget;
            block22: {
                DeclaredReferenceExpression base;
                block20: {
                    block21: {
                        if (!(current instanceof MemberExpression)) {
                            return;
                        }
                        baseTarget = null;
                        if (!(((MemberExpression)current).getBase() instanceof DeclaredReferenceExpression)) break block19;
                        Expression expression = ((MemberExpression)current).getBase();
                        Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression");
                        base = (DeclaredReferenceExpression)expression;
                        if (!(this.getLanguage(current) instanceof JavaLanguageFrontend) || !Intrinsics.areEqual((Object)base.getName(), (Object)"super")) break block20;
                        if (curClass == null) break block21;
                        List<Type> list2 = curClass.getSuperClasses();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"curClass.superClasses");
                        if (!(!((Collection)list2).isEmpty())) break block21;
                        Type superType = curClass.getSuperClasses().get(0);
                        RecordDeclaration superRecord = this.getRecordMap().get(superType.getTypeName());
                        if (superRecord == null) {
                            log.error("Could not find referring super type " + superType.getTypeName() + " for " + curClass.getName() + " in the record map. Will set the super type to java.lang.Object");
                            base.setType(TypeParser.createFrom(Object.class.getName(), true));
                            break block22;
                        } else {
                            FunctionDeclaration func;
                            ScopeManager scopeManager = this.scopeManager;
                            FunctionDeclaration functionDeclaration = func = scopeManager != null ? scopeManager.getCurrentFunction() : null;
                            if (func instanceof MethodDeclaration) {
                                baseTarget = ((MethodDeclaration)func).getReceiver();
                            }
                            if (baseTarget != null) {
                                base.setRefersTo(baseTarget);
                                base.setType(superType);
                                base.updatePossibleSubtypes(CollectionsKt.listOf((Object)superType));
                            }
                        }
                        break block22;
                    }
                    Type type = TypeParser.createFrom(Object.class.getName(), true);
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"createFrom(Any::class.java.name, true)");
                    Type objectType = type;
                    base.setType(objectType);
                    break block22;
                }
                Expression expression = ((MemberExpression)current).getBase();
                Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression");
                baseTarget = this.resolveBase((DeclaredReferenceExpression)expression);
                base.setRefersTo(baseTarget);
            }
            if (baseTarget instanceof EnumDeclaration) {
                Object v7;
                block16: {
                    String name2 = current.getName();
                    List<EnumConstantDeclaration> list3 = ((EnumDeclaration)baseTarget).getEntries();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"baseTarget.entries");
                    Iterable $this$firstOrNull$iv = list3;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        EnumConstantDeclaration it = (EnumConstantDeclaration)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                        v7 = element$iv;
                        break block16;
                    }
                    v7 = null;
                }
                EnumConstantDeclaration memberTarget = v7;
                if (memberTarget != null) {
                    ((MemberExpression)current).setRefersTo(memberTarget);
                    return;
                }
            } else if (baseTarget instanceof RecordDeclaration) {
                Type type = TypeParser.createFrom(((RecordDeclaration)baseTarget).getName(), true);
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"createFrom(baseTarget.name, true)");
                Type baseType = type;
                if (!this.getRecordMap().containsKey(baseType.getTypeName())) {
                    Object v9;
                    block17: {
                        Type containingT = baseType;
                        Iterable $this$firstOrNull$iv = this.getRecordMap().keySet();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            if (!StringsKt.endsWith$default((String)it, (String)("." + containingT.getName()), (boolean)false, (int)2, null)) continue;
                            v9 = element$iv;
                            break block17;
                        }
                        v9 = null;
                    }
                    String fqnResolvedType = v9;
                    if (fqnResolvedType != null) {
                        Type type2 = TypeParser.createFrom(fqnResolvedType, true);
                        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"createFrom(fqnResolvedType, true)");
                        baseType = type2;
                    }
                }
                ((MemberExpression)current).setRefersTo(this.resolveMember(baseType, (DeclaredReferenceExpression)current));
                return;
            }
        }
        Type baseType = null;
        baseType = ((MemberExpression)current).getBase().getType();
        if (!this.getRecordMap().containsKey(baseType.getTypeName())) {
            Object v11;
            block18: {
                Iterable $this$firstOrNull$iv = this.getRecordMap().keySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.endsWith$default((String)it, (String)("." + baseType.getName()), (boolean)false, (int)2, null)) continue;
                    v11 = element$iv;
                    break block18;
                }
                v11 = null;
            }
            String fqnResolvedType = v11;
            if (fqnResolvedType != null) {
                baseType = TypeParser.createFrom(fqnResolvedType, true);
            }
        }
        MemberExpression memberExpression = (MemberExpression)current;
        Type type = baseType;
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"baseType");
        memberExpression.setRefersTo(this.resolveMember(type, (DeclaredReferenceExpression)current));
    }

    private final Declaration resolveBase(DeclaredReferenceExpression reference) {
        ValueDeclaration declaration;
        ScopeManager scopeManager = this.scopeManager;
        ValueDeclaration valueDeclaration = declaration = scopeManager != null ? ScopeManager.resolveReference$default(scopeManager, reference, null, 2, null) : null;
        if (declaration != null) {
            return declaration;
        }
        return this.getEnumMap().containsKey(reference.getType()) ? (Declaration)this.getEnumMap().get(reference.getType()) : (this.getRecordMap().containsKey(reference.getType().getTypeName()) ? (Declaration)this.getRecordMap().get(reference.getType().getTypeName()) : (Declaration)null);
    }

    /*
     * WARNING - void declaration
     */
    private final ValueDeclaration resolveMember(Type containingClass, DeclaredReferenceExpression reference) {
        ValueDeclaration valueDeclaration;
        Collection collection;
        void $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Iterable $this$map$iv;
        boolean $i$f$map;
        Object it;
        Iterable $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Collection destination$iv$iv;
        Iterable $this$filter$iv;
        boolean $i$f$filter;
        CharSequence charSequence;
        if (this.getLanguage(reference) instanceof JavaLanguageFrontend && new Regex("(?<class>.+\\.)?super").matches(charSequence = (CharSequence)reference.getName())) {
            return null;
        }
        String simpleName = Util.getSimpleName(this.getDelimiter(reference), reference.getName());
        FieldDeclaration member = null;
        if (!(containingClass instanceof UnknownType) && this.getRecordMap().containsKey(containingClass.getTypeName())) {
            RecordDeclaration recordDeclaration = this.getRecordMap().get(containingClass.getTypeName());
            Intrinsics.checkNotNull((Object)recordDeclaration);
            List<FieldDeclaration> list2 = recordDeclaration.getFields();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"recordMap[containingClas\u2026                  .fields");
            Iterable iterable = list2;
            $i$f$filter = false;
            void var7_7 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (FieldDeclaration)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((Node)it).getName(), (Object)simpleName)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (FieldDeclaration)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((FieldDeclaration)it).getDefinition());
            }
            member = (FieldDeclaration)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        }
        if (member == null) {
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Map<String, List<Type>> map = this.getSuperTypesMap();
            String string = containingClass.getTypeName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"containingClass.typeName");
            $this$map$iv = map.getOrDefault(string, CollectionsKt.emptyList());
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            it = $this$forEach$iv$iv$iv.iterator();
            while (it.hasNext()) {
                RecordDeclaration it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it.next();
                boolean bl = false;
                Type it2 = (Type)element$iv$iv;
                boolean bl2 = false;
                if (this.getRecordMap().get(it2.getTypeName()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (RecordDeclaration)element$iv$iv;
                boolean bl = false;
                List<FieldDeclaration> list3 = ((RecordDeclaration)it).getFields();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"it.fields");
                Iterable list$iv$iv = list3;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (FieldDeclaration)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((Node)it).getName(), (Object)simpleName)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (FieldDeclaration)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((FieldDeclaration)it).getDefinition());
            }
            member = (FieldDeclaration)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        }
        FieldDeclaration fieldDeclaration = member;
        if (fieldDeclaration != null) {
            valueDeclaration = fieldDeclaration;
        } else {
            String string = reference.getName();
            Type type = reference.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"reference.type");
            valueDeclaration = this.handleUnknownField(containingClass, string, type);
        }
        return valueDeclaration;
    }

    private final FieldDeclaration handleUnknownField(Type base, String name2, Type type) {
        FieldDeclaration fieldDeclaration;
        Object v4;
        RecordDeclaration recordDeclaration;
        block7: {
            if (base instanceof PointerType) {
                Type type2 = ((PointerType)base).getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"base.elementType");
                return this.handleUnknownField(type2, name2, type);
            }
            if (!this.getRecordMap().containsKey(base.getTypeName())) {
                Object object = this.config;
                if (!(object != null && (object = ((TranslationConfiguration)object).getInferenceConfiguration()) != null ? ((InferenceConfiguration)object).getInferRecords() : false)) {
                    return null;
                }
                String string = base.getTypeName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"base.typeName");
                this.inferRecordDeclaration(base, string, "struct");
            }
            if ((recordDeclaration = this.getRecordMap().get(base.getTypeName())) == null) {
                log.error("There is no matching record in the record map. Can't identify which field is used.");
                return null;
            }
            List<FieldDeclaration> list2 = recordDeclaration.getFields();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"recordDeclaration.fields");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FieldDeclaration it = (FieldDeclaration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                v4 = element$iv;
                break block7;
            }
            v4 = null;
        }
        FieldDeclaration target = v4;
        if (target != null) {
            fieldDeclaration = target;
        } else {
            FieldDeclaration declaration = NodeBuilder.newFieldDeclaration$default(name2, type, CollectionsKt.emptyList(), "", null, null, false, null, null, 384, null);
            recordDeclaration.addField(declaration);
            declaration.setInferred(true);
            fieldDeclaration = declaration;
        }
        return fieldDeclaration;
    }

    private final FunctionDeclaration handleUnknownFunction(RecordDeclaration declarationHolder, String name2, FunctionPointerType fctPtrType) {
        FunctionDeclaration target;
        FunctionDeclaration functionDeclaration;
        FunctionDeclaration functionDeclaration2;
        FunctionDeclaration f;
        boolean $i$f$firstOrNull;
        Iterable $this$firstOrNull$iv;
        if (declarationHolder != null) {
            Object v3;
            block6: {
                List<MethodDeclaration> list2 = declarationHolder.getMethods();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"declarationHolder.methods");
                $this$firstOrNull$iv = list2;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    f = (MethodDeclaration)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
                    Type type = fctPtrType.getReturnType();
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"fctPtrType.returnType");
                    List<Type> list3 = fctPtrType.getParameters();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"fctPtrType.parameters");
                    if (!this.matches(f, name2, type, list3)) continue;
                    v3 = element$iv;
                    break block6;
                }
                v3 = null;
            }
            functionDeclaration2 = v3;
        } else {
            Object v7;
            block7: {
                $this$firstOrNull$iv = ExtensionsKt.getFunctions(this.getCurrentTU());
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    f = (FunctionDeclaration)element$iv;
                    boolean bl = false;
                    Type type = fctPtrType.getReturnType();
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"fctPtrType.returnType");
                    List<Type> list4 = fctPtrType.getParameters();
                    Intrinsics.checkNotNullExpressionValue(list4, (String)"fctPtrType.parameters");
                    if (!this.matches(f, name2, type, list4)) continue;
                    v7 = element$iv;
                    break block7;
                }
                v7 = null;
            }
            functionDeclaration2 = v7;
        }
        if ((functionDeclaration = (target = functionDeclaration2)) == null) {
            RecordDeclaration recordDeclaration = declarationHolder;
            if (recordDeclaration == null) {
                recordDeclaration = null;
            }
            List<Type> list5 = fctPtrType.getParameters();
            Intrinsics.checkNotNullExpressionValue(list5, (String)"fctPtrType.parameters");
            functionDeclaration = this.createInferredFunctionDeclaration(recordDeclaration, name2, null, false, list5, fctPtrType.getReturnType());
        }
        return functionDeclaration;
    }

    private static final void accept$lambda$0(VariableUsageResolver this$0, RecordDeclaration recordDeclaration, Node node, Node currNode) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getWalker().collectDeclarations(currNode);
    }

    private static final void accept$lambda$1(VariableUsageResolver this$0, Node node, RecordDeclaration recordDeclaration) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
        this$0.findRecords(node);
    }

    private static final void accept$lambda$2(VariableUsageResolver this$0, Node node, RecordDeclaration recordDeclaration) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
        this$0.findEnums(node);
    }

    private static final void accept$lambda$3(VariableUsageResolver this$0, RecordDeclaration curClass, Node node, Node node2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node");
        this$0.resolveFieldUsages(curClass, node2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fraunhofer/aisec/cpg/passes/VariableUsageResolver$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

