/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0004J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0004J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001cH\u0004J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0012\u0010\"\u001a\u00020\u000f2\b\u0010#\u001a\u0004\u0018\u00010!H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lde/fraunhofer/aisec/cpg/passes/TypeHierarchyResolver;", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "()V", "enums", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/EnumDeclaration;", "getEnums", "()Ljava/util/List;", "recordMap", "", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "getRecordMap", "()Ljava/util/Map;", "accept", "", "translationResult", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "analyzeOverridingMethods", "declaration", "allMethodsFromSupertypes", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/MethodDeclaration;", "cleanup", "findRecordsAndEnums", "node", "Lde/fraunhofer/aisec/cpg/graph/Node;", "findSupertypeRecords", "", "recordDecl", "getAllMethodsFromSupertypes", "supertypeRecords", "getLang", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "setLang", "lang", "cpg-core"})
public class TypeHierarchyResolver
extends Pass {
    @NotNull
    private final Map<String, RecordDeclaration> recordMap = new LinkedHashMap();
    @NotNull
    private final List<EnumDeclaration> enums = new ArrayList();

    @NotNull
    protected final Map<String, RecordDeclaration> getRecordMap() {
        return this.recordMap;
    }

    @NotNull
    protected final List<EnumDeclaration> getEnums() {
        return this.enums;
    }

    @Override
    @Nullable
    public LanguageFrontend getLang() {
        return null;
    }

    @Override
    public void setLang(@Nullable LanguageFrontend lang) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void accept(@NotNull TranslationResult translationResult) {
        Intrinsics.checkNotNullParameter((Object)translationResult, (String)"translationResult");
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            Intrinsics.checkNotNullExpressionValue((Object)tu, (String)"tu");
            this.findRecordsAndEnums(tu);
        }
        for (RecordDeclaration recordDecl : this.recordMap.values()) {
            Set<RecordDeclaration> supertypeRecords = this.findSupertypeRecords(recordDecl);
            List<MethodDeclaration> allMethodsFromSupertypes = this.getAllMethodsFromSupertypes(supertypeRecords);
            this.analyzeOverridingMethods(recordDecl, allMethodsFromSupertypes);
        }
        for (EnumDeclaration enumDecl : this.enums) {
            void $this$mapTo$iv$iv;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            List<Type> list2 = enumDecl.getSuperTypes();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"enumDecl.superTypes");
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Iterable<RecordDeclaration> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                RecordDeclaration it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Type s = (Type)element$iv$iv;
                boolean bl2 = false;
                if (this.recordMap.get(s.toString()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Set directSupertypeRecords = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv = directSupertypeRecords;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                element$iv$iv$iv = (RecordDeclaration)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(this.findSupertypeRecords((RecordDeclaration)it));
            }
            Set allSupertypes = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv2)));
            enumDecl.setSuperTypeDeclarations(allSupertypes);
        }
        List<TranslationUnitDeclaration> list3 = translationResult.getTranslationUnits();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"translationResult.translationUnits");
        Iterable $this$forEach$iv = list3;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TranslationUnitDeclaration it = (TranslationUnitDeclaration)element$iv;
            boolean bl = false;
            SubgraphWalker.refreshType(it);
        }
    }

    protected final void findRecordsAndEnums(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        node.accept(TypeHierarchyResolver::findRecordsAndEnums$lambda$3, new IVisitor<Node>(this){
            final /* synthetic */ TypeHierarchyResolver this$0;
            {
                this.this$0 = $receiver;
            }

            public void visit(@NotNull Node child) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                if (child instanceof RecordDeclaration) {
                    this.this$0.getRecordMap().putIfAbsent(child.getName(), (RecordDeclaration)child);
                } else if (child instanceof EnumDeclaration) {
                    this.this$0.getEnums().add((EnumDeclaration)child);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<MethodDeclaration> getAllMethodsFromSupertypes(@NotNull Set<? extends RecordDeclaration> supertypeRecords) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(supertypeRecords, (String)"supertypeRecords");
        Iterable $this$map$iv = supertypeRecords;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RecordDeclaration recordDeclaration = (RecordDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMethods());
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Set<RecordDeclaration> findSupertypeRecords(@NotNull RecordDeclaration recordDecl) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)recordDecl, (String)"recordDecl");
        List<Type> list2 = recordDecl.getSuperTypes();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"recordDecl.superTypes");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RecordDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Type it = (Type)element$iv$iv;
            boolean bl2 = false;
            if (this.recordMap.get(it.getTypeName()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set superTypeDeclarations = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        recordDecl.setSuperTypeDeclarations(superTypeDeclarations);
        return superTypeDeclarations;
    }

    /*
     * WARNING - void declaration
     */
    protected final void analyzeOverridingMethods(@NotNull RecordDeclaration declaration, @NotNull List<? extends MethodDeclaration> allMethodsFromSupertypes) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(allMethodsFromSupertypes, (String)"allMethodsFromSupertypes");
        for (MethodDeclaration methodDeclaration : allMethodsFromSupertypes) {
            void $this$filterTo$iv$iv;
            List<MethodDeclaration> list2 = declaration.getMethods();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"declaration.methods");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MethodDeclaration it = (MethodDeclaration)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!methodDeclaration.isOverrideCandidate(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List overrideCandidates = (List)destination$iv$iv;
            methodDeclaration.addOverriddenBy(overrideCandidates);
            Iterable $this$forEach$iv = overrideCandidates;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MethodDeclaration it = (MethodDeclaration)element$iv;
                boolean bl = false;
                it.addOverrides(methodDeclaration);
            }
        }
    }

    @Override
    public void cleanup() {
    }

    private static final Iterator findRecordsAndEnums$lambda$3(Node it) {
        return Strategy.AST_FORWARD(it);
    }
}

