/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.ClassTemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TypeParamDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.TypeExpression;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a@\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u001a$\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\f\u001a*\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\f\u00a8\u0006\u000e"}, d2={"addRecursiveDefaultTemplateArgs", "", "constructExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ConstructExpression;", "template", "Lde/fraunhofer/aisec/cpg/graph/declarations/ClassTemplateDeclaration;", "applyMissingParams", "templateParametersExplicitInitialization", "", "Lde/fraunhofer/aisec/cpg/graph/Node;", "templateParameterRealDefaultInitialization", "handleDefaultTemplateParameters", "", "handleExplicitTemplateParameters", "cpg-core"})
public final class TemplateCallResolverHelperKt {
    public static final void addRecursiveDefaultTemplateArgs(@NotNull ConstructExpression constructExpression, @NotNull ClassTemplateDeclaration template) {
        Intrinsics.checkNotNullParameter((Object)constructExpression, (String)"constructExpression");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        int templateParameters = 0;
        do {
            templateParameters = constructExpression.getTemplateParameters().size();
            Map templateParametersExplicitInitialization = new LinkedHashMap();
            TemplateCallResolverHelperKt.handleExplicitTemplateParameters(constructExpression, template, templateParametersExplicitInitialization);
            Map templateParameterRealDefaultInitialization = new LinkedHashMap();
            TemplateCallResolverHelperKt.handleDefaultTemplateParameters(template, templateParameterRealDefaultInitialization);
            TemplateCallResolverHelperKt.applyMissingParams(template, constructExpression, templateParametersExplicitInitialization, templateParameterRealDefaultInitialization);
        } while (templateParameters != constructExpression.getTemplateParameters().size());
    }

    public static final void handleExplicitTemplateParameters(@NotNull ConstructExpression constructExpression, @NotNull ClassTemplateDeclaration template, @NotNull Map<Node, Node> templateParametersExplicitInitialization) {
        Intrinsics.checkNotNullParameter((Object)constructExpression, (String)"constructExpression");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter(templateParametersExplicitInitialization, (String)"templateParametersExplicitInitialization");
        int n = constructExpression.getTemplateParameters().size();
        for (int i = 0; i < n; ++i) {
            Map<Node, Node> map;
            Node explicit = constructExpression.getTemplateParameters().get(i);
            if (template.getParameters().get(i) instanceof TypeParamDeclaration) {
                Type type;
                map = templateParametersExplicitInitialization;
                Declaration declaration = template.getParameters().get(i);
                Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.TypeParamDeclaration");
                Intrinsics.checkNotNullExpressionValue((Object)((TypeParamDeclaration)declaration).getType(), (String)"template.parameters[i] a\u2026ypeParamDeclaration).type");
                map.put(type, explicit);
                continue;
            }
            if (!(template.getParameters().get(i) instanceof ParamVariableDeclaration)) continue;
            map = templateParametersExplicitInitialization;
            Declaration declaration = template.getParameters().get(i);
            Intrinsics.checkNotNullExpressionValue((Object)declaration, (String)"template.parameters[i]");
            map.put(declaration, explicit);
        }
    }

    public static final void applyMissingParams(@NotNull ClassTemplateDeclaration template, @NotNull ConstructExpression constructExpression, @NotNull Map<Node, ? extends Node> templateParametersExplicitInitialization, @NotNull Map<Node, ? extends Node> templateParameterRealDefaultInitialization) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)constructExpression, (String)"constructExpression");
        Intrinsics.checkNotNullParameter(templateParametersExplicitInitialization, (String)"templateParametersExplicitInitialization");
        Intrinsics.checkNotNullParameter(templateParameterRealDefaultInitialization, (String)"templateParameterRealDefaultInitialization");
        List<Node> missingParams = template.getParameterDefaults().subList(constructExpression.getTemplateParameters().size(), template.getParameterDefaults().size());
        for (Node m : missingParams) {
            TypeExpression typeExpression;
            Node missingParam = m;
            if (missingParam instanceof DeclaredReferenceExpression) {
                Declaration declaration = ((DeclaredReferenceExpression)missingParam).getRefersTo();
                Intrinsics.checkNotNull((Object)declaration);
                missingParam = declaration;
            }
            if (templateParametersExplicitInitialization.containsKey(missingParam)) {
                Node node = templateParametersExplicitInitialization.get(missingParam);
                Intrinsics.checkNotNull((Object)node);
                constructExpression.addTemplateParameter(node, TemplateDeclaration.TemplateInitialization.DEFAULT);
                if (!(templateParametersExplicitInitialization.get(missingParam) instanceof TypeExpression)) continue;
                Type type = constructExpression.getType();
                Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.types.ObjectType");
                typeExpression = (TypeExpression)templateParametersExplicitInitialization.get(missingParam);
                ((ObjectType)type).addGeneric(typeExpression != null ? typeExpression.getType() : null);
                continue;
            }
            if (!templateParameterRealDefaultInitialization.containsKey(missingParam)) continue;
            Node node = templateParameterRealDefaultInitialization.get(missingParam);
            Intrinsics.checkNotNull((Object)node);
            constructExpression.addTemplateParameter(node, TemplateDeclaration.TemplateInitialization.DEFAULT);
            if (!(templateParametersExplicitInitialization.get(missingParam) instanceof Type)) continue;
            Type type = constructExpression.getType();
            Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.types.ObjectType");
            typeExpression = (TypeExpression)templateParametersExplicitInitialization.get(missingParam);
            ((ObjectType)type).addGeneric(typeExpression != null ? typeExpression.getType() : null);
        }
    }

    public static final void handleDefaultTemplateParameters(@NotNull ClassTemplateDeclaration template, @NotNull Map<Node, Node> templateParameterRealDefaultInitialization) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter(templateParameterRealDefaultInitialization, (String)"templateParameterRealDefaultInitialization");
        List declaredTemplateTypes = new ArrayList();
        List declaredNonTypeTemplate = new ArrayList();
        List<Declaration> parametersWithDefaults = template.getParametersWithDefaults();
        for (Declaration declaration : template.getParameters()) {
            if (declaration instanceof TypeParamDeclaration) {
                Type type;
                declaredTemplateTypes.add(((TypeParamDeclaration)declaration).getType());
                if (declaredTemplateTypes.contains(((TypeParamDeclaration)declaration).getDefault()) || !parametersWithDefaults.contains(declaration)) continue;
                Map<Node, Node> map = templateParameterRealDefaultInitialization;
                Intrinsics.checkNotNullExpressionValue((Object)((TypeParamDeclaration)declaration).getType(), (String)"declaration.type");
                Type type2 = ((TypeParamDeclaration)declaration).getDefault();
                map.put(type, type2);
                continue;
            }
            if (!(declaration instanceof ParamVariableDeclaration)) continue;
            declaredNonTypeTemplate.add(declaration);
            if (!parametersWithDefaults.contains(declaration)) continue;
            if (((ParamVariableDeclaration)declaration).getDefault() instanceof DeclaredReferenceExpression) {
                DeclaredReferenceExpression declaredReferenceExpression = (DeclaredReferenceExpression)((ParamVariableDeclaration)declaration).getDefault();
                if (CollectionsKt.contains((Iterable)declaredNonTypeTemplate, (Object)(declaredReferenceExpression != null ? declaredReferenceExpression.getRefersTo() : null))) continue;
            }
            templateParameterRealDefaultInitialization.put(declaration, ((ParamVariableDeclaration)declaration).getDefault());
        }
    }
}

