/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.types.IncompleteType;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020*H\u0004JF\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u00112\b\u0010/\u001a\u0004\u0018\u00010\u00102\b\u00100\u001a\u0004\u0018\u00010\u00102\u0006\u00101\u001a\u0002022\u000e\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00142\b\u00104\u001a\u0004\u0018\u00010\u000bJ\u0010\u00105\u001a\u00020*2\u0006\u00106\u001a\u00020\"H\u0004J\u0010\u00107\u001a\u00020*2\u0006\u00106\u001a\u00020\"H\u0004J\u0010\u00108\u001a\u00020*2\u0006\u00106\u001a\u00020\"H\u0004J$\u00109\u001a\u0004\u0018\u00010\u00112\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u00102\b\b\u0002\u0010<\u001a\u00020\u0010H\u0004J\u001c\u0010=\u001a\u000202*\u00020-2\u0006\u0010/\u001a\u00020\u00102\u0006\u0010>\u001a\u00020?H\u0004J,\u0010=\u001a\u000202*\u00020-2\u0006\u0010/\u001a\u00020\u00102\u0006\u00104\u001a\u00020\u000b2\u000e\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0014H\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR&\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00140\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0015\u0010!\u001a\u00020\u0010*\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0015\u0010%\u001a\u00020&*\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006@"}, d2={"Lde/fraunhofer/aisec/cpg/passes/SymbolResolverPass;", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "()V", "currentTU", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "getCurrentTU", "()Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "setCurrentTU", "(Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;)V", "enumMap", "", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "Lde/fraunhofer/aisec/cpg/graph/declarations/EnumDeclaration;", "getEnumMap", "()Ljava/util/Map;", "recordMap", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "getRecordMap", "superTypesMap", "", "getSuperTypesMap", "templateList", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/TemplateDeclaration;", "getTemplateList", "()Ljava/util/List;", "walker", "Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$ScopedWalker;", "getWalker", "()Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$ScopedWalker;", "setWalker", "(Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$ScopedWalker;)V", "delimiter", "Lde/fraunhofer/aisec/cpg/graph/Node;", "getDelimiter", "(Lde/fraunhofer/aisec/cpg/graph/Node;)Ljava/lang/String;", "language", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "getLanguage", "(Lde/fraunhofer/aisec/cpg/graph/Node;)Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "cleanup", "", "collectSupertypes", "createInferredFunctionDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "containingRecord", "name", "code", "isStatic", "", "signature", "returnType", "findEnums", "node", "findRecords", "findTemplates", "inferRecordDeclaration", "type", "recordToUpdate", "kind", "matches", "fctPtrType", "Lde/fraunhofer/aisec/cpg/graph/types/FunctionPointerType;", "cpg-core"})
public abstract class SymbolResolverPass
extends Pass {
    protected SubgraphWalker.ScopedWalker walker;
    public TranslationUnitDeclaration currentTU;
    @NotNull
    private final Map<String, RecordDeclaration> recordMap = new LinkedHashMap();
    @NotNull
    private final Map<Type, EnumDeclaration> enumMap = new LinkedHashMap();
    @NotNull
    private final List<TemplateDeclaration> templateList = new ArrayList();
    @NotNull
    private final Map<String, List<Type>> superTypesMap = new LinkedHashMap();

    @NotNull
    protected final SubgraphWalker.ScopedWalker getWalker() {
        SubgraphWalker.ScopedWalker scopedWalker = this.walker;
        if (scopedWalker != null) {
            return scopedWalker;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"walker");
        return null;
    }

    protected final void setWalker(@NotNull SubgraphWalker.ScopedWalker scopedWalker) {
        Intrinsics.checkNotNullParameter((Object)scopedWalker, (String)"<set-?>");
        this.walker = scopedWalker;
    }

    @NotNull
    public final TranslationUnitDeclaration getCurrentTU() {
        TranslationUnitDeclaration translationUnitDeclaration = this.currentTU;
        if (translationUnitDeclaration != null) {
            return translationUnitDeclaration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentTU");
        return null;
    }

    public final void setCurrentTU(@NotNull TranslationUnitDeclaration translationUnitDeclaration) {
        Intrinsics.checkNotNullParameter((Object)translationUnitDeclaration, (String)"<set-?>");
        this.currentTU = translationUnitDeclaration;
    }

    @NotNull
    public final Map<String, RecordDeclaration> getRecordMap() {
        return this.recordMap;
    }

    @NotNull
    protected final Map<Type, EnumDeclaration> getEnumMap() {
        return this.enumMap;
    }

    @NotNull
    protected final List<TemplateDeclaration> getTemplateList() {
        return this.templateList;
    }

    @NotNull
    protected final Map<String, List<Type>> getSuperTypesMap() {
        return this.superTypesMap;
    }

    protected final void findRecords(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof RecordDeclaration) {
            Type type = TypeParser.createFrom(node.getName(), true);
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"createFrom(node.name, true)");
            Type type2 = type;
            this.recordMap.putIfAbsent(type2.getTypeName(), (RecordDeclaration)node);
        }
    }

    protected final void findEnums(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof EnumDeclaration) {
            Type type = TypeParser.createFrom(node.getName(), true);
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"createFrom(node.name, true)");
            Type type2 = type;
            this.enumMap.putIfAbsent(type2, (EnumDeclaration)node);
        }
    }

    protected final void findTemplates(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof TemplateDeclaration) {
            this.templateList.add((TemplateDeclaration)node);
        }
    }

    protected final boolean matches(@NotNull FunctionDeclaration $this$matches, @NotNull String name2, @NotNull FunctionPointerType fctPtrType) {
        Intrinsics.checkNotNullParameter((Object)$this$matches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fctPtrType, (String)"fctPtrType");
        Type type = fctPtrType.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"fctPtrType.returnType");
        List<Type> list2 = fctPtrType.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"fctPtrType.parameters");
        return this.matches($this$matches, name2, type, list2);
    }

    protected final boolean matches(@NotNull FunctionDeclaration $this$matches, @NotNull String name2, @NotNull Type returnType, @NotNull List<? extends Type> signature2) {
        Intrinsics.checkNotNullParameter((Object)$this$matches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter(signature2, (String)"signature");
        Type thisReturnType = $this$matches.getReturnTypes().isEmpty() ? (Type)new IncompleteType() : $this$matches.getReturnTypes().get(0);
        return Intrinsics.areEqual((Object)$this$matches.getName(), (Object)name2) && Intrinsics.areEqual((Object)thisReturnType, (Object)returnType) && $this$matches.hasSignature(signature2);
    }

    /*
     * WARNING - void declaration
     */
    protected final void collectSupertypes() {
        void $this$mapValuesTo$iv$iv;
        Map<String, RecordDeclaration> $this$mapValues$iv = this.recordMap;
        boolean $i$f$mapValues = false;
        Map<String, RecordDeclaration> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            RecordDeclaration value = (RecordDeclaration)entry2.getValue();
            List<Type> list2 = value.getSuperTypes();
            map3.put(k, list2);
        }
        Map currSuperTypes = destination$iv$iv;
        this.superTypesMap.putAll(currSuperTypes);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FunctionDeclaration createInferredFunctionDeclaration(@Nullable RecordDeclaration containingRecord, @Nullable String name2, @Nullable String code, boolean isStatic, @NotNull List<? extends Type> signature2, @Nullable Type returnType) {
        FunctionDeclaration functionDeclaration;
        DeclarationHolder declarationHolder;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(signature2, (String)"signature");
        Iterable iterable = signature2;
        String string = name2;
        Logger logger = Pass.log;
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Type type = (Type)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            collection.add(v0 != null ? v0.getName() : null);
        }
        collection = (List)destination$iv$iv;
        logger.debug("Inferring a new method declaration " + string + " with parameter types " + (List)collection);
        RecordDeclaration recordDeclaration = containingRecord;
        boolean bl = recordDeclaration != null ? recordDeclaration.isInferred() : false;
        if (bl && Intrinsics.areEqual((Object)containingRecord.getKind(), (Object)"struct")) {
            containingRecord.setKind("class");
        }
        List<ParamVariableDeclaration> parameters2 = Util.createInferredParameters(signature2);
        RecordDeclaration recordDeclaration2 = containingRecord;
        DeclarationHolder declarationHolder2 = declarationHolder = recordDeclaration2 != null ? (DeclarationHolder)recordDeclaration2 : (DeclarationHolder)this.getCurrentTU();
        if (containingRecord != null) {
            functionDeclaration = NodeBuilder.newMethodDeclaration$default(name2, code, isStatic, containingRecord, null, null, 48, null);
        } else {
            String string2 = name2;
            Intrinsics.checkNotNull((Object)string2);
            functionDeclaration = NodeBuilder.newFunctionDeclaration$default(string2, code, null, null, 12, null);
        }
        FunctionDeclaration inferred = functionDeclaration;
        inferred.setInferred(true);
        Intrinsics.checkNotNullExpressionValue(parameters2, (String)"parameters");
        inferred.setParameters(parameters2);
        Type type = returnType;
        if (type != null) {
            Type it = type;
            boolean bl2 = false;
            inferred.setReturnTypes(CollectionsKt.listOf((Object)it));
        }
        inferred.setType(returnType);
        if (declarationHolder instanceof RecordDeclaration) {
            RecordDeclaration recordDeclaration3 = (RecordDeclaration)declarationHolder;
            Intrinsics.checkNotNull((Object)inferred, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration");
            recordDeclaration3.addMethod((MethodDeclaration)inferred);
            if (isStatic) {
                ((RecordDeclaration)declarationHolder).getStaticImports().add(inferred);
            }
        } else {
            declarationHolder.addDeclaration(inferred);
        }
        return inferred;
    }

    @Nullable
    protected final RecordDeclaration inferRecordDeclaration(@NotNull Type type, @NotNull String recordToUpdate, @NotNull String kind) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)recordToUpdate, (String)"recordToUpdate");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (!(type instanceof ObjectType)) {
            Pass.log.error("Trying to infer a record declaration of a non-object type. Not sure what to do? Should we change the type?");
            return null;
        }
        Pass.log.debug("Encountered an unknown record type " + ((ObjectType)type).getTypeName() + " during a call. We are going to infer that record");
        String string = ((ObjectType)type).getTypeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.typeName");
        RecordDeclaration declaration = NodeBuilder.newRecordDeclaration$default(string, kind, "", null, null, 24, null);
        declaration.setInferred(true);
        ((ObjectType)type).setRecordDeclaration(declaration);
        this.recordMap.put(recordToUpdate, declaration);
        this.getCurrentTU().addDeclaration(declaration);
        return declaration;
    }

    public static /* synthetic */ RecordDeclaration inferRecordDeclaration$default(SymbolResolverPass symbolResolverPass, Type type, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: inferRecordDeclaration");
        }
        if ((n & 4) != 0) {
            string2 = "class";
        }
        return symbolResolverPass.inferRecordDeclaration(type, string, string2);
    }

    @Override
    public void cleanup() {
        this.superTypesMap.clear();
        this.recordMap.clear();
        this.enumMap.clear();
        this.templateList.clear();
    }

    @NotNull
    public final String getDelimiter(@NotNull Node $this$delimiter) {
        Intrinsics.checkNotNullParameter((Object)$this$delimiter, (String)"<this>");
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        String string = languageFrontend.getNamespaceDelimiter();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lang!!.namespaceDelimiter");
        return string;
    }

    @NotNull
    public final LanguageFrontend getLanguage(@NotNull Node $this$language) {
        Intrinsics.checkNotNullParameter((Object)$this$language, (String)"<this>");
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        return languageFrontend;
    }
}

