/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.passes.order.DependsOn;
import de.fraunhofer.aisec.cpg.passes.order.ExecuteBefore;
import de.fraunhofer.aisec.cpg.passes.order.ExecuteFirst;
import de.fraunhofer.aisec.cpg.passes.order.ExecuteLast;
import de.fraunhofer.aisec.cpg.passes.order.RequiredFrontend;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Pass
implements Consumer<TranslationResult> {
    protected String name = this.getClass().getName();
    public static final Logger log = LoggerFactory.getLogger(Pass.class);
    private final Set<Class<? extends Pass>> softDependencies;
    private final Set<Class<? extends Pass>> hardDependencies = new HashSet<Class<? extends Pass>>();
    private final Set<Class<? extends Pass>> executeBefore;
    @JsonIgnore
    @Nullable
    protected LanguageFrontend lang;
    @Nullable
    protected ScopeManager scopeManager;
    @Nullable
    protected TranslationConfiguration config;

    public Set<Class<? extends Pass>> getExecuteBefore() {
        return this.executeBefore;
    }

    public void addSoftDependency(Class<? extends Pass> toAdd) {
        this.softDependencies.add(toAdd);
    }

    protected Pass() {
        Annotation[] dependencies;
        this.softDependencies = new HashSet<Class<? extends Pass>>();
        this.executeBefore = new HashSet<Class<? extends Pass>>();
        if (((DependsOn[])this.getClass().getAnnotationsByType(DependsOn.class)).length != 0) {
            dependencies = (DependsOn[])this.getClass().getAnnotationsByType(DependsOn.class);
            for (Annotation d : dependencies) {
                if (d.softDependency()) {
                    this.softDependencies.add(d.value());
                    continue;
                }
                this.hardDependencies.add(d.value());
            }
        }
        if (((ExecuteBefore[])this.getClass().getAnnotationsByType(ExecuteBefore.class)).length != 0) {
            dependencies = (ExecuteBefore[])this.getClass().getAnnotationsByType(ExecuteBefore.class);
            for (Annotation d : dependencies) {
                this.executeBefore.add(d.other());
            }
        }
    }

    @Nullable
    public LanguageFrontend getLang() {
        return this.lang;
    }

    public String getName() {
        return this.name;
    }

    public void setLang(@Nullable LanguageFrontend lang) {
        this.lang = lang;
        if (lang != null) {
            this.scopeManager = lang.getScopeManager();
            this.config = lang.getConfig();
        } else {
            this.scopeManager = null;
            this.config = null;
        }
    }

    public abstract void cleanup();

    public boolean supportsLanguageFrontend(LanguageFrontend lang) {
        return true;
    }

    @NotNull
    public Boolean isLastPass() {
        try {
            return this.getClass().isAnnotationPresent(ExecuteLast.class);
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    public Boolean isFirstPass() {
        try {
            return this.getClass().isAnnotationPresent(ExecuteFirst.class);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Set<Class<? extends Pass>> getSoftDependencies() {
        return this.softDependencies;
    }

    public Set<Class<? extends Pass>> getHardDependencies() {
        return this.hardDependencies;
    }

    public boolean runsWithCurrentFrontend() {
        if (this.getClass().isAnnotationPresent(RequiredFrontend.class)) {
            Class<? extends LanguageFrontend> frontend = this.getClass().getAnnotation(RequiredFrontend.class).value();
            if (this.lang != null) {
                return this.lang.getClass() == frontend;
            }
            return false;
        }
        return true;
    }
}

