/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.TypeHierarchyResolver;
import de.fraunhofer.aisec.cpg.passes.order.DependsOn;
import de.fraunhofer.aisec.cpg.passes.order.RequiredFrontend;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DependsOn(value=TypeHierarchyResolver.class)
@RequiredFrontend(value=JavaLanguageFrontend.class)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lde/fraunhofer/aisec/cpg/passes/JavaExternalTypeHierarchyResolver;", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "()V", "accept", "", "translationResult", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "cleanup", "Companion", "cpg-core"})
public final class JavaExternalTypeHierarchyResolver
extends Pass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaExternalTypeHierarchyResolver.class);

    @Override
    public void accept(@NotNull TranslationResult translationResult) {
        Intrinsics.checkNotNullParameter((Object)translationResult, (String)"translationResult");
        LanguageFrontend languageFrontend = this.lang;
        JavaLanguageFrontend javaLanguageFrontend = languageFrontend instanceof JavaLanguageFrontend ? (JavaLanguageFrontend)languageFrontend : null;
        if (javaLanguageFrontend == null || (javaLanguageFrontend = javaLanguageFrontend.getNativeTypeResolver()) == null) {
            return;
        }
        JavaLanguageFrontend resolver = javaLanguageFrontend;
        TypeManager tm = TypeManager.getInstance();
        for (Type t : new HashSet(tm.getFirstOrderTypes())) {
            SymbolReference symbol = resolver.tryToSolveType(t.getTypeName());
            if (!symbol.isSolved()) continue;
            try {
                List resolvedSuperTypes = ((ResolvedReferenceTypeDeclaration)symbol.getCorrespondingDeclaration()).getAncestors(true);
                for (ResolvedReferenceType anc : resolvedSuperTypes) {
                    Type superType;
                    Intrinsics.checkNotNullExpressionValue((Object)TypeParser.createFrom(anc.getQualifiedName(), false), (String)"createFrom(anc.qualifiedName, false)");
                    superType.setTypeOrigin(Type.Origin.RESOLVED);
                    t.getSuperTypes().add(superType);
                }
            }
            catch (UnsolvedSymbolException e) {
                LOGGER.warn("Could not resolve supertypes of " + symbol.getCorrespondingDeclaration());
            }
        }
    }

    @Override
    public void cleanup() {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fraunhofer/aisec/cpg/passes/JavaExternalTypeHierarchyResolver$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

