/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.CallResolver;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"handleSpecificSupertype", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "Lde/fraunhofer/aisec/cpg/passes/CallResolver;", "curClass", "call", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CallExpression;", "handleSuperCall", "", "cpg-core"})
public final class JavaCallResolverHelperKt {
    public static final void handleSuperCall(@NotNull CallResolver $this$handleSuperCall, @NotNull RecordDeclaration curClass, @NotNull CallExpression call) {
        Intrinsics.checkNotNullParameter((Object)$this$handleSuperCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)curClass, (String)"curClass");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        ScopeManager scopeManager = $this$handleSuperCall.scopeManager;
        Intrinsics.checkNotNull((Object)scopeManager);
        FunctionDeclaration func = scopeManager.getCurrentFunction();
        if (func instanceof MethodDeclaration) {
            DeclaredReferenceExpression declaredReferenceExpression = (DeclaredReferenceExpression)call.getBase();
            if (declaredReferenceExpression != null) {
                declaredReferenceExpression.setRefersTo(((MethodDeclaration)func).getReceiver());
            }
        }
        RecordDeclaration target = null;
        Expression expression = call.getBase();
        Intrinsics.checkNotNull((Object)expression);
        if (Intrinsics.areEqual((Object)expression.getName(), (Object)"super")) {
            List<Type> list2 = curClass.getSuperClasses();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"curClass.superClasses");
            if (!((Collection)list2).isEmpty()) {
                target = $this$handleSuperCall.getRecordMap().get(curClass.getSuperClasses().get(0).getRoot().getTypeName());
            } else {
                Util.warnWithFileLocation(call, CallResolver.Companion.getLOGGER(), "super call without direct superclass! Expected java.lang.Object to be present at least!", new Object[0]);
            }
        } else {
            target = JavaCallResolverHelperKt.handleSpecificSupertype($this$handleSuperCall, curClass, call);
        }
        if (target != null) {
            Type superType = target.toType();
            Expression expression2 = call.getBase();
            Intrinsics.checkNotNull((Object)expression2);
            expression2.setType(superType);
            Expression expression3 = call.getBase();
            Intrinsics.checkNotNull((Object)expression3);
            expression3.updatePossibleSubtypes(CollectionsKt.listOf((Object)superType));
            $this$handleSuperCall.handleMethodCall(target, call);
        }
    }

    @Nullable
    public static final RecordDeclaration handleSpecificSupertype(@NotNull CallResolver $this$handleSpecificSupertype, @NotNull RecordDeclaration curClass, @NotNull CallExpression call) {
        Intrinsics.checkNotNullParameter((Object)$this$handleSpecificSupertype, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)curClass, (String)"curClass");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Expression expression = call.getBase();
        Intrinsics.checkNotNull((Object)expression);
        String string = expression.getName();
        Expression expression2 = call.getBase();
        Intrinsics.checkNotNull((Object)expression2);
        String string2 = string.substring(0, StringsKt.lastIndexOf$default((CharSequence)expression2.getName(), (String)".super", (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String baseName = string2;
        if (curClass.getImplementedInterfaces().contains(TypeParser.createFrom(baseName, true))) {
            return $this$handleSpecificSupertype.getRecordMap().get(baseName);
        }
        RecordDeclaration base = $this$handleSpecificSupertype.getRecordMap().get(baseName);
        if (base != null) {
            List<Type> list2 = base.getSuperClasses();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"base.superClasses");
            if (!((Collection)list2).isEmpty()) {
                return $this$handleSpecificSupertype.getRecordMap().get(base.getSuperClasses().get(0).getRoot().getTypeName());
            }
            Util.warnWithFileLocation(call, CallResolver.Companion.getLOGGER(), "super call without direct superclass! Expected java.lang.Object to be present at least!", new Object[0]);
        }
        return null;
    }
}

