/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumConstantDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.passes.JavaExternalTypeHierarchyResolver;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.TypeHierarchyResolver;
import de.fraunhofer.aisec.cpg.passes.order.DependsOn;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DependsOn.Container(value={@DependsOn(value=TypeHierarchyResolver.class), @DependsOn(value=JavaExternalTypeHierarchyResolver.class, softDependency=true)})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019H\u0004J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0004J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0005H\u0004J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\u0006\u0010\"\u001a\u00020\u000bH\u0004J\u0012\u0010#\u001a\u00020\u000f2\b\u0010$\u001a\u0004\u0018\u00010\u001bH\u0016R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lde/fraunhofer/aisec/cpg/passes/ImportResolver;", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "()V", "importables", "", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/Declaration;", "getImportables", "()Ljava/util/Map;", "records", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "getRecords", "()Ljava/util/List;", "accept", "", "result", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "cleanup", "findImportables", "node", "Lde/fraunhofer/aisec/cpg/graph/Node;", "getDeclarationsForTypeNames", "", "targetTypes", "", "getLang", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "getOrCreateMembers", "Lde/fraunhofer/aisec/cpg/graph/declarations/ValueDeclaration;", "base", "Lde/fraunhofer/aisec/cpg/graph/declarations/EnumDeclaration;", "name", "getStaticImports", "recordDecl", "setLang", "lang", "cpg-core"})
public class ImportResolver
extends Pass {
    @NotNull
    private final List<RecordDeclaration> records = new ArrayList();
    @NotNull
    private final Map<String, Declaration> importables = new HashMap();

    @NotNull
    protected final List<RecordDeclaration> getRecords() {
        return this.records;
    }

    @NotNull
    protected final Map<String, Declaration> getImportables() {
        return this.importables;
    }

    @Override
    @Nullable
    public LanguageFrontend getLang() {
        return null;
    }

    @Override
    public void setLang(@Nullable LanguageFrontend lang) {
    }

    @Override
    public void cleanup() {
        this.records.clear();
        this.importables.clear();
    }

    @Override
    public void accept(@NotNull TranslationResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            Intrinsics.checkNotNullExpressionValue((Object)tu, (String)"tu");
            this.findImportables(tu);
        }
        for (RecordDeclaration recordDecl : this.records) {
            List<String> list2 = recordDecl.getImportStatements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"recordDecl.importStatements");
            Set<Declaration> imports = this.getDeclarationsForTypeNames(list2);
            recordDecl.setImports(imports);
            Set<ValueDeclaration> staticImports = this.getStaticImports(recordDecl);
            recordDecl.setStaticImports(staticImports);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Set<ValueDeclaration> getStaticImports(@NotNull RecordDeclaration recordDecl) {
        Object members;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)recordDecl, (String)"recordDecl");
        List<String> list2 = recordDecl.getStaticImportStatements();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"recordDecl.staticImportStatements");
        Iterable $this$groupBy$iv = list2;
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Boolean key$iv$iv = StringsKt.endsWith$default((String)it, (String)"*", (boolean)false, (int)2, null);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map partitioned = MapsKt.toMutableMap((Map)destination$iv$iv);
        Set staticImports = new LinkedHashSet();
        Pattern importPattern = Pattern.compile("(?<base>.*)\\.(?<member>.*)");
        List list3 = (List)partitioned.get(false);
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        for (String specificStaticImport : list3) {
            Matcher matcher = importPattern.matcher(specificStaticImport);
            if (!matcher.matches()) continue;
            Declaration base = this.importables.get(matcher.group("base"));
            members = SetsKt.emptySet();
            if (base instanceof RecordDeclaration) {
                RecordDeclaration recordDeclaration = (RecordDeclaration)base;
                String string = matcher.group("member");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(\"member\")");
                members = this.getOrCreateMembers(recordDeclaration, string);
            } else if (base instanceof EnumDeclaration) {
                EnumDeclaration enumDeclaration = (EnumDeclaration)base;
                String string = matcher.group("member");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(\"member\")");
                members = this.getOrCreateMembers(enumDeclaration, string);
            }
            staticImports.addAll((Collection)members);
        }
        List list4 = (List)partitioned.get(true);
        if (list4 == null) {
            list4 = CollectionsKt.emptyList();
        }
        for (String asteriskImport : list4) {
            Intrinsics.checkNotNullExpressionValue((Object)asteriskImport, (String)"asteriskImport");
            Declaration base = this.importables.get(StringsKt.replace$default((String)asteriskImport, (String)".*", (String)"", (boolean)false, (int)4, null));
            if (base instanceof RecordDeclaration) {
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable list$iv$iv;
                Declaration it;
                Iterable $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                members = new SpreadBuilder(2);
                members.add((Object)base);
                Set<RecordDeclaration> set = ((RecordDeclaration)base).getSuperTypeDeclarations();
                Intrinsics.checkNotNullExpressionValue(set, (String)"base.superTypeDeclarations");
                Collection $this$toTypedArray$iv = set;
                boolean $i$f$toTypedArray22 = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                RecordDeclaration[] recordDeclarationArray = thisCollection$iv.toArray(new RecordDeclaration[0]);
                Intrinsics.checkNotNull((Object)recordDeclarationArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                members.addSpread((Object)recordDeclarationArray);
                List classes = CollectionsKt.listOf((Object[])members.toArray((Object[])new RecordDeclaration[members.size()]));
                members = classes;
                Set set2 = staticImports;
                boolean $i$f$flatMap = false;
                void $i$f$toTypedArray22 = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (RecordDeclaration)element$iv$iv;
                    boolean bl = false;
                    List<MethodDeclaration> list5 = ((RecordDeclaration)it).getMethods();
                    Intrinsics.checkNotNullExpressionValue(list5, (String)"it.methods");
                    list$iv$iv = list5;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv2;
                boolean $i$f$filter = false;
                $this$flatMapTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    MethodDeclaration p0 = (MethodDeclaration)element$iv$iv;
                    boolean bl = false;
                    if (!p0.isStatic()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                set2.addAll((List)destination$iv$iv2);
                $this$filter$iv = classes;
                set2 = staticImports;
                $i$f$flatMap = false;
                $this$filterTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv2 = new ArrayList();
                $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (RecordDeclaration)element$iv$iv;
                    boolean bl = false;
                    List<FieldDeclaration> list6 = ((RecordDeclaration)it).getFields();
                    Intrinsics.checkNotNullExpressionValue(list6, (String)"it.fields");
                    list$iv$iv = list6;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv2;
                $i$f$filter = false;
                $this$flatMapTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (FieldDeclaration)element$iv$iv;
                    boolean bl = false;
                    if (!((FieldDeclaration)it).getModifiers().contains("static")) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                set2.addAll((List)destination$iv$iv2);
                continue;
            }
            if (!(base instanceof EnumDeclaration)) continue;
            List<EnumConstantDeclaration> list7 = ((EnumDeclaration)base).getEntries();
            Intrinsics.checkNotNullExpressionValue(list7, (String)"base.entries");
            staticImports.addAll((Collection)list7);
        }
        return staticImports;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Set<Declaration> getDeclarationsForTypeNames(@NotNull List<String> targetTypes) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(targetTypes, (String)"targetTypes");
        Iterable $this$mapNotNull$iv = targetTypes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Declaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.importables.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Set<ValueDeclaration> getOrCreateMembers(@NotNull EnumDeclaration base, @NotNull String name2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        List<EnumConstantDeclaration> list2 = base.getEntries();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"base.entries");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EnumConstantDeclaration it = (EnumConstantDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Set<ValueDeclaration> getOrCreateMembers(@NotNull RecordDeclaration base, @NotNull String name2) {
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        Declaration it;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        List<MethodDeclaration> list2 = base.getMethods();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"base.methods");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (MethodDeclaration)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)it.getName(), (String)name2, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set memberMethods = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        Set<RecordDeclaration> set = base.getSuperTypeDeclarations();
        Intrinsics.checkNotNullExpressionValue(set, (String)"base.superTypeDeclarations");
        $this$filter$iv = set;
        Set set2 = memberMethods;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv2 = $this$flatMap$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (RecordDeclaration)element$iv$iv;
            boolean bl = false;
            List<MethodDeclaration> list3 = ((RecordDeclaration)it).getMethods();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"it.methods");
            Iterable list$iv$iv = list3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$flatMapTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (MethodDeclaration)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)it.getName(), (String)name2, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        set2.addAll((List)destination$iv$iv);
        List<FieldDeclaration> list4 = base.getFields();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"base.fields");
        Iterable $this$filter$iv2 = list4;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FieldDeclaration it2 = (FieldDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it2.getName(), (Object)name2)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set memberFields = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
        Set<RecordDeclaration> set3 = base.getSuperTypeDeclarations();
        Intrinsics.checkNotNullExpressionValue(set3, (String)"base.superTypeDeclarations");
        $this$filter$iv2 = set3;
        set2 = memberFields;
        boolean $i$f$flatMap2 = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RecordDeclaration it3 = (RecordDeclaration)element$iv$iv;
            boolean bl = false;
            List<FieldDeclaration> list5 = it3.getFields();
            Intrinsics.checkNotNullExpressionValue(list5, (String)"it.fields");
            Iterable list$iv$iv = list5;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        $i$f$filter2 = false;
        $this$flatMapTo$iv$iv = $this$filter$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FieldDeclaration it4 = (FieldDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it4.getName(), (Object)name2)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        set2.addAll((List)destination$iv$iv2);
        Set result = new LinkedHashSet();
        result.addAll(memberMethods);
        result.addAll(memberFields);
        if (result.isEmpty()) {
            FieldDeclaration targetField = NodeBuilder.newFieldDeclaration$default(name2, UnknownType.getUnknownType(), new ArrayList(), "", null, null, false, null, null, 384, null);
            targetField.setInferred(true);
            MethodDeclaration targetMethod = NodeBuilder.newMethodDeclaration$default(name2, "", true, base, null, null, 48, null);
            targetMethod.setInferred(true);
            base.addField(targetField);
            base.addMethod(targetMethod);
            result.add(targetField);
            result.add(targetMethod);
        }
        return result;
    }

    protected final void findImportables(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        node.accept(ImportResolver::findImportables$lambda$12, new IVisitor<Node>(this){
            final /* synthetic */ ImportResolver this$0;
            {
                this.this$0 = $receiver;
            }

            public void visit(@NotNull Node child) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                if (child instanceof RecordDeclaration) {
                    this.this$0.getRecords().add((RecordDeclaration)child);
                    this.this$0.getImportables().putIfAbsent(child.getName(), (Declaration)child);
                } else if (child instanceof EnumDeclaration) {
                    this.this$0.getImportables().putIfAbsent(child.getName(), (Declaration)child);
                }
            }
        });
    }

    private static final Iterator findImportables$lambda$12(Node it) {
        return Strategy.AST_FORWARD(it);
    }
}

