/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.types.IncompleteType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.IdentitySet;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.CallResolver;
import de.fraunhofer.aisec.cpg.passes.DFGPass;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.order.DependsOn;
import de.fraunhofer.aisec.cpg.passes.order.RequiredFrontend;
import de.fraunhofer.aisec.cpg.passes.scopes.Scope;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import de.fraunhofer.aisec.cpg.passes.scopes.StructureDeclarationScope;
import de.fraunhofer.aisec.cpg.passes.scopes.ValueDeclarationScope;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@DependsOn.Container(value={@DependsOn(value=CallResolver.class), @DependsOn(value=DFGPass.class)})
@RequiredFrontend(value=CXXLanguageFrontend.class)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/fraunhofer/aisec/cpg/passes/FunctionPointerCallResolver;", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "()V", "inferDfgForUnresolvedCalls", "", "walker", "Lde/fraunhofer/aisec/cpg/helpers/SubgraphWalker$ScopedWalker;", "accept", "", "t", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "cleanup", "handleCallExpression", "call", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CallExpression;", "handleFunctionPointerCall", "pointer", "Lde/fraunhofer/aisec/cpg/graph/Node;", "handleMemberCallExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/MemberCallExpression;", "resolve", "node", "cpg-core"})
public final class FunctionPointerCallResolver
extends Pass {
    private SubgraphWalker.ScopedWalker walker;
    private boolean inferDfgForUnresolvedCalls;

    @Override
    public void accept(@NotNull TranslationResult t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.inferDfgForUnresolvedCalls = t.getConfig().getInferenceConfiguration().getInferDfgForUnresolvedSymbols();
        this.walker = new SubgraphWalker.ScopedWalker(this.lang);
        SubgraphWalker.ScopedWalker scopedWalker = this.walker;
        if (scopedWalker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"walker");
            scopedWalker = null;
        }
        scopedWalker.registerHandler((arg_0, arg_1, arg_2) -> FunctionPointerCallResolver.accept$lambda$0(this, arg_0, arg_1, arg_2));
        SubgraphWalker.ScopedWalker scopedWalker2 = this.walker;
        if (scopedWalker2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"walker");
            scopedWalker2 = null;
        }
        scopedWalker2.registerHandler((arg_0, arg_1) -> FunctionPointerCallResolver.accept$lambda$1(this, arg_0, arg_1));
        for (TranslationUnitDeclaration tu : t.getTranslationUnits()) {
            SubgraphWalker.ScopedWalker scopedWalker3 = this.walker;
            if (scopedWalker3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"walker");
                scopedWalker3 = null;
            }
            scopedWalker3.iterate(tu);
        }
    }

    private final void resolve(Node node) {
        Node node2 = node;
        if (node2 instanceof MemberCallExpression) {
            this.handleMemberCallExpression((MemberCallExpression)node);
        } else if (node2 instanceof CallExpression) {
            this.handleCallExpression((CallExpression)node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleCallExpression(CallExpression call) {
        ValueDeclaration pointer;
        ValueDeclaration valueDeclaration;
        ScopeManager scopeManager;
        LanguageFrontend languageFrontend = this.lang;
        if (languageFrontend != null && (scopeManager = languageFrontend.getScopeManager()) != null) {
            List list2;
            block14: {
                ScopeManager scopeManager2 = scopeManager;
                Object object = this.lang;
                Scope scope = object != null && (object = ((LanguageFrontend)object).getScopeManager()) != null ? ((ScopeManager)object).getCurrentScope() : null;
                boolean stopIfFound$iv = true;
                boolean $i$f$resolve = false;
                List declarations$iv = new ArrayList();
                for (Scope scope$iv = searchScope$iv; scope$iv != null; scope$iv = scope$iv.getParent()) {
                    boolean bl;
                    ValueDeclaration it;
                    Iterable destination$iv$iv$iv;
                    if (scope$iv instanceof ValueDeclarationScope) {
                        void $this$filterTo$iv$iv$iv;
                        void $this$filter$iv$iv;
                        void $this$filterIsInstanceTo$iv$iv$iv;
                        Iterable $this$filterIsInstance$iv$iv;
                        Iterable iterable = ((ValueDeclarationScope)scope$iv).getValueDeclarations();
                        List list3 = declarations$iv;
                        boolean $i$f$filterIsInstance = false;
                        void var14_14 = $this$filterIsInstance$iv$iv;
                        destination$iv$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Iterator element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                            if (!(element$iv$iv$iv instanceof ValueDeclaration)) continue;
                            destination$iv$iv$iv.add(element$iv$iv$iv);
                        }
                        $this$filterIsInstance$iv$iv = (List)destination$iv$iv$iv;
                        boolean $i$f$filter = false;
                        $this$filterIsInstanceTo$iv$iv$iv = $this$filter$iv$iv;
                        destination$iv$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Iterator element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
                            it = (ValueDeclaration)((Object)element$iv$iv$iv);
                            bl = false;
                            if (!(it.getType() instanceof FunctionPointerType && Intrinsics.areEqual((Object)it.getName(), (Object)call.getName()))) continue;
                            destination$iv$iv$iv.add(element$iv$iv$iv);
                        }
                        list3.addAll((List)destination$iv$iv$iv);
                    }
                    if (scope$iv instanceof StructureDeclarationScope) {
                        void $this$filterTo$iv$iv$iv;
                        void $this$filter$iv$iv;
                        void $this$filterIsInstanceTo$iv$iv$iv;
                        Iterator element$iv$iv$iv;
                        Iterable $this$filterIsInstance$iv$iv = ((StructureDeclarationScope)scope$iv).getStructureDeclarations();
                        boolean $i$f$filterIsInstance = false;
                        destination$iv$iv$iv = $this$filterIsInstance$iv$iv;
                        Collection destination$iv$iv$iv2 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv$iv2 : $this$filterIsInstanceTo$iv$iv$iv) {
                            if (!(element$iv$iv$iv2 instanceof ValueDeclaration)) continue;
                            destination$iv$iv$iv2.add(element$iv$iv$iv2);
                        }
                        $this$filterIsInstance$iv$iv = (List)destination$iv$iv$iv2;
                        boolean $i$f$filter = false;
                        $this$filterIsInstanceTo$iv$iv$iv = $this$filter$iv$iv;
                        destination$iv$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo2 = false;
                        element$iv$iv$iv = $this$filterTo$iv$iv$iv.iterator();
                        while (element$iv$iv$iv.hasNext()) {
                            Object element$iv$iv$iv2;
                            element$iv$iv$iv2 = element$iv$iv$iv.next();
                            it = (ValueDeclaration)element$iv$iv$iv2;
                            bl = false;
                            if (!(it.getType() instanceof FunctionPointerType && Intrinsics.areEqual((Object)it.getName(), (Object)call.getName()))) continue;
                            destination$iv$iv$iv2.add(element$iv$iv$iv2);
                        }
                        List list$iv = (List)destination$iv$iv$iv2;
                        if (list$iv.isEmpty()) {
                            for (Declaration declaration$iv : ((StructureDeclarationScope)scope$iv).getStructureDeclarations()) {
                                void $this$filterTo$iv$iv$iv2;
                                void $this$filter$iv$iv2;
                                void $this$filterIsInstanceTo$iv$iv$iv2;
                                if (!(declaration$iv instanceof RecordDeclaration)) continue;
                                List<TemplateDeclaration> list4 = ((RecordDeclaration)declaration$iv).getTemplates();
                                Intrinsics.checkNotNullExpressionValue(list4, (String)"declaration.templates");
                                Iterable $this$filterIsInstance$iv$iv2 = list4;
                                boolean $i$f$filterIsInstance2 = false;
                                Iterable $i$f$filterTo2 = $this$filterIsInstance$iv$iv2;
                                Collection destination$iv$iv$iv3 = new ArrayList();
                                boolean $i$f$filterIsInstanceTo2 = false;
                                for (Object element$iv$iv$iv3 : $this$filterIsInstanceTo$iv$iv$iv2) {
                                    if (!(element$iv$iv$iv3 instanceof ValueDeclaration)) continue;
                                    destination$iv$iv$iv3.add(element$iv$iv$iv3);
                                }
                                $this$filterIsInstance$iv$iv2 = (List)destination$iv$iv$iv3;
                                boolean $i$f$filter2 = false;
                                $this$filterIsInstanceTo$iv$iv$iv2 = $this$filter$iv$iv2;
                                destination$iv$iv$iv3 = new ArrayList();
                                boolean $i$f$filterTo3 = false;
                                for (Object element$iv$iv$iv3 : $this$filterTo$iv$iv$iv2) {
                                    it = (ValueDeclaration)element$iv$iv$iv3;
                                    bl = false;
                                    if (!(it.getType() instanceof FunctionPointerType && Intrinsics.areEqual((Object)it.getName(), (Object)call.getName()))) continue;
                                    destination$iv$iv$iv3.add(element$iv$iv$iv3);
                                }
                                list$iv = (List)destination$iv$iv$iv3;
                            }
                        }
                        declarations$iv.addAll(list$iv);
                    }
                    if (!(!((Collection)declarations$iv).isEmpty())) continue;
                    list2 = declarations$iv;
                    break block14;
                }
                list2 = declarations$iv;
            }
            valueDeclaration = (ValueDeclaration)CollectionsKt.firstOrNull((List)list2);
        } else {
            valueDeclaration = pointer = null;
        }
        if (pointer != null) {
            this.handleFunctionPointerCall(call, pointer);
        }
    }

    private final void handleMemberCallExpression(MemberCallExpression call) {
        Node member = call.getMember();
        if (member instanceof HasType && ((HasType)((Object)member)).getType() instanceof FunctionPointerType) {
            this.handleFunctionPointerCall(call, call.getMember());
        }
    }

    private final void handleFunctionPointerCall(CallExpression call, Node pointer) {
        Intrinsics.checkNotNull((Object)pointer, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.HasType");
        Type type = ((HasType)((Object)pointer)).getType();
        Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType");
        FunctionPointerType pointerType = (FunctionPointerType)type;
        List invocationCandidates = new ArrayList();
        Deque work = new ArrayDeque();
        IdentitySet<Node> seen = new IdentitySet<Node>();
        work.push(pointer);
        while (!work.isEmpty()) {
            Node curr = (Node)work.pop();
            Intrinsics.checkNotNullExpressionValue((Object)curr, (String)"curr");
            if (!seen.add(curr)) continue;
            if (curr instanceof FunctionDeclaration) {
                Type returnType;
                Type type2 = returnType = ((FunctionDeclaration)curr).getReturnTypes().isEmpty() ? (Type)new IncompleteType() : ((FunctionDeclaration)curr).getReturnTypes().get(0);
                if (TypeManager.getInstance().isSupertypeOf(pointerType.getReturnType(), returnType)) {
                    FunctionDeclaration functionDeclaration = (FunctionDeclaration)curr;
                    List<Type> list2 = pointerType.getParameters();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"pointerType.parameters");
                    if (functionDeclaration.hasSignature(list2)) {
                        invocationCandidates.add(curr);
                        continue;
                    }
                }
            }
            curr.getPrevDFG().forEach(work::push);
        }
        call.setInvokes(invocationCandidates);
        new DFGPass().handleCallExpression(call, this.inferDfgForUnresolvedCalls);
    }

    @Override
    public void cleanup() {
    }

    private static final void accept$lambda$0(FunctionPointerCallResolver this$0, RecordDeclaration recordDeclaration, Node node, Node currNode) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SubgraphWalker.ScopedWalker scopedWalker = this$0.walker;
        if (scopedWalker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"walker");
            scopedWalker = null;
        }
        scopedWalker.collectDeclarations(currNode);
    }

    private static final void accept$lambda$1(FunctionPointerCallResolver this$0, Node node, RecordDeclaration recordDeclaration) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.resolve(node);
    }
}

