/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.CallableInterface;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.StatementHolder;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.IncludeDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.AssertStatement;
import de.fraunhofer.aisec.cpg.graph.statements.BreakStatement;
import de.fraunhofer.aisec.cpg.graph.statements.CaseStatement;
import de.fraunhofer.aisec.cpg.graph.statements.CatchClause;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ContinueStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DefaultStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.EmptyStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ForEachStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ForStatement;
import de.fraunhofer.aisec.cpg.graph.statements.GotoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.IfStatement;
import de.fraunhofer.aisec.cpg.graph.statements.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.SwitchStatement;
import de.fraunhofer.aisec.cpg.graph.statements.SynchronizedStatement;
import de.fraunhofer.aisec.cpg.graph.statements.TryStatement;
import de.fraunhofer.aisec.cpg.graph.statements.WhileStatement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArrayCreationExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CompoundStatementExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConditionalExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeleteExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ExpressionList;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.NewExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.TypeIdExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UninitializedValue;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.CallResolver;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.order.DependsOn;
import de.fraunhofer.aisec.cpg.passes.scopes.BlockScope;
import de.fraunhofer.aisec.cpg.passes.scopes.FunctionScope;
import de.fraunhofer.aisec.cpg.passes.scopes.LoopScope;
import de.fraunhofer.aisec.cpg.passes.scopes.Scope;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import de.fraunhofer.aisec.cpg.passes.scopes.SwitchScope;
import de.fraunhofer.aisec.cpg.passes.scopes.TryScope;
import de.fraunhofer.aisec.cpg.passes.scopes.ValueDeclarationScope;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DependsOn(value=CallResolver.class)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00be\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u0000 \u0080\u00012\u00020\u0001:\u0002\u0080\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0004J\u001e\u0010\u001f\u001a\u00020\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010\u001e\u001a\u00020\u0005H\u0004J\u0014\u0010\"\u001a\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050!J\b\u0010$\u001a\u00020\u0019H\u0016J\b\u0010%\u001a\u00020\u0019H\u0004J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0005H\u0004J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0005H\u0002J\u0018\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0004J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010'\u001a\u00020/H\u0004J\u0010\u00100\u001a\u00020\u00192\u0006\u0010'\u001a\u000201H\u0004J\u0010\u00102\u001a\u00020\u00192\u0006\u0010'\u001a\u000203H\u0004J\u0010\u00104\u001a\u00020\u00192\u0006\u0010'\u001a\u000205H\u0004J\u0010\u00106\u001a\u00020\u00192\u0006\u0010'\u001a\u000207H\u0004J\u0010\u00108\u001a\u00020\u00192\u0006\u0010'\u001a\u000209H\u0004J\u0010\u0010:\u001a\u00020\u00192\u0006\u0010'\u001a\u00020;H\u0004J\u0010\u0010<\u001a\u00020\u00192\u0006\u0010'\u001a\u00020=H\u0004J\u0010\u0010>\u001a\u00020\u00192\u0006\u0010'\u001a\u00020?H\u0004J\u0010\u0010@\u001a\u00020\u00192\u0006\u0010'\u001a\u00020AH\u0004J\u0010\u0010B\u001a\u00020\u00192\u0006\u0010'\u001a\u00020CH\u0004J\u0010\u0010D\u001a\u00020\u00192\u0006\u0010'\u001a\u00020EH\u0004J\u0010\u0010F\u001a\u00020\u00192\u0006\u0010'\u001a\u00020GH\u0004J\u0010\u0010H\u001a\u00020\u00192\u0006\u0010'\u001a\u00020IH\u0004J\u0010\u0010J\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0005H\u0004J\u0010\u0010K\u001a\u00020\u00192\u0006\u0010'\u001a\u00020LH\u0004J\u0010\u0010M\u001a\u00020\u00192\u0006\u0010'\u001a\u00020NH\u0004J\u0010\u0010O\u001a\u00020\u00192\u0006\u0010'\u001a\u00020PH\u0004J\u0010\u0010Q\u001a\u00020\u00192\u0006\u0010'\u001a\u00020RH\u0004J\u0010\u0010S\u001a\u00020\u00192\u0006\u0010'\u001a\u00020TH\u0004J\u0010\u0010U\u001a\u00020\u00192\u0006\u0010'\u001a\u00020VH\u0004J\u0010\u0010W\u001a\u00020\u00192\u0006\u0010'\u001a\u00020XH\u0004J\u0010\u0010Y\u001a\u00020\u00192\u0006\u0010'\u001a\u00020ZH\u0004J\u0010\u0010[\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\\H\u0004J\u0010\u0010]\u001a\u00020\u00192\u0006\u0010'\u001a\u00020^H\u0004J\u0010\u0010_\u001a\u00020\u00192\u0006\u0010'\u001a\u00020`H\u0004J\u0010\u0010a\u001a\u00020\u00192\u0006\u0010'\u001a\u00020bH\u0004J\u0010\u0010c\u001a\u00020\u00192\u0006\u0010'\u001a\u00020dH\u0004J\u0010\u0010e\u001a\u00020\u00192\u0006\u0010'\u001a\u00020fH\u0004J\u0010\u0010g\u001a\u00020\u00192\u0006\u0010'\u001a\u00020hH\u0004J\u0010\u0010i\u001a\u00020\u00192\u0006\u0010j\u001a\u00020kH\u0004J\u0010\u0010l\u001a\u00020\u00192\u0006\u0010'\u001a\u00020mH\u0004J\u0010\u0010n\u001a\u00020\u00192\u0006\u0010'\u001a\u00020oH\u0004J\u0010\u0010p\u001a\u00020\u00192\u0006\u0010'\u001a\u00020qH\u0004J\u0010\u0010r\u001a\u00020\u00192\u0006\u0010'\u001a\u00020sH\u0004J\u0010\u0010t\u001a\u00020\u00192\u0006\u0010'\u001a\u00020uH\u0004J\u0010\u0010v\u001a\u00020\u00192\u0006\u0010'\u001a\u00020wH\u0004J\u0010\u0010x\u001a\u00020\u00192\u0006\u0010'\u001a\u00020yH\u0004J\u000e\u0010z\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0005J\u0010\u0010{\u001a\u00020\u00192\u0006\u0010|\u001a\u00020qH\u0004J\u000e\u0010\b\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0005J\u0014\u0010}\u001a\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050!J\u0016\u0010~\u001a\u00020\u00192\f\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020\u00050!H\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R.\u0010\u0012\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00150\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0081\u0001"}, d2={"Lde/fraunhofer/aisec/cpg/passes/EvaluationOrderGraphPass;", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "()V", "currentEOG", "", "Lde/fraunhofer/aisec/cpg/graph/Node;", "getCurrentEOG", "()Ljava/util/List;", "setCurrentEOG", "(Ljava/util/List;)V", "currentProperties", "Ljava/util/EnumMap;", "Lde/fraunhofer/aisec/cpg/graph/edge/Properties;", "", "getCurrentProperties", "()Ljava/util/EnumMap;", "intermediateNodes", "getIntermediateNodes", "map", "", "Ljava/lang/Class;", "Lde/fraunhofer/aisec/cpg/frontends/CallableInterface;", "getMap", "()Ljava/util/Map;", "accept", "", "result", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "addEOGEdge", "prev", "next", "addMultipleIncomingEOGEdges", "prevs", "", "addToCurrentEOG", "nodes", "cleanup", "connectCurrentToLoopStart", "createEOG", "node", "doNothing", "exitLoop", "loopStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/Statement;", "loopScope", "Lde/fraunhofer/aisec/cpg/passes/scopes/LoopScope;", "handleArrayCreationExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ArrayCreationExpression;", "handleArraySubscriptionExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ArraySubscriptionExpression;", "handleAssertStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/AssertStatement;", "handleBinaryOperator", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/BinaryOperator;", "handleBreakStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/BreakStatement;", "handleCallExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CallExpression;", "handleCaseStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/CaseStatement;", "handleCastExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CastExpression;", "handleCompoundStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/CompoundStatement;", "handleCompoundStatementExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CompoundStatementExpression;", "handleConditionalExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ConditionalExpression;", "handleConstructExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ConstructExpression;", "handleContinueStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/ContinueStatement;", "handleDeclarationStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/DeclarationStatement;", "handleDefault", "handleDeleteExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/DeleteExpression;", "handleDoStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/DoStatement;", "handleExpressionList", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ExpressionList;", "handleForEachStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/ForEachStatement;", "handleForStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/ForStatement;", "handleFunctionDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "handleGotoStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/GotoStatement;", "handleIfStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/IfStatement;", "handleInitializerListExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/InitializerListExpression;", "handleLabelStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/LabelStatement;", "handleMemberExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/MemberExpression;", "handleNamespaceDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/NamespaceDeclaration;", "handleNewExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/NewExpression;", "handleRecordDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "handleReturnStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/ReturnStatement;", "handleStatementHolder", "statementHolder", "Lde/fraunhofer/aisec/cpg/graph/StatementHolder;", "handleSwitchStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/SwitchStatement;", "handleSynchronizedStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/SynchronizedStatement;", "handleTranslationUnitDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "handleTryStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/TryStatement;", "handleUnaryOperator", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/UnaryOperator;", "handleVariableDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/VariableDeclaration;", "handleWhileStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/WhileStatement;", "pushToEOG", "removeUnreachableEOGEdges", "tu", "setCurrentEOGs", "truncateLooseEdges", "eogSources", "Companion", "cpg-core"})
public class EvaluationOrderGraphPass
extends Pass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Class<? extends Node>, CallableInterface<Node>> map = new LinkedHashMap();
    @NotNull
    private List<Node> currentEOG = new ArrayList();
    @NotNull
    private final EnumMap<Properties, Object> currentProperties = new EnumMap(Properties.class);
    @NotNull
    private final List<Node> intermediateNodes = new ArrayList();
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaluationOrderGraphPass.class);

    public EvaluationOrderGraphPass() {
        this.map.put(IncludeDeclaration.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$0(this, arg_0));
        this.map.put(TranslationUnitDeclaration.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$1(this, arg_0));
        this.map.put(NamespaceDeclaration.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$2(this, arg_0));
        this.map.put(RecordDeclaration.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$3(this, arg_0));
        this.map.put(FunctionDeclaration.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$4(this, arg_0));
        this.map.put(VariableDeclaration.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$5(this, arg_0));
        this.map.put(CallExpression.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$6(this, arg_0));
        this.map.put(MemberExpression.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$7(this, arg_0));
        this.map.put(ArraySubscriptionExpression.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$8(this, arg_0));
        this.map.put(ArrayCreationExpression.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$9(this, arg_0));
        this.map.put(DeclarationStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$10(this, arg_0));
        this.map.put(ReturnStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$11(this, arg_0));
        this.map.put(BinaryOperator.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$12(this, arg_0));
        this.map.put(UnaryOperator.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$13(this, arg_0));
        this.map.put(CompoundStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$14(this, arg_0));
        this.map.put(CompoundStatementExpression.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$15(this, arg_0));
        this.map.put(IfStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$16(this, arg_0));
        this.map.put(AssertStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$17(this, arg_0));
        this.map.put(WhileStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$18(this, arg_0));
        this.map.put(DoStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$19(this, arg_0));
        this.map.put(ForStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$20(this, arg_0));
        this.map.put(ForEachStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$21(this, arg_0));
        this.map.put(TryStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$22(this, arg_0));
        this.map.put(ContinueStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$23(this, arg_0));
        this.map.put(DeleteExpression.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$24(this, arg_0));
        this.map.put(BreakStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$25(this, arg_0));
        this.map.put(SwitchStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$26(this, arg_0));
        this.map.put(LabelStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$27(this, arg_0));
        this.map.put(GotoStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$28(this, arg_0));
        this.map.put(CaseStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$29(this, arg_0));
        this.map.put(SynchronizedStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$30(this, arg_0));
        this.map.put(NewExpression.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$31(this, arg_0));
        this.map.put(CastExpression.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$32(this, arg_0));
        this.map.put(ExpressionList.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$33(this, arg_0));
        this.map.put(ConditionalExpression.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$34(this, arg_0));
        this.map.put(InitializerListExpression.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$35(this, arg_0));
        this.map.put(ConstructExpression.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$36(this, arg_0));
        this.map.put(EmptyStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$37(this, arg_0));
        this.map.put(Literal.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$38(this, arg_0));
        this.map.put(UninitializedValue.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$39(this, arg_0));
        this.map.put(DefaultStatement.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$40(this, arg_0));
        this.map.put(TypeIdExpression.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$41(this, arg_0));
        this.map.put(DeclaredReferenceExpression.class, arg_0 -> EvaluationOrderGraphPass._init_$lambda$42(this, arg_0));
    }

    @NotNull
    protected final Map<Class<? extends Node>, CallableInterface<Node>> getMap() {
        return this.map;
    }

    @NotNull
    protected final List<Node> getCurrentEOG() {
        return this.currentEOG;
    }

    protected final void setCurrentEOG(@NotNull List<Node> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.currentEOG = list2;
    }

    @NotNull
    protected final EnumMap<Properties, Object> getCurrentProperties() {
        return this.currentProperties;
    }

    @NotNull
    protected final List<Node> getIntermediateNodes() {
        return this.intermediateNodes;
    }

    private final void doNothing(Node node) {
    }

    @Override
    public void cleanup() {
        this.intermediateNodes.clear();
        this.currentEOG.clear();
    }

    @Override
    public void accept(@NotNull TranslationResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (this.lang == null) {
            Util.errorWithFileLocation(result, Pass.log, "Could not create EOG: language frontend is null", new Object[0]);
            return;
        }
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            Intrinsics.checkNotNullExpressionValue((Object)tu, (String)"tu");
            this.createEOG(tu);
            this.removeUnreachableEOGEdges(tu);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void truncateLooseEdges(List<? extends Node> eogSources) {
        for (Node node : eogSources) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            if (node instanceof FunctionDeclaration) continue;
            ArrayList nextNodes = new ArrayList(node.getNextEOG());
            node.clearNextEOG();
            Iterable $this$forEach$iv = nextNodes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node node2 = (Node)element$iv;
                boolean bl = false;
                node2.removePrevEOGEntry(node);
            }
            $this$forEach$iv = nextNodes;
            EvaluationOrderGraphPass evaluationOrderGraphPass = this;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Node it = (Node)element$iv$iv;
                boolean bl = false;
                boolean bl2 = it.getPrevEOG().isEmpty() && !((Collection)it.getNextEOG()).isEmpty();
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            evaluationOrderGraphPass.truncateLooseEdges((List)destination$iv$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void removeUnreachableEOGEdges(@NotNull TranslationUnitDeclaration tu) {
        Iterable $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)tu, (String)"tu");
        List<Node> list2 = SubgraphWalker.flattenAST(tu);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"flattenAST(tu)");
        Iterable $this$filter$iv2 = list2;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Node it = (Node)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)it.getPrevEOG()).isEmpty() || !((Collection)it.getNextEOG()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List eognodes = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Iterable $i$f$filter22 = eognodes;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Node node = (Node)element$iv$iv;
            boolean bl = false;
            boolean bl3 = node instanceof FunctionDeclaration || node instanceof RecordDeclaration || node instanceof NamespaceDeclaration || node instanceof TranslationUnitDeclaration;
            if (!bl3) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set validStarts = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        while (!((Collection)validStarts).isEmpty()) {
            Node it;
            void $this$flatMapTo$iv$iv;
            eognodes.removeAll(validStarts);
            Iterable $this$flatMap$iv = validStarts;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (Node)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getNextEOG();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Node)element$iv$iv;
                boolean bl = false;
                if (!eognodes.contains(it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            validStarts = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        }
        for (Node unvisitedNode : eognodes) {
            Iterable $this$forEach$iv = unvisitedNode.getNextEOGEdges();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PropertyEdge next = (PropertyEdge)element$iv;
                boolean bl = false;
                Object t = next.getEnd();
                Intrinsics.checkNotNullExpressionValue((Object)unvisitedNode, (String)"unvisitedNode");
                ((Node)t).removePrevEOGEntry(unvisitedNode);
            }
            unvisitedNode.getNextEOGEdges().clear();
        }
    }

    protected final void handleTranslationUnitDeclaration(@NotNull TranslationUnitDeclaration node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.handleStatementHolder(node);
        for (Declaration child : node.getDeclarations()) {
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            this.createEOG(child);
        }
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        languageFrontend.clearProcessed();
    }

    protected final void handleNamespaceDeclaration(@NotNull NamespaceDeclaration node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.handleStatementHolder(node);
        for (Declaration child : node.getDeclarations()) {
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            this.createEOG(child);
        }
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        languageFrontend.clearProcessed();
    }

    protected final void handleVariableDeclaration(@NotNull VariableDeclaration node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Expression expression = node.getInitializer();
        if (expression != null) {
            Expression it = expression;
            boolean bl = false;
            this.createEOG(it);
        }
        this.pushToEOG(node);
    }

    protected final void handleRecordDeclaration(@NotNull RecordDeclaration node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        languageFrontend.getScopeManager().enterScope(node);
        this.handleStatementHolder(node);
        this.currentEOG.clear();
        for (ConstructorDeclaration constructor : node.getConstructors()) {
            Intrinsics.checkNotNullExpressionValue((Object)constructor, (String)"constructor");
            this.createEOG(constructor);
        }
        for (MethodDeclaration method : node.getMethods()) {
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
            this.createEOG(method);
        }
        for (RecordDeclaration records2 : node.getRecords()) {
            Intrinsics.checkNotNullExpressionValue((Object)records2, (String)"records");
            this.createEOG(records2);
        }
        LanguageFrontend languageFrontend2 = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend2);
        languageFrontend2.getScopeManager().leaveScope(node);
    }

    /*
     * WARNING - void declaration
     */
    protected final void handleStatementHolder(@NotNull StatementHolder statementHolder) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)statementHolder, (String)"statementHolder");
        List<PropertyEdge<Statement>> list2 = statementHolder.getStatementsPropertyEdge();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"statementHolder.statementsPropertyEdge");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PropertyEdge propertyEdge = (PropertyEdge)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge<@[FlexibleNullability] de.fraunhofer.aisec.cpg.graph.statements.Statement?>");
            Object t = it.getEnd();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.Statement");
            collection.add((Statement)t);
        }
        List code = (List)destination$iv$iv;
        Iterable $this$filter$iv = code;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Statement it = (Statement)element$iv$iv;
            boolean bl = false;
            CompoundStatement compoundStatement = it instanceof CompoundStatement ? (CompoundStatement)it : null;
            boolean bl2 = compoundStatement != null ? !compoundStatement.isStaticBlock() : false;
            if (!bl2) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List nonStaticCode = (List)destination$iv$iv2;
        Iterable $this$filter$iv2 = code;
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Statement it = (Statement)element$iv$iv;
            boolean bl = false;
            if (!(!nonStaticCode.contains(it))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List staticCode = (List)destination$iv$iv3;
        this.pushToEOG((Node)((Object)statementHolder));
        for (Statement staticStatement : staticCode) {
            this.createEOG(staticStatement);
        }
        this.currentEOG.clear();
        this.pushToEOG((Node)((Object)statementHolder));
        for (Statement nonStaticStatement : nonStaticCode) {
            this.createEOG(nonStaticStatement);
        }
        this.currentEOG.clear();
    }

    protected final void handleFunctionDeclaration(@NotNull FunctionDeclaration node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.currentEOG.clear();
        boolean needToLeaveRecord = false;
        if (node instanceof MethodDeclaration && ((MethodDeclaration)node).getRecordDeclaration() != null) {
            RecordDeclaration recordDeclaration = ((MethodDeclaration)node).getRecordDeclaration();
            LanguageFrontend languageFrontend = this.lang;
            Intrinsics.checkNotNull((Object)languageFrontend);
            if (recordDeclaration != languageFrontend.getScopeManager().getCurrentRecord()) {
                LanguageFrontend languageFrontend2 = this.lang;
                Intrinsics.checkNotNull((Object)languageFrontend2);
                ScopeManager scopeManager = languageFrontend2.getScopeManager();
                RecordDeclaration recordDeclaration2 = ((MethodDeclaration)node).getRecordDeclaration();
                Intrinsics.checkNotNull((Object)recordDeclaration2);
                scopeManager.enterScope(recordDeclaration2);
                needToLeaveRecord = true;
            }
        }
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        languageFrontend.getScopeManager().enterScope(node);
        this.pushToEOG(node);
        Statement statement = node.getBody();
        if (statement != null) {
            Statement it = statement;
            boolean bl = false;
            this.createEOG(it);
        }
        LanguageFrontend languageFrontend3 = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend3);
        Scope currentScope = languageFrontend3.getScopeManager().getCurrentScope();
        if (!(currentScope instanceof FunctionScope)) {
            Util.errorWithFileLocation(node, Pass.log, "Scope of function declaration is not a function scope. EOG of function might be incorrect.", new Object[0]);
            LanguageFrontend languageFrontend4 = this.lang;
            Intrinsics.checkNotNull((Object)languageFrontend4);
            languageFrontend4.getScopeManager().leaveScope(node);
            this.currentEOG.clear();
            return;
        }
        List uncaughtEOGThrows = CollectionsKt.flatten((Iterable)((FunctionScope)currentScope).getCatchesOrRelays().values());
        Statement statement2 = node.getBody();
        if (statement2 != null) {
            Statement it = statement2;
            boolean bl = false;
            this.addMultipleIncomingEOGEdges(uncaughtEOGThrows, it);
        }
        LanguageFrontend languageFrontend5 = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend5);
        languageFrontend5.getScopeManager().leaveScope(node);
        if (node instanceof MethodDeclaration && ((MethodDeclaration)node).getRecordDeclaration() != null && needToLeaveRecord) {
            LanguageFrontend languageFrontend6 = this.lang;
            Intrinsics.checkNotNull((Object)languageFrontend6);
            ScopeManager scopeManager = languageFrontend6.getScopeManager();
            RecordDeclaration recordDeclaration = ((MethodDeclaration)node).getRecordDeclaration();
            Intrinsics.checkNotNull((Object)recordDeclaration);
            scopeManager.leaveScope(recordDeclaration);
        }
        List<Node> funcDeclNextEOG = node.getNextEOG();
        this.currentEOG.clear();
        this.currentEOG.add(node);
        Expression defaultArg = null;
        for (ParamVariableDeclaration paramVariableDeclaration : node.getParameters()) {
            if (paramVariableDeclaration.getDefault() == null) continue;
            Expression expression = defaultArg = paramVariableDeclaration.getDefault();
            Intrinsics.checkNotNull((Object)expression);
            this.pushToEOG(expression);
            this.currentEOG.clear();
            this.currentEOG.add(defaultArg);
            this.currentEOG.add(node);
        }
        if (defaultArg != null) {
            for (Node nextEOG : funcDeclNextEOG) {
                this.currentEOG.clear();
                this.currentEOG.add(defaultArg);
                this.pushToEOG(nextEOG);
            }
        }
        this.currentEOG.clear();
    }

    protected final void createEOG(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.intermediateNodes.add(node);
        Class<?> toHandle = node.getClass();
        CallableInterface<Node> callable = this.map.get(toHandle);
        while (callable == null) {
            Intrinsics.checkNotNullExpressionValue(toHandle.getSuperclass(), (String)"toHandle.superclass");
            callable = this.map.get(toHandle);
            if (!Intrinsics.areEqual(toHandle, Node.class) && Node.class.isAssignableFrom(toHandle)) continue;
        }
        if (callable != null) {
            callable.dispatch(node);
        } else {
            LOGGER.info("Parsing of type " + node.getClass() + " is not supported (yet)");
        }
    }

    protected final void handleDefault(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.pushToEOG(node);
    }

    protected final void handleCallExpression(@NotNull CallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof MemberCallExpression && node.getBase() != null) {
            Expression expression = node.getBase();
            Intrinsics.checkNotNull((Object)expression);
            this.createEOG(expression);
        }
        for (Expression arg : node.getArguments()) {
            this.createEOG(arg);
        }
        this.pushToEOG(node);
    }

    protected final void handleMemberExpression(@NotNull MemberExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Expression expression = node.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"node.base");
        this.createEOG(expression);
        this.pushToEOG(node);
    }

    protected final void handleArraySubscriptionExpression(@NotNull ArraySubscriptionExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Expression expression = node.getArrayExpression();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"node.arrayExpression");
        this.createEOG(expression);
        Expression expression2 = node.getSubscriptExpression();
        Intrinsics.checkNotNullExpressionValue((Object)expression2, (String)"node.subscriptExpression");
        this.createEOG(expression2);
        this.pushToEOG(node);
    }

    protected final void handleArrayCreationExpression(@NotNull ArrayCreationExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (Expression dimension : node.getDimensions()) {
            Expression it;
            if (dimension == null) continue;
            boolean bl = false;
            this.createEOG(it);
        }
        Expression expression = node.getInitializer();
        if (expression != null) {
            Expression it = expression;
            boolean bl = false;
            this.createEOG(it);
        }
        this.pushToEOG(node);
    }

    protected final void handleDeclarationStatement(@NotNull DeclarationStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (Declaration declaration : node.getDeclarations()) {
            if (declaration instanceof VariableDeclaration) {
                this.createEOG(declaration);
                continue;
            }
            if (!(declaration instanceof FunctionDeclaration)) continue;
            ArrayList oldEOG = new ArrayList(this.currentEOG);
            this.createEOG(declaration);
            this.currentEOG = oldEOG;
        }
        this.pushToEOG(node);
    }

    protected final void handleReturnStatement(@NotNull ReturnStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Expression expression = node.getReturnValue();
        if (expression != null) {
            Expression it = expression;
            boolean bl = false;
            this.createEOG(it);
        }
        this.pushToEOG(node);
        this.currentEOG.clear();
    }

    protected final void handleBinaryOperator(@NotNull BinaryOperator node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Expression expression = node.getLhs();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"node.lhs");
        this.createEOG(expression);
        List shortCircuitNodes = new ArrayList();
        if (Intrinsics.areEqual((Object)node.getOperatorCode(), (Object)"&&") || Intrinsics.areEqual((Object)node.getOperatorCode(), (Object)"||")) {
            shortCircuitNodes.addAll((Collection)this.currentEOG);
        }
        Expression expression2 = node.getRhs();
        Intrinsics.checkNotNullExpressionValue((Object)expression2, (String)"node.rhs");
        this.createEOG(expression2);
        shortCircuitNodes.addAll((Collection)this.currentEOG);
        this.setCurrentEOGs(shortCircuitNodes);
        this.pushToEOG(node);
    }

    protected final void handleCompoundStatement(@NotNull CompoundStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        languageFrontend.getScopeManager().enterScopeIfExists(node);
        for (Statement child : node.getStatements()) {
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            this.createEOG(child);
        }
        LanguageFrontend languageFrontend2 = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend2);
        if (languageFrontend2.getScopeManager().getCurrentScope() instanceof BlockScope) {
            LanguageFrontend languageFrontend3 = this.lang;
            Intrinsics.checkNotNull((Object)languageFrontend3);
            languageFrontend3.getScopeManager().leaveScope(node);
        }
        this.pushToEOG(node);
    }

    /*
     * Unable to fully structure code
     */
    protected final void handleUnaryOperator(@NotNull UnaryOperator node) {
        block9: {
            block6: {
                block8: {
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        input = node.getInput();
                        if (input != null) {
                            this.createEOG(input);
                        }
                        if (!Intrinsics.areEqual((Object)node.getOperatorCode(), (Object)"throw")) break block6;
                        v0 = this.lang;
                        Intrinsics.checkNotNull((Object)v0);
                        v1 = v0.getScopeManager();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"lang!!.scopeManager");
                        catchingScope = ScopeManager.firstScopeOrNull$default(v1, null, (Predicate<Scope>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, handleUnaryOperator$lambda$59(de.fraunhofer.aisec.cpg.passes.scopes.Scope ), (Lde/fraunhofer/aisec/cpg/passes/scopes/Scope;)Z)(), 1, null);
                        if (input == null) break block7;
                        v2 = input.getType();
                        break block8;
                    }
                    v3 = this.lang;
                    Intrinsics.checkNotNull((Object)v3);
                    v4 = v3.getScopeManager();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"lang!!.scopeManager");
                    decl = ScopeManager.firstScopeOrNull$default(v4, null, (Predicate<Scope>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, handleUnaryOperator$lambda$60(de.fraunhofer.aisec.cpg.passes.scopes.Scope ), (Lde/fraunhofer/aisec/cpg/passes/scopes/Scope;)Z)(), 1, null);
                    if (decl == null || !(decl.getAstNode() instanceof CatchClause)) ** GOTO lbl-1000
                    v5 = (CatchClause)decl.getAstNode();
                    Intrinsics.checkNotNull((Object)v5);
                    if (v5.getParameter() != null) {
                        v6 = (CatchClause)decl.getAstNode();
                        Intrinsics.checkNotNull((Object)v6);
                        v7 = v6.getParameter();
                        Intrinsics.checkNotNull((Object)v7);
                        param = v7;
                        v2 = param.getType();
                    } else lbl-1000:
                    // 2 sources

                    {
                        EvaluationOrderGraphPass.LOGGER.info("Unknown throw type, potentially throw; in a method");
                        v2 = TypeParser.createFrom("UNKNOWN_THROW_TYPE", true);
                    }
                }
                throwType = v2;
                this.pushToEOG(node);
                if (catchingScope instanceof TryScope) {
                    v8 = ((TryScope)catchingScope).getCatchesOrRelays();
                    Intrinsics.checkNotNullExpressionValue((Object)throwType, (String)"throwType");
                    v8.put(throwType, new ArrayList<E>(this.currentEOG));
                } else if (catchingScope instanceof FunctionScope) {
                    v9 = ((FunctionScope)catchingScope).getCatchesOrRelays();
                    Intrinsics.checkNotNullExpressionValue((Object)throwType, (String)"throwType");
                    v9.put(throwType, new ArrayList<E>(this.currentEOG));
                }
                this.currentEOG.clear();
                break block9;
            }
            this.pushToEOG(node);
        }
    }

    protected final void handleCompoundStatementExpression(@NotNull CompoundStatementExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Statement statement = node.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"node.statement");
        this.createEOG(statement);
        this.pushToEOG(node);
    }

    protected final void handleAssertStatement(@NotNull AssertStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Expression expression = node.getCondition();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"node.condition");
        this.createEOG(expression);
        ArrayList openConditionEOGs = new ArrayList(this.currentEOG);
        Statement statement = node.getMessage();
        if (statement != null) {
            Statement it = statement;
            boolean bl = false;
            this.createEOG(it);
        }
        this.setCurrentEOGs(openConditionEOGs);
        this.pushToEOG(node);
    }

    /*
     * WARNING - void declaration
     */
    protected final void handleTryStatement(@NotNull TryStatement node) {
        boolean bl;
        Iterable $this$any$iv;
        Map<Type, List<Node>> catchesOrRelays;
        ArrayList tmpEOGNodes;
        block15: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            LanguageFrontend languageFrontend = this.lang;
            Intrinsics.checkNotNull((Object)languageFrontend);
            languageFrontend.getScopeManager().enterScope(node);
            LanguageFrontend languageFrontend2 = this.lang;
            Intrinsics.checkNotNull((Object)languageFrontend2);
            TryScope tryScope = (TryScope)languageFrontend2.getScopeManager().getCurrentScope();
            List<Statement> list2 = node.getResources();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"node.resources");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Statement it = (Statement)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.createEOG(it);
            }
            CompoundStatement compoundStatement = node.getTryBlock();
            Intrinsics.checkNotNullExpressionValue((Object)compoundStatement, (String)"node.tryBlock");
            this.createEOG(compoundStatement);
            tmpEOGNodes = new ArrayList(this.currentEOG);
            TryScope tryScope2 = tryScope;
            Intrinsics.checkNotNull((Object)tryScope2);
            catchesOrRelays = tryScope2.getCatchesOrRelays();
            for (CatchClause catchClause : node.getCatchClauses()) {
                this.currentEOG.clear();
                Set toRemove = new LinkedHashSet();
                for (Map.Entry<Type, List<Node>> entry : catchesOrRelays.entrySet()) {
                    Type throwType = entry.getKey();
                    List<Node> eogEdges = entry.getValue();
                    if (catchClause.getParameter() == null) {
                        this.currentEOG.addAll((Collection<Node>)eogEdges);
                        continue;
                    }
                    TypeManager typeManager = TypeManager.getInstance();
                    VariableDeclaration variableDeclaration = catchClause.getParameter();
                    Intrinsics.checkNotNull((Object)variableDeclaration);
                    if (!typeManager.isSupertypeOf(variableDeclaration.getType(), throwType)) continue;
                    this.currentEOG.addAll((Collection<Node>)eogEdges);
                    toRemove.add(throwType);
                }
                Iterable $this$forEach$iv2 = toRemove;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Type it = (Type)element$iv;
                    boolean bl3 = false;
                    catchesOrRelays.remove(it);
                }
                CompoundStatement compoundStatement2 = catchClause.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)compoundStatement2, (String)"catchClause.body");
                this.createEOG(compoundStatement2);
                tmpEOGNodes.addAll(this.currentEOG);
            }
            $this$any$iv = tmpEOGNodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Node it = (Node)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!Companion.reachableFromValidEOGRoot(it)) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        boolean canTerminateExceptionfree = bl;
        this.currentEOG.clear();
        this.currentEOG.addAll(tmpEOGNodes);
        if (node.getFinallyBlock() != null) {
            void $this$flatMapTo$iv$iv;
            Iterator<Map.Entry<Type, List<Node>>> $this$flatMap$iv;
            $this$any$iv = catchesOrRelays.entrySet();
            List<Node> list3 = this.currentEOG;
            boolean $i$f$flatMap = false;
            void $this$forEach$iv2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Map.Entry bl3 = (Map.Entry)element$iv$iv;
                boolean bl5 = false;
                List value = (List)bl3.getValue();
                Iterable list$iv$iv = value;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list3.addAll((List)destination$iv$iv);
            CompoundStatement compoundStatement = node.getFinallyBlock();
            Intrinsics.checkNotNullExpressionValue((Object)compoundStatement, (String)"node.finallyBlock");
            this.createEOG(compoundStatement);
            $this$flatMap$iv = catchesOrRelays.entrySet().iterator();
            while ($this$flatMap$iv.hasNext()) {
                List<Node> value = $this$flatMap$iv.next().getValue();
                value.clear();
                value.addAll((Collection<Node>)this.currentEOG);
            }
        }
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        ScopeManager scopeManager = languageFrontend.getScopeManager();
        LanguageFrontend languageFrontend3 = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend3);
        Scope scope = languageFrontend3.getScopeManager().getCurrentScope();
        Intrinsics.checkNotNull((Object)scope);
        Scope outerScope = scopeManager.firstScopeOrNull(scope.getParent(), EvaluationOrderGraphPass::handleTryStatement$lambda$66);
        if (outerScope != null) {
            Map<Type, List<Node>> outerCatchesOrRelays = outerScope instanceof TryScope ? ((TryScope)outerScope).getCatchesOrRelays() : ((FunctionScope)outerScope).getCatchesOrRelays();
            for (Map.Entry<Type, List<Node>> entry : catchesOrRelays.entrySet()) {
                Type key = entry.getKey();
                List<Node> value = entry.getValue();
                List list4 = outerCatchesOrRelays.get(key);
                if (list4 == null) {
                    list4 = new ArrayList();
                }
                List catches = list4;
                catches.addAll((Collection)value);
                outerCatchesOrRelays.put(key, catches);
            }
        }
        LanguageFrontend languageFrontend4 = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend4);
        languageFrontend4.getScopeManager().leaveScope(node);
        if (!canTerminateExceptionfree) {
            this.currentEOG.clear();
        }
        this.pushToEOG(node);
    }

    protected final void handleContinueStatement(@NotNull ContinueStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.pushToEOG(node);
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        languageFrontend.getScopeManager().addContinueStatement(node);
        this.currentEOG.clear();
    }

    protected final void handleDeleteExpression(@NotNull DeleteExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Expression expression = node.getOperand();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"node.operand");
        this.createEOG(expression);
        this.pushToEOG(node);
    }

    protected final void handleBreakStatement(@NotNull BreakStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.pushToEOG(node);
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        languageFrontend.getScopeManager().addBreakStatement(node);
        this.currentEOG.clear();
    }

    protected final void handleLabelStatement(@NotNull LabelStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        languageFrontend.getScopeManager().addLabelStatement(node);
        Statement statement = node.getSubStatement();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"node.subStatement");
        this.createEOG(statement);
    }

    protected final void handleGotoStatement(@NotNull GotoStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.pushToEOG(node);
        if (node.getTargetLabel() != null) {
            LanguageFrontend languageFrontend = this.lang;
            Intrinsics.checkNotNull((Object)languageFrontend);
            languageFrontend.registerObjectListener(node.getTargetLabel(), (arg_0, arg_1) -> EvaluationOrderGraphPass.handleGotoStatement$lambda$67(this, node, arg_0, arg_1));
        }
        this.currentEOG.clear();
    }

    protected final void handleCaseStatement(@NotNull CaseStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Expression expression = node.getCaseExpression();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"node.getCaseExpression()");
        this.createEOG(expression);
        this.pushToEOG(node);
    }

    protected final void handleNewExpression(@NotNull NewExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Expression expression = node.getInitializer();
        if (expression != null) {
            Expression it = expression;
            boolean bl = false;
            this.createEOG(it);
        }
        this.pushToEOG(node);
    }

    protected final void handleCastExpression(@NotNull CastExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Expression expression = node.getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"node.expression");
        this.createEOG(expression);
        this.pushToEOG(node);
    }

    protected final void handleExpressionList(@NotNull ExpressionList node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (Statement expr : node.getExpressions()) {
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"expr");
            this.createEOG(expr);
        }
        this.pushToEOG(node);
    }

    protected final void handleInitializerListExpression(@NotNull InitializerListExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (Expression inits : node.getInitializers()) {
            Intrinsics.checkNotNullExpressionValue((Object)inits, (String)"inits");
            this.createEOG(inits);
        }
        this.pushToEOG(node);
    }

    protected final void handleConstructExpression(@NotNull ConstructExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (Expression arg : node.getArguments()) {
            this.createEOG(arg);
        }
        this.pushToEOG(node);
    }

    public final void pushToEOG(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LOGGER.trace("Pushing " + node.getClass().getSimpleName() + " " + node + " to EOG");
        for (Node intermediate : this.intermediateNodes) {
            LanguageFrontend languageFrontend = this.lang;
            Intrinsics.checkNotNull((Object)languageFrontend);
            languageFrontend.process(intermediate, node);
        }
        this.addMultipleIncomingEOGEdges(this.currentEOG, node);
        this.intermediateNodes.clear();
        this.currentEOG.clear();
        this.currentProperties.clear();
        this.currentEOG.add(node);
    }

    public final void setCurrentEOG(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LOGGER.trace("Setting " + node + " to EOG");
        Object[] objectArray = new Node[]{node};
        this.currentEOG = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public final void setCurrentEOGs(@NotNull List<? extends Node> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        LOGGER.trace("Setting " + nodes + " to EOGs");
        this.currentEOG = new ArrayList(nodes);
    }

    public final void addToCurrentEOG(@NotNull List<? extends Node> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        LOGGER.trace("Adding " + nodes + " to current EOG");
        this.currentEOG.addAll((Collection<Node>)nodes);
    }

    protected final void exitLoop(@NotNull Statement loopStatement, @NotNull LoopScope loopScope) {
        Intrinsics.checkNotNullParameter((Object)loopStatement, (String)"loopStatement");
        Intrinsics.checkNotNullParameter((Object)loopScope, (String)"loopScope");
        this.currentEOG.addAll((Collection<Node>)loopScope.getBreakStatements());
        ArrayList continues = new ArrayList(loopScope.getContinueStatements());
        if (!((Collection)continues).isEmpty()) {
            Statement statement = loopStatement;
            Statement condition = statement instanceof DoStatement ? (Statement)((DoStatement)loopStatement).getCondition() : (statement instanceof ForStatement ? (Statement)((ForStatement)loopStatement).getCondition() : (statement instanceof WhileStatement ? (Statement)((WhileStatement)loopStatement).getCondition() : (statement instanceof AssertStatement ? (Statement)((AssertStatement)loopStatement).getCondition() : loopStatement)));
            List<Node> conditions = SubgraphWalker.getEOGPathEdges(condition).getEntries();
            Intrinsics.checkNotNullExpressionValue(conditions, (String)"conditions");
            Iterable $this$forEach$iv = conditions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node node = (Node)element$iv;
                boolean bl = false;
                List list2 = continues;
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
                this.addMultipleIncomingEOGEdges(list2, node);
            }
        }
    }

    protected final void connectCurrentToLoopStart() {
        LoopScope loopScope;
        if (this.lang == null) {
            LOGGER.warn("Skipping connection of EOG loop to start - no information about frontend available.");
            return;
        }
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        ScopeManager scopeManager = languageFrontend.getScopeManager();
        Intrinsics.checkNotNullExpressionValue((Object)scopeManager, (String)"lang!!.scopeManager");
        Scope scope = ScopeManager.firstScopeOrNull$default(scopeManager, null, EvaluationOrderGraphPass::connectCurrentToLoopStart$lambda$70, 1, null);
        LoopScope loopScope2 = loopScope = scope instanceof LoopScope ? (LoopScope)scope : null;
        if (loopScope == null) {
            LOGGER.error("I am unexpectedly not in a loop, cannot add edge to loop start");
            return;
        }
        Iterable $this$forEach$iv = loopScope.starts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node node = (Node)element$iv;
            boolean bl = false;
            this.addMultipleIncomingEOGEdges(this.currentEOG, node);
        }
    }

    protected final void addEOGEdge(@NotNull Node prev, @NotNull Node next) {
        Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        PropertyEdge<Node> propertyEdge = new PropertyEdge<Node>(prev, next);
        propertyEdge.addProperties((Map<Properties, Object>)this.currentProperties);
        propertyEdge.addProperty(Properties.INDEX, prev.getNextEOG().size());
        propertyEdge.addProperty(Properties.UNREACHABLE, false);
        prev.addNextEOG(propertyEdge);
        next.addPrevEOG(propertyEdge);
    }

    protected final void addMultipleIncomingEOGEdges(@NotNull List<? extends Node> prevs, @NotNull Node next) {
        Intrinsics.checkNotNullParameter(prevs, (String)"prevs");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        Iterable $this$forEach$iv = prevs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node prev = (Node)element$iv;
            boolean bl = false;
            this.addEOGEdge(prev, next);
        }
    }

    protected final void handleSynchronizedStatement(@NotNull SynchronizedStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Expression expression = node.getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"node.getExpression()");
        this.createEOG(expression);
        this.pushToEOG(node);
        CompoundStatement compoundStatement = node.getBlockStatement();
        Intrinsics.checkNotNullExpressionValue((Object)compoundStatement, (String)"node.getBlockStatement()");
        this.createEOG(compoundStatement);
    }

    protected final void handleConditionalExpression(@NotNull ConditionalExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List openBranchNodes = new ArrayList();
        Expression expression = node.getCondition();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"node.condition");
        this.createEOG(expression);
        this.pushToEOG(node);
        ArrayList openConditionEOGs = new ArrayList(this.currentEOG);
        Expression expression2 = node.getThenExpr();
        Intrinsics.checkNotNullExpressionValue((Object)expression2, (String)"node.thenExpr");
        this.createEOG(expression2);
        openBranchNodes.addAll((Collection)this.currentEOG);
        this.setCurrentEOGs(openConditionEOGs);
        Expression expression3 = node.getElseExpr();
        Intrinsics.checkNotNullExpressionValue((Object)expression3, (String)"node.elseExpr");
        this.createEOG(expression3);
        openBranchNodes.addAll((Collection)this.currentEOG);
        this.setCurrentEOGs(openBranchNodes);
    }

    protected final void handleDoStatement(@NotNull DoStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        languageFrontend.getScopeManager().enterScope(node);
        Statement statement = node.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"node.statement");
        this.createEOG(statement);
        Expression expression = node.getCondition();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"node.condition");
        this.createEOG(expression);
        Expression expression2 = node.getCondition();
        Intrinsics.checkNotNullExpressionValue((Object)expression2, (String)"node.condition");
        node.addPrevDFG(expression2);
        this.pushToEOG(node);
        this.connectCurrentToLoopStart();
        LanguageFrontend languageFrontend2 = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend2);
        LoopScope currentLoopScope = (LoopScope)languageFrontend2.getScopeManager().leaveScope(node);
        if (currentLoopScope != null) {
            this.exitLoop(node, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit do loop, but no loop scope: " + node);
        }
    }

    protected final void handleForEachStatement(@NotNull ForEachStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        languageFrontend.getScopeManager().enterScope(node);
        Statement statement = node.getIterable();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"node.iterable");
        this.createEOG(statement);
        Statement statement2 = node.getVariable();
        Intrinsics.checkNotNullExpressionValue((Object)statement2, (String)"node.variable");
        this.createEOG(statement2);
        Statement statement3 = node.getVariable();
        Intrinsics.checkNotNullExpressionValue((Object)statement3, (String)"node.variable");
        node.addPrevDFG(statement3);
        this.pushToEOG(node);
        ArrayList tmpEOGNodes = new ArrayList(this.currentEOG);
        Statement statement4 = node.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)statement4, (String)"node.statement");
        this.createEOG(statement4);
        this.connectCurrentToLoopStart();
        this.currentEOG.clear();
        LanguageFrontend languageFrontend2 = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend2);
        LoopScope currentLoopScope = (LoopScope)languageFrontend2.getScopeManager().leaveScope(node);
        if (currentLoopScope != null) {
            this.exitLoop(node, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit foreach loop, but not in loop scope: " + node);
        }
        this.currentEOG.addAll(tmpEOGNodes);
    }

    protected final void handleForStatement(@NotNull ForStatement node) {
        Node it;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        languageFrontend.getScopeManager().enterScope(node);
        Statement statement = node.getInitializerStatement();
        if (statement != null) {
            it = statement;
            boolean bl = false;
            this.createEOG(it);
        }
        Declaration declaration = node.getConditionDeclaration();
        if (declaration != null) {
            it = declaration;
            boolean bl = false;
            this.createEOG(it);
        }
        Expression expression = node.getCondition();
        if (expression != null) {
            it = expression;
            boolean bl = false;
            this.createEOG(it);
        }
        Util.addDFGEdgesForMutuallyExclusiveBranchingExpression(node, node.getCondition(), node.getConditionDeclaration());
        this.pushToEOG(node);
        ArrayList tmpEOGNodes = new ArrayList(this.currentEOG);
        Statement statement2 = node.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)statement2, (String)"node.statement");
        this.createEOG(statement2);
        Statement statement3 = node.getIterationStatement();
        Intrinsics.checkNotNullExpressionValue((Object)statement3, (String)"node.iterationStatement");
        this.createEOG(statement3);
        this.connectCurrentToLoopStart();
        this.currentEOG.clear();
        LanguageFrontend languageFrontend2 = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend2);
        LoopScope currentLoopScope = (LoopScope)languageFrontend2.getScopeManager().leaveScope(node);
        if (currentLoopScope != null) {
            this.exitLoop(node, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit for loop, but no loop scope: " + node);
        }
        this.currentEOG.addAll(tmpEOGNodes);
    }

    protected final void handleIfStatement(@NotNull IfStatement node) {
        Node it;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List openBranchNodes = new ArrayList();
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        languageFrontend.getScopeManager().enterScopeIfExists(node);
        Statement statement = node.getInitializerStatement();
        if (statement != null) {
            it = statement;
            boolean bl = false;
            this.createEOG(it);
        }
        Declaration declaration = node.getConditionDeclaration();
        if (declaration != null) {
            it = declaration;
            boolean bl = false;
            this.createEOG(it);
        }
        Expression expression = node.getCondition();
        if (expression != null) {
            it = expression;
            boolean bl = false;
            this.createEOG(it);
        }
        Util.addDFGEdgesForMutuallyExclusiveBranchingExpression(node, node.getCondition(), node.getConditionDeclaration());
        this.pushToEOG(node);
        ArrayList openConditionEOGs = new ArrayList(this.currentEOG);
        ((Map)this.currentProperties).put(Properties.BRANCH, true);
        Statement statement2 = node.getThenStatement();
        Intrinsics.checkNotNullExpressionValue((Object)statement2, (String)"node.thenStatement");
        this.createEOG(statement2);
        openBranchNodes.addAll((Collection)this.currentEOG);
        if (node.getElseStatement() != null) {
            this.setCurrentEOGs(openConditionEOGs);
            ((Map)this.currentProperties).put(Properties.BRANCH, false);
            Statement statement3 = node.getElseStatement();
            Intrinsics.checkNotNullExpressionValue((Object)statement3, (String)"node.elseStatement");
            this.createEOG(statement3);
            openBranchNodes.addAll((Collection)this.currentEOG);
        } else {
            openBranchNodes.addAll(openConditionEOGs);
        }
        LanguageFrontend languageFrontend2 = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend2);
        languageFrontend2.getScopeManager().leaveScope(node);
        this.setCurrentEOGs(openBranchNodes);
    }

    protected final void handleSwitchStatement(@NotNull SwitchStatement node) {
        CompoundStatement compoundStatement;
        Object it;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        languageFrontend.getScopeManager().enterScopeIfExists(node);
        Statement statement = node.getInitializerStatement();
        if (statement != null) {
            it = statement;
            boolean bl = false;
            this.createEOG((Node)it);
        }
        Declaration declaration = node.getSelectorDeclaration();
        if (declaration != null) {
            it = declaration;
            boolean bl = false;
            this.createEOG((Node)it);
        }
        Expression expression = node.selector;
        if (expression != null) {
            it = expression;
            boolean bl = false;
            this.createEOG((Node)it);
        }
        Util.addDFGEdgesForMutuallyExclusiveBranchingExpression(node, node.getSelector(), node.getSelectorDeclaration());
        this.pushToEOG(node);
        ArrayList tmp = new ArrayList(this.currentEOG);
        if (node.getStatement() instanceof DoStatement) {
            Statement statement2 = node.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)statement2, (String)"node.statement");
            this.createEOG(statement2);
            Statement statement3 = node.getStatement();
            Intrinsics.checkNotNull((Object)statement3, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.DoStatement");
            Statement statement4 = ((DoStatement)statement3).getStatement();
            Intrinsics.checkNotNull((Object)statement4, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement");
            compoundStatement = (CompoundStatement)statement4;
        } else {
            Statement statement5 = node.getStatement();
            Intrinsics.checkNotNull((Object)statement5, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement");
            compoundStatement = (CompoundStatement)statement5;
        }
        CompoundStatement compound = compoundStatement;
        this.currentEOG = new ArrayList();
        for (Statement subStatement : compound.getStatements()) {
            if (subStatement instanceof CaseStatement || subStatement instanceof DefaultStatement) {
                this.currentEOG.addAll(tmp);
            }
            Intrinsics.checkNotNullExpressionValue((Object)subStatement, (String)"subStatement");
            this.createEOG(subStatement);
        }
        this.pushToEOG(compound);
        LanguageFrontend languageFrontend2 = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend2);
        SwitchScope switchScope = (SwitchScope)languageFrontend2.getScopeManager().leaveScope(node);
        if (switchScope != null) {
            this.currentEOG.addAll((Collection<Node>)switchScope.getBreakStatements());
        } else {
            LOGGER.error("Handling switch statement, but not in switch scope: " + node);
        }
    }

    protected final void handleWhileStatement(@NotNull WhileStatement node) {
        Node it;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        languageFrontend.getScopeManager().enterScope(node);
        Declaration declaration = node.getConditionDeclaration();
        if (declaration != null) {
            it = declaration;
            boolean bl = false;
            this.createEOG(it);
        }
        Expression expression = node.getCondition();
        if (expression != null) {
            it = expression;
            boolean bl = false;
            this.createEOG(it);
        }
        Util.addDFGEdgesForMutuallyExclusiveBranchingExpression(node, node.getCondition(), node.getConditionDeclaration());
        this.pushToEOG(node);
        ArrayList tmpEOGNodes = new ArrayList(this.currentEOG);
        Statement statement = node.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"node.statement");
        this.createEOG(statement);
        this.connectCurrentToLoopStart();
        this.currentEOG.clear();
        LanguageFrontend languageFrontend2 = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend2);
        LoopScope currentLoopScope = (LoopScope)languageFrontend2.getScopeManager().leaveScope(node);
        if (currentLoopScope != null) {
            this.exitLoop(node, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit while loop, but no loop scope: " + node);
        }
        this.currentEOG.addAll(tmpEOGNodes);
    }

    private static final void _init_$lambda$0(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.doNothing(it);
    }

    private static final void _init_$lambda$1(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration");
        this$0.handleTranslationUnitDeclaration((TranslationUnitDeclaration)it);
    }

    private static final void _init_$lambda$2(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration");
        this$0.handleNamespaceDeclaration((NamespaceDeclaration)it);
    }

    private static final void _init_$lambda$3(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration");
        this$0.handleRecordDeclaration((RecordDeclaration)it);
    }

    private static final void _init_$lambda$4(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration");
        this$0.handleFunctionDeclaration((FunctionDeclaration)it);
    }

    private static final void _init_$lambda$5(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration");
        this$0.handleVariableDeclaration((VariableDeclaration)it);
    }

    private static final void _init_$lambda$6(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression");
        this$0.handleCallExpression((CallExpression)it);
    }

    private static final void _init_$lambda$7(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression");
        this$0.handleMemberExpression((MemberExpression)it);
    }

    private static final void _init_$lambda$8(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.ArraySubscriptionExpression");
        this$0.handleArraySubscriptionExpression((ArraySubscriptionExpression)it);
    }

    private static final void _init_$lambda$9(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.ArrayCreationExpression");
        this$0.handleArrayCreationExpression((ArrayCreationExpression)it);
    }

    private static final void _init_$lambda$10(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement");
        this$0.handleDeclarationStatement((DeclarationStatement)it);
    }

    private static final void _init_$lambda$11(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement");
        this$0.handleReturnStatement((ReturnStatement)it);
    }

    private static final void _init_$lambda$12(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator");
        this$0.handleBinaryOperator((BinaryOperator)it);
    }

    private static final void _init_$lambda$13(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator");
        this$0.handleUnaryOperator((UnaryOperator)it);
    }

    private static final void _init_$lambda$14(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement");
        this$0.handleCompoundStatement((CompoundStatement)it);
    }

    private static final void _init_$lambda$15(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.CompoundStatementExpression");
        this$0.handleCompoundStatementExpression((CompoundStatementExpression)it);
    }

    private static final void _init_$lambda$16(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.IfStatement");
        this$0.handleIfStatement((IfStatement)it);
    }

    private static final void _init_$lambda$17(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.AssertStatement");
        this$0.handleAssertStatement((AssertStatement)it);
    }

    private static final void _init_$lambda$18(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.WhileStatement");
        this$0.handleWhileStatement((WhileStatement)it);
    }

    private static final void _init_$lambda$19(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.DoStatement");
        this$0.handleDoStatement((DoStatement)it);
    }

    private static final void _init_$lambda$20(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.ForStatement");
        this$0.handleForStatement((ForStatement)it);
    }

    private static final void _init_$lambda$21(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.ForEachStatement");
        this$0.handleForEachStatement((ForEachStatement)it);
    }

    private static final void _init_$lambda$22(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.TryStatement");
        this$0.handleTryStatement((TryStatement)it);
    }

    private static final void _init_$lambda$23(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.ContinueStatement");
        this$0.handleContinueStatement((ContinueStatement)it);
    }

    private static final void _init_$lambda$24(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.DeleteExpression");
        this$0.handleDeleteExpression((DeleteExpression)it);
    }

    private static final void _init_$lambda$25(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.BreakStatement");
        this$0.handleBreakStatement((BreakStatement)it);
    }

    private static final void _init_$lambda$26(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.SwitchStatement");
        this$0.handleSwitchStatement((SwitchStatement)it);
    }

    private static final void _init_$lambda$27(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.LabelStatement");
        this$0.handleLabelStatement((LabelStatement)it);
    }

    private static final void _init_$lambda$28(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.GotoStatement");
        this$0.handleGotoStatement((GotoStatement)it);
    }

    private static final void _init_$lambda$29(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.CaseStatement");
        this$0.handleCaseStatement((CaseStatement)it);
    }

    private static final void _init_$lambda$30(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.SynchronizedStatement");
        this$0.handleSynchronizedStatement((SynchronizedStatement)it);
    }

    private static final void _init_$lambda$31(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.NewExpression");
        this$0.handleNewExpression((NewExpression)it);
    }

    private static final void _init_$lambda$32(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression");
        this$0.handleCastExpression((CastExpression)it);
    }

    private static final void _init_$lambda$33(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.ExpressionList");
        this$0.handleExpressionList((ExpressionList)it);
    }

    private static final void _init_$lambda$34(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.ConditionalExpression");
        this$0.handleConditionalExpression((ConditionalExpression)it);
    }

    private static final void _init_$lambda$35(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression");
        this$0.handleInitializerListExpression((InitializerListExpression)it);
    }

    private static final void _init_$lambda$36(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression");
        this$0.handleConstructExpression((ConstructExpression)it);
    }

    private static final void _init_$lambda$37(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.EmptyStatement");
        this$0.handleDefault((EmptyStatement)it);
    }

    private static final void _init_$lambda$38(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.handleDefault(it);
    }

    private static final void _init_$lambda$39(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.handleDefault(it);
    }

    private static final void _init_$lambda$40(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.handleDefault(it);
    }

    private static final void _init_$lambda$41(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.handleDefault(it);
    }

    private static final void _init_$lambda$42(EvaluationOrderGraphPass this$0, Node it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.handleDefault(it);
    }

    private static final boolean handleUnaryOperator$lambda$59(Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return scope instanceof TryScope || scope instanceof FunctionScope;
    }

    private static final boolean handleUnaryOperator$lambda$60(Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return Intrinsics.areEqual(scope.getClass(), ValueDeclarationScope.class);
    }

    private static final boolean handleTryStatement$lambda$66(Scope scope) {
        return scope instanceof TryScope || scope instanceof FunctionScope;
    }

    private static final void handleGotoStatement$lambda$67(EvaluationOrderGraphPass this$0, GotoStatement $node, Object object, Object to2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        Node node = $node;
        Intrinsics.checkNotNull((Object)to2, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.Node");
        this$0.addEOGEdge(node, (Node)to2);
    }

    private static final boolean connectCurrentToLoopStart$lambda$70(Scope it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof LoopScope;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0004R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/fraunhofer/aisec/cpg/passes/EvaluationOrderGraphPass$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "checkEOGInvariant", "", "n", "Lde/fraunhofer/aisec/cpg/graph/Node;", "reachableFromValidEOGRoot", "node", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        protected final boolean reachableFromValidEOGRoot(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Set passedBy = new LinkedHashSet();
            ArrayList<Node> workList = new ArrayList<Node>((Collection)node.getPrevEOG());
            while (!((Collection)workList).isEmpty()) {
                Node toProcess = (Node)workList.get(0);
                workList.remove(toProcess);
                Intrinsics.checkNotNullExpressionValue((Object)toProcess, (String)"toProcess");
                passedBy.add(toProcess);
                if (toProcess instanceof FunctionDeclaration) {
                    return true;
                }
                for (Node pred : toProcess.getPrevEOG()) {
                    if (passedBy.contains(pred) || workList.contains(pred)) continue;
                    workList.add(pred);
                }
            }
            return false;
        }

        public final boolean checkEOGInvariant(@NotNull Node n) {
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            List<Node> allNodes = SubgraphWalker.flattenAST(n);
            boolean ret = true;
            for (Node node : allNodes) {
                for (Node next : node.getNextEOG()) {
                    if (next.getPrevEOG().contains(node)) continue;
                    LOGGER.warn("Violation to EOG invariant found: Node " + node + " does not have a back-reference from his EOG-successor " + next + ".");
                    ret = false;
                }
                for (Node prev : node.getPrevEOG()) {
                    if (prev.getNextEOG().contains(node)) continue;
                    LOGGER.warn("Violation to EOG invariant found: Node " + node + " does not have a reference from his EOG-predecessor " + prev + ".");
                    ret = false;
                }
            }
            return ret;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

