/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.graph.AccessValues;
import de.fraunhofer.aisec.cpg.graph.Assignment;
import de.fraunhofer.aisec.cpg.graph.AssignmentTarget;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArrayCreationExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConditionalExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ExpressionList;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.KeyValueExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.LambdaExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.VariableUsageResolver;
import de.fraunhofer.aisec.cpg.passes.order.DependsOn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@DependsOn(value=VariableUsageResolver.class)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J$\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002J\u0016\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\t\u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020-2\u0006\u0010.\u001a\u00020\rH\u0002J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010\t\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u00042\u0006\u0010\t\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u00104\u001a\u00020\u00042\u0006\u0010\t\u001a\u000205H\u0002\u00a8\u00066"}, d2={"Lde/fraunhofer/aisec/cpg/passes/DFGPass;", "Lde/fraunhofer/aisec/cpg/passes/Pass;", "()V", "accept", "", "tr", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "cleanup", "handle", "node", "Lde/fraunhofer/aisec/cpg/graph/Node;", "parent", "inferDfgForUnresolvedSymbols", "", "handleArrayCreationExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ArrayCreationExpression;", "handleArraySubscriptionExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ArraySubscriptionExpression;", "handleAssignment", "Lde/fraunhofer/aisec/cpg/graph/Assignment;", "handleBinaryOp", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/BinaryOperator;", "handleCallExpression", "call", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CallExpression;", "handleCastExpression", "castExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CastExpression;", "handleConditionalExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ConditionalExpression;", "handleDeclaredReferenceExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/DeclaredReferenceExpression;", "handleExpressionList", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ExpressionList;", "handleFieldDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/FieldDeclaration;", "handleFunctionDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "handleInitializerListExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/InitializerListExpression;", "handleKeyValueExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/KeyValueExpression;", "handleLambdaExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/LambdaExpression;", "handleMemberExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/MemberExpression;", "inferDfgForUnresolvedCalls", "handleReturnStatement", "Lde/fraunhofer/aisec/cpg/graph/statements/ReturnStatement;", "handleUnaryOperator", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/UnaryOperator;", "handleUnresolvedCalls", "handleVariableDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/VariableDeclaration;", "cpg-core"})
public final class DFGPass
extends Pass {
    @Override
    public void accept(@NotNull TranslationResult tr) {
        Intrinsics.checkNotNullParameter((Object)tr, (String)"tr");
        boolean inferDfgForUnresolvedCalls = tr.getTranslationManager().getConfig().getInferenceConfiguration().getInferDfgForUnresolvedSymbols();
        SubgraphWalker.IterativeGraphWalker walker = new SubgraphWalker.IterativeGraphWalker();
        walker.registerOnNodeVisit2((arg_0, arg_1) -> DFGPass.accept$lambda$0(this, inferDfgForUnresolvedCalls, arg_0, arg_1));
        for (TranslationUnitDeclaration tu : tr.getTranslationUnits()) {
            walker.iterate(tu);
        }
    }

    @Override
    public void cleanup() {
    }

    private final void handle(Node node, Node parent, boolean inferDfgForUnresolvedSymbols) {
        Node node2 = node;
        if (node2 instanceof CallExpression) {
            this.handleCallExpression((CallExpression)node, inferDfgForUnresolvedSymbols);
        } else if (node2 instanceof CastExpression) {
            this.handleCastExpression((CastExpression)node);
        } else if (node2 instanceof BinaryOperator) {
            this.handleBinaryOp((BinaryOperator)node, parent);
        } else if (node2 instanceof ArrayCreationExpression) {
            this.handleArrayCreationExpression((ArrayCreationExpression)node);
        } else if (node2 instanceof ArraySubscriptionExpression) {
            this.handleArraySubscriptionExpression((ArraySubscriptionExpression)node);
        } else if (node2 instanceof ConditionalExpression) {
            this.handleConditionalExpression((ConditionalExpression)node);
        } else if (node2 instanceof MemberExpression) {
            this.handleMemberExpression((MemberExpression)node, inferDfgForUnresolvedSymbols);
        } else if (node2 instanceof DeclaredReferenceExpression) {
            this.handleDeclaredReferenceExpression((DeclaredReferenceExpression)node);
        } else if (node2 instanceof ExpressionList) {
            this.handleExpressionList((ExpressionList)node);
        } else if (node2 instanceof KeyValueExpression) {
            this.handleKeyValueExpression((KeyValueExpression)node);
        } else if (node2 instanceof LambdaExpression) {
            this.handleLambdaExpression((LambdaExpression)node);
        } else if (node2 instanceof UnaryOperator) {
            this.handleUnaryOperator((UnaryOperator)node);
        } else if (node2 instanceof ReturnStatement) {
            this.handleReturnStatement((ReturnStatement)node);
        } else if (node2 instanceof FieldDeclaration) {
            this.handleFieldDeclaration((FieldDeclaration)node);
        } else if (node2 instanceof FunctionDeclaration) {
            this.handleFunctionDeclaration((FunctionDeclaration)node);
        } else if (node2 instanceof VariableDeclaration) {
            this.handleVariableDeclaration((VariableDeclaration)node);
        } else if (node2 instanceof Assignment) {
            this.handleAssignment((Assignment)((Object)node));
        }
    }

    private final void handleMemberExpression(MemberExpression node, boolean inferDfgForUnresolvedCalls) {
        if (node.getRefersTo() == null && inferDfgForUnresolvedCalls) {
            Expression expression = node.getBase();
            Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"node.base");
            node.addPrevDFG(expression);
        } else {
            this.handleDeclaredReferenceExpression(node);
        }
    }

    private final void handleVariableDeclaration(VariableDeclaration node) {
        block0: {
            Expression expression = node.getInitializer();
            if (expression == null) break block0;
            Expression it = expression;
            boolean bl = false;
            node.addPrevDFG(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleFunctionDeclaration(FunctionDeclaration node) {
        if (node.getBody() instanceof ReturnStatement) {
            Statement statement = node.getBody();
            Intrinsics.checkNotNull((Object)statement, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement");
            node.addPrevDFG((ReturnStatement)statement);
        } else if (node.getBody() instanceof CompoundStatement) {
            void $this$filterIsInstanceTo$iv$iv;
            Statement statement = node.getBody();
            Intrinsics.checkNotNull((Object)statement, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement");
            List<Statement> list2 = ((CompoundStatement)statement).getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"node.body as CompoundSta\u2026              .statements");
            Iterable $this$filterIsInstance$iv = list2;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ReturnStatement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReturnStatement it = (ReturnStatement)element$iv;
                boolean bl = false;
                node.addPrevDFG(it);
            }
        }
    }

    private final void handleFieldDeclaration(FieldDeclaration node) {
        block0: {
            Expression expression = node.getInitializer();
            if (expression == null) break block0;
            Expression it = expression;
            boolean bl = false;
            node.addPrevDFG(it);
        }
    }

    private final void handleReturnStatement(ReturnStatement node) {
        block0: {
            Expression expression = node.getReturnValue();
            if (expression == null) break block0;
            Expression it = expression;
            boolean bl = false;
            node.addPrevDFG(it);
        }
    }

    private final void handleUnaryOperator(UnaryOperator node) {
        block1: {
            Expression expression = node.getInput();
            if (expression == null) break block1;
            Expression it = expression;
            boolean bl = false;
            node.addPrevDFG(it);
            if (Intrinsics.areEqual((Object)node.getOperatorCode(), (Object)"++") || Intrinsics.areEqual((Object)node.getOperatorCode(), (Object)"--")) {
                node.addNextDFG(it);
            }
        }
    }

    private final void handleLambdaExpression(LambdaExpression node) {
        block0: {
            FunctionDeclaration functionDeclaration = node.getFunction();
            if (functionDeclaration == null) break block0;
            FunctionDeclaration it = functionDeclaration;
            boolean bl = false;
            node.addPrevDFG(it);
        }
    }

    private final void handleKeyValueExpression(KeyValueExpression node) {
        block0: {
            Expression expression = node.getValue();
            if (expression == null) break block0;
            Expression it = expression;
            boolean bl = false;
            node.addPrevDFG(it);
        }
    }

    private final void handleInitializerListExpression(InitializerListExpression node) {
        block1: {
            List<Expression> list2 = node.getInitializers();
            if (list2 == null) break block1;
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Expression it = (Expression)element$iv;
                boolean bl = false;
                it.registerTypeListener(node);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                node.addPrevDFG(it);
            }
        }
    }

    private final void handleExpressionList(ExpressionList node) {
        block0: {
            List<Statement> list2 = node.getExpressions();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"node.expressions");
            Statement statement = (Statement)CollectionsKt.lastOrNull(list2);
            if (statement == null) break block0;
            Statement it = statement;
            boolean bl = false;
            node.addPrevDFG(it);
        }
    }

    private final void handleDeclaredReferenceExpression(DeclaredReferenceExpression node) {
        block4: {
            Declaration declaration = node.getRefersTo();
            if (declaration == null) break block4;
            Declaration it = declaration;
            boolean bl = false;
            AccessValues accessValues = node.getAccess();
            switch (accessValues == null ? -1 : WhenMappings.$EnumSwitchMapping$0[accessValues.ordinal()]) {
                case 1: {
                    node.addNextDFG(it);
                    break;
                }
                case 2: {
                    node.addPrevDFG(it);
                    break;
                }
                default: {
                    node.addNextDFG(it);
                    node.addPrevDFG(it);
                }
            }
        }
    }

    private final void handleConditionalExpression(ConditionalExpression node) {
        block1: {
            Expression it;
            Expression expression = node.getThenExpr();
            if (expression != null) {
                it = expression;
                boolean bl = false;
                node.addPrevDFG(it);
            }
            Expression expression2 = node.getElseExpr();
            if (expression2 == null) break block1;
            it = expression2;
            boolean bl = false;
            node.addPrevDFG(it);
        }
    }

    private final void handleArraySubscriptionExpression(ArraySubscriptionExpression node) {
        block0: {
            Expression expression = node.getArrayExpression();
            if (expression == null) break block0;
            Expression it = expression;
            boolean bl = false;
            node.addPrevDFG(it);
        }
    }

    private final void handleArrayCreationExpression(ArrayCreationExpression node) {
        block0: {
            Expression expression = node.getInitializer();
            if (expression == null) break block0;
            Expression it = expression;
            boolean bl = false;
            node.addPrevDFG(it);
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private final void handleBinaryOp(BinaryOperator node, Node parent) {
        Expression it;
        String string = node.getOperatorCode();
        if (string != null) {
            Expression it2;
            int n = -1;
            switch (string.hashCode()) {
                case 1456: {
                    if (!string.equals("-=")) break;
                    n = 1;
                    break;
                }
                case 3905: {
                    if (!string.equals("|=")) break;
                    n = 1;
                    break;
                }
                case 1394: {
                    if (!string.equals("+=")) break;
                    n = 1;
                    break;
                }
                case 1363: {
                    if (!string.equals("*=")) break;
                    n = 1;
                    break;
                }
                case 1239: {
                    if (!string.equals("&=")) break;
                    n = 1;
                    break;
                }
                case 1208: {
                    if (!string.equals("%=")) break;
                    n = 1;
                    break;
                }
                case 61: {
                    if (!string.equals("=")) break;
                    n = 2;
                    break;
                }
                case 59581: {
                    if (!string.equals("<<=")) break;
                    n = 1;
                    break;
                }
                case 61565: {
                    if (!string.equals(">>=")) break;
                    n = 1;
                    break;
                }
                case 1518: {
                    if (!string.equals("/=")) break;
                    n = 1;
                    break;
                }
                case 2975: {
                    if (!string.equals("^=")) break;
                    n = 1;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    Expression expression = node.getRhs();
                    if (expression != null) {
                        Expression it3 = expression;
                        boolean bl = false;
                        node.getLhs().addPrevDFG(it3);
                    }
                }
                if (parent != null) {
                    if (parent instanceof CompoundStatement) return;
                }
                Expression expression = node.getRhs();
                if (expression == null) return;
                expression.addNextDFG(node);
                return;
                case 1: {
                    Expression expression2 = node.getLhs();
                    if (expression2 != null) {
                        it2 = expression2;
                        boolean bl = false;
                        node.addPrevDFG(it2);
                        node.addNextDFG(it2);
                    }
                }
                Expression expression3 = node.getRhs();
                if (expression3 == null) return;
                it2 = expression3;
                boolean bl = false;
                node.addPrevDFG(it2);
                return;
            }
        }
        Expression expression = node.getLhs();
        if (expression != null) {
            it = expression;
            boolean bl = false;
            node.addPrevDFG(it);
        }
        Expression expression4 = node.getRhs();
        if (expression4 == null) return;
        it = expression4;
        boolean bl = false;
        node.addPrevDFG(it);
    }

    private final void handleAssignment(Assignment node) {
        block1: {
            Expression expression = node.getValue();
            if (expression == null) break block1;
            Expression it = expression;
            boolean bl = false;
            AssignmentTarget assignmentTarget = node.getTarget();
            Node node2 = assignmentTarget instanceof Node ? (Node)((Object)assignmentTarget) : null;
            if (node2 != null) {
                node2.addPrevDFG(it);
            }
        }
    }

    private final void handleCastExpression(CastExpression castExpression) {
        block0: {
            Expression expression = castExpression.getExpression();
            if (expression == null) break block0;
            Expression it = expression;
            boolean bl = false;
            castExpression.addPrevDFG(it);
        }
    }

    public final void handleCallExpression(@NotNull CallExpression call, boolean inferDfgForUnresolvedSymbols) {
        Node it;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Iterable $this$forEach$iv = call.getPrevDFG();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Node)element$iv;
            boolean bl = false;
            it.getNextDFG().remove(call);
        }
        call.getPrevDFG().clear();
        if (call.getInvokes().isEmpty() && inferDfgForUnresolvedSymbols) {
            this.handleUnresolvedCalls(call);
        } else if (!((Collection)call.getInvokes()).isEmpty()) {
            $this$forEach$iv = call.getInvokes();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FunctionDeclaration)element$iv;
                boolean bl = false;
                Util.attachCallParameters((FunctionDeclaration)it, call.getArguments());
                call.addPrevDFG(it);
            }
        }
    }

    private final void handleUnresolvedCalls(CallExpression call) {
        Expression expression = call.getBase();
        if (expression != null) {
            Expression it = expression;
            boolean bl = false;
            call.addPrevDFG(it);
        }
        Iterable $this$forEach$iv = call.getArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Expression it = (Expression)element$iv;
            boolean bl = false;
            call.addPrevDFG(it);
        }
    }

    private static final void accept$lambda$0(DFGPass this$0, boolean $inferDfgForUnresolvedCalls, Node node, Node parent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.handle(node, parent, $inferDfgForUnresolvedCalls);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AccessValues.values().length];
            try {
                nArray[AccessValues.WRITE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccessValues.READ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

