/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.InferenceConfiguration;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.HasTemplates;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.ClassTemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ExplicitConstructorInvocation;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.StaticCallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.TypeExpression;
import de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.CXXCallResolverHelperKt;
import de.fraunhofer.aisec.cpg.passes.JavaCallResolverHelperKt;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.SymbolResolverPass;
import de.fraunhofer.aisec.cpg.passes.TemplateCallResolverHelperKt;
import de.fraunhofer.aisec.cpg.passes.VariableUsageResolver;
import de.fraunhofer.aisec.cpg.passes.order.DependsOn;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DependsOn(value=VariableUsageResolver.class)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 >2\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0011H\u0002J,\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J0\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\b\u0010 \u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000fH\u0002J\"\u0010%\u001a\u0004\u0018\u00010\r2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00112\u0006\u0010$\u001a\u00020\u000fH\u0002J \u0010&\u001a\u00020\r2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00112\u0006\u0010$\u001a\u00020\u000fH\u0002J.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0002J(\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\b\u0010$\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0017\u001a\u00020\u0018J&\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00162\u0006\u0010,\u001a\u00020\u0005H\u0002J\"\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010 \u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u0010.\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010/\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u00100\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u00101\u001a\u0002022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u000fH\u0002J\u001a\u00103\u001a\u00020\b2\b\u00104\u001a\u0004\u0018\u00010\u000f2\u0006\u00105\u001a\u00020\u001bH\u0002J\u0010\u00106\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u0010\u00107\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u00108\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020;H\u0002J.\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0002J\u0010\u0010=\u001a\u0002022\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lde/fraunhofer/aisec/cpg/passes/CallResolver;", "Lde/fraunhofer/aisec/cpg/passes/SymbolResolverPass;", "()V", "containingType", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "accept", "", "translationResult", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "cleanup", "createInferredConstructor", "Lde/fraunhofer/aisec/cpg/graph/declarations/ConstructorDeclaration;", "containingRecord", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "signature", "", "createMethodDummies", "invocationCandidates", "", "possibleContainingTypes", "", "call", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CallExpression;", "fixInitializers", "node", "Lde/fraunhofer/aisec/cpg/graph/Node;", "generateInferredStaticallyImportedMethods", "name", "", "invokes", "curClass", "getConstructorDeclaration", "constructExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ConstructExpression;", "recordDeclaration", "getConstructorDeclarationDirectMatch", "getConstructorDeclarationForExplicitInvocation", "getInvocationCandidatesFromParents", "possibleTypes", "getInvocationCandidatesFromRecord", "getOverridingCandidates", "possibleSubTypes", "declaration", "getPossibleContainingTypes", "handleCallExpression", "handleMethodCall", "handleNormalCalls", "handlePossibleStaticImport", "", "registerMethods", "currentClass", "currentNode", "resolve", "resolveArguments", "resolveConstructExpression", "resolveExplicitConstructorInvocation", "eci", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ExplicitConstructorInvocation;", "retrieveInvocationCandidatesFromCall", "shouldSearchForInvokesInParent", "Companion", "cpg-core"})
public class CallResolver
extends SymbolResolverPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<FunctionDeclaration, Type> containingType = new LinkedHashMap();
    @NotNull
    private static final Logger LOGGER;

    @Override
    public void cleanup() {
        this.containingType.clear();
    }

    @Override
    public void accept(@NotNull TranslationResult translationResult) {
        Intrinsics.checkNotNullParameter((Object)translationResult, (String)"translationResult");
        if (this.lang == null) {
            Pass.log.error("No language frontend specified. Can't resolve anything.");
            return;
        }
        LanguageFrontend languageFrontend = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend);
        this.scopeManager = languageFrontend.getScopeManager();
        LanguageFrontend languageFrontend2 = this.lang;
        Intrinsics.checkNotNull((Object)languageFrontend2);
        this.config = languageFrontend2.getConfig();
        this.setWalker(new SubgraphWalker.ScopedWalker(this.scopeManager));
        this.getWalker().registerHandler((arg_0, arg_1, arg_2) -> CallResolver.accept$lambda$0(this, arg_0, arg_1, arg_2));
        this.getWalker().registerHandler((arg_0, arg_1) -> CallResolver.accept$lambda$1(this, arg_0, arg_1));
        this.getWalker().registerHandler((arg_0, arg_1) -> CallResolver.accept$lambda$2(this, arg_0, arg_1));
        this.getWalker().registerHandler((arg_0, arg_1, arg_2) -> CallResolver.accept$lambda$3(this, arg_0, arg_1, arg_2));
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            this.getWalker().iterate(tu);
        }
        this.getWalker().clearCallbacks();
        this.getWalker().registerHandler((arg_0, arg_1) -> CallResolver.accept$lambda$4(this, arg_0, arg_1));
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            this.getWalker().iterate(tu);
        }
        this.getWalker().clearCallbacks();
        this.getWalker().registerHandler((arg_0, arg_1) -> CallResolver.accept$lambda$5(this, arg_0, arg_1));
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            this.getWalker().iterate(tu);
        }
    }

    private final void registerMethods(RecordDeclaration currentClass, Node currentNode) {
        if (currentNode instanceof MethodDeclaration && currentClass != null) {
            Map<FunctionDeclaration, Type> map = this.containingType;
            Node node = currentNode;
            Type type = TypeParser.createFrom(currentClass.getName(), true);
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"createFrom(currentClass.name, true)");
            Type type2 = type;
            map.put((FunctionDeclaration)node, type2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fixInitializers(Node node) {
        if (node instanceof VariableDeclaration) {
            String typeString = ((VariableDeclaration)node).getType().getRoot().getName();
            if (this.getRecordMap().containsKey(typeString)) {
                Expression currInitializer = ((VariableDeclaration)node).getInitializer();
                if (currInitializer == null && ((VariableDeclaration)node).isImplicitInitializerAllowed()) {
                    ConstructExpression initializer = NodeBuilder.newConstructExpression$default("()", null, null, 6, null);
                    initializer.setImplicit(true);
                    ((VariableDeclaration)node).setInitializer(initializer);
                    List<Node> list2 = ((VariableDeclaration)node).getTemplateParameters();
                    if (list2 != null) {
                        List<Node> it = list2;
                        boolean bl = false;
                        Companion.addImplicitTemplateParametersToCall(it, initializer);
                    }
                } else if (currInitializer instanceof CallExpression && Intrinsics.areEqual((Object)((CallExpression)currInitializer).getName(), (Object)typeString)) {
                    void $this$mapTo$iv$iv;
                    List<Expression> arguments2 = ((CallExpression)currInitializer).getArguments();
                    Iterable $this$map$iv = arguments2;
                    boolean $i$f$map = false;
                    Iterable bl = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        Node node2 = (Node)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(p0.getCode());
                    }
                    String signature2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                    ConstructExpression initializer = NodeBuilder.newConstructExpression$default("(" + signature2 + ")", null, null, 6, null);
                    Collection $this$toTypedArray$iv = arguments2;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Expression[] expressionArray = thisCollection$iv.toArray(new Expression[0]);
                    Intrinsics.checkNotNull((Object)expressionArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    Expression[] expressionArray2 = expressionArray;
                    initializer.setArguments(CollectionsKt.mutableListOf((Object[])Arrays.copyOf(expressionArray2, expressionArray2.length)));
                    initializer.setImplicit(true);
                    ((VariableDeclaration)node).setInitializer(initializer);
                    ((CallExpression)currInitializer).disconnectFromGraph();
                }
            }
        }
    }

    protected final void resolve(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Node node2 = node;
        if (node2 instanceof TranslationUnitDeclaration) {
            this.setCurrentTU((TranslationUnitDeclaration)node);
        } else if (node2 instanceof ExplicitConstructorInvocation) {
            this.resolveExplicitConstructorInvocation((ExplicitConstructorInvocation)node);
        } else if (node2 instanceof ConstructExpression) {
            this.resolveArguments((CallExpression)node);
            this.resolveConstructExpression((ConstructExpression)node);
        } else if (node2 instanceof CallExpression) {
            this.resolveArguments((CallExpression)node);
            ScopeManager scopeManager = this.scopeManager;
            Intrinsics.checkNotNull((Object)scopeManager);
            this.handleCallExpression(scopeManager.getCurrentRecord(), (CallExpression)node);
        }
    }

    private final void handleCallExpression(RecordDeclaration curClass, CallExpression call) {
        if (this.getLanguage(call) instanceof JavaLanguageFrontend) {
            CharSequence charSequence;
            DeclaredReferenceExpression declaredReferenceExpression;
            Object object = call.getBase();
            DeclaredReferenceExpression declaredReferenceExpression2 = declaredReferenceExpression = object instanceof DeclaredReferenceExpression ? (DeclaredReferenceExpression)object : null;
            boolean bl = declaredReferenceExpression != null && (object = declaredReferenceExpression.getName()) != null ? new Regex("(?<class>.+\\.)?super").matches(charSequence = (CharSequence)object) : false;
            if (bl) {
                RecordDeclaration recordDeclaration = curClass;
                Intrinsics.checkNotNull((Object)recordDeclaration);
                JavaCallResolverHelperKt.handleSuperCall(this, recordDeclaration, call);
                return;
            }
        }
        if (call instanceof MemberCallExpression) {
            Node member = ((MemberCallExpression)call).getMember();
            if (!(member instanceof HasType) || !(((HasType)((Object)member)).getType() instanceof FunctionPointerType)) {
                this.handleMethodCall(curClass, call);
            }
            return;
        }
        if (call.instantiatesTemplate() && this.getLanguage(call) instanceof HasTemplates) {
            CXXCallResolverHelperKt.handleTemplateFunctionCalls(this, curClass, call, true);
            return;
        }
        Optional<? extends ValueDeclaration> funcPointer = this.getWalker().getDeclarationForScope(call, arg_0 -> CallResolver.handleCallExpression$lambda$7(call, arg_0));
        if (!funcPointer.isPresent()) {
            this.handleNormalCalls(curClass, call);
        }
    }

    private final void resolveArguments(CallExpression call) {
        Deque worklist = new ArrayDeque();
        Iterable $this$forEach$iv = call.getArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Expression it = (Expression)element$iv;
            boolean bl = false;
            worklist.push(it);
        }
        while (!worklist.isEmpty()) {
            Iterator<Node> it;
            Node curr = (Node)worklist.pop();
            if (curr instanceof CallExpression) {
                this.resolve(curr);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(Strategy.AST_FORWARD(curr), (String)"AST_FORWARD(curr)");
            while (it.hasNext()) {
                Node astChild = it.next();
                if (astChild instanceof RecordDeclaration) continue;
                worklist.push(astChild);
            }
        }
    }

    protected void handleNormalCalls(@Nullable RecordDeclaration curClass, @NotNull CallExpression call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (curClass == null) {
            if (this.getLanguage(call) instanceof CXXLanguageFrontend) {
                CXXCallResolverHelperKt.handleNormalCallCXX(this, call);
            } else {
                ScopeManager scopeManager = this.scopeManager;
                Intrinsics.checkNotNull((Object)scopeManager);
                List invocationCandidates = CollectionsKt.toMutableList((Collection)ScopeManager.resolveFunction$default(scopeManager, call, null, 2, null));
                if (invocationCandidates.isEmpty()) {
                    invocationCandidates.add(this.createInferredFunctionDeclaration(null, call.getName(), call.getCode(), false, call.getSignature(), call.getType()));
                }
                call.setInvokes(invocationCandidates);
            }
        } else if (!this.handlePossibleStaticImport(call, curClass)) {
            this.handleMethodCall(curClass, call);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void handleMethodCall(@Nullable RecordDeclaration curClass, @NotNull CallExpression call) {
        Regex $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Set<Type> possibleContainingTypes = this.getPossibleContainingTypes(call, curClass);
        Iterable iterable = call.getInvokes();
        boolean $i$f$map2 = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FunctionDeclaration functionDeclaration = (FunctionDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(this.getOverridingCandidates(possibleContainingTypes, (FunctionDeclaration)it));
        }
        List invocationCandidates = CollectionsKt.toMutableList((Collection)CollectionsKt.flatten((Iterable)((List)destination$iv$iv2)));
        if (invocationCandidates.isEmpty()) {
            invocationCandidates = this.retrieveInvocationCandidatesFromCall(call, curClass, possibleContainingTypes);
        }
        if (invocationCandidates.isEmpty() && (!(this.getLanguage(call) instanceof CXXLanguageFrontend) || this.shouldSearchForInvokesInParent(call))) {
            void $this$toTypedArray$iv;
            List list2;
            Collection $this$dropLastWhile$iv;
            Object $i$f$map2 = call.getName();
            $this$mapTo$iv$iv = new Regex("\\.");
            int destination$iv$iv2 = 0;
            $i$f$map2 = $this$mapTo$iv$iv.split((CharSequence)$i$f$map2, destination$iv$iv2);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list2;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            String[] nameParts = stringArray;
            if (!(nameParts.length == 0)) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = possibleContainingTypes;
                boolean $i$f$mapNotNull = false;
                Iterable it = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    RecordDeclaration it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Type it2 = (Type)element$iv$iv;
                    boolean bl2 = false;
                    if (this.getRecordMap().get(it2.getRoot().getTypeName()) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                Set records2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
                invocationCandidates = CollectionsKt.toMutableList((Collection)this.getInvocationCandidatesFromParents(nameParts[nameParts.length - 1], call, records2));
            }
        }
        this.createMethodDummies(invocationCandidates, possibleContainingTypes, call);
        call.setInvokes(invocationCandidates);
    }

    private final List<FunctionDeclaration> retrieveInvocationCandidatesFromCall(CallExpression call, RecordDeclaration curClass, Set<? extends Type> possibleContainingTypes) {
        List list2;
        if (this.getLanguage(call) instanceof CXXLanguageFrontend) {
            list2 = CollectionsKt.toMutableList((Collection)CXXCallResolverHelperKt.handleCXXMethodCall(this, curClass, possibleContainingTypes, call));
        } else {
            ScopeManager scopeManager = this.scopeManager;
            Intrinsics.checkNotNull((Object)scopeManager);
            list2 = CollectionsKt.toMutableList((Collection)ScopeManager.resolveFunction$default(scopeManager, call, null, 2, null));
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final void createMethodDummies(List<FunctionDeclaration> invocationCandidates, Set<? extends Type> possibleContainingTypes, CallExpression call) {
        if (invocationCandidates.isEmpty()) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Iterable iterable = possibleContainingTypes;
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                RecordDeclaration it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                Type it = (Type)element$iv$iv;
                boolean bl2 = false;
                RecordDeclaration record = this.getRecordMap().get(it.getRoot().getTypeName());
                if (record == null) {
                    Object object2 = this.config;
                    boolean bl3 = object2 != null && (object2 = ((TranslationConfiguration)object2).getInferenceConfiguration()) != null ? ((InferenceConfiguration)object2).getInferRecords() : false;
                    if (bl3) {
                        SymbolResolverPass symbolResolverPass = this;
                        String string = it.getRoot().getTypeName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.root.typeName");
                        record = SymbolResolverPass.inferRecordDeclaration$default(symbolResolverPass, it, string, null, 4, null);
                    }
                }
                if (record == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (RecordDeclaration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.createInferredFunctionDeclaration((RecordDeclaration)it, call.getName(), call.getCode(), false, call.getSignature(), call.getType()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                FunctionDeclaration it = (FunctionDeclaration)element$iv;
                boolean bl = false;
                invocationCandidates.add(it);
            }
        }
    }

    private final boolean shouldSearchForInvokesInParent(CallExpression call) {
        if (this.scopeManager == null) {
            Util.errorWithFileLocation(call, Pass.log, "Could not search for invokes in parent: scopeManager is null", new Object[0]);
            return false;
        }
        ScopeManager scopeManager = this.scopeManager;
        Intrinsics.checkNotNull((Object)scopeManager);
        return scopeManager.resolveFunctionStopScopeTraversalOnDefinition(call).isEmpty();
    }

    private final void resolveConstructExpression(ConstructExpression constructExpression) {
        String typeName = constructExpression.getType().getTypeName();
        RecordDeclaration recordDeclaration = this.getRecordMap().get(typeName);
        constructExpression.setInstantiates(recordDeclaration);
        for (TemplateDeclaration template : this.getTemplateList()) {
            int defaultDifference;
            if (!(template instanceof ClassTemplateDeclaration) || !((ClassTemplateDeclaration)template).getRealization().contains(recordDeclaration) || constructExpression.getTemplateParameters().size() > template.getParameters().size() || (defaultDifference = template.getParameters().size() - constructExpression.getTemplateParameters().size()) > template.getParameterDefaults().size()) continue;
            TemplateCallResolverHelperKt.addRecursiveDefaultTemplateArgs(constructExpression, (ClassTemplateDeclaration)template);
            List<Node> missingNewParams = template.getParameterDefaults().subList(constructExpression.getTemplateParameters().size(), template.getParameterDefaults().size());
            for (Node missingParam : missingNewParams) {
                constructExpression.addTemplateParameter(missingParam, TemplateDeclaration.TemplateInitialization.DEFAULT);
            }
            constructExpression.setTemplateInstantiation(template);
            break;
        }
        if (recordDeclaration != null) {
            ConstructorDeclaration constructor = this.getConstructorDeclaration(constructExpression, recordDeclaration);
            constructExpression.setConstructor(constructor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveExplicitConstructorInvocation(ExplicitConstructorInvocation eci) {
        if (eci.getContainingClass() != null) {
            void $this$mapTo$iv$iv;
            RecordDeclaration recordDeclaration = this.getRecordMap().get(eci.getContainingClass());
            Iterable $this$map$iv = eci.getArguments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expression expression = (Expression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getType());
            }
            List signature2 = (List)destination$iv$iv;
            if (recordDeclaration != null) {
                ConstructorDeclaration constructor = this.getConstructorDeclarationForExplicitInvocation(signature2, recordDeclaration);
                List invokes = new ArrayList();
                invokes.add(constructor);
                eci.setInvokes(invokes);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean handlePossibleStaticImport(CallExpression call, RecordDeclaration curClass) {
        boolean bl;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        String string = call.getName().substring(StringsKt.lastIndexOf$default((CharSequence)call.getName(), (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String name2 = string;
        Set<ValueDeclaration> set = curClass.getStaticImports();
        Intrinsics.checkNotNullExpressionValue(set, (String)"curClass.staticImports");
        Iterable $this$filterIsInstance$iv = set;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FunctionDeclaration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FunctionDeclaration it = (FunctionDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)name2) || StringsKt.endsWith$default((String)it.getName(), (String)("." + name2), (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nameMatches = (List)destination$iv$iv;
        if (nameMatches.isEmpty()) {
            bl = false;
        } else {
            Object v3;
            List invokes;
            block7: {
                invokes = new ArrayList();
                Iterable $this$firstOrNull$iv = nameMatches;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FunctionDeclaration it = (FunctionDeclaration)element$iv;
                    boolean bl3 = false;
                    if (!it.hasSignature(call.getSignature())) continue;
                    v3 = element$iv;
                    break block7;
                }
                v3 = null;
            }
            FunctionDeclaration target = v3;
            if (target == null) {
                this.generateInferredStaticallyImportedMethods(call, name2, invokes, curClass);
            } else {
                invokes.add(target);
            }
            call.setInvokes(invokes);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateInferredStaticallyImportedMethods(CallExpression call, String name2, List<FunctionDeclaration> invokes, RecordDeclaration curClass) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if (curClass == null) {
            LOGGER.warn("Cannot generate inferred nodes for imports of a null class: " + call);
            return;
        }
        List<String> list2 = curClass.getStaticImportStatements();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"curClass.staticImportStatements");
        Iterable iterable = list2;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!StringsKt.endsWith$default((String)it, (String)("." + name2), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            String string = it.substring(0, StringsKt.lastIndexOf$default((CharSequence)it, (char)'.', (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RecordDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.getRecordMap().get(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List containingRecords = (List)destination$iv$iv;
        for (RecordDeclaration recordDeclaration : containingRecords) {
            FunctionDeclaration inferred = this.createInferredFunctionDeclaration(recordDeclaration, name2, "", true, call.getSignature(), call.getType());
            invokes.add(inferred);
        }
    }

    private final ConstructorDeclaration createInferredConstructor(RecordDeclaration containingRecord, List<? extends Type> signature2) {
        ConstructorDeclaration inferred = NodeBuilder.newConstructorDeclaration$default(containingRecord.getName(), "", containingRecord, null, null, 24, null);
        inferred.setInferred(true);
        List<ParamVariableDeclaration> list2 = Util.createInferredParameters(signature2);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"createInferredParameters(signature)");
        inferred.setParameters(list2);
        containingRecord.addConstructor(inferred);
        return inferred;
    }

    private final Set<Type> getPossibleContainingTypes(Node node, RecordDeclaration curClass) {
        Set possibleTypes = new LinkedHashSet();
        if (node instanceof MemberCallExpression) {
            Expression expression = ((MemberCallExpression)node).getBase();
            Intrinsics.checkNotNull((Object)expression);
            Expression base = expression;
            Type type = base.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"base.type");
            possibleTypes.add(type);
            List<Type> list2 = base.getPossibleSubTypes();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"base.possibleSubTypes");
            possibleTypes.addAll((Collection)list2);
        } else if (node instanceof StaticCallExpression) {
            if (((StaticCallExpression)node).getTargetRecord() != null) {
                Type type = TypeParser.createFrom(((StaticCallExpression)node).getTargetRecord(), true);
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"createFrom(node.targetRecord, true)");
                possibleTypes.add(type);
            }
        } else if (curClass != null) {
            Type type = TypeParser.createFrom(curClass.getName(), true);
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"createFrom(curClass.name, true)");
            possibleTypes.add(type);
        }
        return possibleTypes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FunctionDeclaration> getInvocationCandidatesFromRecord(@Nullable RecordDeclaration recordDeclaration, @Nullable String name2, @NotNull CallExpression call) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (recordDeclaration == null) {
            return CollectionsKt.emptyList();
        }
        Pattern namePattern = Pattern.compile("(" + Pattern.quote(recordDeclaration.getName()) + "\\.)?" + Pattern.quote(name2));
        if (this.getLanguage(call) instanceof CXXLanguageFrontend) {
            Intrinsics.checkNotNullExpressionValue((Object)namePattern, (String)"namePattern");
            list2 = CXXCallResolverHelperKt.getInvocationCandidatesFromRecordCXX(recordDeclaration, call, namePattern);
        } else {
            void $this$filterTo$iv$iv;
            List<MethodDeclaration> list3 = recordDeclaration.getMethods();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"recordDeclaration.methods");
            Iterable $this$filter$iv = list3;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MethodDeclaration it = (MethodDeclaration)element$iv$iv;
                boolean bl = false;
                if (!(namePattern.matcher(it.getName()).matches() && it.hasSignature(call.getSignature()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FunctionDeclaration> getInvocationCandidatesFromParents(String name2, CallExpression call, Set<? extends RecordDeclaration> possibleTypes) {
        List list2;
        Collection $this$toTypedArray$iv = possibleTypes;
        boolean $i$f$toTypedArray = false;
        Iterable thisCollection$iv = $this$toTypedArray$iv;
        RecordDeclaration[] recordDeclarationArray = thisCollection$iv.toArray(new RecordDeclaration[0]);
        Intrinsics.checkNotNull((Object)recordDeclarationArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        RecordDeclaration[] recordDeclarationArray2 = recordDeclarationArray;
        Set workingPossibleTypes = SetsKt.mutableSetOf((Object[])Arrays.copyOf(recordDeclarationArray2, recordDeclarationArray2.length));
        if (possibleTypes.isEmpty()) {
            list2 = CollectionsKt.emptyList();
        } else {
            Collection collection;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = possibleTypes;
            boolean $i$f$map = false;
            thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Iterator iterator = (RecordDeclaration)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(this.getInvocationCandidatesFromRecord((RecordDeclaration)it, name2, call));
            }
            List firstLevelCandidates = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            if (this.getLanguage(call) instanceof CXXLanguageFrontend) {
                workingPossibleTypes.removeIf(arg_0 -> CallResolver.getInvocationCandidatesFromParents$lambda$23((Function1)new Function1<RecordDeclaration, Boolean>(name2){
                    final /* synthetic */ String $name;
                    {
                        this.$name = $name;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull RecordDeclaration recordDeclaration) {
                        Intrinsics.checkNotNullParameter((Object)recordDeclaration, (String)"recordDeclaration");
                        return !CXXCallResolverHelperKt.shouldContinueSearchInParent(recordDeclaration, this.$name);
                    }
                }, arg_0));
            }
            if ((collection2 = (Collection)firstLevelCandidates).isEmpty()) {
                Set it;
                Collection collection4;
                Iterable $this$mapTo$iv$iv2;
                Iterable $this$map$iv2;
                boolean bl = false;
                $this$mapTo$iv$iv = workingPossibleTypes;
                boolean $i$f$map2 = false;
                void $i$f$mapTo2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    RecordDeclaration recordDeclaration = (RecordDeclaration)item$iv$iv;
                    collection4 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection4.add(((RecordDeclaration)((Object)it)).getSuperTypeDeclarations());
                }
                $this$map$iv2 = (List)destination$iv$iv2;
                $i$f$map2 = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it = (Set)item$iv$iv;
                    collection4 = destination$iv$iv2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection4.add(this.getInvocationCandidatesFromParents(name2, call, it));
                }
                collection = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
            } else {
                collection = collection2;
            }
            list2 = (List)collection;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<FunctionDeclaration> getOverridingCandidates(Set<? extends Type> possibleSubTypes, FunctionDeclaration declaration) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = declaration.getOverriddenBy();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FunctionDeclaration f = (FunctionDeclaration)element$iv$iv;
            boolean bl = false;
            if (!possibleSubTypes.contains(this.containingType.get(f))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final ConstructorDeclaration getConstructorDeclarationDirectMatch(List<? extends Type> signature2, RecordDeclaration recordDeclaration) {
        for (ConstructorDeclaration constructor : recordDeclaration.getConstructors()) {
            if (!constructor.hasSignature(signature2)) continue;
            return constructor;
        }
        return null;
    }

    private final ConstructorDeclaration getConstructorDeclaration(ConstructExpression constructExpression, RecordDeclaration recordDeclaration) {
        ConstructorDeclaration constructorDeclaration;
        List<Type> signature2 = constructExpression.getSignature();
        ConstructorDeclaration constructorCandidate = this.getConstructorDeclarationDirectMatch(signature2, recordDeclaration);
        if (constructorCandidate == null && this.getLanguage(constructExpression) instanceof CXXLanguageFrontend) {
            constructorCandidate = CXXCallResolverHelperKt.resolveConstructorWithDefaults(constructExpression, signature2, recordDeclaration);
        }
        if (constructorCandidate == null && this.getLanguage(constructExpression) instanceof CXXLanguageFrontend) {
            constructorCandidate = CXXCallResolverHelperKt.resolveConstructorWithImplicitCast(constructExpression, recordDeclaration);
        }
        if ((constructorDeclaration = constructorCandidate) == null) {
            constructorDeclaration = this.createInferredConstructor(recordDeclaration, constructExpression.getSignature());
        }
        return constructorDeclaration;
    }

    private final ConstructorDeclaration getConstructorDeclarationForExplicitInvocation(List<? extends Type> signature2, RecordDeclaration recordDeclaration) {
        ConstructorDeclaration constructorDeclaration;
        Object v1;
        block2: {
            List<ConstructorDeclaration> list2 = recordDeclaration.getConstructors();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"recordDeclaration.constructors");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ConstructorDeclaration it = (ConstructorDeclaration)element$iv;
                boolean bl = false;
                if (!it.hasSignature(signature2)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        if ((constructorDeclaration = (ConstructorDeclaration)v1) == null) {
            constructorDeclaration = this.createInferredConstructor(recordDeclaration, signature2);
        }
        return constructorDeclaration;
    }

    private static final void accept$lambda$0(CallResolver this$0, RecordDeclaration recordDeclaration, Node node, Node currNode) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getWalker().collectDeclarations(currNode);
    }

    private static final void accept$lambda$1(CallResolver this$0, Node node, RecordDeclaration recordDeclaration) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
        this$0.findRecords(node);
    }

    private static final void accept$lambda$2(CallResolver this$0, Node node, RecordDeclaration recordDeclaration) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
        this$0.findTemplates(node);
    }

    private static final void accept$lambda$3(CallResolver this$0, RecordDeclaration currentClass, Node node, Node currentNode) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)currentNode, (String)"currentNode");
        this$0.registerMethods(currentClass, currentNode);
    }

    private static final void accept$lambda$4(CallResolver this$0, Node node, RecordDeclaration recordDeclaration) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
        this$0.fixInitializers(node);
    }

    private static final void accept$lambda$5(CallResolver this$0, Node node, RecordDeclaration recordDeclaration) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
        this$0.resolve(node);
    }

    private static final boolean handleCallExpression$lambda$7(CallExpression $call, ValueDeclaration v) {
        Intrinsics.checkNotNullParameter((Object)$call, (String)"$call");
        return v.getType() instanceof FunctionPointerType && Intrinsics.areEqual((Object)v.getName(), (Object)$call.getName());
    }

    private static final boolean getInvocationCandidatesFromParents$lambda$23(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Logger logger = LoggerFactory.getLogger(CallResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(CallResolver::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lde/fraunhofer/aisec/cpg/passes/CallResolver$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "addImplicitTemplateParametersToCall", "", "templateParams", "", "Lde/fraunhofer/aisec/cpg/graph/Node;", "constructExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ConstructExpression;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public final void addImplicitTemplateParametersToCall(@NotNull List<? extends Node> templateParams, @NotNull ConstructExpression constructExpression) {
            Intrinsics.checkNotNullParameter(templateParams, (String)"templateParams");
            Intrinsics.checkNotNullParameter((Object)constructExpression, (String)"constructExpression");
            for (Node node : templateParams) {
                if (node instanceof TypeExpression) {
                    CallExpression.addTemplateParameter$default(constructExpression, NodeBuilder.duplicateTypeExpression((TypeExpression)node, true), null, 2, null);
                    continue;
                }
                if (!(node instanceof Literal)) continue;
                CallExpression.addTemplateParameter$default(constructExpression, NodeBuilder.duplicateLiteral((Literal)node, true), null, 2, null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

