/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.graph.HasDefault;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionTemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TypeParamDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.TypeExpression;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.ParameterizedType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.CallResolver;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u00a8\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0006\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u001ad\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0016\u0010\r\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e2\u0016\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140\u000e\u001a4\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00052\u0006\u0010\u001a\u001a\u00020\u00032\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u0005\u001a&\u0010\u001d\u001a\u00020\u00012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u001a$\u0010 \u001a\u00020\u00162\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u0005\u001ad\u0010#\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010$2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0016\u0010%\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00120$2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140$2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001e\u001a@\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020)0\u000e2\u0016\u0010\r\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e\u001a\u001e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\f\u001a$\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/\u001a*\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020)0\u000e2\u0016\u00101\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e\u001ad\u00102\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0016\u0010%\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00120$2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140$2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001e\u001aZ\u00103\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u00104\u001a\u00020\u00142\u0016\u00105\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100$2\u0016\u0010%\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00120$2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140$\u001a\u0018\u00106\u001a\u00020\u00162\u0006\u00107\u001a\u00020\u00102\b\u00108\u001a\u0004\u0018\u00010\u000f\u001a(\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<2\u000e\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00052\u0006\u0010,\u001a\u00020-\u001a\u0018\u0010>\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<2\u0006\u0010,\u001a\u00020-\u001a\"\u0010?\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u001a\"\u0010A\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u001a\u001a\u0010B\u001a\u00020\u00162\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010C\u001a\u0004\u0018\u00010D\u001a<\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u001e2\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00052\u000e\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010G0\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u0005\u001a\u001c\u0010H\u001a\u00020\n*\u00020I2\b\u0010J\u001a\u0004\u0018\u00010-2\u0006\u0010\u0002\u001a\u00020\u0003\u001a0\u0010K\u001a\b\u0012\u0004\u0012\u00020\f0\u0005*\u00020I2\b\u0010L\u001a\u0004\u0018\u00010-2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00190N2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010O\u001a\u00020\u0001*\u00020I2\u0006\u0010\u0002\u001a\u00020\u0003\u001a$\u0010P\u001a\u00020\u0016*\u00020I2\b\u0010L\u001a\u0004\u0018\u00010-2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010Q\u001a\u00020\u0016\u001a\u0018\u0010R\u001a\b\u0012\u0004\u0012\u00020\f0\u0005*\u00020I2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010S\u001a\b\u0012\u0004\u0012\u00020\f0\u0005*\u00020I2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006T"}, d2={"applyImplicitCastToArguments", "", "call", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CallExpression;", "implicitCasts", "", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/CastExpression;", "applyTemplateInstantiation", "templateCall", "functionTemplateDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionTemplateDeclaration;", "function", "Lde/fraunhofer/aisec/cpg/graph/declarations/FunctionDeclaration;", "initializationSignature", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/Declaration;", "Lde/fraunhofer/aisec/cpg/graph/Node;", "initializationType", "Lde/fraunhofer/aisec/cpg/graph/declarations/TemplateDeclaration$TemplateInitialization;", "orderedInitializationSignature", "", "checkArgumentValidity", "", "functionDeclaration", "functionDeclarationSignature", "Lde/fraunhofer/aisec/cpg/graph/types/Type;", "templateCallExpression", "explicitInstantiation", "Lde/fraunhofer/aisec/cpg/graph/types/ParameterizedType;", "checkMostCommonImplicitCast", "", "implicitCastTargets", "compatibleSignatures", "callSignature", "functionSignature", "constructTemplateInitializationSignatureFromTemplateParameters", "", "instantiationType", "explicitInstantiated", "getCallSignature", "parameterizedTypeResolution", "Lde/fraunhofer/aisec/cpg/graph/declarations/TypeParamDeclaration;", "getCallSignatureWithDefaults", "getInvocationCandidatesFromRecordCXX", "recordDeclaration", "Lde/fraunhofer/aisec/cpg/graph/declarations/RecordDeclaration;", "namePattern", "Ljava/util/regex/Pattern;", "getParameterizedSignaturesFromInitialization", "initialization", "getTemplateInitializationSignature", "handleImplicitTemplateParameter", "index", "instantiationSignature", "isInstantiated", "callParameterArg", "templateParameter", "resolveConstructorWithDefaults", "Lde/fraunhofer/aisec/cpg/graph/declarations/ConstructorDeclaration;", "constructExpression", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/ConstructExpression;", "signature", "resolveConstructorWithImplicitCast", "resolveWithDefaultArgs", "initialInvocationCandidates", "resolveWithImplicitCast", "shouldContinueSearchInParent", "name", "", "signatureWithImplicitCastTransformation", "arguments", "Lde/fraunhofer/aisec/cpg/graph/statements/expressions/Expression;", "createInferredFunctionTemplate", "Lde/fraunhofer/aisec/cpg/passes/CallResolver;", "containingRecord", "handleCXXMethodCall", "curClass", "possibleContainingTypes", "", "handleNormalCallCXX", "handleTemplateFunctionCalls", "applyInference", "resolveWithDefaultArgsFunc", "resolveWithImplicitCastFunc", "cpg-core"})
public final class CXXCallResolverHelperKt {
    /*
     * WARNING - void declaration
     */
    public static final void handleNormalCallCXX(@NotNull CallResolver $this$handleNormalCallCXX, @NotNull CallExpression call) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$handleNormalCallCXX, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if ($this$handleNormalCallCXX.scopeManager == null) {
            Util.errorWithFileLocation(call, CallResolver.Companion.getLOGGER(), "Could not handle normal call cpp: scopeManager is null", new Object[0]);
            return;
        }
        ScopeManager scopeManager = $this$handleNormalCallCXX.scopeManager;
        Intrinsics.checkNotNull((Object)scopeManager);
        Iterable $this$filter$iv = scopeManager.resolveFunctionStopScopeTraversalOnDefinition(call);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FunctionDeclaration it = (FunctionDeclaration)element$iv$iv;
            boolean bl = false;
            if (!it.hasSignature(call.getSignature())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List invocationCandidates = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (invocationCandidates.isEmpty()) {
            invocationCandidates.addAll((Collection)CXXCallResolverHelperKt.resolveWithDefaultArgsFunc($this$handleNormalCallCXX, call));
        }
        if (invocationCandidates.isEmpty()) {
            call.setTemplateParametersEdges(new ArrayList());
            if (CXXCallResolverHelperKt.handleTemplateFunctionCalls($this$handleNormalCallCXX, null, call, false)) {
                return;
            }
            call.setTemplateParametersEdges(null);
        }
        if (invocationCandidates.isEmpty()) {
            invocationCandidates.addAll((Collection)CXXCallResolverHelperKt.resolveWithImplicitCastFunc($this$handleNormalCallCXX, call));
        }
        if (invocationCandidates.isEmpty()) {
            invocationCandidates.add($this$handleNormalCallCXX.createInferredFunctionDeclaration(null, call.getName(), call.getCode(), false, call.getSignature(), call.getType()));
        }
        call.setInvokes(invocationCandidates);
    }

    public static final boolean compatibleSignatures(@NotNull List<? extends Type> callSignature, @NotNull List<? extends Type> functionSignature) {
        boolean bl;
        Intrinsics.checkNotNullParameter(callSignature, (String)"callSignature");
        Intrinsics.checkNotNullParameter(functionSignature, (String)"functionSignature");
        if (callSignature.size() == functionSignature.size()) {
            int n = callSignature.size();
            for (int i = 0; i < n; ++i) {
                Type type = callSignature.get(i);
                Intrinsics.checkNotNull((Object)type);
                if (type.isPrimitive() == functionSignature.get(i).isPrimitive() || TypeManager.getInstance().isSupertypeOf(functionSignature.get(i), callSignature.get(i))) continue;
                return false;
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final List<Type> getCallSignatureWithDefaults(@NotNull CallExpression call, @NotNull FunctionDeclaration functionDeclaration) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)functionDeclaration, (String)"functionDeclaration");
        Collection $this$toTypedArray$iv = call.getSignature();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Type[] typeArray = thisCollection$iv.toArray(new Type[0]);
        Intrinsics.checkNotNull((Object)typeArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Type[] typeArray2 = typeArray;
        List callSignature = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(typeArray2, typeArray2.length));
        if (call.getSignature().size() < functionDeclaration.getParameters().size()) {
            callSignature.addAll((Collection)functionDeclaration.getDefaultParameterSignature().subList(call.getArguments().size(), functionDeclaration.getDefaultParameterSignature().size()));
        }
        return callSignature;
    }

    @NotNull
    public static final List<FunctionDeclaration> resolveWithImplicitCast(@NotNull CallExpression call, @NotNull List<? extends FunctionDeclaration> initialInvocationCandidates) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter(initialInvocationCandidates, (String)"initialInvocationCandidates");
        List invocationTargetsWithImplicitCast = new ArrayList();
        List invocationTargetsWithImplicitCastAndDefaults = new ArrayList();
        List<CastExpression> implicitCasts = null;
        for (FunctionDeclaration functionDeclaration : initialInvocationCandidates) {
            List<Type> callSignature = CXXCallResolverHelperKt.getCallSignatureWithDefaults(call, functionDeclaration);
            if (!CXXCallResolverHelperKt.compatibleSignatures(callSignature, functionDeclaration.getSignatureTypes())) continue;
            List<CastExpression> implicitCastTargets = CXXCallResolverHelperKt.signatureWithImplicitCastTransformation(CXXCallResolverHelperKt.getCallSignatureWithDefaults(call, functionDeclaration), call.getArguments(), functionDeclaration.getSignatureTypes());
            if (implicitCasts == null) {
                implicitCasts = implicitCastTargets;
            } else {
                CXXCallResolverHelperKt.checkMostCommonImplicitCast(implicitCasts, implicitCastTargets);
            }
            if (CXXCallResolverHelperKt.compatibleSignatures(call.getSignature(), functionDeclaration.getSignatureTypes())) {
                invocationTargetsWithImplicitCast.add(functionDeclaration);
                continue;
            }
            invocationTargetsWithImplicitCastAndDefaults.add(functionDeclaration);
        }
        List<CastExpression> list2 = implicitCasts;
        if (list2 != null) {
            List<CastExpression> it = list2;
            boolean bl = false;
            CXXCallResolverHelperKt.applyImplicitCastToArguments(call, it);
        }
        Collection collection2 = invocationTargetsWithImplicitCast;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = invocationTargetsWithImplicitCastAndDefaults;
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    public static final void checkMostCommonImplicitCast(@NotNull List<CastExpression> implicitCasts, @NotNull List<? extends CastExpression> implicitCastTargets) {
        Intrinsics.checkNotNullParameter(implicitCasts, (String)"implicitCasts");
        Intrinsics.checkNotNullParameter(implicitCastTargets, (String)"implicitCastTargets");
        int n = implicitCasts.size();
        for (int i = 0; i < n; ++i) {
            CastExpression currentCast = implicitCasts.get(i);
            if (i >= implicitCastTargets.size()) continue;
            CastExpression otherCast = implicitCastTargets.get(i);
            if (currentCast == null || otherCast == null || Intrinsics.areEqual((Object)currentCast, (Object)otherCast)) continue;
            CastExpression contradictoryCast = new CastExpression();
            contradictoryCast.setImplicit(true);
            contradictoryCast.setCastType(UnknownType.getUnknownType());
            contradictoryCast.setExpression(currentCast.getExpression());
            implicitCasts.set(i, contradictoryCast);
        }
    }

    public static final void applyImplicitCastToArguments(@NotNull CallExpression call, @NotNull List<? extends CastExpression> implicitCasts) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter(implicitCasts, (String)"implicitCasts");
        int n = implicitCasts.size();
        for (int i = 0; i < n; ++i) {
            CastExpression it;
            if (implicitCasts.get(i) == null) continue;
            boolean bl = false;
            call.setArgument(i, it);
        }
    }

    @NotNull
    public static final List<FunctionDeclaration> resolveWithImplicitCastFunc(@NotNull CallResolver $this$resolveWithImplicitCastFunc, @NotNull CallExpression call) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveWithImplicitCastFunc, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if ($this$resolveWithImplicitCastFunc.scopeManager == null) {
            Util.errorWithFileLocation(call, CallResolver.Companion.getLOGGER(), "Could not resolve with implicit cast function: scopeManager is null", new Object[0]);
            return CollectionsKt.emptyList();
        }
        ScopeManager scopeManager = $this$resolveWithImplicitCastFunc.scopeManager;
        Intrinsics.checkNotNull((Object)scopeManager);
        Collection $this$toTypedArray$iv = scopeManager.resolveFunctionStopScopeTraversalOnDefinition(call);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FunctionDeclaration[] functionDeclarationArray = thisCollection$iv.toArray(new FunctionDeclaration[0]);
        Intrinsics.checkNotNull((Object)functionDeclarationArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        FunctionDeclaration[] functionDeclarationArray2 = functionDeclarationArray;
        List initialInvocationCandidates = CollectionsKt.listOf((Object[])Arrays.copyOf(functionDeclarationArray2, functionDeclarationArray2.length));
        return CXXCallResolverHelperKt.resolveWithImplicitCast(call, initialInvocationCandidates);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FunctionDeclaration> resolveWithDefaultArgsFunc(@NotNull CallResolver $this$resolveWithDefaultArgsFunc, @NotNull CallExpression call) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$resolveWithDefaultArgsFunc, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if ($this$resolveWithDefaultArgsFunc.scopeManager == null) {
            Util.errorWithFileLocation(call, CallResolver.Companion.getLOGGER(), "Could not resolve with default args: scopeManager is null", new Object[0]);
            return CollectionsKt.emptyList();
        }
        ScopeManager scopeManager = $this$resolveWithDefaultArgsFunc.scopeManager;
        Intrinsics.checkNotNull((Object)scopeManager);
        Iterable $this$filter$iv = scopeManager.resolveFunctionStopScopeTraversalOnDefinition(call);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FunctionDeclaration f = (FunctionDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(call.getSignature().size() < f.getSignatureTypes().size())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List invocationCandidates = (List)destination$iv$iv;
        return CXXCallResolverHelperKt.resolveWithDefaultArgs(call, invocationCandidates);
    }

    @NotNull
    public static final List<FunctionDeclaration> resolveWithDefaultArgs(@NotNull CallExpression call, @NotNull List<? extends FunctionDeclaration> initialInvocationCandidates) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter(initialInvocationCandidates, (String)"initialInvocationCandidates");
        List invocationCandidatesDefaultArgs = new ArrayList();
        for (FunctionDeclaration functionDeclaration : initialInvocationCandidates) {
            if (!functionDeclaration.hasSignature(CXXCallResolverHelperKt.getCallSignatureWithDefaults(call, functionDeclaration))) continue;
            invocationCandidatesDefaultArgs.add(functionDeclaration);
        }
        return invocationCandidatesDefaultArgs;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FunctionDeclaration> handleCXXMethodCall(@NotNull CallResolver $this$handleCXXMethodCall, @Nullable RecordDeclaration curClass, @NotNull Set<? extends Type> possibleContainingTypes, @NotNull CallExpression call) {
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$handleCXXMethodCall, (String)"<this>");
        Intrinsics.checkNotNullParameter(possibleContainingTypes, (String)"possibleContainingTypes");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        List invocationCandidates = new ArrayList();
        Iterable $this$mapNotNull$iv = possibleContainingTypes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RecordDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Type it = (Type)element$iv$iv;
            boolean bl2 = false;
            if ($this$handleCXXMethodCall.getRecordMap().get(it.getRoot().getTypeName()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set records2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        for (RecordDeclaration record : records2) {
            invocationCandidates.addAll((Collection)$this$handleCXXMethodCall.getInvocationCandidatesFromRecord(record, call.getName(), call));
        }
        if (invocationCandidates.isEmpty()) {
            invocationCandidates.addAll((Collection)CXXCallResolverHelperKt.resolveWithDefaultArgsFunc($this$handleCXXMethodCall, call));
        }
        if (invocationCandidates.isEmpty()) {
            if (CXXCallResolverHelperKt.handleTemplateFunctionCalls($this$handleCXXMethodCall, curClass, call, false)) {
                return call.getInvokes();
            }
            call.setTemplateParametersEdges(null);
        }
        if (invocationCandidates.isEmpty()) {
            invocationCandidates.addAll((Collection)CXXCallResolverHelperKt.resolveWithImplicitCastFunc($this$handleCXXMethodCall, call));
        }
        if (call instanceof MemberCallExpression) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = invocationCandidates;
            boolean $i$f$filterIsInstance = false;
            $this$mapNotNullTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MethodDeclaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            invocationCandidates = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        }
        return invocationCandidates;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FunctionDeclaration> getInvocationCandidatesFromRecordCXX(@NotNull RecordDeclaration recordDeclaration, @NotNull CallExpression call, @NotNull Pattern namePattern) {
        List list2;
        MethodDeclaration m;
        Collection destination$iv$iv;
        Iterable $this$filter$iv;
        List list3;
        CallExpression callExpression;
        void $this$toTypedArray$iv;
        void $this$filterTo$iv$iv;
        Collection $this$filter$iv2;
        Intrinsics.checkNotNullParameter((Object)recordDeclaration, (String)"recordDeclaration");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)namePattern, (String)"namePattern");
        List<MethodDeclaration> list4 = recordDeclaration.getMethods();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"recordDeclaration.methods");
        Iterable iterable = list4;
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MethodDeclaration m2 = (MethodDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(namePattern.matcher(m2.getName()).matches() && m2.hasSignature(call.getSignature()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray2 = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        MethodDeclaration[] methodDeclarationArray = thisCollection$iv.toArray(new MethodDeclaration[0]);
        Intrinsics.checkNotNull((Object)methodDeclarationArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Object object = methodDeclarationArray;
        List invocationCandidate = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(object, ((MethodDeclaration[])object).length));
        if (invocationCandidate.isEmpty()) {
            void $this$filterTo$iv$iv2;
            List<MethodDeclaration> list5 = recordDeclaration.getMethods();
            Intrinsics.checkNotNullExpressionValue(list5, (String)"recordDeclaration.methods");
            object = list5;
            callExpression = call;
            list3 = invocationCandidate;
            boolean $i$f$filter2 = false;
            Iterable $i$f$toTypedArray2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                m = (MethodDeclaration)element$iv$iv;
                boolean bl = false;
                boolean bl2 = namePattern.matcher(m.getName()).matches() && call.getSignature().size() < m.getSignatureTypes().size();
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
            list3.addAll((Collection)CXXCallResolverHelperKt.resolveWithDefaultArgs(callExpression, list2));
        }
        if (invocationCandidate.isEmpty()) {
            List<MethodDeclaration> list6 = recordDeclaration.getMethods();
            Intrinsics.checkNotNullExpressionValue(list6, (String)"recordDeclaration.methods");
            $this$filter$iv = list6;
            callExpression = call;
            list3 = invocationCandidate;
            boolean $i$f$filter3 = false;
            Iterable $this$filterTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                m = (MethodDeclaration)element$iv$iv;
                boolean bl = false;
                if (!namePattern.matcher(m.getName()).matches()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
            list3.addAll((Collection)CXXCallResolverHelperKt.resolveWithImplicitCast(callExpression, list2));
        }
        return invocationCandidate;
    }

    @Nullable
    public static final ConstructorDeclaration resolveConstructorWithDefaults(@NotNull ConstructExpression constructExpression, @NotNull List<? extends Type> signature2, @NotNull RecordDeclaration recordDeclaration) {
        Intrinsics.checkNotNullParameter((Object)constructExpression, (String)"constructExpression");
        Intrinsics.checkNotNullParameter(signature2, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)recordDeclaration, (String)"recordDeclaration");
        for (ConstructorDeclaration constructor : recordDeclaration.getConstructors()) {
            if (signature2.size() >= constructor.getSignatureTypes().size()) continue;
            CallExpression callExpression = constructExpression;
            Intrinsics.checkNotNullExpressionValue((Object)constructor, (String)"constructor");
            List<Type> workingSignature = CXXCallResolverHelperKt.getCallSignatureWithDefaults(callExpression, constructor);
            if (!constructor.hasSignature(workingSignature)) continue;
            return constructor;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean shouldContinueSearchInParent(@Nullable RecordDeclaration recordDeclaration, @Nullable String name2) {
        void $this$filterTo$iv$iv;
        RecordDeclaration recordDeclaration2 = recordDeclaration;
        Intrinsics.checkNotNull((Object)recordDeclaration2);
        Pattern namePattern = Pattern.compile("(" + Pattern.quote(recordDeclaration2.getName()) + "\\.)?" + Pattern.quote(name2));
        List<MethodDeclaration> list2 = recordDeclaration.getMethods();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"recordDeclaration.methods");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MethodDeclaration it = (MethodDeclaration)element$iv$iv;
            boolean bl = false;
            if (!namePattern.matcher(it.getName()).matches()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List invocationCandidate = (List)destination$iv$iv;
        return invocationCandidate.isEmpty();
    }

    @Nullable
    public static final ConstructorDeclaration resolveConstructorWithImplicitCast(@NotNull ConstructExpression constructExpression, @NotNull RecordDeclaration recordDeclaration) {
        Intrinsics.checkNotNullParameter((Object)constructExpression, (String)"constructExpression");
        Intrinsics.checkNotNullParameter((Object)recordDeclaration, (String)"recordDeclaration");
        for (ConstructorDeclaration constructorDeclaration : recordDeclaration.getConstructors()) {
            List<CastExpression> implicitCasts;
            Type[] typeArray;
            Collection $this$toTypedArray$iv = constructExpression.getSignature();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Intrinsics.checkNotNull((Object)thisCollection$iv.toArray(new Type[0]), (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            List workingSignature = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(typeArray, typeArray.length));
            List<Type> defaultParameterSignature = constructorDeclaration.getDefaultParameterSignature();
            if (constructExpression.getArguments().size() <= defaultParameterSignature.size()) {
                workingSignature.addAll((Collection)defaultParameterSignature.subList(constructExpression.getArguments().size(), defaultParameterSignature.size()));
            }
            if (CXXCallResolverHelperKt.compatibleSignatures(constructExpression.getSignature(), constructorDeclaration.getSignatureTypes())) {
                implicitCasts = CXXCallResolverHelperKt.signatureWithImplicitCastTransformation(constructExpression.getSignature(), constructExpression.getArguments(), constructorDeclaration.getSignatureTypes());
                CXXCallResolverHelperKt.applyImplicitCastToArguments(constructExpression, implicitCasts);
                return constructorDeclaration;
            }
            if (!CXXCallResolverHelperKt.compatibleSignatures(workingSignature, constructorDeclaration.getSignatureTypes())) continue;
            CallExpression callExpression = constructExpression;
            Intrinsics.checkNotNullExpressionValue((Object)constructorDeclaration, (String)"constructorDeclaration");
            implicitCasts = CXXCallResolverHelperKt.signatureWithImplicitCastTransformation(CXXCallResolverHelperKt.getCallSignatureWithDefaults(callExpression, constructorDeclaration), constructExpression.getArguments(), constructorDeclaration.getSignatureTypes());
            CXXCallResolverHelperKt.applyImplicitCastToArguments(constructExpression, implicitCasts);
            return constructorDeclaration;
        }
        return null;
    }

    public static final boolean handleTemplateFunctionCalls(@NotNull CallResolver $this$handleTemplateFunctionCalls, @Nullable RecordDeclaration curClass, @NotNull CallExpression templateCall, boolean applyInference) {
        Intrinsics.checkNotNullParameter((Object)$this$handleTemplateFunctionCalls, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)templateCall, (String)"templateCall");
        if ($this$handleTemplateFunctionCalls.scopeManager == null) {
            Util.errorWithFileLocation(templateCall, Pass.log, "Could not handle template function call: scopeManager is null", new Object[0]);
            return false;
        }
        ScopeManager scopeManager = $this$handleTemplateFunctionCalls.scopeManager;
        Intrinsics.checkNotNull((Object)scopeManager);
        List instantiationCandidates = ScopeManager.resolveFunctionTemplateDeclaration$default(scopeManager, templateCall, null, 2, null);
        for (FunctionTemplateDeclaration functionTemplateDeclaration : instantiationCandidates) {
            Map initializationType = new LinkedHashMap();
            Map orderedInitializationSignature = new LinkedHashMap();
            List explicitInstantiation = new ArrayList();
            if (templateCall.getTemplateParameters().size() > functionTemplateDeclaration.getParameters().size() || templateCall.getArguments().size() > functionTemplateDeclaration.getRealization().get(0).getParameters().size()) continue;
            Map<Declaration, Node> initializationSignature = CXXCallResolverHelperKt.getTemplateInitializationSignature(functionTemplateDeclaration, templateCall, initializationType, orderedInitializationSignature, explicitInstantiation);
            FunctionDeclaration function = functionTemplateDeclaration.getRealization().get(0);
            if (initializationSignature == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)function, (String)"function");
            if (!CXXCallResolverHelperKt.checkArgumentValidity(function, CXXCallResolverHelperKt.getCallSignature(function, CXXCallResolverHelperKt.getParameterizedSignaturesFromInitialization(initializationSignature), initializationSignature), templateCall, explicitInstantiation)) continue;
            CXXCallResolverHelperKt.applyTemplateInstantiation(templateCall, functionTemplateDeclaration, function, initializationSignature, initializationType, orderedInitializationSignature);
            return true;
        }
        if (applyInference) {
            FunctionTemplateDeclaration functionTemplateDeclaration = CXXCallResolverHelperKt.createInferredFunctionTemplate($this$handleTemplateFunctionCalls, curClass, templateCall);
            templateCall.setTemplateInstantiation(functionTemplateDeclaration);
            List<FunctionDeclaration> list2 = functionTemplateDeclaration.getRealization();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"functionTemplateDeclaration.realization");
            templateCall.setInvokes(list2);
            List<PropertyEdge<Node>> list3 = templateCall.getTemplateParametersEdges();
            if (list3 == null) {
                return false;
            }
            List<PropertyEdge<Node>> edges = list3;
            for (PropertyEdge<Node> instantiationParameter : edges) {
                instantiationParameter.addProperty(Properties.INSTANTIATION, (Object)TemplateDeclaration.TemplateInitialization.EXPLICIT);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static final FunctionTemplateDeclaration createInferredFunctionTemplate(@NotNull CallResolver $this$createInferredFunctionTemplate, @Nullable RecordDeclaration containingRecord, @NotNull CallExpression call) {
        Intrinsics.checkNotNullParameter((Object)$this$createInferredFunctionTemplate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        String name2 = call.getName();
        String code = call.getCode();
        FunctionTemplateDeclaration inferred = NodeBuilder.newFunctionTemplateDeclaration$default(name2, code, null, null, 12, null);
        inferred.setInferred(true);
        if (containingRecord != null) {
            containingRecord.addDeclaration(inferred);
        } else {
            $this$createInferredFunctionTemplate.getCurrentTU().addDeclaration(inferred);
        }
        FunctionDeclaration inferredRealization = $this$createInferredFunctionTemplate.createInferredFunctionDeclaration(containingRecord, name2, code, false, call.getSignature(), call.getType());
        inferred.addRealization(inferredRealization);
        int typeCounter = 0;
        int nonTypeCounter = 0;
        for (Node node : call.getTemplateParameters()) {
            if (node instanceof TypeExpression) {
                String inferredTypeIdentifier = "T" + typeCounter;
                TypeParamDeclaration typeParamDeclaration = NodeBuilder.newTypeParamDeclaration$default(inferredTypeIdentifier, inferredTypeIdentifier, null, null, 12, null);
                typeParamDeclaration.setInferred(true);
                ParameterizedType parameterizedType = new ParameterizedType(inferredTypeIdentifier);
                parameterizedType.setInferred(true);
                typeParamDeclaration.setType(parameterizedType);
                TypeManager.getInstance().addTypeParameter(inferred, parameterizedType);
                ++typeCounter;
                inferred.addParameter(typeParamDeclaration);
                continue;
            }
            if (!(node instanceof Expression)) continue;
            String inferredNonTypeIdentifier = "N" + nonTypeCounter;
            ParamVariableDeclaration paramVariableDeclaration = NodeBuilder.newMethodParameterIn$default(inferredNonTypeIdentifier, ((Expression)node).getType(), false, inferredNonTypeIdentifier, null, null, 48, null);
            paramVariableDeclaration.setInferred(true);
            paramVariableDeclaration.addPrevDFG(node);
            node.addNextDFG(paramVariableDeclaration);
            ++nonTypeCounter;
            inferred.addParameter(paramVariableDeclaration);
        }
        return inferred;
    }

    public static final void applyTemplateInstantiation(@NotNull CallExpression templateCall, @Nullable FunctionTemplateDeclaration functionTemplateDeclaration, @NotNull FunctionDeclaration function, @NotNull Map<Declaration, ? extends Node> initializationSignature, @NotNull Map<Node, ? extends TemplateDeclaration.TemplateInitialization> initializationType, @NotNull Map<Declaration, Integer> orderedInitializationSignature) {
        Intrinsics.checkNotNullParameter((Object)templateCall, (String)"templateCall");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(initializationSignature, (String)"initializationSignature");
        Intrinsics.checkNotNullParameter(initializationType, (String)"initializationType");
        Intrinsics.checkNotNullParameter(orderedInitializationSignature, (String)"orderedInitializationSignature");
        Collection collection = orderedInitializationSignature.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = collection;
        Declaration[] declarationArray = thisCollection$iv.toArray(new Declaration[0]);
        Intrinsics.checkNotNull((Object)declarationArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Declaration[] declarationArray2 = declarationArray;
        List templateInstantiationParameters = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(declarationArray2, declarationArray2.length));
        for (Map.Entry entry : orderedInitializationSignature.entrySet()) {
            Declaration key = (Declaration)entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            Node node = initializationSignature.get(key);
            Intrinsics.checkNotNull((Object)node);
            templateInstantiationParameters.set(value, node);
        }
        templateCall.setTemplateInstantiation(functionTemplateDeclaration);
        templateCall.setInvokes(CollectionsKt.listOf((Object)function));
        Type returnType = function.getReturnTypes().get(0);
        Map<ParameterizedType, TypeParamDeclaration> map = CXXCallResolverHelperKt.getParameterizedSignaturesFromInitialization(initializationSignature);
        if (returnType instanceof ParameterizedType) {
            TypeExpression key = (TypeExpression)initializationSignature.get(map.get(returnType));
            returnType = key != null ? key.getType() : null;
        }
        templateCall.setType(returnType);
        templateCall.updateTemplateParameters(initializationType, templateInstantiationParameters);
        List<Type> templateFunctionSignature = CXXCallResolverHelperKt.getCallSignature(function, map, initializationSignature);
        List<Type> templateCallSignature = templateCall.getSignature();
        List<CastExpression> callSignatureImplicit = CXXCallResolverHelperKt.signatureWithImplicitCastTransformation(templateCallSignature, templateCall.getArguments(), templateFunctionSignature);
        int n = callSignatureImplicit.size();
        for (int i = 0; i < n; ++i) {
            CastExpression cast = callSignatureImplicit.get(i);
            if (cast == null) continue;
            templateCall.setArgument(i, cast);
        }
        Iterator<Map.Entry<Declaration, ? extends Node>> iterator = initializationSignature.entrySet().iterator();
        while (iterator.hasNext()) {
            Declaration declaration = iterator.next().getKey();
            if (!(declaration instanceof ParamVariableDeclaration)) continue;
            ParamVariableDeclaration paramVariableDeclaration = (ParamVariableDeclaration)declaration;
            Node node = initializationSignature.get(declaration);
            Intrinsics.checkNotNull((Object)node);
            paramVariableDeclaration.addPrevDFG(node);
            Node node2 = initializationSignature.get(declaration);
            Intrinsics.checkNotNull((Object)node2);
            node2.addNextDFG(declaration);
        }
    }

    @NotNull
    public static final List<CastExpression> signatureWithImplicitCastTransformation(@NotNull List<? extends Type> callSignature, @NotNull List<? extends Expression> arguments2, @NotNull List<? extends Type> functionSignature) {
        Intrinsics.checkNotNullParameter(callSignature, (String)"callSignature");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter(functionSignature, (String)"functionSignature");
        List implicitCasts = new ArrayList();
        if (callSignature.size() != functionSignature.size()) {
            return implicitCasts;
        }
        int n = callSignature.size();
        for (int i = 0; i < n; ++i) {
            Type callType = callSignature.get(i);
            Type funcType = functionSignature.get(i);
            Type type = callType;
            Intrinsics.checkNotNull((Object)type);
            if (type.isPrimitive() && funcType.isPrimitive() && !Intrinsics.areEqual((Object)callType, (Object)funcType)) {
                CastExpression implicitCast = new CastExpression();
                implicitCast.setImplicit(true);
                implicitCast.setCastType(funcType);
                implicitCast.setExpression(arguments2.get(i));
                implicitCasts.add(implicitCast);
                continue;
            }
            implicitCasts.add(null);
        }
        return implicitCasts;
    }

    @NotNull
    public static final Map<ParameterizedType, TypeParamDeclaration> getParameterizedSignaturesFromInitialization(@NotNull Map<Declaration, ? extends Node> initialization) {
        Intrinsics.checkNotNullParameter(initialization, (String)"initialization");
        Map parameterizedSignature = new HashMap();
        for (Declaration templateParam : initialization.keySet()) {
            if (!(templateParam instanceof TypeParamDeclaration)) continue;
            Map map = parameterizedSignature;
            Type type = ((TypeParamDeclaration)templateParam).getType();
            Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.types.ParameterizedType");
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Declaration declaration = templateParam;
            map.put(parameterizedType, declaration);
        }
        return parameterizedSignature;
    }

    @Nullable
    public static final Map<Declaration, Node> getTemplateInitializationSignature(@NotNull FunctionTemplateDeclaration functionTemplateDeclaration, @NotNull CallExpression templateCall, @NotNull Map<Node, TemplateDeclaration.TemplateInitialization> instantiationType, @NotNull Map<Declaration, Integer> orderedInitializationSignature, @NotNull List<ParameterizedType> explicitInstantiated) {
        Intrinsics.checkNotNullParameter((Object)functionTemplateDeclaration, (String)"functionTemplateDeclaration");
        Intrinsics.checkNotNullParameter((Object)templateCall, (String)"templateCall");
        Intrinsics.checkNotNullParameter(instantiationType, (String)"instantiationType");
        Intrinsics.checkNotNullParameter(orderedInitializationSignature, (String)"orderedInitializationSignature");
        Intrinsics.checkNotNullParameter(explicitInstantiated, (String)"explicitInstantiated");
        Map<Declaration, Node> map = CXXCallResolverHelperKt.constructTemplateInitializationSignatureFromTemplateParameters(functionTemplateDeclaration, templateCall, instantiationType, orderedInitializationSignature, explicitInstantiated);
        if (map == null) {
            return null;
        }
        Map<Declaration, Node> signature2 = map;
        Map<ParameterizedType, TypeParamDeclaration> parameterizedTypeResolution = CXXCallResolverHelperKt.getParameterizedSignaturesFromInitialization(signature2);
        int n = templateCall.getArguments().size();
        for (int i = 0; i < n; ++i) {
            FunctionDeclaration functionDeclaration = functionTemplateDeclaration.getRealization().get(0);
            Type currentArgumentType = functionDeclaration.getParameters().get(i).getType();
            Type deducedType = templateCall.getArguments().get(i).getType();
            TypeExpression typeExpression = NodeBuilder.newTypeExpression$default(deducedType.getName(), deducedType, null, null, 12, null);
            typeExpression.setImplicit(true);
            if (!(currentArgumentType instanceof ParameterizedType) || signature2.get(parameterizedTypeResolution.get(currentArgumentType)) != null && instantiationType.get(signature2.get(parameterizedTypeResolution.get(currentArgumentType))) != TemplateDeclaration.TemplateInitialization.DEFAULT) continue;
            signature2.put(parameterizedTypeResolution.get(currentArgumentType), typeExpression);
            instantiationType.put(typeExpression, TemplateDeclaration.TemplateInitialization.AUTO_DEDUCTION);
        }
        return signature2;
    }

    @Nullable
    public static final Map<Declaration, Node> constructTemplateInitializationSignatureFromTemplateParameters(@NotNull FunctionTemplateDeclaration functionTemplateDeclaration, @NotNull CallExpression templateCall, @NotNull Map<Node, TemplateDeclaration.TemplateInitialization> instantiationType, @NotNull Map<Declaration, Integer> orderedInitializationSignature, @NotNull List<ParameterizedType> explicitInstantiated) {
        Intrinsics.checkNotNullParameter((Object)functionTemplateDeclaration, (String)"functionTemplateDeclaration");
        Intrinsics.checkNotNullParameter((Object)templateCall, (String)"templateCall");
        Intrinsics.checkNotNullParameter(instantiationType, (String)"instantiationType");
        Intrinsics.checkNotNullParameter(orderedInitializationSignature, (String)"orderedInitializationSignature");
        Intrinsics.checkNotNullParameter(explicitInstantiated, (String)"explicitInstantiated");
        Map instantiationSignature = new HashMap();
        int n = functionTemplateDeclaration.getParameters().size();
        for (int i = 0; i < n; ++i) {
            if (i < templateCall.getTemplateParameters().size()) {
                Declaration templateParameter;
                Node callParameter = templateCall.getTemplateParameters().get(i);
                if (CXXCallResolverHelperKt.isInstantiated(callParameter, templateParameter = functionTemplateDeclaration.getParameters().get(i))) {
                    instantiationSignature.put(templateParameter, callParameter);
                    instantiationType.put(callParameter, TemplateDeclaration.TemplateInitialization.EXPLICIT);
                    if (templateParameter instanceof TypeParamDeclaration) {
                        Type type = ((TypeParamDeclaration)templateParameter).getType();
                        Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.types.ParameterizedType");
                        explicitInstantiated.add((ParameterizedType)type);
                    }
                    Integer n2 = i;
                    Intrinsics.checkNotNullExpressionValue((Object)templateParameter, (String)"templateParameter");
                    orderedInitializationSignature.put(templateParameter, n2);
                    continue;
                }
                return null;
            }
            CXXCallResolverHelperKt.handleImplicitTemplateParameter(functionTemplateDeclaration, i, instantiationSignature, instantiationType, orderedInitializationSignature);
        }
        return instantiationSignature;
    }

    public static final boolean isInstantiated(@NotNull Node callParameterArg, @Nullable Declaration templateParameter) {
        Intrinsics.checkNotNullParameter((Object)callParameterArg, (String)"callParameterArg");
        Node callParameter = callParameterArg;
        if (callParameter instanceof TypeExpression) {
            Type type = ((TypeExpression)callParameter).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"callParameter.type");
            callParameter = type;
        }
        return callParameter instanceof Type && templateParameter instanceof TypeParamDeclaration ? callParameter instanceof ObjectType : (callParameter instanceof Expression && templateParameter instanceof ParamVariableDeclaration ? Intrinsics.areEqual((Object)((Expression)callParameter).getType(), (Object)((ParamVariableDeclaration)templateParameter).getType()) || TypeManager.getInstance().isSupertypeOf(((ParamVariableDeclaration)templateParameter).getType(), ((Expression)callParameter).getType()) : false);
    }

    public static final void handleImplicitTemplateParameter(@NotNull FunctionTemplateDeclaration functionTemplateDeclaration, int index, @NotNull Map<Declaration, Node> instantiationSignature, @NotNull Map<Node, TemplateDeclaration.TemplateInitialization> instantiationType, @NotNull Map<Declaration, Integer> orderedInitializationSignature) {
        Intrinsics.checkNotNullParameter((Object)functionTemplateDeclaration, (String)"functionTemplateDeclaration");
        Intrinsics.checkNotNullParameter(instantiationSignature, (String)"instantiationSignature");
        Intrinsics.checkNotNullParameter(instantiationType, (String)"instantiationType");
        Intrinsics.checkNotNullParameter(orderedInitializationSignature, (String)"orderedInitializationSignature");
        Declaration declaration = functionTemplateDeclaration.getParameters().get(index);
        Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.HasDefault<*>");
        if (((HasDefault)((Object)declaration)).getDefault() != null) {
            Declaration declaration2 = functionTemplateDeclaration.getParameters().get(index);
            Intrinsics.checkNotNull((Object)declaration2, (String)"null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.HasDefault<*>");
            Object defaultNode = ((HasDefault)((Object)declaration2)).getDefault();
            if (defaultNode instanceof Type) {
                defaultNode = NodeBuilder.newTypeExpression$default(((Node)defaultNode).getName(), (Type)defaultNode, null, null, 12, null);
                ((Node)defaultNode).setImplicit(true);
            }
            instantiationSignature.put(functionTemplateDeclaration.getParameters().get(index), (Node)defaultNode);
            instantiationType.put((Node)defaultNode, TemplateDeclaration.TemplateInitialization.DEFAULT);
            Map<Declaration, Integer> map = orderedInitializationSignature;
            Declaration declaration3 = functionTemplateDeclaration.getParameters().get(index);
            Intrinsics.checkNotNullExpressionValue((Object)declaration3, (String)"functionTemplateDeclaration.parameters[index]");
            Declaration declaration4 = declaration3;
            Integer n = index;
            map.put(declaration4, n);
        } else {
            instantiationSignature.put(functionTemplateDeclaration.getParameters().get(index), null);
            instantiationType.put(null, TemplateDeclaration.TemplateInitialization.UNKNOWN);
            Map<Declaration, Integer> map = orderedInitializationSignature;
            Declaration declaration5 = functionTemplateDeclaration.getParameters().get(index);
            Intrinsics.checkNotNullExpressionValue((Object)declaration5, (String)"functionTemplateDeclaration.parameters[index]");
            Declaration declaration6 = declaration5;
            Integer n = index;
            map.put(declaration6, n);
        }
    }

    @NotNull
    public static final List<Type> getCallSignature(@NotNull FunctionDeclaration function, @NotNull Map<ParameterizedType, ? extends TypeParamDeclaration> parameterizedTypeResolution, @NotNull Map<Declaration, ? extends Node> initializationSignature) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(parameterizedTypeResolution, (String)"parameterizedTypeResolution");
        Intrinsics.checkNotNullParameter(initializationSignature, (String)"initializationSignature");
        List templateCallSignature = new ArrayList();
        for (ParamVariableDeclaration argument : function.getParameters()) {
            if (argument.getType() instanceof ParameterizedType) {
                Node node;
                UnknownType unknownType = UnknownType.getUnknownType();
                Intrinsics.checkNotNullExpressionValue((Object)unknownType, (String)"getUnknownType()");
                Type type = unknownType;
                TypeParamDeclaration typeParamDeclaration = parameterizedTypeResolution.get(argument.getType());
                if (typeParamDeclaration != null && (node = initializationSignature.get(typeParamDeclaration)) instanceof TypeExpression) {
                    Type type2 = ((TypeExpression)node).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"node.type");
                    type = type2;
                }
                templateCallSignature.add(type);
                continue;
            }
            Type type = argument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"argument.type");
            templateCallSignature.add(type);
        }
        return templateCallSignature;
    }

    public static final boolean checkArgumentValidity(@NotNull FunctionDeclaration functionDeclaration, @NotNull List<? extends Type> functionDeclarationSignature, @NotNull CallExpression templateCallExpression, @NotNull List<? extends ParameterizedType> explicitInstantiation) {
        Intrinsics.checkNotNullParameter((Object)functionDeclaration, (String)"functionDeclaration");
        Intrinsics.checkNotNullParameter(functionDeclarationSignature, (String)"functionDeclarationSignature");
        Intrinsics.checkNotNullParameter((Object)templateCallExpression, (String)"templateCallExpression");
        Intrinsics.checkNotNullParameter(explicitInstantiation, (String)"explicitInstantiation");
        if (templateCallExpression.getArguments().size() <= functionDeclaration.getParameters().size()) {
            Collection $this$toTypedArray$iv = templateCallExpression.getArguments();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Expression[] expressionArray = thisCollection$iv.toArray(new Expression[0]);
            Intrinsics.checkNotNull((Object)expressionArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            Expression[] expressionArray2 = expressionArray;
            List callArguments = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(expressionArray2, expressionArray2.length));
            callArguments.addAll(CollectionsKt.filterNotNull((Iterable)functionDeclaration.getDefaultParameters().subList(callArguments.size(), functionDeclaration.getDefaultParameters().size())));
            int n = callArguments.size();
            for (int i = 0; i < n; ++i) {
                Expression callArgument;
                if ((Expression)callArguments.get(i) == null) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)callArgument.getType(), (Object)functionDeclarationSignature.get(i)) || callArgument.getType().isPrimitive() && functionDeclarationSignature.get(i).isPrimitive() && CollectionsKt.contains((Iterable)explicitInstantiation, (Object)functionDeclaration.getParameters().get(i).getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

