/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.IdentitySet;
import de.fraunhofer.aisec.cpg.helpers.TriConsumer;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubgraphWalker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubgraphWalker.class);
    private static final HashMap<String, List<Field>> fieldCache = new HashMap();

    private SubgraphWalker() {
    }

    private static Collection<Field> getAllFields(Class<?> classType) {
        if (classType.getSuperclass() != null) {
            String cacheKey = classType.getName();
            if (fieldCache.containsKey(cacheKey)) {
                return fieldCache.get(cacheKey);
            }
            ArrayList<Field> fields = new ArrayList<Field>();
            fields.addAll(SubgraphWalker.getAllFields(classType.getSuperclass()));
            fields.addAll(Arrays.asList(classType.getDeclaredFields()));
            fieldCache.put(cacheKey, fields);
            return fields;
        }
        return new ArrayList<Field>();
    }

    public static List<Node> getAstChildren(Node node) {
        ArrayList<Node> children2 = new ArrayList<Node>();
        if (node == null) {
            return children2;
        }
        Class<?> classType = node.getClass();
        for (Field field : SubgraphWalker.getAllFields(classType)) {
            SubGraph subGraph = field.getAnnotation(SubGraph.class);
            if (subGraph == null || !Arrays.asList(subGraph.value()).contains("AST")) continue;
            try {
                field.trySetAccessible();
                List obj = field.get(node);
                field.setAccessible(false);
                if (obj == null) continue;
                boolean outgoing = true;
                if (field.getAnnotation(Relationship.class) != null) {
                    outgoing = field.getAnnotation(Relationship.class).direction().equals("OUTGOING");
                }
                if (PropertyEdge.checkForPropertyEdge(field, obj)) {
                    obj = PropertyEdge.unwrap(obj, outgoing);
                }
                if (obj instanceof Node) {
                    children2.add((Node)((Object)obj));
                    continue;
                }
                if (obj instanceof Collection) {
                    Collection astChildren = obj;
                    astChildren.removeIf(Objects::isNull);
                    children2.addAll(astChildren);
                    continue;
                }
                throw new AnnotationFormatError("Found @SubGraph(\"AST\") on field of type " + obj.getClass() + " but can only used with node graph classes or collections of graph nodes");
            }
            catch (IllegalAccessException ex) {
                LOGGER.error("Error while retrieving AST children: {}", (Object)ex.getMessage());
            }
        }
        return children2;
    }

    public static List<Node> flattenAST(@Nullable Node n) {
        if (n == null) {
            return new ArrayList<Node>();
        }
        IdentitySet<Node> identitySet = new IdentitySet<Node>();
        SubgraphWalker.flattenASTInternal(identitySet, n);
        return identitySet.toSortedList();
    }

    private static void flattenASTInternal(@NotNull Set<Node> identitySet, @NotNull Node n) {
        if (!identitySet.add(n)) {
            return;
        }
        for (Node child : SubgraphWalker.getAstChildren(n)) {
            SubgraphWalker.flattenASTInternal(identitySet, child);
        }
    }

    public static Border getEOGPathEdges(Node n) {
        Border border = new Border();
        List<Node> flattedASTTree = SubgraphWalker.flattenAST(n);
        List eogNodes = flattedASTTree.stream().filter(node -> !node.getPrevEOG().isEmpty() || !node.getNextEOG().isEmpty()).collect(Collectors.toList());
        border.entries = eogNodes.stream().filter(node -> node.getPrevEOG().stream().anyMatch(prev -> !eogNodes.contains(prev))).collect(Collectors.toList());
        border.exits = eogNodes.stream().filter(node -> node.getNextEOG().stream().anyMatch(next -> !eogNodes.contains(next))).collect(Collectors.toList());
        return border;
    }

    public static void refreshType(Node node) {
        node.accept(Strategy::AST_FORWARD, new IVisitor<Node>(){

            @Override
            public void visit(@NotNull Node child) {
                if (child instanceof HasType) {
                    ((HasType)((Object)child)).refreshType();
                }
            }
        });
    }

    public static void activateTypes(Node node) {
        final AtomicInteger num = new AtomicInteger();
        final Map<HasType, List<Type>> typeCache = TypeManager.getInstance().getTypeCache();
        node.accept(Strategy::AST_FORWARD, new IVisitor<Node>(){

            @Override
            public void visit(Node n) {
                if (n instanceof HasType) {
                    HasType typeNode = (HasType)((Object)n);
                    typeCache.getOrDefault(typeNode, Collections.emptyList()).forEach(t -> {
                        t = TypeManager.getInstance().resolvePossibleTypedef((Type)t);
                        ((HasType)((Object)n)).setType((Type)t);
                    });
                    typeCache.remove((HasType)((Object)n));
                    num.getAndIncrement();
                }
            }
        });
        LOGGER.debug("Activated {} nodes for {}", (Object)num, (Object)node.getName());
        typeCache.forEach((n, types2) -> types2.forEach(t -> {
            t = TypeManager.getInstance().resolvePossibleTypedef((Type)t);
            n.setType((Type)t);
        }));
    }

    public static class Border {
        private List<Node> entries = new ArrayList<Node>();
        private List<Node> exits = new ArrayList<Node>();

        public List<Node> getEntries() {
            return this.entries;
        }

        public List<Node> getExits() {
            return this.exits;
        }
    }

    public static class ScopedWalker {
        private final Map<Node, org.apache.commons.lang3.tuple.Pair<Node, List<ValueDeclaration>>> nodeToParentBlockAndContainedValueDeclarations = new IdentityHashMap<Node, org.apache.commons.lang3.tuple.Pair<Node, List<ValueDeclaration>>>();
        private final Deque<RecordDeclaration> currentClass = new ArrayDeque<RecordDeclaration>();
        private IterativeGraphWalker walker;
        private final ScopeManager scopeManager;
        private final List<TriConsumer<RecordDeclaration, Node, Node>> handlers = new ArrayList<TriConsumer<RecordDeclaration, Node, Node>>();

        public ScopedWalker(LanguageFrontend lang) {
            this.scopeManager = lang.getScopeManager();
        }

        public ScopedWalker(ScopeManager scopeManager) {
            this.scopeManager = scopeManager;
        }

        public void clearCallbacks() {
            this.handlers.clear();
        }

        public void registerHandler(TriConsumer<RecordDeclaration, Node, Node> handler) {
            this.handlers.add(handler);
        }

        public void registerHandler(BiConsumer<Node, RecordDeclaration> handler) {
            this.handlers.add((currClass, parent, currNode) -> handler.accept((Node)currNode, (RecordDeclaration)currClass));
        }

        public void iterate(Node root) {
            this.walker = new IterativeGraphWalker();
            this.handlers.forEach(h -> this.walker.registerOnNodeVisit(n -> this.handleNode((Node)n, (TriConsumer<RecordDeclaration, Node, Node>)h)));
            this.walker.registerOnScopeExit(this::leaveScope);
            this.walker.iterate(root);
        }

        private void handleNode(Node current, TriConsumer<RecordDeclaration, Node, Node> handler) {
            RecordDeclaration recordDeclaration;
            this.scopeManager.enterScopeIfExists(current);
            Node parent = this.walker.getBacklog().peek();
            if (current instanceof RecordDeclaration && current != this.currentClass.peek()) {
                this.currentClass.push((RecordDeclaration)current);
            }
            if (current instanceof MethodDeclaration && (recordDeclaration = ((MethodDeclaration)current).getRecordDeclaration()) != null && recordDeclaration != this.currentClass.peek()) {
                this.currentClass.push(recordDeclaration);
            }
            handler.accept(this.currentClass.peek(), parent, current);
        }

        private void leaveScope(Node exiting) {
            if (exiting instanceof RecordDeclaration) {
                this.currentClass.pop();
            }
            this.scopeManager.leaveScope(exiting);
        }

        @Deprecated
        @Nullable
        public RecordDeclaration getCurrentClass() {
            return this.currentClass.isEmpty() ? null : this.currentClass.peek();
        }

        public void collectDeclarations(Node current) {
            Node parentBlock = null;
            for (Node node : this.walker.getBacklog()) {
                if (!(node instanceof RecordDeclaration) && !(node instanceof CompoundStatement) && !(node instanceof FunctionDeclaration) && !(node instanceof TranslationUnitDeclaration)) continue;
                parentBlock = node;
                break;
            }
            this.nodeToParentBlockAndContainedValueDeclarations.put(current, (org.apache.commons.lang3.tuple.Pair<Node, List<ValueDeclaration>>)new MutablePair((Object)parentBlock, new ArrayList()));
            if (current instanceof ValueDeclaration) {
                LOGGER.trace("Adding variable {}", (Object)current.getCode());
                if (parentBlock == null) {
                    LOGGER.warn("Parent block is empty during subgraph run");
                } else {
                    ((List)this.nodeToParentBlockAndContainedValueDeclarations.get(parentBlock).getRight()).add((ValueDeclaration)current);
                }
            }
        }

        public List<ValueDeclaration> getAllDeclarationsForScope(Node scope) {
            ArrayList<ValueDeclaration> result = new ArrayList<ValueDeclaration>();
            Node currentScope = scope;
            HashSet<String> scopedVars = new HashSet<String>();
            while (currentScope != null && this.nodeToParentBlockAndContainedValueDeclarations.containsKey(scope)) {
                org.apache.commons.lang3.tuple.Pair<Node, List<ValueDeclaration>> entry = this.nodeToParentBlockAndContainedValueDeclarations.get(currentScope);
                for (ValueDeclaration val : (List)entry.getRight()) {
                    if (!(val instanceof FunctionDeclaration) && scopedVars.contains(val.getName())) continue;
                    result.add(val);
                    scopedVars.add(val.getName());
                }
                currentScope = (Node)entry.getLeft();
            }
            return result;
        }

        @Deprecated
        public Optional<? extends ValueDeclaration> getDeclarationForScope(Node scope, Predicate<ValueDeclaration> predicate) {
            Node currentScope = scope;
            while (currentScope != null && this.nodeToParentBlockAndContainedValueDeclarations.containsKey(scope)) {
                org.apache.commons.lang3.tuple.Pair<Node, List<ValueDeclaration>> entry = this.nodeToParentBlockAndContainedValueDeclarations.get(currentScope);
                for (ValueDeclaration val : (List)entry.getRight()) {
                    if (!predicate.test(val)) continue;
                    return Optional.of(val);
                }
                currentScope = (Node)entry.getLeft();
            }
            return Optional.empty();
        }
    }

    public static class IterativeGraphWalker {
        private Deque<Pair<Node, Node>> todo;
        private Deque<Node> backlog;
        private final List<Consumer<Node>> onNodeVisit = new ArrayList<Consumer<Node>>();
        private final List<BiConsumer<Node, Node>> onNodeVisit2 = new ArrayList<BiConsumer<Node, Node>>();
        private final List<Consumer<Node>> onScopeExit = new ArrayList<Consumer<Node>>();

        public void iterate(Node root) {
            this.todo = new ArrayDeque<Pair<Node, Node>>();
            this.backlog = new ArrayDeque<Node>();
            LinkedHashSet seen = new LinkedHashSet();
            this.todo.push((Pair<Node, Node>)new Pair((Object)root, null));
            while (!this.todo.isEmpty()) {
                Pair<Node, Node> pair = this.todo.pop();
                Node current = (Node)pair.getFirst();
                Node parent = (Node)pair.getSecond();
                if (!this.backlog.isEmpty() && this.backlog.peek().equals(current)) {
                    Node exiting = this.backlog.pop();
                    this.onScopeExit.forEach(c -> c.accept(exiting));
                    continue;
                }
                this.todo.push((Pair<Node, Node>)new Pair((Object)current, (Object)parent));
                this.onNodeVisit.forEach(c -> c.accept(current));
                this.onNodeVisit2.forEach(c -> c.accept(current, parent));
                List unseenChildren = SubgraphWalker.getAstChildren(current).stream().filter(Predicate.not(seen::contains)).collect(Collectors.toList());
                seen.addAll(unseenChildren);
                Util.reverse(unseenChildren.stream()).forEach(child -> this.todo.push((Pair<Node, Node>)new Pair(child, (Object)current)));
                this.backlog.push(current);
            }
        }

        public void registerOnNodeVisit(Consumer<Node> callback) {
            this.onNodeVisit.add(callback);
        }

        public void registerOnNodeVisit2(BiConsumer<Node, Node> callback) {
            this.onNodeVisit2.add(callback);
        }

        public void registerOnScopeExit(Consumer<Node> callback) {
            this.onScopeExit.add(callback);
        }

        public void clearCallbacks() {
            this.onNodeVisit.clear();
            this.onScopeExit.clear();
        }

        public Deque<Node> getTodo() {
            return new ArrayDeque<Node>(this.todo.stream().map(Pair::getFirst).collect(Collectors.toList()));
        }

        public Deque<Node> getBacklog() {
            return this.backlog;
        }
    }
}

