/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ConditionalExpression
extends Expression
implements HasType.TypeListener {
    @SubGraph(value={"AST"})
    private Expression condition;
    @SubGraph(value={"AST"})
    private Expression thenExpr;
    @SubGraph(value={"AST"})
    private Expression elseExpr;

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public Expression getThenExpr() {
        return this.thenExpr;
    }

    public void setThenExpr(Expression thenExpr) {
        if (this.thenExpr != null) {
            this.thenExpr.unregisterTypeListener(this);
        }
        this.thenExpr = thenExpr;
        if (thenExpr != null) {
            thenExpr.registerTypeListener(this);
        }
    }

    public Expression getElseExpr() {
        return this.elseExpr;
    }

    public void setElseExpr(Expression elseExpr) {
        if (this.elseExpr != null) {
            this.elseExpr.unregisterTypeListener(this);
        }
        this.elseExpr = elseExpr;
        if (elseExpr != null) {
            elseExpr.registerTypeListener(this);
        }
    }

    @Override
    public void typeChanged(HasType src, List<HasType> root, Type oldType) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        Type previous = this.type;
        ArrayList<Type> types2 = new ArrayList<Type>();
        if (this.thenExpr != null && this.thenExpr.getPropagationType() != null) {
            types2.add(this.thenExpr.getPropagationType());
        }
        if (this.elseExpr != null && this.elseExpr.getPropagationType() != null) {
            types2.add(this.elseExpr.getPropagationType());
        }
        ArrayList<Type> subTypes = new ArrayList<Type>(this.getPossibleSubTypes());
        subTypes.remove(oldType);
        subTypes.addAll(types2);
        UnknownType alternative = !types2.isEmpty() ? (Type)types2.get(0) : UnknownType.getUnknownType();
        this.setType(TypeManager.getInstance().getCommonType(types2).orElse(alternative), root);
        this.setPossibleSubTypes(subTypes, root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, List<HasType> root) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        ArrayList<Type> subTypes = new ArrayList<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("condition", (Object)this.condition).append("thenExpr", (Object)this.thenExpr).append("elseExpr", (Object)this.elseExpr).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConditionalExpression)) {
            return false;
        }
        ConditionalExpression that = (ConditionalExpression)o;
        return super.equals(that) && Objects.equals(this.condition, that.condition) && Objects.equals(this.thenExpr, that.thenExpr) && Objects.equals(this.elseExpr, that.elseExpr);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

