/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.neo4j.ogm.annotation.Relationship;

public class ArrayCreationExpression
extends Expression
implements HasType.TypeListener {
    @SubGraph(value={"AST"})
    private Expression initializer;
    @Relationship(value="DIMENSIONS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<Expression>> dimensions = new ArrayList<PropertyEdge<Expression>>();

    public Expression getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Expression initializer) {
        if (this.initializer != null) {
            this.initializer.unregisterTypeListener(this);
        }
        this.initializer = initializer;
        if (initializer != null) {
            initializer.registerTypeListener(this);
        }
    }

    @NotNull
    public List<Expression> getDimensions() {
        return PropertyEdge.unwrap(this.dimensions);
    }

    public void addDimension(Expression expression) {
        this.addIfNotContains(this.dimensions, expression);
    }

    @NotNull
    public List<PropertyEdge<Expression>> getDimensionsPropertyEdge() {
        return this.dimensions;
    }

    public void setDimensions(List<Expression> dimensions) {
        this.dimensions = PropertyEdge.transformIntoOutgoingPropertyEdgeList(dimensions, this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayCreationExpression)) {
            return false;
        }
        ArrayCreationExpression that = (ArrayCreationExpression)o;
        return super.equals(that) && Objects.equals(this.initializer, that.initializer) && Objects.equals(this.getDimensions(), that.getDimensions()) && PropertyEdge.propertyEqualsList(this.dimensions, that.dimensions);
    }

    @Override
    public void typeChanged(HasType src, List<HasType> root, Type oldType) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        Type previous = this.type;
        this.setType(src.getPropagationType(), root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, List<HasType> root) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        ArrayList<Type> subTypes = new ArrayList<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

