/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.StatementHolder;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.neo4j.ogm.annotation.Relationship;

public class CompoundStatement
extends Statement
implements StatementHolder {
    @Relationship(value="STATEMENTS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    @NotNull
    private List<PropertyEdge<Statement>> statements = new ArrayList<PropertyEdge<Statement>>();
    private boolean staticBlock = false;

    @Override
    @NotNull
    public List<PropertyEdge<Statement>> getStatementEdges() {
        return this.statements;
    }

    @Override
    public void setStatementEdges(@NotNull List<PropertyEdge<Statement>> statements) {
        this.statements = statements;
    }

    public boolean isStaticBlock() {
        return this.staticBlock;
    }

    public void setStaticBlock(boolean staticBlock) {
        this.staticBlock = staticBlock;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompoundStatement)) {
            return false;
        }
        CompoundStatement that = (CompoundStatement)o;
        return super.equals(that) && Objects.equals(this.getStatements(), that.getStatements()) && PropertyEdge.propertyEqualsList(this.statements, that.statements);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

