/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.edge;

import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class PropertyEdgeConverterManager {
    @NotNull
    private static final PropertyEdgeConverterManager INSTANCE = new PropertyEdgeConverterManager();
    private final Map<String, Function<Object, String>> serializer = new HashMap<String, Function<Object, String>>();
    private final Map<String, Function<Object, Object>> deserializer = new HashMap<String, Function<Object, Object>>();

    private PropertyEdgeConverterManager() {
        this.addSerializer(TemplateDeclaration.TemplateInitialization.class.getName(), Object::toString);
        this.addDeserializer("INSTANTIATION", s -> s != null ? TemplateDeclaration.TemplateInitialization.valueOf(s.toString()) : null);
    }

    public static PropertyEdgeConverterManager getInstance() {
        return INSTANCE;
    }

    public void addSerializer(String clazz, Function<Object, String> func) {
        this.serializer.put(clazz, func);
    }

    public void addDeserializer(String name2, Function<Object, Object> func) {
        this.deserializer.put(name2, func);
    }

    public Map<String, Function<Object, String>> getSerializer() {
        return this.serializer;
    }

    public Map<String, Function<Object, Object>> getDeserializer() {
        return this.deserializer;
    }
}

