/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.Assignment;
import de.fraunhofer.aisec.cpg.graph.AssignmentTarget;
import de.fraunhofer.aisec.cpg.graph.HasInitializer;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.Relationship;

public class VariableDeclaration
extends ValueDeclaration
implements HasType.TypeListener,
HasInitializer,
Assignment,
AssignmentTarget {
    @SubGraph(value={"AST"})
    @Nullable
    protected Expression initializer;
    @Relationship(value="TEMPLATE_PARAMETERS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    @Nullable
    private List<Node> templateParameters = null;
    private boolean implicitInitializerAllowed = false;
    private boolean isArray = false;

    public List<Node> getTemplateParameters() {
        return this.templateParameters;
    }

    public void setTemplateParameters(List<Node> templateParameters) {
        this.templateParameters = templateParameters;
    }

    public boolean isImplicitInitializerAllowed() {
        return this.implicitInitializerAllowed;
    }

    public void setImplicitInitializerAllowed(boolean implicitInitializerAllowed) {
        this.implicitInitializerAllowed = implicitInitializerAllowed;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setIsArray(boolean isArray) {
        this.isArray = isArray;
    }

    @Override
    @Nullable
    public Expression getInitializer() {
        return this.initializer;
    }

    @Nullable
    public <T> T getInitializerAs(Class<T> clazz) {
        return clazz.cast(this.getInitializer());
    }

    @Override
    public void setInitializer(@Nullable Expression initializer) {
        if (this.initializer != null) {
            this.initializer.unregisterTypeListener(this);
            if (this.initializer instanceof HasType.TypeListener) {
                this.unregisterTypeListener((HasType.TypeListener)((Object)this.initializer));
            }
        }
        this.initializer = initializer;
        if (initializer != null) {
            initializer.registerTypeListener(this);
            if (initializer instanceof HasType.TypeListener) {
                this.registerTypeListener((HasType.TypeListener)((Object)initializer));
            }
        }
    }

    @Override
    public void typeChanged(HasType src, List<HasType> root, Type oldType) {
        Type newType;
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        if (!TypeManager.getInstance().isUnknown(this.type) && src.getPropagationType().equals(oldType)) {
            return;
        }
        Type previous = this.type;
        if (src == this.initializer && this.initializer instanceof InitializerListExpression) {
            if (this.isArray) {
                newType = src.getType();
            } else {
                if (!TypeManager.getInstance().isUnknown(this.type)) {
                    return;
                }
                newType = src.getType().dereference();
            }
        } else {
            newType = src.getPropagationType();
        }
        this.setType(newType, root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, List<HasType> root) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        ArrayList<Type> subTypes = new ArrayList<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).append("name", (Object)this.getName()).append("location", (Object)this.getLocation()).append("initializer", (Object)this.initializer).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VariableDeclaration)) {
            return false;
        }
        VariableDeclaration that = (VariableDeclaration)o;
        return super.equals(that) && Objects.equals(this.initializer, that.initializer);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    @Nullable
    public AssignmentTarget getTarget() {
        return this;
    }

    @Override
    @Nullable
    public Expression getValue() {
        return this.initializer;
    }
}

