/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.StatementHolder;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.IncludeDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.Relationship;

public class TranslationUnitDeclaration
extends Declaration
implements DeclarationHolder,
StatementHolder {
    @Relationship(value="DECLARATIONS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    @NotNull
    private final List<PropertyEdge<Declaration>> declarations = new ArrayList<PropertyEdge<Declaration>>();
    @Relationship(value="INCLUDES", direction="OUTGOING")
    @SubGraph(value={"AST"})
    @NotNull
    private final List<PropertyEdge<IncludeDeclaration>> includes = new ArrayList<PropertyEdge<IncludeDeclaration>>();
    @Relationship(value="NAMESPACES", direction="OUTGOING")
    @SubGraph(value={"AST"})
    @NotNull
    private final List<PropertyEdge<Declaration>> namespaces = new ArrayList<PropertyEdge<Declaration>>();
    @Relationship(value="STATEMENTS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    @NotNull
    private List<PropertyEdge<Statement>> statements = new ArrayList<PropertyEdge<Statement>>();

    @Nullable
    public <T extends Declaration> T getDeclarationAs(int i, Class<T> clazz) {
        Declaration declaration = this.declarations.get(i).getEnd();
        return (T)(declaration.getClass().isAssignableFrom(clazz) ? (Declaration)clazz.cast(this.declarations.get(i).getEnd()) : null);
    }

    @NotNull
    public <T extends Declaration> Set<T> getDeclarationsByName(@NotNull String name2, @NotNull Class<T> clazz) {
        return this.declarations.stream().map(PropertyEdge::getEnd).filter(declaration -> clazz.isAssignableFrom(declaration.getClass())).map(clazz::cast).filter(declaration -> Objects.equals(declaration.getName(), name2)).collect(Collectors.toSet());
    }

    @Nullable
    public IncludeDeclaration getIncludeByName(@NotNull String name2) {
        return this.includes.stream().map(PropertyEdge::getEnd).filter(declaration -> Objects.equals(declaration.getName(), name2)).findFirst().orElse(null);
    }

    @Override
    @NotNull
    public List<Declaration> getDeclarations() {
        return PropertyEdge.unwrap(this.declarations);
    }

    @NotNull
    public List<PropertyEdge<Declaration>> getDeclarationsPropertyEdge() {
        return this.declarations;
    }

    @NotNull
    public List<IncludeDeclaration> getIncludes() {
        return PropertyEdge.unwrap(this.includes);
    }

    @NotNull
    public List<PropertyEdge<IncludeDeclaration>> getIncludesPropertyEdge() {
        return this.includes;
    }

    @NotNull
    public List<Declaration> getNamespaces() {
        return PropertyEdge.unwrap(this.namespaces);
    }

    @NotNull
    public List<PropertyEdge<Declaration>> getNamespacesPropertyEdge() {
        return this.namespaces;
    }

    @Override
    public void addDeclaration(@NotNull Declaration declaration) {
        if (declaration instanceof IncludeDeclaration) {
            this.addIfNotContains(this.includes, (IncludeDeclaration)declaration);
        } else if (declaration instanceof NamespaceDeclaration) {
            this.addIfNotContains(this.namespaces, declaration);
        }
        this.addIfNotContains(this.declarations, declaration);
    }

    @Override
    @NotNull
    public List<PropertyEdge<Statement>> getStatementEdges() {
        return this.statements;
    }

    @Override
    public void setStatementEdges(@NotNull List<PropertyEdge<Statement>> statements) {
        this.statements = statements;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).append("declarations", this.declarations).append("includes", this.includes).append("namespaces", this.namespaces).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TranslationUnitDeclaration)) {
            return false;
        }
        TranslationUnitDeclaration that = (TranslationUnitDeclaration)o;
        return super.equals(that) && Objects.equals(this.getDeclarations(), that.getDeclarations()) && PropertyEdge.propertyEqualsList(this.declarations, that.declarations) && Objects.equals(this.getIncludes(), that.getIncludes()) && PropertyEdge.propertyEqualsList(this.includes, that.includes) && Objects.equals(this.getNamespaces(), that.getNamespaces()) && PropertyEdge.propertyEqualsList(this.namespaces, that.namespaces);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

