/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TypeParamDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.neo4j.ogm.annotation.Relationship;

public abstract class TemplateDeclaration
extends Declaration
implements DeclarationHolder {
    @Relationship(value="PARAMETERS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    protected List<PropertyEdge<Declaration>> parameters = new ArrayList<PropertyEdge<Declaration>>();

    public List<Declaration> getParameters() {
        return PropertyEdge.unwrap(this.parameters);
    }

    public List<Declaration> getParametersOfClazz(Class<? extends Declaration> clazz) {
        ArrayList<Declaration> reducedParametersByType = new ArrayList<Declaration>();
        for (Declaration n : this.getParameters()) {
            if (!clazz.isInstance(n)) continue;
            reducedParametersByType.add(n);
        }
        return reducedParametersByType;
    }

    public List<PropertyEdge<Declaration>> getParametersPropertyEdge() {
        return this.parameters;
    }

    public List<Declaration> getParametersWithDefaults() {
        ArrayList<Declaration> parametersWithDefaults = new ArrayList<Declaration>();
        for (Declaration declaration : this.getParameters()) {
            if ((!(declaration instanceof TypeParamDeclaration) || ((TypeParamDeclaration)declaration).getDefault() == null) && (!(declaration instanceof ParamVariableDeclaration) || ((ParamVariableDeclaration)declaration).getDefault() == null)) continue;
            parametersWithDefaults.add(declaration);
        }
        return parametersWithDefaults;
    }

    public List<Node> getParameterDefaults() {
        ArrayList<Node> defaults = new ArrayList<Node>();
        for (Declaration declaration : this.getParameters()) {
            if (declaration instanceof TypeParamDeclaration) {
                defaults.add(((TypeParamDeclaration)declaration).getDefault());
                continue;
            }
            if (!(declaration instanceof ParamVariableDeclaration)) continue;
            defaults.add(((ParamVariableDeclaration)declaration).getDefault());
        }
        return defaults;
    }

    public void addParameter(TypeParamDeclaration parameterizedType) {
        PropertyEdge<TypeParamDeclaration> propertyEdge = new PropertyEdge<TypeParamDeclaration>(this, parameterizedType);
        propertyEdge.addProperty(Properties.INDEX, this.parameters.size());
        this.parameters.add(propertyEdge);
    }

    public void addParameter(ParamVariableDeclaration nonTypeTemplateParamDeclaration) {
        PropertyEdge<ParamVariableDeclaration> propertyEdge = new PropertyEdge<ParamVariableDeclaration>(this, nonTypeTemplateParamDeclaration);
        propertyEdge.addProperty(Properties.INDEX, this.parameters.size());
        this.parameters.add(propertyEdge);
    }

    @Override
    @NotNull
    public List<Declaration> getDeclarations() {
        ArrayList<Declaration> list2 = new ArrayList<Declaration>();
        list2.addAll(this.getRealizationDeclarations());
        return list2;
    }

    public void removeParameter(TypeParamDeclaration parameterizedType) {
        this.parameters.removeIf(propertyEdge -> ((Declaration)propertyEdge.getEnd()).equals(parameterizedType));
    }

    public void removeParameter(ParamVariableDeclaration nonTypeTemplateParamDeclaration) {
        this.parameters.removeIf(propertyEdge -> ((Declaration)propertyEdge.getEnd()).equals(nonTypeTemplateParamDeclaration));
    }

    public abstract List<Declaration> getRealizationDeclarations();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TemplateDeclaration that = (TemplateDeclaration)o;
        return Objects.equals(this.getParameters(), that.getParameters()) && PropertyEdge.propertyEqualsList(this.parameters, that.parameters);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static enum TemplateInitialization {
        AUTO_DEDUCTION,
        DEFAULT,
        EXPLICIT,
        UNKNOWN;

    }
}

