/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.StatementHolder;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.ogm.annotation.Relationship;

public class NamespaceDeclaration
extends Declaration
implements DeclarationHolder,
StatementHolder {
    @SubGraph(value={"AST"})
    private final List<Declaration> declarations = new ArrayList<Declaration>();
    @Relationship(value="STATEMENTS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    @NotNull
    private List<PropertyEdge<Statement>> statements = new ArrayList<PropertyEdge<Statement>>();

    public List<FieldDeclaration> getFields() {
        return this.declarations.stream().filter(FieldDeclaration.class::isInstance).map(FieldDeclaration.class::cast).collect(Collectors.toList());
    }

    public List<FunctionDeclaration> getFunctions() {
        return this.declarations.stream().filter(FunctionDeclaration.class::isInstance).map(FunctionDeclaration.class::cast).collect(Collectors.toList());
    }

    public List<RecordDeclaration> getRecords() {
        return this.declarations.stream().filter(RecordDeclaration.class::isInstance).map(RecordDeclaration.class::cast).collect(Collectors.toList());
    }

    public List<NamespaceDeclaration> getNamespaces() {
        return this.declarations.stream().filter(NamespaceDeclaration.class::isInstance).map(NamespaceDeclaration.class::cast).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<Declaration> getDeclarations() {
        return this.declarations;
    }

    @NotNull
    public <T extends Declaration> Set<T> getDeclarationsByName(@NotNull String name2, @NotNull Class<T> clazz) {
        return this.getDeclarations().stream().filter(declaration -> clazz.isAssignableFrom(declaration.getClass())).map(clazz::cast).filter(declaration -> Objects.equals(declaration.getName(), name2)).collect(Collectors.toSet());
    }

    public <T> T getDeclarationAs(int i, Class<T> clazz) {
        return clazz.cast(this.getDeclarations().get(i));
    }

    @Override
    @NotNull
    public List<PropertyEdge<Statement>> getStatementEdges() {
        return this.statements;
    }

    @Override
    public void setStatementEdges(@NotNull List<PropertyEdge<Statement>> statements) {
        this.statements = statements;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamespaceDeclaration)) {
            return false;
        }
        NamespaceDeclaration that = (NamespaceDeclaration)o;
        return super.equals(that) && Objects.equals(this.declarations, that.declarations);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void addDeclaration(@NotNull Declaration declaration) {
        this.addIfNotContains(this.declarations, declaration);
    }
}

