/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.HasInitializer;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.Nullable;
import org.neo4j.ogm.annotation.Relationship;

public class FieldDeclaration
extends ValueDeclaration
implements HasType.TypeListener,
HasInitializer {
    @SubGraph(value={"AST"})
    @Nullable
    private Expression initializer;
    private boolean isDefinition = false;
    @Relationship(value="DEFINES")
    private FieldDeclaration definition = this;
    private boolean implicitInitializerAllowed = false;
    private boolean isArray = false;
    private List<String> modifiers = new ArrayList<String>();

    public boolean isImplicitInitializerAllowed() {
        return this.implicitInitializerAllowed;
    }

    public void setImplicitInitializerAllowed(boolean implicitInitializerAllowed) {
        this.implicitInitializerAllowed = implicitInitializerAllowed;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setIsArray(boolean isArray) {
        this.isArray = isArray;
    }

    @Override
    @Nullable
    public Expression getInitializer() {
        return this.initializer;
    }

    @Override
    public void setInitializer(Expression initializer) {
        if (this.initializer != null) {
            this.setIsDefinition(true);
            this.initializer.unregisterTypeListener(this);
            if (this.initializer instanceof HasType.TypeListener) {
                this.unregisterTypeListener((HasType.TypeListener)((Object)this.initializer));
            }
        }
        this.initializer = initializer;
        if (initializer != null) {
            initializer.registerTypeListener(this);
            if (initializer instanceof HasType.TypeListener) {
                this.registerTypeListener((HasType.TypeListener)((Object)initializer));
            }
        }
    }

    public FieldDeclaration getDefinition() {
        return this.isDefinition ? this : this.definition;
    }

    public boolean isDefinition() {
        return this.isDefinition;
    }

    public void setIsDefinition(boolean definition) {
        this.isDefinition = definition;
    }

    public void setDefinition(FieldDeclaration definition) {
        this.definition = definition;
    }

    public List<String> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(List<String> modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public void typeChanged(HasType src, List<HasType> root, Type oldType) {
        Type newType;
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        if (!TypeManager.getInstance().isUnknown(this.type) && src.getPropagationType().equals(oldType)) {
            return;
        }
        Type previous = this.type;
        if (src == this.initializer && this.initializer instanceof InitializerListExpression) {
            if (this.isArray) {
                newType = src.getType();
            } else {
                if (!TypeManager.getInstance().isUnknown(this.type)) {
                    return;
                }
                newType = src.getType().dereference();
            }
        } else {
            newType = src.getPropagationType();
        }
        this.setType(newType, root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, List<HasType> root) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        ArrayList<Type> subTypes = new ArrayList<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("initializer", (Object)this.initializer).append("modifiers", this.modifiers).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldDeclaration)) {
            return false;
        }
        FieldDeclaration that = (FieldDeclaration)o;
        return super.equals(that) && Objects.equals(this.initializer, that.initializer) && Objects.equals(this.modifiers, that.modifiers);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

