/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends;

import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.GotoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.LabelStatement;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LanguageFrontend {
    public static final Logger log = LoggerFactory.getLogger(LanguageFrontend.class);
    protected final TranslationConfiguration config;
    protected ScopeManager scopeManager;
    protected List<Class<?>> interestingStatements = List.of(GotoStatement.class, LabelStatement.class);
    protected Map<Object, BiConsumer<Object, Object>> objectListeners = new HashMap<Object, BiConsumer<Object, Object>>();
    protected Map<BiPredicate<Object, Object>, BiConsumer<Object, Object>> predicateListeners = new HashMap<BiPredicate<Object, Object>, BiConsumer<Object, Object>>();
    protected Map<Object, Object> processedMapping = new HashMap<Object, Object>();
    private final String namespaceDelimiter;
    protected TranslationUnitDeclaration currentTU = null;

    public LanguageFrontend(@NotNull TranslationConfiguration config, ScopeManager scopeManager, String namespaceDelimiter) {
        this.config = config;
        this.namespaceDelimiter = namespaceDelimiter;
        this.scopeManager = scopeManager;
        this.scopeManager.setLang(this);
    }

    public void process(Object from2, Object to2) {
        BiConsumer<Object, Object> listener;
        if (this.interestingStatements.stream().anyMatch(c -> c.isInstance(from2) || c.isInstance(to2))) {
            this.processedMapping.put(from2, to2);
        }
        if ((listener = this.objectListeners.get(from2)) != null) {
            listener.accept(from2, to2);
            this.objectListeners.remove(from2);
        }
        HashMap<BiPredicate<Object, Object>, BiConsumer<Object, Object>> newPredicateListeners = new HashMap<BiPredicate<Object, Object>, BiConsumer<Object, Object>>();
        for (Map.Entry<BiPredicate<Object, Object>, BiConsumer<Object, Object>> pListener : this.predicateListeners.entrySet()) {
            if (pListener.getKey().test(from2, to2)) {
                pListener.getValue().accept(from2, to2);
                continue;
            }
            newPredicateListeners.put(pListener.getKey(), pListener.getValue());
        }
        this.predicateListeners = newPredicateListeners;
    }

    public void registerObjectListener(Object from2, BiConsumer<Object, Object> biConsumer) {
        if (this.processedMapping.containsKey(from2)) {
            biConsumer.accept(from2, this.processedMapping.get(from2));
        }
        this.objectListeners.put(from2, biConsumer);
    }

    public void registerPredicateListener(BiPredicate<Object, Object> predicate, BiConsumer<Object, Object> biConsumer) {
        ArrayList<Map.Entry<Object, Object>> matchingEntries = new ArrayList<Map.Entry<Object, Object>>();
        for (Map.Entry<Object, Object> mapping : this.processedMapping.entrySet()) {
            if (!predicate.test(mapping.getKey(), mapping.getValue())) continue;
            matchingEntries.add(mapping);
        }
        if (!matchingEntries.isEmpty()) {
            for (Map.Entry<Object, Object> match : matchingEntries) {
                biConsumer.accept(match.getKey(), match.getValue());
            }
        }
        this.predicateListeners.put(predicate, biConsumer);
    }

    public void clearProcessed() {
        this.objectListeners.clear();
        this.predicateListeners.clear();
        this.processedMapping.clear();
    }

    public List<TranslationUnitDeclaration> parseAll() throws TranslationException {
        ArrayList<TranslationUnitDeclaration> units = new ArrayList<TranslationUnitDeclaration>();
        for (String component : this.config.getSoftwareComponents().keySet()) {
            for (File sourceFile : this.config.getSoftwareComponents().get(component)) {
                units.add(this.parse(sourceFile));
            }
        }
        return units;
    }

    @NotNull
    public ScopeManager getScopeManager() {
        return this.scopeManager;
    }

    public void setScopeManager(@NotNull ScopeManager scopeManager) {
        this.scopeManager = scopeManager;
        this.scopeManager.setLang(this);
    }

    public TranslationUnitDeclaration getCurrentTU() {
        return this.currentTU;
    }

    public void setCurrentTU(TranslationUnitDeclaration currentTU) {
        this.currentTU = currentTU;
    }

    public abstract TranslationUnitDeclaration parse(File var1) throws TranslationException;

    @Nullable
    public abstract <T> String getCodeFromRawNode(T var1);

    @Nullable
    public abstract <T> PhysicalLocation getLocationFromRawNode(T var1);

    public <N, S> void setCodeAndRegion(@NotNull N cpgNode, @Nullable S astNode) {
        if (cpgNode instanceof Node && astNode != null) {
            if (this.config.codeInNodes) {
                String code = this.getCodeFromRawNode(astNode);
                if (code != null) {
                    ((Node)cpgNode).setCode(code);
                } else {
                    log.warn("Unexpected: No code for node {}", astNode);
                }
            }
            ((Node)cpgNode).setLocation(this.getLocationFromRawNode(astNode));
        }
    }

    public String getNewLineType(Node node) {
        List<String> nls = Arrays.asList("\n\r", "\r\n", "\n");
        for (String nl : nls) {
            if (!node.toString().endsWith(nl)) continue;
            return nl;
        }
        log.debug("Could not determine newline type. Assuming \\n. {}", (Object)node);
        return "\n";
    }

    public String getCodeOfSubregion(Node node, Region nodeRegion, Region subRegion) {
        String code = node.getCode();
        if (code == null) {
            return "";
        }
        String nlType = this.getNewLineType(node);
        int start = subRegion.getStartLine() == nodeRegion.getStartLine() ? subRegion.getStartColumn() - nodeRegion.getStartColumn() : StringUtils.ordinalIndexOf((CharSequence)code, (CharSequence)nlType, (int)(subRegion.getStartLine() - nodeRegion.getStartLine())) + subRegion.getStartColumn();
        int end = subRegion.getEndLine() == nodeRegion.getStartLine() ? subRegion.getEndColumn() - nodeRegion.getStartColumn() : StringUtils.ordinalIndexOf((CharSequence)code, (CharSequence)nlType, (int)(subRegion.getEndLine() - nodeRegion.getStartLine())) + subRegion.getEndColumn();
        return code.substring(start, end);
    }

    public Region mergeRegions(Region regionOne, Region regionTwo) {
        Region ret = new Region();
        if (regionOne.getStartLine() < regionTwo.getStartLine() || regionOne.getStartLine() == regionTwo.getStartLine() && regionOne.getStartColumn() < regionTwo.getStartColumn()) {
            ret.setStartLine(regionOne.getStartLine());
            ret.setStartColumn(regionOne.getStartColumn());
        } else {
            ret.setStartLine(regionTwo.getStartLine());
            ret.setStartColumn(regionTwo.getStartColumn());
        }
        if (regionOne.getEndLine() > regionTwo.getEndLine() || regionOne.getEndLine() == regionTwo.getEndLine() && regionOne.getEndColumn() > regionTwo.getEndColumn()) {
            ret.setEndLine(regionOne.getEndLine());
            ret.setEndColumn(regionOne.getStartColumn());
        } else {
            ret.setEndLine(regionTwo.getEndLine());
            ret.setEndColumn(regionTwo.getEndColumn());
        }
        return ret;
    }

    public void cleanup() {
        this.clearProcessed();
    }

    public String getNamespaceDelimiter() {
        return this.namespaceDelimiter;
    }

    public abstract <S, T> void setComment(S var1, T var2);

    public TranslationConfiguration getConfig() {
        return this.config;
    }
}

