/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg;

import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationManager;
import de.fraunhofer.aisec.cpg.graph.Component;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.helpers.BenchmarkResults;
import de.fraunhofer.aisec.cpg.helpers.MeasurementHolder;
import de.fraunhofer.aisec.cpg.helpers.StatisticsHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TranslationResult
extends Node
implements StatisticsHolder {
    public static final String SOURCE_LOCATIONS_TO_FRONTEND = "sourceLocationsToFrontend";
    private final TranslationManager translationManager;
    @SubGraph(value={"AST"})
    private final List<Component> components = new ArrayList<Component>();
    private final Map<String, Object> scratch = new ConcurrentHashMap<String, Object>();
    private final Set<Node> additionalNodes = new HashSet<Node>();
    private final Set<MeasurementHolder> benchmarks = new LinkedHashSet<MeasurementHolder>();

    public TranslationResult(TranslationManager translationManager) {
        this.translationManager = translationManager;
    }

    public boolean isCancelled() {
        return this.translationManager.isCancelled();
    }

    public List<TranslationUnitDeclaration> getTranslationUnits() {
        if (this.components.size() == 1) {
            return Collections.unmodifiableList(this.components.get(0).getTranslationUnits());
        }
        ArrayList<TranslationUnitDeclaration> result = new ArrayList<TranslationUnitDeclaration>();
        for (Component sc : this.components) {
            result.addAll(sc.getTranslationUnits());
        }
        return result;
    }

    @Deprecated(since="4.4.1")
    public synchronized void addTranslationUnit(TranslationUnitDeclaration tu) {
        Component swc = null;
        if (this.components.size() == 1) {
            swc = this.components.get(0);
        } else if (this.components.isEmpty()) {
            swc = new Component();
            swc.setName("application");
            this.components.add(swc);
        } else {
            for (Component component : this.components) {
                if (!component.getName().equals("application")) continue;
                swc = component;
                break;
            }
            if (swc == null) {
                swc = new Component();
                swc.setName("application");
                this.components.add(swc);
            }
        }
        swc.getTranslationUnits().add(tu);
    }

    public List<Component> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public synchronized void addComponent(Component sc) {
        this.components.add(sc);
    }

    public Map<String, Object> getScratch() {
        return this.scratch;
    }

    public Set<Node> getAdditionalNodes() {
        return this.additionalNodes;
    }

    public TranslationManager getTranslationManager() {
        return this.translationManager;
    }

    @Override
    public void addBenchmark(@NotNull MeasurementHolder b) {
        this.benchmarks.add(b);
    }

    @Override
    @NotNull
    public Set<MeasurementHolder> getBenchmarks() {
        return this.benchmarks;
    }

    @Override
    @NotNull
    public List<String> getTranslatedFiles() {
        ArrayList<String> result = new ArrayList<String>();
        this.components.forEach(sc -> result.addAll(sc.getTranslationUnits().stream().map(Node::getName).collect(Collectors.toList())));
        return result;
    }

    @Override
    @NotNull
    public TranslationConfiguration getConfig() {
        return this.translationManager.getConfig();
    }

    @Override
    @NotNull
    public BenchmarkResults getBenchmarkResults() {
        return StatisticsHolder.DefaultImpls.getBenchmarkResults(this);
    }
}

