/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.fraunhofer.aisec.cpg.ConfigurationException;
import de.fraunhofer.aisec.cpg.InferenceConfiguration;
import de.fraunhofer.aisec.cpg.frontends.CompilationDatabase;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.passes.CallResolver;
import de.fraunhofer.aisec.cpg.passes.ControlFlowSensitiveDFGPass;
import de.fraunhofer.aisec.cpg.passes.DFGPass;
import de.fraunhofer.aisec.cpg.passes.EvaluationOrderGraphPass;
import de.fraunhofer.aisec.cpg.passes.FilenameMapper;
import de.fraunhofer.aisec.cpg.passes.FunctionPointerCallResolver;
import de.fraunhofer.aisec.cpg.passes.ImportResolver;
import de.fraunhofer.aisec.cpg.passes.JavaExternalTypeHierarchyResolver;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.TypeHierarchyResolver;
import de.fraunhofer.aisec.cpg.passes.TypeResolver;
import de.fraunhofer.aisec.cpg.passes.VariableUsageResolver;
import de.fraunhofer.aisec.cpg.passes.order.PassWithDependencies;
import de.fraunhofer.aisec.cpg.passes.order.PassWithDepsContainer;
import de.fraunhofer.aisec.cpg.passes.order.RegisterExtraPass;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TranslationConfiguration.class);
    public final boolean debugParser;
    public final boolean loadIncludes;
    public final String[] includePaths;
    public final List<String> includeWhitelist;
    public final List<String> includeBlacklist;
    private final Map<Class<? extends LanguageFrontend>, List<String>> frontends;
    public boolean disableCleanup = false;
    public final boolean codeInNodes;
    public final boolean processAnnotations;
    final boolean failOnError;
    public final Map<String, String> symbols;
    private final Map<String, List<File>> softwareComponents;
    private final File topLevel;
    final boolean useUnityBuild;
    final boolean useParallelFrontends;
    final boolean typeSystemActiveInFrontend;
    final CompilationDatabase compilationDatabase;
    public final boolean matchCommentsToNodes;
    public final boolean addIncludesToGraph;
    @NotNull
    private final List<Pass> passes;
    final InferenceConfiguration inferenceConfiguration;

    private TranslationConfiguration(Map<String, String> symbols, Map<String, List<File>> softwareComponents, File topLevel, boolean debugParser, boolean failOnError, boolean loadIncludes, String[] includePaths, List<String> includeWhitelist, List<String> includeBlacklist, List<Pass> passes, Map<Class<? extends LanguageFrontend>, List<String>> frontends, boolean codeInNodes, boolean processAnnotations, boolean disableCleanup, boolean useUnityBuild, boolean useParallelFrontends, boolean typeSystemActiveInFrontend, InferenceConfiguration inferenceConfiguration, CompilationDatabase compilationDatabase, boolean matchCommentsToNodes, boolean addIncludesToGraph) {
        this.symbols = symbols;
        this.softwareComponents = softwareComponents;
        this.topLevel = topLevel;
        this.debugParser = debugParser;
        this.failOnError = failOnError;
        this.loadIncludes = loadIncludes;
        this.includePaths = includePaths;
        this.includeWhitelist = includeWhitelist;
        this.includeBlacklist = includeBlacklist;
        this.passes = passes != null ? passes : new ArrayList();
        this.frontends = frontends;
        this.codeInNodes = codeInNodes;
        this.processAnnotations = processAnnotations;
        this.disableCleanup = disableCleanup;
        this.useUnityBuild = useUnityBuild;
        this.useParallelFrontends = useParallelFrontends;
        this.typeSystemActiveInFrontend = typeSystemActiveInFrontend;
        this.inferenceConfiguration = inferenceConfiguration;
        this.compilationDatabase = compilationDatabase;
        this.matchCommentsToNodes = matchCommentsToNodes;
        this.addIncludesToGraph = addIncludesToGraph;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, String> getSymbols() {
        return this.symbols;
    }

    public List<File> getSourceLocations() {
        ArrayList<File> sourceLocations = new ArrayList<File>();
        for (Map.Entry<String, List<File>> entry : this.softwareComponents.entrySet()) {
            sourceLocations.addAll((Collection<File>)entry.getValue());
        }
        return sourceLocations;
    }

    public Map<String, List<File>> getSoftwareComponents() {
        return this.softwareComponents;
    }

    @Nullable
    public CompilationDatabase getCompilationDatabase() {
        return this.compilationDatabase;
    }

    public File getTopLevel() {
        return this.topLevel;
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="name")
    @JsonIdentityReference(alwaysAsId=true)
    public List<Pass> getRegisteredPasses() {
        return this.passes;
    }

    public Map<Class<? extends LanguageFrontend>, List<String>> getFrontends() {
        return this.frontends;
    }

    public InferenceConfiguration getInferenceConfiguration() {
        return this.inferenceConfiguration;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    public static class Builder {
        private Map<String, List<File>> softwareComponents = new HashMap<String, List<File>>();
        private final Map<Class<? extends LanguageFrontend>, List<String>> frontends = new HashMap<Class<? extends LanguageFrontend>, List<String>>();
        private File topLevel = null;
        private boolean debugParser = false;
        private boolean failOnError = false;
        private boolean loadIncludes = false;
        private Map<String, String> symbols = new HashMap<String, String>();
        private final List<String> includePaths = new ArrayList<String>();
        private final List<String> includeWhitelist = new ArrayList<String>();
        private final List<String> includeBlacklist = new ArrayList<String>();
        private final List<Pass> passes = new ArrayList<Pass>();
        private boolean codeInNodes = true;
        private boolean processAnnotations = false;
        private boolean disableCleanup = false;
        private boolean useUnityBuild = false;
        private boolean useParallelFrontends = false;
        private boolean typeSystemActiveInFrontend = true;
        private InferenceConfiguration inferenceConfiguration = new InferenceConfiguration.Builder().build();
        private CompilationDatabase compilationDatabase;
        private boolean matchCommentsToNodes = false;
        private boolean addIncludesToGraph = true;

        public Builder symbols(Map<String, String> symbols) {
            this.symbols = symbols;
            return this;
        }

        public Builder sourceLocations(File ... sourceLocations) {
            this.softwareComponents.put("application", Arrays.asList(sourceLocations));
            return this;
        }

        public Builder sourceLocations(List<File> sourceLocations) {
            this.softwareComponents.put("application", sourceLocations);
            return this;
        }

        public Builder softwareComponents(Map<String, List<File>> softwareComponents) {
            this.softwareComponents = softwareComponents;
            return this;
        }

        public Builder useCompilationDatabase(CompilationDatabase compilationDatabase) {
            this.compilationDatabase = compilationDatabase;
            return this;
        }

        public Builder topLevel(File topLevel) {
            this.topLevel = topLevel;
            return this;
        }

        public Builder debugParser(boolean debugParser) {
            this.debugParser = debugParser;
            return this;
        }

        public Builder matchCommentsToNodes(boolean matchCommentsToNodes) {
            this.matchCommentsToNodes = matchCommentsToNodes;
            return this;
        }

        public Builder addIncludesToGraph(boolean addIncludesToGraph) {
            this.addIncludesToGraph = addIncludesToGraph;
            return this;
        }

        public Builder failOnError(boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        public Builder loadIncludes(boolean loadIncludes) {
            this.loadIncludes = loadIncludes;
            return this;
        }

        public Builder includePath(String includePath) {
            this.includePaths.add(includePath);
            return this;
        }

        public Builder includeWhitelist(String includeFile) {
            this.includeWhitelist.add(includeFile);
            return this;
        }

        public Builder disableCleanup() {
            this.disableCleanup = true;
            return this;
        }

        public Builder includeBlacklist(String includeFile) {
            this.includeBlacklist.add(includeFile);
            return this;
        }

        public Builder registerPass(@NotNull Pass pass) {
            this.passes.add(pass);
            return this;
        }

        public Builder registerLanguage(@NotNull Class<? extends LanguageFrontend> frontend, List<String> fileTypes) {
            this.frontends.put(frontend, fileTypes);
            return this;
        }

        public Builder unregisterLanguage(@NotNull Class<? extends LanguageFrontend> frontend) {
            this.frontends.remove(frontend);
            return this;
        }

        public Builder defaultPasses() {
            this.registerPass(new TypeHierarchyResolver());
            this.registerPass(new JavaExternalTypeHierarchyResolver());
            this.registerPass(new ImportResolver());
            this.registerPass(new VariableUsageResolver());
            this.registerPass(new CallResolver());
            this.registerPass(new DFGPass());
            this.registerPass(new FunctionPointerCallResolver());
            this.registerPass(new EvaluationOrderGraphPass());
            this.registerPass(new TypeResolver());
            this.registerPass(new ControlFlowSensitiveDFGPass());
            this.registerPass(new FilenameMapper());
            return this;
        }

        private void registerExtraFrontendPasses() throws ConfigurationException {
            for (Class<? extends LanguageFrontend> frontend : this.frontends.keySet()) {
                RegisterExtraPass[] extraPasses;
                if (((RegisterExtraPass[])frontend.getAnnotationsByType(RegisterExtraPass.class)).length == 0) continue;
                for (RegisterExtraPass p : extraPasses = (RegisterExtraPass[])frontend.getAnnotationsByType(RegisterExtraPass.class)) {
                    try {
                        Class<? extends Pass> clazz = p.value();
                        this.registerPass(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                        log.info("Registered an extra (frontend dependent) default dependency: {}", p.value());
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ignored) {
                        throw new ConfigurationException("Failed to load frontend: {}" + frontend.getName());
                    }
                }
            }
        }

        public Builder defaultLanguages() {
            this.registerLanguage(CXXLanguageFrontend.class, Lists.newArrayList((Iterable)Iterables.concat(CXXLanguageFrontend.CXX_EXTENSIONS, CXXLanguageFrontend.CXX_HEADER_EXTENSIONS)));
            this.registerLanguage(JavaLanguageFrontend.class, JavaLanguageFrontend.JAVA_EXTENSIONS);
            return this;
        }

        public Builder codeInNodes(boolean b) {
            this.codeInNodes = b;
            return this;
        }

        public Builder processAnnotations(boolean b) {
            this.processAnnotations = b;
            return this;
        }

        public Builder useUnityBuild(boolean b) {
            this.useUnityBuild = b;
            return this;
        }

        public Builder useParallelFrontends(boolean b) {
            this.useParallelFrontends = b;
            return this;
        }

        public Builder typeSystemActiveInFrontend(boolean b) {
            this.typeSystemActiveInFrontend = b;
            return this;
        }

        public Builder inferenceConfiguration(InferenceConfiguration configuration) {
            this.inferenceConfiguration = configuration;
            return this;
        }

        public TranslationConfiguration build() throws ConfigurationException {
            if (this.useParallelFrontends && this.typeSystemActiveInFrontend) {
                log.warn("Not disabling the type system during the frontend phase is not recommended when using the parallel frontends feature! This may result in erroneous results.");
            }
            this.registerExtraFrontendPasses();
            return new TranslationConfiguration(this.symbols, this.softwareComponents, this.topLevel, this.debugParser, this.failOnError, this.loadIncludes, this.includePaths.toArray(new String[0]), this.includeWhitelist, this.includeBlacklist, this.orderPasses(), this.frontends, this.codeInNodes, this.processAnnotations, this.disableCleanup, this.useUnityBuild, this.useParallelFrontends, this.typeSystemActiveInFrontend, this.inferenceConfiguration, this.compilationDatabase, this.matchCommentsToNodes, this.addIncludesToGraph);
        }

        private PassWithDepsContainer collectInitialPasses() {
            PassWithDepsContainer workingList = new PassWithDepsContainer();
            for (Pass p : this.passes) {
                Set<Class<? extends Pass>> executeBefore = p.getExecuteBefore();
                for (Class<? extends Pass> eb : executeBefore) {
                    for (Pass p2 : this.passes) {
                        if (!eb.isInstance(p2)) continue;
                        p2.addSoftDependency(p.getClass());
                    }
                }
            }
            for (Pass p : this.passes) {
                boolean passFound = false;
                for (PassWithDependencies wl : workingList.getWorkingList()) {
                    if (wl.getPass().getClass() != p.getClass()) continue;
                    passFound = true;
                    break;
                }
                if (passFound) continue;
                HashSet<Class<? extends Pass>> deps = new HashSet<Class<? extends Pass>>();
                deps.addAll(p.getHardDependencies());
                deps.addAll(p.getSoftDependencies());
                workingList.addToWorkingList(new PassWithDependencies(p, deps));
            }
            return workingList;
        }

        private List<Pass> orderPasses() throws ConfigurationException {
            log.info("Passes before enforcing order: {}", this.passes);
            ArrayList<Pass> result = new ArrayList<Pass>();
            PassWithDepsContainer workingList = this.collectInitialPasses();
            log.debug("Working list after initial scan: {}", (Object)workingList);
            workingList.addMissingDependencies();
            log.debug("Working list after adding missing dependencies: {}", (Object)workingList);
            if (workingList.getFirstPasses().size() > 1) {
                log.error("Too many passes require to be executed as first pass: {}", workingList.getWorkingList());
                throw new ConfigurationException("Too many passes require to be executed as first pass.");
            }
            if (workingList.getLastPasses().size() > 1) {
                log.error("Too many passes require to be executed as last pass: {}", workingList.getLastPasses());
                throw new ConfigurationException("Too many passes require to be executed as last pass.");
            }
            Pass firstPass = workingList.getAndRemoveFirstPass();
            if (firstPass != null) {
                result.add(firstPass);
            }
            while (!workingList.isEmpty()) {
                Pass p = workingList.getAndRemoveFirstPassWithoutDependencies();
                if (p != null) {
                    result.add(p);
                    continue;
                }
                throw new ConfigurationException("Failed to satisfy ordering requirements.");
            }
            log.info("Passes after enforcing order: {}", result);
            return result;
        }
    }
}

