/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TypeHierarchyResolver
extends Pass {
    protected final Map<String, RecordDeclaration> recordMap = new HashMap<String, RecordDeclaration>();
    protected final List<EnumDeclaration> enums = new ArrayList<EnumDeclaration>();

    @Override
    public LanguageFrontend getLang() {
        return null;
    }

    @Override
    public void setLang(LanguageFrontend lang) {
    }

    @Override
    public void accept(TranslationResult translationResult) {
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            this.findRecordsAndEnums(tu);
        }
        for (RecordDeclaration record : this.recordMap.values()) {
            Set<RecordDeclaration> supertypeRecords = this.findSupertypeRecords(record);
            List<MethodDeclaration> allMethodsFromSupertypes = this.getAllMethodsFromSupertypes(supertypeRecords);
            this.analyzeOverridingMethods(record, allMethodsFromSupertypes);
        }
        for (EnumDeclaration enumDecl : this.enums) {
            Set directSupertypeRecords = enumDecl.getSuperTypes().stream().map(s -> this.recordMap.getOrDefault(s.toString(), null)).filter(Objects::nonNull).collect(Collectors.toSet());
            Set<RecordDeclaration> allSupertypes = directSupertypeRecords.stream().map(this::findSupertypeRecords).flatMap(Collection::stream).collect(Collectors.toSet());
            enumDecl.setSuperTypeDeclarations(allSupertypes);
        }
        translationResult.getTranslationUnits().forEach(SubgraphWalker::refreshType);
    }

    protected void findRecordsAndEnums(Node node) {
        node.accept(Strategy::AST_FORWARD, new IVisitor<Node>(){

            @Override
            public void visit(@NotNull Node child) {
                if (child instanceof RecordDeclaration) {
                    TypeHierarchyResolver.this.recordMap.putIfAbsent(child.getName(), (RecordDeclaration)child);
                } else if (child instanceof EnumDeclaration) {
                    TypeHierarchyResolver.this.enums.add((EnumDeclaration)child);
                }
            }
        });
    }

    protected List<MethodDeclaration> getAllMethodsFromSupertypes(Set<RecordDeclaration> supertypeRecords) {
        return supertypeRecords.stream().map(RecordDeclaration::getMethods).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected Set<RecordDeclaration> findSupertypeRecords(RecordDeclaration record) {
        Set<RecordDeclaration> superTypeDeclarations = record.getSuperTypes().stream().map(Type::getTypeName).map(this.recordMap::get).filter(Objects::nonNull).collect(Collectors.toSet());
        record.setSuperTypeDeclarations(superTypeDeclarations);
        return superTypeDeclarations;
    }

    protected void analyzeOverridingMethods(RecordDeclaration declaration, List<MethodDeclaration> allMethodsFromSupertypes) {
        for (MethodDeclaration superMethod : allMethodsFromSupertypes) {
            List<MethodDeclaration> overrideCandidates = declaration.getMethods().stream().filter(superMethod::isOverrideCandidate).collect(Collectors.toList());
            superMethod.addOverriddenBy(overrideCandidates);
            overrideCandidates.forEach(o -> o.addOverrides(superMethod));
        }
    }

    @Override
    public void cleanup() {
    }
}

