/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.graph.AccessValues;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.StatementHolder;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ControlFlowSensitiveDFGPass
extends Pass {
    @Override
    public void cleanup() {
    }

    @Override
    public void accept(TranslationResult translationResult) {
        SubgraphWalker.IterativeGraphWalker walker = new SubgraphWalker.IterativeGraphWalker();
        walker.registerOnNodeVisit(this::handle);
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            walker.iterate(tu);
        }
    }

    protected void removeValues(FunctionLevelFixpointIterator fixDFGs) {
        for (Node currNode : fixDFGs.getRemoves().keySet()) {
            for (Node prev : fixDFGs.getRemoves().get(currNode)) {
                currNode.removePrevDFG(prev);
            }
        }
    }

    protected void handle(Node node) {
        if (node instanceof FunctionDeclaration || node instanceof StatementHolder) {
            FunctionLevelFixpointIterator flfIterator = new FunctionLevelFixpointIterator();
            flfIterator.handle(node);
            this.removeValues(flfIterator);
        }
    }

    protected class FunctionLevelFixpointIterator {
        protected Map<Node, Set<Node>> removes = new HashMap<Node, Set<Node>>();
        protected final Map<Node, Map<VariableDeclaration, Set<Node>>> joinPoints = new HashMap<Node, Map<VariableDeclaration, Set<Node>>>();

        protected FunctionLevelFixpointIterator() {
        }

        public void handle(Node functionRoot) {
            this.iterateTillFixpoint(functionRoot, new HashMap<VariableDeclaration, Set<Node>>(), null, false);
            this.removes = new HashMap<Node, Set<Node>>();
            this.propagateValues();
        }

        public Map<Node, Set<Node>> getRemoves() {
            return this.removes;
        }

        protected void addToRemoves(Node curr, Node prev) {
            if (!this.removes.containsKey(curr)) {
                this.removes.put(curr, new HashSet());
            }
            this.removes.get(curr).add(prev);
        }

        protected Set<Node> eogTraversal(Node node) {
            HashSet<Node> eogReachableNodes = new HashSet<Node>();
            HashSet<Node> checkReachable = new HashSet<Node>();
            checkReachable.add(node);
            while (!checkReachable.isEmpty()) {
                Node n = (Node)checkReachable.iterator().next();
                checkReachable.addAll(n.getNextEOG());
                eogReachableNodes.add(n);
                checkReachable.removeAll(eogReachableNodes);
            }
            return eogReachableNodes;
        }

        protected void setIngoingDFG(Node currNode, Map<VariableDeclaration, Set<Node>> variables) {
            HashSet<Node> prevDFGs = new HashSet<Node>(currNode.getPrevDFG());
            for (Node prev : prevDFGs) {
                if (!(prev instanceof VariableDeclaration) || !variables.containsKey(prev)) continue;
                for (Node target : variables.get(prev)) {
                    currNode.addPrevDFG(target);
                }
                this.addToRemoves(currNode, prev);
            }
        }

        protected void registerOutgoingDFG(Node currNode, Map<VariableDeclaration, Set<Node>> variables) {
            HashSet<Node> nextDFG = new HashSet<Node>(currNode.getNextDFG());
            for (Node next : nextDFG) {
                if (!(next instanceof VariableDeclaration) || !variables.containsKey(next)) continue;
                HashSet<Node> values = new HashSet<Node>(currNode.getPrevDFG());
                variables.replace((VariableDeclaration)next, values);
            }
        }

        protected Node obtainAssignmentNode(Node node) {
            HashSet<Node> nextEOG = new HashSet<Node>(node.getNextEOG());
            HashSet<Node> reachableEOGs = new HashSet<Node>();
            for (Node next : nextEOG) {
                reachableEOGs.addAll(this.eogTraversal(next));
            }
            return reachableEOGs.stream().filter(n -> n instanceof BinaryOperator && Objects.equals(((BinaryOperator)n).getLhs(), node)).findAny().orElse(null);
        }

        protected void modifyDFGEdges(Node currNode, Map<VariableDeclaration, Set<Node>> variables) {
            this.registerOutgoingDFG(currNode, variables);
            this.setIngoingDFG(currNode, variables);
        }

        protected Map<VariableDeclaration, Set<Node>> iterateTillFixpoint(Node node, Map<VariableDeclaration, Set<Node>> variables, Node endNode, boolean stopBefore) {
            Node next;
            if (node == null) {
                return variables;
            }
            do {
                if (node.getPrevEOG().size() != 1) {
                    if (!this.joinPoints.containsKey(node)) {
                        this.joinPoints.put(node, this.createShallowCopy(variables));
                    } else {
                        Map<VariableDeclaration, Set<Node>> currentJoinpoint = this.joinPoints.get(node);
                        if (!this.mergeStates(currentJoinpoint, variables)) {
                            return currentJoinpoint;
                        }
                        variables = this.createShallowCopy(currentJoinpoint);
                    }
                }
                if (node.equals(endNode) && stopBefore) {
                    return variables;
                }
                if (node instanceof DeclaredReferenceExpression) {
                    node = this.handleDeclaredReferenceExpression((DeclaredReferenceExpression)node, variables, this::iterateTillFixpoint);
                }
                if (node.equals(endNode) && !stopBefore) {
                    return variables;
                }
                if (node.getNextEOG().size() > 1) {
                    HashMap<VariableDeclaration, Set<Node>> updatedVariables = new HashMap<VariableDeclaration, Set<Node>>();
                    for (Node next2 : node.getNextEOG()) {
                        if (next2 instanceof VariableDeclaration) {
                            this.addDFGToMap((VariableDeclaration)next2, node, variables);
                        }
                        this.mergeStates(updatedVariables, this.iterateTillFixpoint(next2, this.createShallowCopy(variables), endNode, stopBefore));
                    }
                    return updatedVariables;
                }
                if (node.getNextEOG().isEmpty()) {
                    return variables;
                }
                next = node.getNextEOG().get(0);
                if (!(next instanceof VariableDeclaration)) continue;
                this.addDFGToMap((VariableDeclaration)next, node, variables);
            } while ((node = next) != null);
            return variables;
        }

        protected Node handleDeclaredReferenceExpression(DeclaredReferenceExpression currNode, Map<VariableDeclaration, Set<Node>> variables, IterationFunction iterationFunction) {
            Node binaryOperator;
            if (currNode.getAccess().equals((Object)AccessValues.WRITE) && (binaryOperator = this.obtainAssignmentNode(currNode)) != null) {
                Node nextEOG = currNode.getNextEOG().get(0);
                Map<VariableDeclaration, Set<Node>> updatedVariables = iterationFunction.iterate(nextEOG, this.createShallowCopy(variables), binaryOperator, false);
                variables.clear();
                variables.putAll(updatedVariables);
                this.modifyDFGEdges(currNode, variables);
                return binaryOperator;
            }
            this.modifyDFGEdges(currNode, variables);
            return currNode;
        }

        protected void propagateValues() {
            for (Map.Entry<Node, Map<VariableDeclaration, Set<Node>>> joinPoint : this.joinPoints.entrySet()) {
                this.propagateFromJoinPoints(joinPoint.getKey(), joinPoint.getValue(), null, true);
            }
        }

        protected Map<VariableDeclaration, Set<Node>> propagateFromJoinPoints(Node node, Map<VariableDeclaration, Set<Node>> variables, Node endNode, boolean stopBefore) {
            Node next;
            if (node == null) {
                return variables;
            }
            do {
                if (node.equals(endNode) && stopBefore) {
                    return variables;
                }
                if (node instanceof DeclaredReferenceExpression) {
                    node = this.handleDeclaredReferenceExpression((DeclaredReferenceExpression)node, variables, this::propagateFromJoinPoints);
                }
                if (node.equals(endNode) && !stopBefore) {
                    return variables;
                }
                if (node.getNextEOG().size() > 1) {
                    HashMap<VariableDeclaration, Set<Node>> updatedVariables = new HashMap<VariableDeclaration, Set<Node>>();
                    for (Node next2 : node.getNextEOG()) {
                        if (next2 instanceof VariableDeclaration) {
                            this.addDFGToMap((VariableDeclaration)next2, node, variables);
                        }
                        if (this.joinPoints.containsKey(next2)) continue;
                        this.mergeStates(updatedVariables, this.iterateTillFixpoint(next2, this.createShallowCopy(variables), endNode, stopBefore));
                    }
                    return updatedVariables;
                }
                if (node.getNextEOG().isEmpty()) {
                    return variables;
                }
                next = node.getNextEOG().get(0);
                if (!(next instanceof VariableDeclaration)) continue;
                this.addDFGToMap((VariableDeclaration)next, node, variables);
            } while (!this.joinPoints.containsKey(node = next) && !node.getNextEOG().isEmpty());
            return variables;
        }

        protected void addDFGToMap(VariableDeclaration variableDeclaration, Node prev, Map<VariableDeclaration, Set<Node>> variables) {
            Set<Node> prevDFGSet = variableDeclaration.getPrevDFG();
            if (prevDFGSet.contains(prev)) {
                if (variables.containsKey(variableDeclaration)) {
                    variables.get(variableDeclaration).add(prev);
                } else {
                    HashSet<Node> dfgSet = new HashSet<Node>();
                    dfgSet.add(prev);
                    variables.put(variableDeclaration, dfgSet);
                }
            }
        }

        protected boolean mergeStates(Map<VariableDeclaration, Set<Node>> currentJoinpoint, Map<VariableDeclaration, Set<Node>> variables) {
            boolean changed = false;
            for (Map.Entry<VariableDeclaration, Set<Node>> entry : variables.entrySet()) {
                Set<Node> newAssignments = entry.getValue();
                if (currentJoinpoint.containsKey(entry.getKey())) {
                    Set<Node> existing = currentJoinpoint.get(entry.getKey());
                    for (Node assignment : newAssignments) {
                        if (existing.contains(assignment)) continue;
                        existing.add(assignment);
                        changed = true;
                    }
                    continue;
                }
                currentJoinpoint.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
                changed = true;
            }
            return changed;
        }

        protected Map<VariableDeclaration, Set<Node>> createShallowCopy(Map<VariableDeclaration, Set<Node>> state) {
            LinkedHashMap<VariableDeclaration, Set<Node>> shallowCopy = new LinkedHashMap<VariableDeclaration, Set<Node>>();
            for (Map.Entry<VariableDeclaration, Set<Node>> entry : state.entrySet()) {
                shallowCopy.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
            }
            return shallowCopy;
        }
    }

    protected static interface IterationFunction {
        public Map<VariableDeclaration, Set<Node>> iterate(Node var1, Map<VariableDeclaration, Set<Node>> var2, Node var3, boolean var4);
    }
}

