/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.HasBase;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ArraySubscriptionExpression
extends Expression
implements HasType.TypeListener,
HasBase {
    @SubGraph(value={"AST"})
    private Expression arrayExpression;
    @SubGraph(value={"AST"})
    private Expression subscriptExpression;

    public Expression getArrayExpression() {
        return this.arrayExpression;
    }

    public void setArrayExpression(Expression arrayExpression) {
        this.arrayExpression = arrayExpression;
        this.addPrevDFG(arrayExpression);
        this.setType(this.getSubscriptType(arrayExpression.getType()));
        arrayExpression.registerTypeListener(this);
    }

    private Type getSubscriptType(Type arrayType) {
        return arrayType.dereference();
    }

    public Expression getSubscriptExpression() {
        return this.subscriptExpression;
    }

    public void setSubscriptExpression(Expression subscriptExpression) {
        this.subscriptExpression = subscriptExpression;
    }

    @Override
    public void typeChanged(HasType src, Collection<HasType> root, Type oldType) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        Type previous = this.type;
        this.setType(this.getSubscriptType(src.getPropagationType()), root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, Collection<HasType> root, Set<Type> oldSubTypes) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes().stream().map(this::getSubscriptType).collect(Collectors.toList()));
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArraySubscriptionExpression)) {
            return false;
        }
        ArraySubscriptionExpression that = (ArraySubscriptionExpression)o;
        return super.equals(that) && Objects.equals(this.arrayExpression, that.arrayExpression) && Objects.equals(this.subscriptExpression, that.subscriptExpression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.arrayExpression, this.subscriptExpression);
    }

    @Override
    @NotNull
    public Expression getBase() {
        return this.arrayExpression;
    }
}

