/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TypeParamDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.neo4j.ogm.annotation.Relationship;

public class ClassTemplateDeclaration
extends TemplateDeclaration {
    @Relationship(value="REALIZATION", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private final List<PropertyEdge<RecordDeclaration>> realization = new ArrayList<PropertyEdge<RecordDeclaration>>();

    public List<RecordDeclaration> getRealization() {
        return PropertyEdge.unwrap(this.realization);
    }

    @Override
    public List<Declaration> getRealizationDeclarations() {
        return new ArrayList<Declaration>(this.getRealization());
    }

    public List<PropertyEdge<RecordDeclaration>> getRealizationPropertyEdge() {
        return this.realization;
    }

    public void addRealization(RecordDeclaration realizedRecord) {
        PropertyEdge<RecordDeclaration> propertyEdge = new PropertyEdge<RecordDeclaration>(this, realizedRecord);
        propertyEdge.addProperty(Properties.INDEX, this.realization.size());
        this.realization.add(propertyEdge);
    }

    public void removeRealization(RecordDeclaration realizedRecordDeclaration) {
        this.realization.removeIf(propertyEdge -> ((RecordDeclaration)propertyEdge.getEnd()).equals(realizedRecordDeclaration));
    }

    @Override
    public void addDeclaration(@NonNull Declaration declaration) {
        if (declaration instanceof TypeParamDeclaration || declaration instanceof ParamVariableDeclaration) {
            this.addIfNotContains(this.parameters, declaration);
        } else if (declaration instanceof RecordDeclaration) {
            this.addIfNotContains(this.realization, (RecordDeclaration)declaration);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClassTemplateDeclaration that = (ClassTemplateDeclaration)o;
        return Objects.equals(this.getRealization(), that.getRealization()) && PropertyEdge.propertyEqualsList(this.realization, that.realization) && Objects.equals(this.getParameters(), that.getParameters()) && PropertyEdge.propertyEqualsList(this.parameters, that.parameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode());
    }
}

