/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.processing.strategy;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import java.util.Collections;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Strategy {
    private Strategy() {
    }

    public static @NonNull Iterator<Node> NO_STRATEGY(@NonNull Node x) {
        return Collections.emptyIterator();
    }

    public static @NonNull Iterator<Node> EOG_FORWARD(@NonNull Node x) {
        return x.getNextEOG().iterator();
    }

    public static @NonNull Iterator<Node> EOG_BACKWARD(@NonNull Node x) {
        return x.getPrevEOG().iterator();
    }

    public static @NonNull Iterator<Node> DFG_FORWARD(@NonNull Node x) {
        return x.getNextDFG().iterator();
    }

    public static @NonNull Iterator<Node> DFG_BACKWARD(@NonNull Node x) {
        return x.getPrevDFG().iterator();
    }

    public static @NonNull Iterator<Node> AST_FORWARD(@NonNull Node x) {
        return SubgraphWalker.getAstChildren(x).iterator();
    }
}

