/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes.scopes;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.passes.scopes.ValueDeclarationScope;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class StructureDeclarationScope
extends ValueDeclarationScope {
    private @NonNull List<Declaration> structureDeclarations = new ArrayList<Declaration>();

    public List<Declaration> getStructureDeclarations() {
        return this.structureDeclarations;
    }

    public void setStructureDeclarations(@NonNull List<Declaration> structureDeclarations) {
        this.structureDeclarations = structureDeclarations;
    }

    public StructureDeclarationScope(Node node) {
        super(node);
    }

    private void addStructureDeclaration(@NonNull Declaration declaration) {
        this.structureDeclarations.add(declaration);
        if (this.astNode instanceof DeclarationHolder) {
            DeclarationHolder holder = (DeclarationHolder)((Object)this.astNode);
            holder.addDeclaration(declaration);
        } else {
            log.error("Trying to add a value declaration to a scope which does not have a declaration holder AST node");
        }
    }

    @Override
    public void addDeclaration(@NonNull Declaration declaration, boolean addToAST) {
        if (declaration instanceof ValueDeclaration) {
            this.addValueDeclaration((ValueDeclaration)declaration, addToAST);
        } else {
            this.addStructureDeclaration(declaration);
        }
    }
}

