/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.processing.IVisitor;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import org.jetbrains.annotations.NotNull;

public class FilenameMapper
extends Pass {
    @Override
    public void accept(TranslationResult translationResult) {
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            String name = tu.getName();
            tu.setFile(name);
            this.handle(tu, name);
        }
    }

    private void handle(Node node, final String file) {
        node.accept(Strategy::AST_FORWARD, new IVisitor<Node>(){

            @Override
            public void visit(@NotNull Node child) {
                child.setFile(file);
            }
        });
    }

    @Override
    public void cleanup() {
    }
}

