/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.helpers.MeasurementHolderKt;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\f"}, d2={"printMarkdown", "", "table", "", "", "headers", "", "relativeOrAbsolute", "Ljava/nio/file/Path;", "path", "topLevel", "Ljava/io/File;", "cpg-core"})
public final class MeasurementHolderKt {
    public static final void printMarkdown(@NotNull List<? extends List<? extends Object>> table, @NotNull List<String> headers) {
        Intrinsics.checkNotNullParameter(table, (String)"table");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        int[] lengths = new int[headers.size()];
        for (List<? extends Object> list : table) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String string = list.get(i).toString();
                if (string.length() <= lengths[i]) continue;
                lengths[i] = string.length();
            }
        }
        String dash2 = ArraysKt.joinToString$default((int[])lengths, (CharSequence)" | ", (CharSequence)"| ", (CharSequence)" |", (int)0, null, (Function1)printMarkdown.dash.1.INSTANCE, (int)24, null);
        Ref.IntRef intRef = new Ref.IntRef();
        String header2 = CollectionsKt.joinToString$default((Iterable)headers, (CharSequence)" | ", (CharSequence)"| ", (CharSequence)" |", (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(lengths, intRef){
            final /* synthetic */ int[] $lengths;
            final /* synthetic */ Ref.IntRef $i;
            {
                this.$lengths = $lengths;
                this.$i = $i;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int n = this.$i.element;
                this.$i.element = n + 1;
                return StringsKt.padEnd$default((String)it, (int)this.$lengths[n], (char)'\u0000', (int)2, null);
            }
        }), (int)24, null);
        System.out.println();
        System.out.println((Object)header2);
        System.out.println((Object)dash2);
        for (List<? extends Object> list : table) {
            Ref.IntRef rowIndex = new Ref.IntRef();
            String line2 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" | ", (CharSequence)"| ", (CharSequence)" |", (int)0, null, (Function1)((Function1)new Function1<Object, CharSequence>(lengths, rowIndex){
                final /* synthetic */ int[] $lengths;
                final /* synthetic */ Ref.IntRef $rowIndex;
                {
                    this.$lengths = $lengths;
                    this.$rowIndex = $rowIndex;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull Object it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int n = this.$rowIndex.element;
                    this.$rowIndex.element = n + 1;
                    return StringsKt.padEnd$default((String)it.toString(), (int)this.$lengths[n], (char)'\u0000', (int)2, null);
                }
            }), (int)24, null);
            System.out.println((Object)line2);
        }
        System.out.println();
    }

    @NotNull
    public static final Path relativeOrAbsolute(@NotNull Path path, @Nullable File topLevel) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (topLevel != null) {
            Path path3;
            try {
                path3 = topLevel.toPath().toAbsolutePath().relativize(path);
            }
            catch (IllegalArgumentException ex) {
                path3 = path;
            }
            Path path4 = path3;
            path2 = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"{\n        try {\n        \u2026     path\n        }\n    }");
        } else {
            path2 = path;
        }
        return path2;
    }
}

