/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.types.ReferenceType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.neo4j.ogm.annotation.Transient;

public abstract class Expression
extends Statement
implements HasType {
    protected Type type = UnknownType.getUnknownType();
    @Transient
    private final Set<HasType.TypeListener> typeListeners = new HashSet<HasType.TypeListener>();
    private Set<Type> possibleSubTypes = new HashSet<Type>();

    @Override
    public Type getType() {
        Type result = TypeManager.isTypeSystemActive() ? (this.type != null ? this.type : UnknownType.getUnknownType()) : (Type)TypeManager.getInstance().getTypeCache().computeIfAbsent(this, n -> Collections.emptySet()).stream().findAny().orElse(UnknownType.getUnknownType());
        return result;
    }

    @Override
    public Type getPropagationType() {
        if (this.type instanceof ReferenceType) {
            return ((ReferenceType)this.type).getElementType();
        }
        return this.getType();
    }

    @Override
    public void updateType(Type type) {
        this.type = type;
    }

    @Override
    public void updatePossibleSubtypes(Set<Type> types) {
        this.possibleSubTypes = types;
    }

    @Override
    public void setType(Type type, Collection<HasType> root) {
        if (!TypeManager.isTypeSystemActive()) {
            this.type = type;
            TypeManager.getInstance().cacheType(this, type);
            return;
        }
        if (root == null) {
            root = new ArrayList<HasType>();
        }
        if (type == null || root.contains(this) || TypeManager.getInstance().isUnknown(type) || TypeManager.getInstance().stopPropagation(this.type, type) || this.type instanceof FunctionPointerType && !(type instanceof FunctionPointerType)) {
            return;
        }
        Type oldType = this.type;
        type = type.duplicate();
        type.setQualifier(this.type.getQualifier().merge(type.getQualifier()));
        HashSet<Type> subTypes = new HashSet<Type>();
        for (Type t : this.getPossibleSubTypes()) {
            if (t.isSimilar(type)) continue;
            subTypes.add(t);
        }
        subTypes.add(type);
        this.type = TypeManager.getInstance().registerType(TypeManager.getInstance().getCommonType(subTypes).orElse(type));
        HashSet<Type> newSubtypes = new HashSet<Type>();
        for (Type s : subTypes) {
            if (!TypeManager.getInstance().isSupertypeOf(this.type, s)) continue;
            newSubtypes.add(TypeManager.getInstance().registerType(s));
        }
        this.setPossibleSubTypes(newSubtypes);
        if (Objects.equals(oldType, type)) {
            return;
        }
        root.add(this);
        for (HasType.TypeListener l : this.typeListeners) {
            if (l.equals(this)) continue;
            l.typeChanged(this, root, oldType);
        }
    }

    @Override
    public Set<Type> getPossibleSubTypes() {
        if (!TypeManager.isTypeSystemActive()) {
            return TypeManager.getInstance().getTypeCache().getOrDefault(this, Collections.emptySet());
        }
        return this.possibleSubTypes;
    }

    @Override
    public void setPossibleSubTypes(Set<Type> possibleSubTypes, @NotNull Collection<HasType> root) {
        block7: {
            block6: {
                possibleSubTypes = possibleSubTypes.stream().filter(Predicate.not(TypeManager.getInstance()::isUnknown)).collect(Collectors.toSet());
                if (!TypeManager.isTypeSystemActive()) {
                    possibleSubTypes.forEach(t -> TypeManager.getInstance().cacheType(this, (Type)t));
                    return;
                }
                if (root.contains(this)) break block6;
                if (!possibleSubTypes.stream().allMatch(TypeManager.getInstance()::isPrimitive) || this.possibleSubTypes.isEmpty()) break block7;
            }
            return;
        }
        Set<Type> oldSubTypes = this.possibleSubTypes;
        this.possibleSubTypes = possibleSubTypes;
        if (this.getPossibleSubTypes().equals(oldSubTypes)) {
            return;
        }
        root.add(this);
        for (HasType.TypeListener listener : this.typeListeners) {
            if (listener.equals(this)) continue;
            listener.possibleSubTypesChanged(this, root, oldSubTypes);
        }
    }

    @Override
    public void resetTypes(Type type) {
        HashSet<Type> oldSubTypes = new HashSet<Type>(this.getPossibleSubTypes());
        Type oldType = this.type;
        this.type = type;
        this.possibleSubTypes = new HashSet<Type>();
        ArrayList<Expression> root = new ArrayList<Expression>(List.of(this));
        if (!Objects.equals(oldType, type)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.typeChanged(this, root, oldType));
        }
        if (oldSubTypes.size() != 1 || !oldSubTypes.contains(type)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.possibleSubTypesChanged(this, root, oldSubTypes));
        }
    }

    @Override
    public void registerTypeListener(HasType.TypeListener listener) {
        ArrayList<HasType> root = new ArrayList<HasType>(List.of(this));
        this.typeListeners.add(listener);
        listener.typeChanged(this, root, this.type);
        listener.possibleSubTypesChanged(this, root, this.possibleSubTypes);
    }

    @Override
    public void unregisterTypeListener(HasType.TypeListener listener) {
        this.typeListeners.remove(listener);
    }

    @Override
    public Set<HasType.TypeListener> getTypeListeners() {
        return this.typeListeners;
    }

    @Override
    public void refreshType() {
        ArrayList<HasType> root = new ArrayList<HasType>(List.of(this));
        for (HasType.TypeListener l : this.typeListeners) {
            l.typeChanged(this, root, this.type);
            l.possibleSubTypesChanged(this, root, this.possibleSubTypes);
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("type", (Object)this.type).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Expression)) {
            return false;
        }
        Expression that = (Expression)o;
        return super.equals(that) && Objects.equals(this.type, that.type) && Objects.equals(this.possibleSubTypes, that.possibleSubTypes);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

