/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.HasBase;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.neo4j.ogm.annotation.Relationship;

public class CallExpression
extends Expression
implements HasType.TypeListener,
HasBase,
HasType.SecondaryTypeEdge {
    @Relationship(value="INVOKES", direction="OUTGOING")
    protected List<PropertyEdge<FunctionDeclaration>> invokes = new ArrayList<PropertyEdge<FunctionDeclaration>>();
    @Relationship(value="ARGUMENTS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<Expression>> arguments = new ArrayList<PropertyEdge<Expression>>();
    @SubGraph(value={"AST"})
    private Expression base;
    private String fqn;
    boolean template;
    @Relationship(value="TEMPLATE_PARAMETERS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private @Nullable List<PropertyEdge<Node>> templateParameters;
    @Relationship(value="TEMPLATE_INSTANTIATION", direction="OUTGOING")
    private @Nullable TemplateDeclaration templateInstantiation;

    @Override
    @NotNull
    public Expression getBase() {
        return this.base;
    }

    public void setBase(Expression base) {
        if (this.base != null) {
            this.base.unregisterTypeListener(this);
        }
        this.base = base;
        if (base != null) {
            base.registerTypeListener(this);
        }
    }

    public @NonNull List<Expression> getArguments() {
        ArrayList<Expression> targets = new ArrayList<Expression>();
        for (PropertyEdge<Expression> propertyEdge : this.arguments) {
            targets.add(propertyEdge.getEnd());
        }
        return Collections.unmodifiableList(targets);
    }

    public void setArgument(int index, Expression argument) {
        this.arguments.get(index).setEnd(argument);
    }

    public @NonNull List<PropertyEdge<Expression>> getArgumentsPropertyEdge() {
        return this.arguments;
    }

    public void addArgument(Expression expression) {
        this.addArgument(expression, null);
    }

    public void addArgument(Expression expression, @Nullable String name) {
        PropertyEdge<Expression> propertyEdge = new PropertyEdge<Expression>(this, expression);
        propertyEdge.addProperty(Properties.INDEX, this.arguments.size());
        if (name != null) {
            propertyEdge.addProperty(Properties.NAME, name);
        }
        this.arguments.add(propertyEdge);
    }

    public void setArguments(List<Expression> arguments) {
        this.arguments = PropertyEdge.transformIntoOutgoingPropertyEdgeList(arguments, this);
    }

    public @NonNull List<FunctionDeclaration> getInvokes() {
        ArrayList<FunctionDeclaration> targets = new ArrayList<FunctionDeclaration>();
        for (PropertyEdge<FunctionDeclaration> propertyEdge : this.invokes) {
            targets.add(propertyEdge.getEnd());
        }
        return Collections.unmodifiableList(targets);
    }

    public List<PropertyEdge<FunctionDeclaration>> getInvokesPropertyEdge() {
        return this.invokes;
    }

    public void setInvokes(List<FunctionDeclaration> invokes) {
        PropertyEdge.unwrap(this.invokes).forEach(i -> {
            i.unregisterTypeListener(this);
            Util.detachCallParameters(i, this.getArguments());
            this.removePrevDFG((Node)i);
        });
        this.invokes = PropertyEdge.transformIntoOutgoingPropertyEdgeList(invokes, this);
        invokes.forEach(i -> {
            i.registerTypeListener(this);
            Util.attachCallParameters(i, this.getArguments());
            this.addPrevDFG((Node)i);
        });
    }

    public List<Type> getSignature() {
        return this.getArguments().stream().map(Expression::getType).collect(Collectors.toList());
    }

    public void setTemplate(boolean template) {
        this.template = template;
        if (template) {
            this.templateParameters = new ArrayList<PropertyEdge<Node>>();
        }
    }

    public @Nullable List<PropertyEdge<Node>> getTemplateParametersPropertyEdge() {
        return this.templateParameters;
    }

    public @Nullable List<Node> getTemplateParameters() {
        if (this.templateParameters == null) {
            return null;
        }
        return PropertyEdge.unwrap(this.templateParameters);
    }

    public @Nullable List<Type> getTypeTemplateParameters() {
        if (this.templateParameters == null) {
            return null;
        }
        ArrayList<Type> types = new ArrayList<Type>();
        for (Node n : this.getTemplateParameters()) {
            if (!(n instanceof Type)) continue;
            types.add((Type)n);
        }
        return types;
    }

    public void addTemplateParameter(Type typeTemplateParam, TemplateDeclaration.TemplateInitialization templateInitialization) {
        if (this.templateParameters == null) {
            this.templateParameters = new ArrayList<PropertyEdge<Node>>();
        }
        PropertyEdge<Type> propertyEdge = new PropertyEdge<Type>(this, typeTemplateParam);
        propertyEdge.addProperty(Properties.INDEX, this.templateParameters.size());
        propertyEdge.addProperty(Properties.INSTANTIATION, (Object)templateInitialization);
        this.templateParameters.add(propertyEdge);
        this.template = true;
    }

    public void replaceTypeTemplateParameter(Type oldType, Type newType) {
        if (this.templateParameters == null) {
            return;
        }
        for (int i = 0; i < this.templateParameters.size(); ++i) {
            PropertyEdge<Node> propertyEdge = this.templateParameters.get(i);
            if (!propertyEdge.getEnd().equals(oldType)) continue;
            propertyEdge.setEnd(newType);
        }
    }

    public void addTemplateParameter(Expression expressionTemplateParam, TemplateDeclaration.TemplateInitialization templateInitialization) {
        if (this.templateParameters == null) {
            this.templateParameters = new ArrayList<PropertyEdge<Node>>();
        }
        PropertyEdge<Expression> propertyEdge = new PropertyEdge<Expression>(this, expressionTemplateParam);
        propertyEdge.addProperty(Properties.INDEX, this.templateParameters.size());
        propertyEdge.addProperty(Properties.INSTANTIATION, (Object)templateInitialization);
        this.templateParameters.add(propertyEdge);
        this.template = true;
    }

    public void addTemplateParameter(Node templateParam, TemplateDeclaration.TemplateInitialization templateInitialization) {
        if (templateParam instanceof Expression) {
            this.addTemplateParameter((Expression)templateParam, templateInitialization);
        } else if (templateParam instanceof Type) {
            this.addTemplateParameter((Type)templateParam, templateInitialization);
        }
    }

    public void addExplicitTemplateParameter(Node templateParameter) {
        this.addTemplateParameter(templateParameter, TemplateDeclaration.TemplateInitialization.EXPLICIT);
    }

    public void addExplicitTemplateParameters(List<Node> templateParameters) {
        for (Node node : templateParameters) {
            this.addTemplateParameter(node, TemplateDeclaration.TemplateInitialization.EXPLICIT);
        }
    }

    public void removeRealization(Node templateParam) {
        if (this.templateParameters == null) {
            return;
        }
        this.templateParameters.removeIf(propertyEdge -> ((Node)propertyEdge.getEnd()).equals(templateParam));
    }

    public void setTemplateParameters(List<PropertyEdge<Node>> templateParameters) {
        this.templateParameters = templateParameters;
        this.template = templateParameters != null;
    }

    public @Nullable TemplateDeclaration getTemplateInstantiation() {
        return this.templateInstantiation;
    }

    public void setTemplateInstantiation(TemplateDeclaration templateInstantiation) {
        this.templateInstantiation = templateInstantiation;
        this.template = templateInstantiation != null;
    }

    public void updateTemplateParameters(Map<Node, TemplateDeclaration.TemplateInitialization> initializationType, List<Node> orderedInitializationSignature) {
        if (this.templateParameters == null) {
            return;
        }
        for (PropertyEdge<Node> edge : this.templateParameters) {
            if (edge.getProperty(Properties.INSTANTIATION) == null || !edge.getProperty(Properties.INSTANTIATION).equals((Object)TemplateDeclaration.TemplateInitialization.UNKNOWN) || !initializationType.containsKey(edge.getEnd())) continue;
            edge.addProperty(Properties.INSTANTIATION, (Object)initializationType.get(edge.getEnd()));
        }
        for (int i = this.templateParameters.size(); i < orderedInitializationSignature.size(); ++i) {
            Node signature = orderedInitializationSignature.get(i);
            if (signature == null) continue;
            PropertyEdge<Node> propertyEdge = new PropertyEdge<Node>(this, orderedInitializationSignature.get(i));
            propertyEdge.addProperty(Properties.INDEX, this.templateParameters.size());
            propertyEdge.addProperty(Properties.INSTANTIATION, (Object)initializationType.getOrDefault(orderedInitializationSignature.get(i), TemplateDeclaration.TemplateInitialization.UNKNOWN));
            this.templateParameters.add(propertyEdge);
        }
    }

    public boolean instantiatesTemplate() {
        return this.templateInstantiation != null || this.templateParameters != null || this.template;
    }

    @Override
    public void typeChanged(HasType src, Collection<HasType> root, Type oldType) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        if (src == this.base) {
            this.setFqn(src.getType().getRoot().getTypeName() + "." + this.getName());
        } else {
            Type previous = this.type;
            List<Type> types = this.invokes.stream().map(PropertyEdge::getEnd).map(ValueDeclaration::getType).filter(Objects::nonNull).collect(Collectors.toList());
            Type alternative = !types.isEmpty() ? (Type)types.get(0) : null;
            Type commonType = TypeManager.getInstance().getCommonType(types).orElse(alternative);
            HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
            subTypes.remove(oldType);
            subTypes.addAll(types);
            this.setType(commonType, root);
            this.setPossibleSubTypes(subTypes, root);
            if (!previous.equals(this.type)) {
                this.type.setTypeOrigin(Type.Origin.DATAFLOW);
            }
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, Collection<HasType> root, Set<Type> oldSubTypes) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        if (src != this.base) {
            HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
            subTypes.addAll(src.getPossibleSubTypes());
            this.setPossibleSubTypes(subTypes, root);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("base", (Object)this.base).toString();
    }

    public String getFqn() {
        return this.fqn;
    }

    public void setFqn(String fqn) {
        this.fqn = fqn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CallExpression)) {
            return false;
        }
        CallExpression that = (CallExpression)o;
        return super.equals(that) && Objects.equals(this.getArguments(), that.getArguments()) && PropertyEdge.propertyEqualsList(this.arguments, that.arguments) && Objects.equals(this.getInvokes(), that.getInvokes()) && PropertyEdge.propertyEqualsList(this.invokes, that.invokes) && Objects.equals(this.base, that.base) && Objects.equals(this.getTemplateParameters(), that.getTemplateParameters()) && PropertyEdge.propertyEqualsList(this.templateParameters, that.templateParameters) && Objects.equals(this.templateInstantiation, that.templateInstantiation) && this.template == that.template;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void updateType(Collection<Type> typeState) {
        if (this.templateParameters == null) {
            return;
        }
        for (Type t : this.getTypeTemplateParameters()) {
            for (Type t2 : typeState) {
                if (!t2.equals(t)) continue;
                this.replaceTypeTemplateParameter(t, t2);
            }
        }
    }
}

