/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.neo4j.ogm.annotation.Relationship;

public abstract class Statement
extends Node
implements DeclarationHolder {
    @Relationship(value="LOCALS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    protected List<PropertyEdge<VariableDeclaration>> locals = new ArrayList<PropertyEdge<VariableDeclaration>>();

    public List<VariableDeclaration> getLocals() {
        return PropertyEdge.unwrap(this.locals);
    }

    public List<PropertyEdge<VariableDeclaration>> getLocalsPropertyEdge() {
        return this.locals;
    }

    public void removeLocal(VariableDeclaration variableDeclaration) {
        this.locals = PropertyEdge.removeElementFromList(this.locals, variableDeclaration, true);
    }

    public void setLocals(List<VariableDeclaration> locals) {
        this.locals = PropertyEdge.transformIntoOutgoingPropertyEdgeList(locals, this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Statement)) {
            return false;
        }
        Statement statement = (Statement)o;
        return super.equals(statement) && Objects.equals(this.getLocals(), statement.getLocals()) && PropertyEdge.propertyEqualsList(this.locals, statement.locals);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void addDeclaration(@NonNull Declaration declaration) {
        if (declaration instanceof VariableDeclaration) {
            this.addIfNotContains(this.locals, (VariableDeclaration)declaration);
        }
    }

    @Override
    @NotNull
    public List<Declaration> getDeclarations() {
        ArrayList<Declaration> list = new ArrayList<Declaration>(this.getLocals());
        return list;
    }
}

