/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TypedefDeclaration;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.ParameterizedType;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.ReferenceType;
import de.fraunhofer.aisec.cpg.graph.types.SecondOrderType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.graph.types.WrapState;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.scopes.RecordScope;
import de.fraunhofer.aisec.cpg.passes.scopes.Scope;
import de.fraunhofer.aisec.cpg.passes.scopes.TemplateScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function1;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeManager {
    private static final Logger log = LoggerFactory.getLogger(TypeManager.class);
    private static Class<?> llvmClass = null;
    private static Class<?> pythonClass = null;
    private static Class<?> goClass = null;
    private static final List<String> primitiveTypeNames;
    private static final Pattern funPointerPattern;
    private static @NonNull TypeManager INSTANCE;
    private static boolean typeSystemActive;
    private final @NonNull Map<HasType, Set<Type>> typeCache = Collections.synchronizedMap(new IdentityHashMap());
    private @NonNull Map<String, RecordDeclaration> typeToRecord = Collections.synchronizedMap(new HashMap());
    private final @NonNull Map<RecordDeclaration, List<ParameterizedType>> recordToTypeParameters = Collections.synchronizedMap(new HashMap());
    private final @NonNull Map<TemplateDeclaration, List<ParameterizedType>> templateToTypeParameters = Collections.synchronizedMap(new HashMap());
    private final @NonNull Map<Type, List<Type>> typeState = Collections.synchronizedMap(new HashMap());
    private final Set<Type> firstOrderTypes = Collections.synchronizedSet(new HashSet());
    private final Set<Type> secondOrderTypes = Collections.synchronizedSet(new HashSet());
    @org.jetbrains.annotations.Nullable
    private LanguageFrontend frontend;
    private boolean noFrontendWarningIssued = false;

    public static void reset() {
        INSTANCE = new TypeManager();
    }

    public @Nullable ParameterizedType getTypeParameter(RecordDeclaration recordDeclaration, String name) {
        if (this.recordToTypeParameters.containsKey(recordDeclaration)) {
            for (ParameterizedType parameterizedType : this.recordToTypeParameters.get(recordDeclaration)) {
                if (!parameterizedType.getName().equals(name)) continue;
                return parameterizedType;
            }
        }
        return null;
    }

    public void addTypeParameter(RecordDeclaration recordDeclaration, List<ParameterizedType> typeParameters) {
        this.recordToTypeParameters.put(recordDeclaration, typeParameters);
    }

    public @Nullable ParameterizedType getTypeParameter(TemplateDeclaration templateDeclaration, String name) {
        if (this.templateToTypeParameters.containsKey(templateDeclaration)) {
            for (ParameterizedType parameterizedType : this.templateToTypeParameters.get(templateDeclaration)) {
                if (!parameterizedType.getName().equals(name)) continue;
                return parameterizedType;
            }
        }
        return null;
    }

    public @NonNull List<ParameterizedType> getAllParameterizedType(TemplateDeclaration templateDeclaration) {
        if (this.templateToTypeParameters.containsKey(templateDeclaration)) {
            return this.templateToTypeParameters.get(templateDeclaration);
        }
        return new ArrayList<ParameterizedType>();
    }

    public ParameterizedType searchTemplateScopeForDefinedParameterizedTypes(Scope scope, String name) {
        TemplateDeclaration template;
        ParameterizedType parameterizedType;
        Node node;
        if (scope instanceof TemplateScope && (node = scope.getAstNode()) instanceof TemplateDeclaration && (parameterizedType = this.getTypeParameter(template = (TemplateDeclaration)node, name)) != null) {
            return parameterizedType;
        }
        return scope.getParent() != null ? this.searchTemplateScopeForDefinedParameterizedTypes(scope.getParent(), name) : null;
    }

    public void addTypeParameter(TemplateDeclaration templateDeclaration, ParameterizedType typeParameter) {
        if (this.templateToTypeParameters.containsKey(templateDeclaration)) {
            this.templateToTypeParameters.get(templateDeclaration).add(typeParameter);
        } else {
            ArrayList<ParameterizedType> typeParameters = new ArrayList<ParameterizedType>();
            typeParameters.add(typeParameter);
            this.templateToTypeParameters.put(templateDeclaration, typeParameters);
        }
    }

    public ParameterizedType createOrGetTypeParameter(TemplateDeclaration templateDeclaration, String typeName) {
        ParameterizedType parameterizedType = this.getTypeParameter(templateDeclaration, typeName);
        if (parameterizedType != null) {
            return parameterizedType;
        }
        parameterizedType = new ParameterizedType(typeName);
        this.addTypeParameter(templateDeclaration, parameterizedType);
        return parameterizedType;
    }

    public @NonNull Map<Type, List<Type>> getTypeState() {
        return this.typeState;
    }

    public <T extends Type> T registerType(T t) {
        if (t.isFirstOrderType()) {
            this.firstOrderTypes.add(t);
        } else {
            this.secondOrderTypes.add(t);
            this.registerType(((SecondOrderType)((Object)t)).getElementType());
        }
        return t;
    }

    public Set<Type> getFirstOrderTypes() {
        return this.firstOrderTypes;
    }

    public Set<Type> getSecondOrderTypes() {
        return this.secondOrderTypes;
    }

    public boolean typeExists(String name) {
        return this.firstOrderTypes.stream().anyMatch(type -> type.getRoot().getName().equals(name));
    }

    private TypeManager() {
    }

    public static TypeManager getInstance() {
        return INSTANCE;
    }

    public static boolean isTypeSystemActive() {
        return typeSystemActive;
    }

    public static void setTypeSystemActive(boolean active) {
        typeSystemActive = active;
    }

    @NotNull
    public Map<HasType, Set<Type>> getTypeCache() {
        return this.typeCache;
    }

    public synchronized void cacheType(HasType node, Type type) {
        if (!this.isUnknown(type)) {
            this.typeCache.computeIfAbsent(node, n -> new HashSet()).add(type);
        }
    }

    public void setLanguageFrontend(@NonNull LanguageFrontend frontend) {
        this.frontend = frontend;
    }

    public boolean isPrimitive(Type type) {
        return primitiveTypeNames.contains(type.getTypeName());
    }

    public boolean isUnknown(Type type) {
        return type instanceof UnknownType;
    }

    public boolean containsParameterizedType(List<Type> generics) {
        for (Type t : generics) {
            if (!(t instanceof ParameterizedType)) continue;
            return true;
        }
        return false;
    }

    public boolean stopPropagation(Type type, Type newType) {
        if (type instanceof ObjectType && newType instanceof ObjectType && ((ObjectType)type).getGenerics() != null && ((ObjectType)newType).getGenerics() != null && type.getName().equals(newType.getName())) {
            return this.containsParameterizedType(((ObjectType)newType).getGenerics()) && !this.containsParameterizedType(((ObjectType)type).getGenerics());
        }
        return false;
    }

    private Optional<Type> rewrapType(Type type, int depth, PointerType.PointerOrigin[] pointerOrigins, boolean reference, ReferenceType referenceType) {
        if (depth > 0) {
            for (int i = depth - 1; i >= 0; --i) {
                type = type.reference(pointerOrigins[i]);
            }
        }
        if (reference) {
            referenceType.setElementType(type);
            return Optional.of(referenceType);
        }
        return Optional.of(type);
    }

    private Set<Type> unwrapTypes(Collection<Type> types, WrapState wrapState) {
        Type t2;
        HashSet<Type> original = new HashSet<Type>(types);
        HashSet<Type> unwrappedTypes = new HashSet<Type>();
        PointerType.PointerOrigin[] pointerOrigins = new PointerType.PointerOrigin[]{};
        int depth = 0;
        int counter = 0;
        boolean reference = false;
        ReferenceType referenceType = null;
        Type t1 = types.stream().findAny().orElse(null);
        if (t1 instanceof ReferenceType) {
            for (Type t : types) {
                referenceType = (ReferenceType)t;
                if (!referenceType.isSimilar(t)) {
                    return Collections.emptySet();
                }
                unwrappedTypes.add(((ReferenceType)t).getElementType());
                reference = true;
            }
            types = unwrappedTypes;
        }
        if ((t2 = (Type)types.stream().findAny().orElse(null)) instanceof PointerType) {
            for (Type t : types) {
                if (counter == 0) {
                    depth = t.getReferenceDepth();
                    ++counter;
                }
                if (t.getReferenceDepth() != depth) {
                    return Collections.emptySet();
                }
                unwrappedTypes.add(t.getRoot());
                pointerOrigins = new PointerType.PointerOrigin[depth];
                Type containedType = t2;
                int i = 0;
                pointerOrigins[i] = ((PointerType)containedType).getPointerOrigin();
                while (containedType instanceof PointerType) {
                    if (!((containedType = ((PointerType)containedType).getElementType()) instanceof PointerType)) continue;
                    pointerOrigins[++i] = ((PointerType)containedType).getPointerOrigin();
                }
            }
        }
        wrapState.setDepth(depth);
        wrapState.setPointerOrigin(pointerOrigins);
        wrapState.setReference(reference);
        wrapState.setReferenceType(referenceType);
        if (unwrappedTypes.isEmpty() && !original.isEmpty()) {
            return original;
        }
        return unwrappedTypes;
    }

    public @NonNull Optional<Type> getCommonType(@NonNull Collection<Type> types) {
        boolean sameType;
        boolean bl = sameType = types.stream().map(t -> t.getClass().getCanonicalName()).collect(Collectors.toSet()).size() == 1;
        if (!sameType) {
            return Optional.empty();
        }
        WrapState wrapState = new WrapState();
        if ((types = this.unwrapTypes(types, wrapState)).isEmpty()) {
            return Optional.empty();
        }
        if (types.size() == 1) {
            return this.rewrapType(types.iterator().next(), wrapState.getDepth(), wrapState.getPointerOrigins(), wrapState.isReference(), wrapState.getReferenceType());
        }
        this.typeToRecord = this.frontend.getScopeManager().filterScopesDistinctBy((Function1<? super Scope, Boolean>)((Function1)scope -> scope instanceof RecordScope && scope.getAstNode() instanceof RecordDeclaration), s -> s.getAstNode().getName()).stream().map(s -> (RecordDeclaration)s.getAstNode()).collect(Collectors.toMap(Node::getName, Function.identity()));
        List allAncestors = types.stream().map(t -> this.typeToRecord.getOrDefault(t.getTypeName(), null)).filter(Objects::nonNull).map(r -> this.getAncestors((RecordDeclaration)r, 0)).collect(Collectors.toList());
        for (Set ancestors : allAncestors) {
            Optional<Ancestor> farthest = ancestors.stream().max(Comparator.comparingInt(Ancestor::getDepth));
            if (!farthest.isPresent()) continue;
            int maxDepth = farthest.get().getDepth();
            ancestors.forEach(a -> a.setDepth(maxDepth - a.getDepth()));
        }
        HashSet commonAncestors = new HashSet();
        for (int i = 0; i < allAncestors.size(); ++i) {
            if (i == 0) {
                commonAncestors.addAll((Collection)allAncestors.get(i));
                continue;
            }
            Set others = (Set)allAncestors.get(i);
            HashSet newCommonAncestors = new HashSet();
            for (Ancestor curr : commonAncestors) {
                Optional<Ancestor> toRetain = others.stream().filter(a -> a.equals(curr)).map(a -> curr.getDepth() >= a.getDepth() ? curr : a).findFirst();
                toRetain.ifPresent(newCommonAncestors::add);
            }
            commonAncestors = newCommonAncestors;
        }
        Optional<Ancestor> lca = commonAncestors.stream().max(Comparator.comparingInt(Ancestor::getDepth));
        Optional<Type> commonType = lca.map(a -> TypeParser.createFrom(a.getRecord().getName(), true));
        if (!commonType.isPresent()) {
            return commonType;
        }
        Type finalType = commonType.get();
        return this.rewrapType(finalType, wrapState.getDepth(), wrapState.getPointerOrigins(), wrapState.isReference(), wrapState.getReferenceType());
    }

    private Set<Ancestor> getAncestors(RecordDeclaration recordDeclaration, int depth) {
        if (recordDeclaration.getSuperTypes().isEmpty()) {
            HashSet<Ancestor> ret = new HashSet<Ancestor>();
            ret.add(new Ancestor(recordDeclaration, depth));
            return ret;
        }
        Set<Ancestor> ancestors = recordDeclaration.getSuperTypes().stream().map(s -> this.typeToRecord.getOrDefault(s.getTypeName(), null)).filter(Objects::nonNull).map(s -> this.getAncestors((RecordDeclaration)s, depth + 1)).flatMap(Collection::stream).collect(Collectors.toSet());
        ancestors.add(new Ancestor(recordDeclaration, depth));
        return ancestors;
    }

    public @NonNull Language getLanguage() {
        if (this.frontend instanceof JavaLanguageFrontend) {
            return Language.JAVA;
        }
        if (this.frontend instanceof CXXLanguageFrontend) {
            return Language.CXX;
        }
        if (this.frontend != null && goClass != null && goClass.isAssignableFrom(this.frontend.getClass())) {
            return Language.GO;
        }
        if (this.frontend != null && pythonClass != null && pythonClass.isAssignableFrom(this.frontend.getClass())) {
            return Language.PYTHON;
        }
        if (this.frontend instanceof TypeScriptLanguageFrontend) {
            return Language.TYPESCRIPT;
        }
        if (this.frontend != null && llvmClass != null && llvmClass.isAssignableFrom(this.frontend.getClass())) {
            return Language.LLVM_IR;
        }
        log.error("Unknown language (frontend: {})", this.frontend != null ? this.frontend.getClass().getSimpleName() : null);
        return Language.UNKNOWN;
    }

    public @Nullable LanguageFrontend getFrontend() {
        return this.frontend;
    }

    public boolean isSupertypeOf(Type superType, Type subType) {
        if (superType.getReferenceDepth() != subType.getReferenceDepth()) {
            return false;
        }
        if (this.checkArrayAndPointer(superType, subType)) {
            return true;
        }
        if (superType instanceof ReferenceType) {
            return this.isSupertypeOf(((ReferenceType)superType).getElementType(), subType);
        }
        Optional<Type> commonType = this.getCommonType(new HashSet<Type>(List.of(superType, subType)));
        if (commonType.isPresent()) {
            return commonType.get().equals(superType);
        }
        try {
            Class<?> superCls = Class.forName(superType.getTypeName());
            Class<?> subCls = Class.forName(subType.getTypeName());
            return superCls.isAssignableFrom(subCls);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    public boolean checkArrayAndPointer(Type first, Type second) {
        int secondDepth;
        int firstDepth = first.getReferenceDepth();
        if (firstDepth == (secondDepth = second.getReferenceDepth())) {
            return first.getTypeName().equals(second.getTypeName()) && first.isSimilar(second);
        }
        return false;
    }

    public void cleanup() {
        this.frontend = null;
        this.typeToRecord.clear();
    }

    private Type getTargetType(Type currTarget, String alias) {
        if (alias.contains("(") && alias.contains("*")) {
            return TypeParser.createFrom(currTarget.getName() + " " + alias, true);
        }
        if (alias.endsWith("]")) {
            return currTarget.reference(PointerType.PointerOrigin.ARRAY);
        }
        if (alias.contains("*")) {
            int depth = StringUtils.countMatches((CharSequence)alias, (char)'*');
            for (int i = 0; i < depth; ++i) {
                currTarget = currTarget.reference(PointerType.PointerOrigin.POINTER);
            }
            return currTarget;
        }
        return currTarget;
    }

    private Type getAlias(String alias) {
        if (alias.contains("(") && alias.contains("*")) {
            Matcher matcher = funPointerPattern.matcher(alias);
            if (matcher.find()) {
                return TypeParser.createIgnoringAlias(matcher.group("alias"));
            }
            log.error("Could not find alias name in function pointer typedef: {}", (Object)alias);
            return TypeParser.createIgnoringAlias(alias);
        }
        alias = alias.split("\\[")[0];
        alias = alias.replace("*", "");
        return TypeParser.createIgnoringAlias(alias);
    }

    public @NonNull Declaration handleSingleAlias(LanguageFrontend frontend, String rawCode, Type target, String aliasString) {
        String cleanedPart = Util.removeRedundantParentheses(aliasString);
        Type currTarget = this.getTargetType(target, cleanedPart);
        Type alias = this.getAlias(cleanedPart);
        if (alias instanceof SecondOrderType) {
            Type chain = alias.duplicate();
            chain.setRoot(currTarget);
            currTarget = chain;
            currTarget.refreshNames();
            alias = alias.getRoot();
        }
        TypedefDeclaration typedef = NodeBuilder.newTypedefDeclaration(currTarget, alias, rawCode);
        if (frontend == null) {
            if (!this.noFrontendWarningIssued) {
                log.warn("No frontend available. Be aware that typedef resolving cannot currently be done");
                this.noFrontendWarningIssued = true;
            }
            return typedef;
        }
        frontend.getScopeManager().addTypedef(typedef);
        return typedef;
    }

    public Type resolvePossibleTypedef(Type alias) {
        if (this.frontend == null) {
            if (!this.noFrontendWarningIssued) {
                log.warn("No frontend available. Be aware that typedef resolving cannot currently be done");
                this.noFrontendWarningIssued = true;
            }
            return alias;
        }
        Type finalToCheck = alias.getRoot();
        Optional<Type> applicable = this.frontend.getScopeManager().getCurrentTypedefs().stream().filter(t -> t.getAlias().getRoot().equals(finalToCheck)).findAny().map(TypedefDeclaration::getType);
        if (applicable.isEmpty()) {
            return alias;
        }
        return TypeParser.reWrapType(alias, applicable.get());
    }

    static {
        try {
            llvmClass = Class.forName("de.fraunhofer.aisec.cpg.frontends.llvm.LLVMIRLanguageFrontend");
        }
        catch (ClassNotFoundException | ExceptionInInitializerError ignored) {
            log.info("LLVM frontend not loaded.");
        }
        try {
            pythonClass = Class.forName("de.fraunhofer.aisec.cpg.frontends.python.PythonLanguageFrontend");
        }
        catch (ClassNotFoundException | ExceptionInInitializerError ignored) {
            log.info("Python frontend not loaded.");
        }
        try {
            goClass = Class.forName("de.fraunhofer.aisec.cpg.frontends.golang.GoLanguageFrontend");
        }
        catch (ClassNotFoundException | ExceptionInInitializerError ignored) {
            log.info("Go frontend not loaded.");
        }
        catch (LinkageError ex) {
            log.error("Go frontend was found, but could not be loaded", (Throwable)ex);
        }
        primitiveTypeNames = List.of("byte", "short", "int", "long", "float", "double", "boolean", "char", "i1", "i8", "i32", "i64", "i128", "half", "bfloat", "fp128", "x86_fp80", "ppc_fp128");
        funPointerPattern = Pattern.compile("\\(?\\*(?<alias>[^()]+)\\)?\\(.*\\)");
        INSTANCE = new TypeManager();
        typeSystemActive = true;
    }

    private static class Ancestor {
        private final RecordDeclaration recordDeclaration;
        private int depth;

        public Ancestor(RecordDeclaration recordDeclaration, int depth) {
            this.recordDeclaration = recordDeclaration;
            this.depth = depth;
        }

        public RecordDeclaration getRecord() {
            return this.recordDeclaration;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public int hashCode() {
            return Objects.hash(this.recordDeclaration);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Ancestor)) {
                return false;
            }
            Ancestor ancestor = (Ancestor)o;
            return Objects.equals(this.recordDeclaration, ancestor.recordDeclaration);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).append("record", (Object)this.recordDeclaration.getName()).append("depth", this.depth).toString();
        }
    }

    public static enum Language {
        JAVA,
        CXX,
        GO,
        PYTHON,
        TYPESCRIPT,
        LLVM_IR,
        UNKNOWN;

    }
}

