/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends;

import de.fraunhofer.aisec.cpg.frontends.FrontendUtils;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/FrontendUtils;", "", "()V", "Companion", "cpg-core"})
public final class FrontendUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOGGER = LoggerFactory.getLogger(FrontendUtils.class);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J0\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/FrontendUtils$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getEndColumnIndex", "", "posPrefix", "", "end", "matchCommentToNode", "", "comment", "location", "Lde/fraunhofer/aisec/cpg/sarif/Region;", "tu", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "parseColumnPositionsFromFile", "fileContent", "nodeLength", "nodeOffset", "startingLineNumber", "endingLineNumber", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Region parseColumnPositionsFromFile(@NotNull String fileContent, int nodeLength, int nodeOffset, int startingLineNumber, int endingLineNumber) {
            Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
            int startColumn = 1;
            for (int i = nodeOffset - 1; 1 < i; --i) {
                if (i >= fileContent.length()) {
                    LOGGER.warn("Requested index {} exceeds length of translation unit code ({})", (Object)i, (Object)fileContent.length());
                    return null;
                }
                if (fileContent.charAt(i) == '\n') break;
                ++startColumn;
            }
            int endColumn = this.getEndColumnIndex(fileContent, nodeOffset + nodeLength);
            Region region = new Region(startingLineNumber, startColumn, endingLineNumber, endColumn);
            return region;
        }

        private final int getEndColumnIndex(String posPrefix, int end) {
            int mutableEnd = end;
            int column = 1;
            try {
                if (mutableEnd - 1 >= posPrefix.length() || posPrefix.charAt(mutableEnd - 1) == '\n') {
                    mutableEnd = Math.min(mutableEnd - 1, posPrefix.length() - 1);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LanguageFrontend.log.error("could not update end ", (Throwable)e);
            }
            for (int i = mutableEnd - 1; 1 < i && posPrefix.charAt(i) != '\n'; --i) {
                ++column;
            }
            return column;
        }

        /*
         * WARNING - void declaration
         */
        public final void matchCommentToNode(@NotNull String comment, @NotNull Region location, @NotNull TranslationUnitDeclaration tu) {
            int closestLine;
            void $this$filterTo$iv$iv;
            Collection destination$iv$iv;
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            NamespaceDeclaration it;
            Iterable $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)tu, (String)"tu");
            List<Node> list = SubgraphWalker.flattenAST(tu);
            Intrinsics.checkNotNullExpressionValue(list, (String)"flattenAST(tu)");
            List<Node> nodes = list;
            Iterable $this$filter$iv = nodes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Region nodeRegion;
                Region region;
                Region region2;
                Region region3;
                Iterator it2 = (Node)element$iv$iv;
                boolean bl = false;
                if (((Node)((Object)it2)).getLocation() != null) {
                    boolean bl2 = false;
                    region3 = ((PhysicalLocation)((Object)it)).getRegion();
                } else {
                    region3 = null;
                }
                Region region4 = region2 = region3;
                if (region4 == null) {
                    region = new Region();
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)region4, (String)"it.location?.let { it.region } ?: Region()");
                    region = nodeRegion = region2;
                }
                boolean bl3 = !(nodeRegion.getStartLine() > location.getStartLine() || nodeRegion.getEndLine() < location.getEndLine() || nodeRegion.getStartLine() == location.getStartLine() && nodeRegion.getStartColumn() > location.getStartColumn() || nodeRegion.getEndLine() == location.getEndLine() && nodeRegion.getEndColumn() < location.getEndColumn());
                if (!bl3) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List enclosingNodes = (List)destination$iv$iv2;
            if (!enclosingNodes.contains(tu)) {
                enclosingNodes = CollectionsKt.plus((Collection)enclosingNodes, (Object)tu);
            }
            Node smallestEnclosingNode = (Node)CollectionsKt.first((List)CollectionsKt.sortedWith((Iterable)enclosingNodes, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Node it = (Node)a;
                    boolean bl = false;
                    String string = it.getCode();
                    it = (Node)b;
                    Comparable comparable = string != null ? (Comparable)Integer.valueOf(string.length()) : (Comparable)Integer.valueOf(10000);
                    bl = false;
                    String string2 = it.getCode();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(string2 != null ? (Comparable)Integer.valueOf(string2.length()) : (Comparable)Integer.valueOf(10000)));
                }
            }));
            List<Node> children = null;
            List<Node> list2 = children = SubgraphWalker.getAstChildren(smallestEnclosingNode);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"children");
            $this$filterTo$iv$iv2 = list2;
            List<Node> list3 = children;
            boolean $i$f$filterIsInstance = false;
            void $i$f$filterTo22 = $this$filterIsInstance$iv;
            Iterable destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof NamespaceDeclaration)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv3;
            boolean $i$f$flatMap = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$filterTo$iv$iv3;
                it = (NamespaceDeclaration)element$iv$iv;
                boolean bl = false;
                List<Node> list4 = SubgraphWalker.getAstChildren(it);
                Intrinsics.checkNotNullExpressionValue(list4, (String)"getAstChildren(it)");
                Iterable $this$filter$iv2 = list4;
                boolean $i$f$filter2 = false;
                Iterable iterable2 = $this$filter$iv2;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv3) {
                    Node it3 = (Node)element$iv$iv2;
                    boolean bl4 = false;
                    if (!(!children.contains(it3))) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                Iterable list$iv$iv = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            list3.addAll((List)destination$iv$iv3);
            List<Node> list5 = children;
            Intrinsics.checkNotNullExpressionValue(list5, (String)"children");
            Iterable $this$filter$iv3 = list5;
            boolean $i$f$filter22 = false;
            destination$iv$iv3 = $this$filter$iv3;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Object nodeRegion;
                Object object;
                Object object2;
                Node it4 = (Node)element$iv$iv;
                boolean bl = false;
                Object object3 = it4.getLocation();
                if (object3 != null && (object3 = ((PhysicalLocation)object3).getRegion()) != null) {
                    Object it5 = object3;
                    boolean bl5 = false;
                    object2 = it5;
                } else {
                    object2 = null;
                }
                Collection collection = destination$iv$iv = object2;
                if (collection == null) {
                    object = new Region();
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"it.location?.region?.let { it } ?: Region()");
                    object = nodeRegion = destination$iv$iv;
                }
                boolean bl6 = ((Region)nodeRegion).getStartLine() >= location.getEndLine() && (((Region)nodeRegion).getStartLine() > location.getEndLine() || ((Region)nodeRegion).getStartColumn() >= location.getEndColumn());
                if (!bl6) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List successors = (List)destination$iv$iv4;
            Function1[] $i$f$filter22 = new Function1[]{matchCommentToNode.closest.1.INSTANCE, matchCommentToNode.closest.2.INSTANCE};
            Node closest2 = (Node)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)successors, (Comparator)ComparisonsKt.compareBy((Function1[])$i$f$filter22)));
            Object object = closest2;
            int n = object != null && (object = ((Node)object).getLocation()) != null && (object = ((PhysicalLocation)object).getRegion()) != null ? ((Region)object).getStartLine() : (closestLine = location.getEndLine() + 1);
            if (closest2 == null || closestLine > location.getEndLine()) {
                void $this$filterTo$iv$iv4;
                List<Node> list6 = children;
                Intrinsics.checkNotNullExpressionValue(list6, (String)"children");
                Iterable $this$filter$iv4 = list6;
                boolean $i$f$filter3 = false;
                Iterable element$iv$iv = $this$filter$iv4;
                Collection destination$iv$iv5 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv3 : $this$filterTo$iv$iv4) {
                    Region nodeRegion;
                    Region region;
                    Region region5;
                    Node it6 = (Node)element$iv$iv3;
                    boolean bl = false;
                    PhysicalLocation physicalLocation = it6.getLocation();
                    Region region6 = region5 = physicalLocation != null ? physicalLocation.getRegion() : null;
                    if (region6 == null) {
                        region = new Region();
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)region6, (String)"it.location?.region ?: Region()");
                        region = nodeRegion = region5;
                    }
                    boolean bl7 = nodeRegion.getEndLine() <= location.getStartLine() && (nodeRegion.getEndLine() < location.getStartLine() || nodeRegion.getEndColumn() <= location.getStartColumn());
                    if (!bl7) continue;
                    destination$iv$iv5.add(element$iv$iv3);
                }
                List predecessor = (List)destination$iv$iv5;
                Function1[] function1Array = new Function1[]{matchCommentToNode.closestPredecessor.1.INSTANCE, matchCommentToNode.closestPredecessor.2.INSTANCE};
                Node closestPredecessor2 = (Node)CollectionsKt.lastOrNull((List)CollectionsKt.sortedWith((Iterable)predecessor, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)));
                Object object4 = closestPredecessor2;
                int n2 = object4 != null && (object4 = ((Node)object4).getLocation()) != null && (object4 = ((PhysicalLocation)object4).getRegion()) != null ? ((Region)object4).getEndLine() : (closestLine = location.getStartLine() - 1);
                if (closestPredecessor2 != null && closestLine == location.getStartLine()) {
                    closest2 = closestPredecessor2;
                }
            }
            if (closest2 == null) {
                closest2 = smallestEnclosingNode;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = closest2.getComment();
            if (string == null) {
                string = "";
            }
            closest2.setComment(stringBuilder.append(string).append(comment).toString());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

