/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0006\u0018\u0000 \u00162\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\tJ\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\tR#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R&\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00120\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase;", "Ljava/util/ArrayList;", "Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase$CompilationDatabaseEntry;", "Lkotlin/collections/ArrayList;", "()V", "components", "", "", "", "Ljava/io/File;", "getComponents", "()Ljava/util/Map;", "includePaths", "", "sourceFiles", "getSourceFiles", "()Ljava/util/List;", "symbols", "", "getIncludePaths", "file", "getSymbols", "Companion", "CompilationDatabaseEntry", "cpg-core"})
public final class CompilationDatabase
extends ArrayList<CompilationDatabaseEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<File, List<String>> includePaths = new LinkedHashMap();
    @NotNull
    private final Map<File, Map<String, String>> symbols = new LinkedHashMap();
    @NotNull
    private final Map<String, List<File>> components = new LinkedHashMap();

    @NotNull
    public final Map<String, List<File>> getComponents() {
        return this.components;
    }

    @NotNull
    public final List<File> getSourceFiles() {
        return CollectionsKt.toList((Iterable)this.includePaths.keySet());
    }

    @Nullable
    public final List<String> getIncludePaths(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.includePaths.get(file);
    }

    @Nullable
    public final Map<String, String> getSymbols(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.symbols.get(file);
    }

    @JvmStatic
    @NotNull
    public static final CompilationDatabase fromFile(@NotNull File file) {
        return Companion.fromFile(file);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JI\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001d"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase$CompilationDatabaseEntry;", "", "directory", "", "command", "arguments", "", "file", "output", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getArguments", "()Ljava/util/List;", "getCommand", "()Ljava/lang/String;", "getDirectory", "getFile", "getOutput", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "cpg-core"})
    public static final class CompilationDatabaseEntry {
        @Nullable
        private final String directory;
        @Nullable
        private final String command;
        @Nullable
        private final List<String> arguments;
        @NotNull
        private final String file;
        @Nullable
        private final String output;

        public CompilationDatabaseEntry(@Nullable String directory, @Nullable String command, @Nullable List<String> arguments, @NotNull String file, @Nullable String output) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.directory = directory;
            this.command = command;
            this.arguments = arguments;
            this.file = file;
            this.output = output;
        }

        public /* synthetic */ CompilationDatabaseEntry(String string, String string2, List list, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                list = null;
            }
            this(string, string2, list, string3, string4);
        }

        @Nullable
        public final String getDirectory() {
            return this.directory;
        }

        @Nullable
        public final String getCommand() {
            return this.command;
        }

        @Nullable
        public final List<String> getArguments() {
            return this.arguments;
        }

        @NotNull
        public final String getFile() {
            return this.file;
        }

        @Nullable
        public final String getOutput() {
            return this.output;
        }

        @Nullable
        public final String component1() {
            return this.directory;
        }

        @Nullable
        public final String component2() {
            return this.command;
        }

        @Nullable
        public final List<String> component3() {
            return this.arguments;
        }

        @NotNull
        public final String component4() {
            return this.file;
        }

        @Nullable
        public final String component5() {
            return this.output;
        }

        @NotNull
        public final CompilationDatabaseEntry copy(@Nullable String directory, @Nullable String command, @Nullable List<String> arguments, @NotNull String file, @Nullable String output) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new CompilationDatabaseEntry(directory, command, arguments, file, output);
        }

        public static /* synthetic */ CompilationDatabaseEntry copy$default(CompilationDatabaseEntry compilationDatabaseEntry, String string, String string2, List list, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = compilationDatabaseEntry.directory;
            }
            if ((n & 2) != 0) {
                string2 = compilationDatabaseEntry.command;
            }
            if ((n & 4) != 0) {
                list = compilationDatabaseEntry.arguments;
            }
            if ((n & 8) != 0) {
                string3 = compilationDatabaseEntry.file;
            }
            if ((n & 0x10) != 0) {
                string4 = compilationDatabaseEntry.output;
            }
            return compilationDatabaseEntry.copy(string, string2, list, string3, string4);
        }

        @NotNull
        public String toString() {
            return "CompilationDatabaseEntry(directory=" + this.directory + ", command=" + this.command + ", arguments=" + this.arguments + ", file=" + this.file + ", output=" + this.output + ')';
        }

        public int hashCode() {
            int result = this.directory == null ? 0 : this.directory.hashCode();
            result = result * 31 + (this.command == null ? 0 : this.command.hashCode());
            result = result * 31 + (this.arguments == null ? 0 : ((Object)this.arguments).hashCode());
            result = result * 31 + this.file.hashCode();
            result = result * 31 + (this.output == null ? 0 : this.output.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompilationDatabaseEntry)) {
                return false;
            }
            CompilationDatabaseEntry compilationDatabaseEntry = (CompilationDatabaseEntry)other;
            if (!Intrinsics.areEqual((Object)this.directory, (Object)compilationDatabaseEntry.directory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.command, (Object)compilationDatabaseEntry.command)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.arguments, compilationDatabaseEntry.arguments)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.file, (Object)compilationDatabaseEntry.file)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.output, (Object)compilationDatabaseEntry.output);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J*\u0010\u0007\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\"\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u0012\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase$Companion;", "", "()V", "fromFile", "Lde/fraunhofer/aisec/cpg/frontends/CompilationDatabase;", "file", "Ljava/io/File;", "parseIncludeDirectories", "Lkotlin/Pair;", "", "", "command", "parseOutput", "output", "parseSymbols", "", "splitCommand", "splitSymbol", "sym", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CompilationDatabase fromFile(@NotNull File file) {
            ObjectMapper mapper;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String jsonStringFile = FilesKt.readText$default((File)file, null, (int)1, null);
            ObjectMapper $this$readValue$iv = mapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            CompilationDatabase db = (CompilationDatabase)$this$readValue$iv.readValue(jsonStringFile, (TypeReference)new TypeReference<CompilationDatabase>(){});
            for (CompilationDatabaseEntry entry : db) {
                List list;
                String[] stringArray;
                String fileNameInTheObject = entry.getFile();
                File srcFile = new File(fileNameInTheObject);
                Pair<List<String>, String> pair = entry.getArguments() != null ? this.parseIncludeDirectories(entry.getArguments()) : (entry.getCommand() != null ? this.parseIncludeDirectories(this.splitCommand(entry.getCommand())) : new Pair<List<String>, String>(null, (Object)"application"));
                List includes = (List)pair.component1();
                String component = (String)pair.component2();
                String basedir = entry.getDirectory();
                if (!srcFile.isAbsolute() && basedir != null && Paths.get(basedir, stringArray = new String[]{fileNameInTheObject}).toFile().exists()) {
                    String[] stringArray2 = new String[]{fileNameInTheObject};
                    File file2 = Paths.get(basedir, stringArray2).toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"get(basedir, fileNameInTheObject).toFile()");
                    srcFile = file2;
                }
                if (includes != null && srcFile.exists()) {
                    db.includePaths.put(srcFile, includes);
                }
                db.symbols.put(srcFile, entry.getArguments() != null ? this.parseSymbols(entry.getArguments()) : (entry.getCommand() != null ? this.parseSymbols(this.splitCommand(entry.getCommand())) : MapsKt.emptyMap()));
                Map<String, List<File>> $this$getOrPut$iv = db.getComponents();
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(component);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(component, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                ((Collection)list).add(srcFile);
            }
            return db;
        }

        private final List<String> splitCommand(String command) {
            if (((CharSequence)command).length() == 0) {
                return CollectionsKt.emptyList();
            }
            String[] stringArray = new String[]{" "};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)command, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            String[] stringArray3 = stringArray2;
            return CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray3, stringArray3.length));
        }

        private final Pair<List<String>, String> parseIncludeDirectories(List<String> command) {
            String component = null;
            component = "application";
            if (command.isEmpty()) {
                return new Pair(null, (Object)component);
            }
            List includeFilesDirectories = new LinkedList();
            for (int i = 0; i < command.size(); ++i) {
                String it;
                String word = command.get(i);
                if (StringsKt.startsWith$default((String)word, (String)"-I", (boolean)false, (int)2, null)) {
                    if (word.length() == 2) {
                        if (i + 1 == command.size()) continue;
                        includeFilesDirectories.add(command.get(++i));
                        continue;
                    }
                    String string = word.substring(2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    includeFilesDirectories.add(string);
                    continue;
                }
                if (Intrinsics.areEqual((Object)word, (Object)"-isystem")) {
                    if (i + 1 == command.size()) continue;
                    includeFilesDirectories.add(command.get(++i));
                    continue;
                }
                if (Intrinsics.areEqual((Object)word, (Object)"-isysroot")) {
                    if (i + 1 == command.size()) continue;
                    includeFilesDirectories.add(command.get(++i) + "/usr/include");
                    continue;
                }
                if (!Intrinsics.areEqual((Object)word, (Object)"-o") || i + 1 == command.size()) continue;
                if (this.parseOutput(command.get(++i)) == null) continue;
                boolean bl = false;
                component = it;
            }
            return new Pair((Object)includeFilesDirectories, (Object)component);
        }

        private final Pair<String, String> splitSymbol(String sym) {
            if (StringsKt.contains$default((CharSequence)sym, (CharSequence)"=", (boolean)false, (int)2, null)) {
                String[] stringArray = new String[]{"="};
                List pair = StringsKt.split$default((CharSequence)sym, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                return new Pair(pair.get(0), pair.get(1));
            }
            return new Pair((Object)sym, (Object)"");
        }

        private final Map<String, String> parseSymbols(List<String> command) {
            if (command.isEmpty()) {
                return MapsKt.emptyMap();
            }
            LinkedHashMap symbols = new LinkedHashMap();
            for (int i = 0; i < command.size(); ++i) {
                Pair<String, String> sym;
                String word = command.get(i);
                if (!StringsKt.startsWith$default((String)word, (String)"-D", (boolean)false, (int)2, null)) continue;
                if (word.length() == 2) {
                    if (i + 1 == command.size()) continue;
                    sym = this.splitSymbol(command.get(++i));
                    ((Map)symbols).put(sym.getFirst(), sym.getSecond());
                    continue;
                }
                String string = word.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                sym = this.splitSymbol(string);
                ((Map)symbols).put(sym.getFirst(), sym.getSecond());
            }
            return symbols;
        }

        private final String parseOutput(String output) {
            int dirIdx;
            boolean isLibrary = false;
            int cmakeIdx = StringsKt.indexOf$default((CharSequence)output, (String)"CMakeFiles/", (int)0, (boolean)false, (int)6, null);
            if (cmakeIdx < 0) {
                return null;
            }
            String string = output.substring(0, cmakeIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String prefix = string;
            if (Intrinsics.areEqual((Object)prefix, (Object)"lib/")) {
                isLibrary = true;
            }
            if ((dirIdx = StringsKt.indexOf$default((CharSequence)output, (String)".dir/", (int)0, (boolean)false, (int)6, null)) < 0) {
                return null;
            }
            String string2 = output.substring(cmakeIdx + "CMakeFiles/".length(), dirIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String name = string2;
            if (isLibrary) {
                name = "lib" + name;
            }
            return name;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

