/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ImportResolver
extends Pass {
    protected final List<RecordDeclaration> records = new ArrayList<RecordDeclaration>();
    protected final Map<String, Declaration> importables = new HashMap<String, Declaration>();

    @Override
    public @Nullable LanguageFrontend getLang() {
        return null;
    }

    @Override
    public void setLang(LanguageFrontend lang) {
    }

    @Override
    public void cleanup() {
        this.records.clear();
        this.importables.clear();
    }

    @Override
    public void accept(TranslationResult result) {
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            this.findImportables(tu);
        }
        for (RecordDeclaration record : this.records) {
            Set<Declaration> imports = this.getDeclarationsForTypeNames(record.getImportStatements());
            record.setImports(imports);
            Set<ValueDeclaration> staticImports = this.getStaticImports(record);
            record.setStaticImports(staticImports);
        }
    }

    protected Set<ValueDeclaration> getStaticImports(RecordDeclaration record) {
        Map<Boolean, List<String>> partitioned = record.getStaticImportStatements().stream().collect(Collectors.partitioningBy(i -> i.endsWith("*")));
        HashSet<ValueDeclaration> staticImports = new HashSet<ValueDeclaration>();
        Pattern importPattern = Pattern.compile("(?<base>.*)\\.(?<member>.*)");
        for (String specificStaticImport : partitioned.get(false)) {
            Matcher matcher = importPattern.matcher(specificStaticImport);
            if (!matcher.matches()) continue;
            Declaration base = this.importables.get(matcher.group("base"));
            Set<Object> members = new HashSet();
            if (base instanceof RecordDeclaration) {
                members = this.getOrCreateMembers((RecordDeclaration)base, matcher.group("member"));
            } else if (base instanceof EnumDeclaration) {
                members = this.getOrCreateMembers((EnumDeclaration)base, matcher.group("member"));
            }
            staticImports.addAll(members);
        }
        for (String asteriskImport : partitioned.get(true)) {
            Declaration base = this.importables.get(asteriskImport.replace(".*", ""));
            if (base instanceof RecordDeclaration) {
                RecordDeclaration baseRecord = (RecordDeclaration)base;
                staticImports.addAll(Stream.concat(Stream.of(baseRecord), baseRecord.getSuperTypeDeclarations().stream()).map(RecordDeclaration::getMethods).flatMap(Collection::stream).filter(MethodDeclaration::isStatic).collect(Collectors.toList()));
                staticImports.addAll(Stream.concat(Stream.of(baseRecord), baseRecord.getSuperTypeDeclarations().stream()).map(RecordDeclaration::getFields).flatMap(Collection::stream).filter(f -> f.getModifiers().contains("static")).collect(Collectors.toList()));
                continue;
            }
            if (!(base instanceof EnumDeclaration)) continue;
            EnumDeclaration baseEnum = (EnumDeclaration)base;
            staticImports.addAll(baseEnum.getEntries());
        }
        return staticImports;
    }

    protected Set<Declaration> getDeclarationsForTypeNames(List<String> targetTypes) {
        return targetTypes.stream().map(this.importables::get).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected Set<ValueDeclaration> getOrCreateMembers(EnumDeclaration base, String name) {
        Set<ValueDeclaration> entries = base.getEntries().stream().filter(e -> e.getName().equals(name)).collect(Collectors.toSet());
        return entries;
    }

    protected Set<ValueDeclaration> getOrCreateMembers(RecordDeclaration base, String name) {
        Set memberMethods = base.getMethods().stream().filter(m -> m.getName().endsWith(name)).collect(Collectors.toSet());
        memberMethods.addAll(base.getSuperTypeDeclarations().stream().map(RecordDeclaration::getMethods).flatMap(Collection::stream).filter(m -> m.getName().endsWith(name)).collect(Collectors.toSet()));
        Set memberFields = base.getFields().stream().filter(f -> f.getName().equals(name)).collect(Collectors.toSet());
        memberFields.addAll(base.getSuperTypeDeclarations().stream().map(RecordDeclaration::getFields).flatMap(Collection::stream).filter(f -> f.getName().equals(name)).collect(Collectors.toSet()));
        Set<ValueDeclaration> result = Stream.concat(memberMethods.stream(), memberFields.stream()).map(ValueDeclaration.class::cast).collect(Collectors.toSet());
        if (result.isEmpty()) {
            FieldDeclaration targetField = NodeBuilder.newFieldDeclaration(name, UnknownType.getUnknownType(), new ArrayList<String>(), "", null, null, false);
            targetField.setInferred(true);
            MethodDeclaration targetMethod = NodeBuilder.newMethodDeclaration(name, "", true, base);
            targetMethod.setInferred(true);
            base.addField(targetField);
            base.addMethod(targetMethod);
            result.add(targetField);
            result.add(targetMethod);
        }
        return result;
    }

    protected void findImportables(Node node) {
        if (node instanceof RecordDeclaration) {
            this.records.add((RecordDeclaration)node);
            this.importables.putIfAbsent(node.getName(), (RecordDeclaration)node);
        } else if (node instanceof EnumDeclaration) {
            this.importables.putIfAbsent(node.getName(), (EnumDeclaration)node);
        }
        for (Node child : SubgraphWalker.getAstChildren(node)) {
            this.findImportables(child);
        }
    }
}

