/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.Pass;

public class FilenameMapper
extends Pass {
    @Override
    public void accept(TranslationResult translationResult) {
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            String name = tu.getName();
            tu.setFile(name);
            tu.getDeclarations().forEach(d -> this.handle((Node)d, name));
            tu.getIncludes().forEach(d -> this.handle((Node)d, name));
            tu.getNamespaces().forEach(d -> this.handle((Node)d, name));
        }
    }

    private void handle(Node node, String file) {
        if (node != null) {
            node.setFile(file);
            for (Node child : SubgraphWalker.getAstChildren(node)) {
                this.handle(child, file);
            }
        }
    }

    @Override
    public void cleanup() {
    }
}

