/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.HasTemplates;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.HasDefault;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.ClassTemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionTemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TemplateDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TypeParamDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ExplicitConstructorInvocation;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.StaticCallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.TypeExpression;
import de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.types.ObjectType;
import de.fraunhofer.aisec.cpg.graph.types.ParameterizedType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.processing.strategy.Strategy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallResolver
extends Pass {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallResolver.class);
    protected final Map<String, RecordDeclaration> recordMap = new HashMap<String, RecordDeclaration>();
    protected final List<TemplateDeclaration> templateList = new ArrayList<TemplateDeclaration>();
    protected final Map<FunctionDeclaration, Type> containingType = new HashMap<FunctionDeclaration, Type>();
    protected @Nullable TranslationUnitDeclaration currentTU;
    protected SubgraphWalker.ScopedWalker walker;

    @Override
    public void cleanup() {
        this.containingType.clear();
        this.currentTU = null;
    }

    @Override
    public void accept(@NonNull TranslationResult translationResult) {
        this.walker = new SubgraphWalker.ScopedWalker(this.lang);
        this.walker.registerHandler((currClass, parent, currNode) -> this.walker.collectDeclarations((Node)currNode));
        this.walker.registerHandler(this::findRecords);
        this.walker.registerHandler(this::findTemplates);
        this.walker.registerHandler(this::registerMethods);
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            this.walker.iterate(tu);
        }
        this.walker.clearCallbacks();
        this.walker.registerHandler(this::fixInitializers);
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            this.walker.iterate(tu);
        }
        this.walker.clearCallbacks();
        this.walker.registerHandler(this::resolve);
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            this.walker.iterate(tu);
        }
    }

    protected void findRecords(@NonNull Node node, RecordDeclaration curClass) {
        if (node instanceof RecordDeclaration) {
            this.recordMap.putIfAbsent(node.getName(), (RecordDeclaration)node);
        }
    }

    protected void findTemplates(@NonNull Node node, RecordDeclaration curClass) {
        if (node instanceof TemplateDeclaration) {
            this.templateList.add((TemplateDeclaration)node);
        }
    }

    protected void registerMethods(RecordDeclaration currentClass, Node parent, @NonNull Node currentNode) {
        if (currentNode instanceof MethodDeclaration && currentClass != null) {
            this.containingType.put((FunctionDeclaration)currentNode, TypeParser.createFrom(currentClass.getName(), true));
        }
    }

    protected void fixInitializers(@NonNull Node node, RecordDeclaration curClass) {
        VariableDeclaration declaration;
        String typeString;
        boolean isRecord;
        if (node instanceof VariableDeclaration && (isRecord = this.recordMap.containsKey(typeString = (declaration = (VariableDeclaration)node).getType().getRoot().getName()))) {
            Expression currInitializer = declaration.getInitializer();
            if (currInitializer == null && declaration.isImplicitInitializerAllowed()) {
                ConstructExpression initializer = NodeBuilder.newConstructExpression("()");
                initializer.setImplicit(true);
                declaration.setInitializer(initializer);
                CallResolver.addImplicitTemplateParametersToCall(declaration.getTemplateParameters(), initializer);
            } else if (currInitializer instanceof CallExpression && currInitializer.getName().equals(typeString)) {
                CallExpression call = (CallExpression)currInitializer;
                List<Expression> arguments = call.getArguments();
                String signature = arguments.stream().map(Node::getCode).collect(Collectors.joining(", "));
                ConstructExpression initializer = NodeBuilder.newConstructExpression("(" + signature + ")");
                initializer.setArguments(new ArrayList<Expression>(arguments));
                initializer.setImplicit(true);
                declaration.setInitializer(initializer);
                currInitializer.disconnectFromGraph();
            }
        }
    }

    public static void addImplicitTemplateParametersToCall(List<Node> templateParams, ConstructExpression constructExpression) {
        if (templateParams != null) {
            for (Node node : templateParams) {
                if (node instanceof TypeExpression) {
                    constructExpression.addExplicitTemplateParameter(NodeBuilder.duplicateTypeExpression((TypeExpression)node, true));
                    continue;
                }
                if (!(node instanceof Literal)) continue;
                constructExpression.addExplicitTemplateParameter(NodeBuilder.duplicateLiteral((Literal)node, true));
            }
        }
    }

    protected void handleSuperCall(RecordDeclaration curClass, CallExpression call) {
        RecordDeclaration target = null;
        if (call.getBase().getName().equals("super")) {
            if (!curClass.getSuperClasses().isEmpty()) {
                target = this.recordMap.get(curClass.getSuperClasses().get(0).getRoot().getTypeName());
            } else {
                Util.warnWithFileLocation(call, LOGGER, "super call without direct superclass! Expected java.lang.Object to be present at least!", new Object[0]);
            }
        } else {
            target = this.handleSpecificSupertype(curClass, call);
        }
        if (target != null) {
            ((DeclaredReferenceExpression)call.getBase()).setRefersTo(target.getThis());
            this.handleMethodCall(target, call);
        }
    }

    protected RecordDeclaration handleSpecificSupertype(RecordDeclaration curClass, CallExpression call) {
        String baseName = call.getBase().getName().substring(0, call.getBase().getName().lastIndexOf(".super"));
        if (curClass.getImplementedInterfaces().contains(TypeParser.createFrom(baseName, true))) {
            return this.recordMap.get(baseName);
        }
        RecordDeclaration base = this.recordMap.get(baseName);
        if (base != null) {
            if (!base.getSuperClasses().isEmpty()) {
                return this.recordMap.get(base.getSuperClasses().get(0).getRoot().getTypeName());
            }
            Util.warnWithFileLocation(call, LOGGER, "super call without direct superclass! Expected java.lang.Object to be present at least!", new Object[0]);
        }
        return null;
    }

    protected void resolve(@NonNull Node node, RecordDeclaration curClass) {
        RecordDeclaration record = this.lang.getScopeManager().getCurrentRecord();
        if (node instanceof TranslationUnitDeclaration) {
            this.currentTU = (TranslationUnitDeclaration)node;
        } else if (node instanceof ExplicitConstructorInvocation) {
            this.resolveExplicitConstructorInvocation((ExplicitConstructorInvocation)node);
        } else if (node instanceof ConstructExpression) {
            ConstructExpression constructExpression = (ConstructExpression)node;
            this.resolveArguments(constructExpression, record);
            this.resolveConstructExpression((ConstructExpression)node);
        } else if (node instanceof CallExpression) {
            CallExpression call = (CallExpression)node;
            this.resolveArguments(call, record);
            this.handleCallExpression(record, call);
        }
    }

    protected void handleCallExpression(RecordDeclaration curClass, CallExpression call) {
        if (this.lang instanceof JavaLanguageFrontend && call.getBase() instanceof DeclaredReferenceExpression && call.getBase().getName().matches("(?<class>.+\\.)?super")) {
            this.handleSuperCall(curClass, call);
            return;
        }
        if (call instanceof MemberCallExpression) {
            Node member = ((MemberCallExpression)call).getMember();
            if (member instanceof HasType && ((HasType)((Object)member)).getType() instanceof FunctionPointerType) {
                this.handleFunctionPointerCall(call, member);
            } else {
                this.handleMethodCall(curClass, call);
            }
            return;
        }
        if (call.instantiatesTemplate() && this.lang instanceof HasTemplates) {
            this.handleTemplateFunctionCalls(curClass, call, true);
            return;
        }
        Optional<? extends ValueDeclaration> funcPointer = this.walker.getDeclarationForScope(call, v -> v.getType() instanceof FunctionPointerType && v.getName().equals(call.getName()));
        if (funcPointer.isPresent()) {
            this.handleFunctionPointerCall(call, funcPointer.get());
        } else {
            this.handleNormalCalls(curClass, call);
        }
    }

    protected boolean isInstantiated(Node callParameter, Declaration templateParameter) {
        if (callParameter instanceof TypeExpression) {
            callParameter = ((TypeExpression)callParameter).getType();
        }
        if (callParameter instanceof Type && templateParameter instanceof TypeParamDeclaration) {
            Type type = (Type)callParameter;
            return type instanceof ObjectType;
        }
        if (callParameter instanceof Expression && templateParameter instanceof ParamVariableDeclaration) {
            Expression expression = (Expression)callParameter;
            ParamVariableDeclaration paramVariableDeclaration = (ParamVariableDeclaration)templateParameter;
            return expression.getType().equals(paramVariableDeclaration.getType()) || TypeManager.getInstance().isSupertypeOf(paramVariableDeclaration.getType(), expression.getType());
        }
        return false;
    }

    protected Map<ParameterizedType, TypeParamDeclaration> getParameterizedSignaturesFromInitialization(Map<Declaration, Node> intialization) {
        HashMap<ParameterizedType, TypeParamDeclaration> parameterizedSignature = new HashMap<ParameterizedType, TypeParamDeclaration>();
        for (Declaration templateParam : intialization.keySet()) {
            if (!(templateParam instanceof TypeParamDeclaration)) continue;
            parameterizedSignature.put((ParameterizedType)((TypeParamDeclaration)templateParam).getType(), (TypeParamDeclaration)templateParam);
        }
        return parameterizedSignature;
    }

    protected void handleImplicitTemplateParameter(FunctionTemplateDeclaration functionTemplateDeclaration, int index, Map<Declaration, Node> instantiationSignature, Map<Node, TemplateDeclaration.TemplateInitialization> instantiationType, Map<Declaration, Integer> orderedInitializationSignature) {
        if (((HasDefault)((Object)functionTemplateDeclaration.getParameters().get(index))).getDefault() != null) {
            Object defaultNode = ((HasDefault)((Object)functionTemplateDeclaration.getParameters().get(index))).getDefault();
            if (defaultNode instanceof Type) {
                defaultNode = NodeBuilder.newTypeExpression(((Node)defaultNode).getName(), (Type)defaultNode);
                ((Node)defaultNode).setImplicit(true);
            }
            instantiationSignature.put(functionTemplateDeclaration.getParameters().get(index), (Node)defaultNode);
            instantiationType.put((Node)defaultNode, TemplateDeclaration.TemplateInitialization.DEFAULT);
            orderedInitializationSignature.put(functionTemplateDeclaration.getParameters().get(index), index);
        } else {
            instantiationSignature.put(functionTemplateDeclaration.getParameters().get(index), null);
            instantiationType.put(null, TemplateDeclaration.TemplateInitialization.UNKNOWN);
            orderedInitializationSignature.put(functionTemplateDeclaration.getParameters().get(index), index);
        }
    }

    protected @Nullable Map<Declaration, Node> constructTemplateInitializationSignatureFromTemplateParameters(FunctionTemplateDeclaration functionTemplateDeclaration, CallExpression templateCall, Map<Node, TemplateDeclaration.TemplateInitialization> instantiationType, Map<Declaration, Integer> orderedInitializationSignature, List<ParameterizedType> explicitInstantiated) {
        HashMap<Declaration, Node> instantiationSignature = new HashMap<Declaration, Node>();
        for (int i = 0; i < functionTemplateDeclaration.getParameters().size(); ++i) {
            if (i < templateCall.getTemplateParameters().size()) {
                Declaration templateParameter;
                Node callParameter = templateCall.getTemplateParameters().get(i);
                if (this.isInstantiated(callParameter, templateParameter = functionTemplateDeclaration.getParameters().get(i))) {
                    instantiationSignature.put(templateParameter, callParameter);
                    instantiationType.put(callParameter, TemplateDeclaration.TemplateInitialization.EXPLICIT);
                    if (templateParameter instanceof TypeParamDeclaration) {
                        explicitInstantiated.add((ParameterizedType)((TypeParamDeclaration)templateParameter).getType());
                    }
                    orderedInitializationSignature.put(templateParameter, i);
                    continue;
                }
                return null;
            }
            this.handleImplicitTemplateParameter(functionTemplateDeclaration, i, instantiationSignature, instantiationType, orderedInitializationSignature);
        }
        return instantiationSignature;
    }

    protected Map<Declaration, Node> getTemplateInitializationSignature(FunctionTemplateDeclaration functionTemplateDeclaration, CallExpression templateCall, Map<Node, TemplateDeclaration.TemplateInitialization> instantiationType, Map<Declaration, Integer> orderedInitializationSignature, List<ParameterizedType> explicitInstantiated) {
        Map<Declaration, Node> signature = this.constructTemplateInitializationSignatureFromTemplateParameters(functionTemplateDeclaration, templateCall, instantiationType, orderedInitializationSignature, explicitInstantiated);
        if (signature == null) {
            return null;
        }
        Map<ParameterizedType, TypeParamDeclaration> parameterizedTypeResolution = this.getParameterizedSignaturesFromInitialization(signature);
        for (int i = 0; i < templateCall.getArguments().size(); ++i) {
            FunctionDeclaration functionDeclaration = functionTemplateDeclaration.getRealization().get(0);
            Type currentArgumentType = functionDeclaration.getParameters().get(i).getType();
            Type deducedType = templateCall.getArguments().get(i).getType();
            TypeExpression typeExpression = NodeBuilder.newTypeExpression(deducedType.getName(), deducedType);
            typeExpression.setImplicit(true);
            if (!(currentArgumentType instanceof ParameterizedType) || signature.get(parameterizedTypeResolution.get(currentArgumentType)) != null && !instantiationType.get(signature.get(parameterizedTypeResolution.get(currentArgumentType))).equals((Object)TemplateDeclaration.TemplateInitialization.DEFAULT)) continue;
            signature.put(parameterizedTypeResolution.get(currentArgumentType), typeExpression);
            instantiationType.put(typeExpression, TemplateDeclaration.TemplateInitialization.AUTO_DEDUCTION);
        }
        return signature;
    }

    protected boolean handleTemplateFunctionCalls(@Nullable RecordDeclaration curClass, @NonNull CallExpression templateCall, boolean applyInference) {
        if (this.lang == null) {
            Util.errorWithFileLocation(templateCall, log, "Could not handle template function call: language frontend is null", new Object[0]);
            return false;
        }
        List<FunctionTemplateDeclaration> instantiationCandidates = this.lang.getScopeManager().resolveFunctionTemplateDeclaration(templateCall);
        for (FunctionTemplateDeclaration functionTemplateDeclaration : instantiationCandidates) {
            HashMap<Node, TemplateDeclaration.TemplateInitialization> initializationType = new HashMap<Node, TemplateDeclaration.TemplateInitialization>();
            HashMap<Declaration, Integer> orderedInitializationSignature = new HashMap<Declaration, Integer>();
            ArrayList<ParameterizedType> explicitInstantiation = new ArrayList<ParameterizedType>();
            if (templateCall.getTemplateParameters() == null || templateCall.getTemplateParameters().size() > functionTemplateDeclaration.getParameters().size() || templateCall.getArguments().size() > functionTemplateDeclaration.getRealization().get(0).getParameters().size()) continue;
            Map<Declaration, Node> initializationSignature = this.getTemplateInitializationSignature(functionTemplateDeclaration, templateCall, initializationType, orderedInitializationSignature, explicitInstantiation);
            FunctionDeclaration function = functionTemplateDeclaration.getRealization().get(0);
            if (initializationSignature == null || !this.checkArgumentValidity(function, this.getCallSignature(function, this.getParameterizedSignaturesFromInitialization(initializationSignature), initializationSignature), templateCall, explicitInstantiation)) continue;
            this.applyTemplateInstantiation(templateCall, functionTemplateDeclaration, function, initializationSignature, initializationType, orderedInitializationSignature);
            return true;
        }
        if (applyInference) {
            FunctionTemplateDeclaration functionTemplateDeclaration = this.createInferredFunctionTemplate(curClass, templateCall);
            templateCall.setTemplateInstantiation(functionTemplateDeclaration);
            templateCall.setInvokes(functionTemplateDeclaration.getRealization());
            for (PropertyEdge<Node> instantiationParameter : templateCall.getTemplateParametersPropertyEdge()) {
                instantiationParameter.addProperty(Properties.INSTANTIATION, (Object)TemplateDeclaration.TemplateInitialization.EXPLICIT);
            }
            return true;
        }
        return false;
    }

    protected void applyTemplateInstantiation(CallExpression templateCall, FunctionTemplateDeclaration functionTemplateDeclaration, FunctionDeclaration function, Map<Declaration, Node> initializationSignature, Map<Node, TemplateDeclaration.TemplateInitialization> initializationType, Map<Declaration, Integer> orderedInitializationSignature) {
        ArrayList<Node> templateInstantiationParameters = new ArrayList<Node>(orderedInitializationSignature.keySet());
        for (Map.Entry<Declaration, Integer> entry : orderedInitializationSignature.entrySet()) {
            templateInstantiationParameters.set(entry.getValue(), (Declaration)initializationSignature.get(entry.getKey()));
        }
        templateCall.setTemplateInstantiation(functionTemplateDeclaration);
        templateCall.setInvokes(List.of(function));
        Type returnType = function.getType();
        Map<ParameterizedType, TypeParamDeclaration> parameterizedTypeResolution = this.getParameterizedSignaturesFromInitialization(initializationSignature);
        if (returnType instanceof ParameterizedType) {
            returnType = ((TypeExpression)initializationSignature.get(parameterizedTypeResolution.get(returnType))).getType();
        }
        templateCall.setType(returnType);
        templateCall.updateTemplateParameters(initializationType, templateInstantiationParameters);
        List<Type> templateFunctionSignature = this.getCallSignature(function, parameterizedTypeResolution, initializationSignature);
        List<Type> templateCallSignature = templateCall.getSignature();
        List<CastExpression> callSignatureImplicit = this.signatureWithImplicitCastTransformation(templateCallSignature, templateCall.getArguments(), templateFunctionSignature);
        for (int i = 0; i < callSignatureImplicit.size(); ++i) {
            CastExpression cast = callSignatureImplicit.get(i);
            if (cast == null) continue;
            templateCall.setArgument(i, cast);
        }
        for (Map.Entry<Declaration, Node> entry : initializationSignature.entrySet()) {
            Declaration declaration = entry.getKey();
            if (!(declaration instanceof ParamVariableDeclaration)) continue;
            declaration.addPrevDFG(initializationSignature.get(declaration));
            initializationSignature.get(declaration).addNextDFG(declaration);
        }
    }

    protected boolean checkArgumentValidity(FunctionDeclaration functionDeclaration, List<Type> functionDeclarationSignature, CallExpression templateCallExpression, List<ParameterizedType> explicitInstantiation) {
        if (templateCallExpression.getArguments().size() <= functionDeclaration.getParameters().size()) {
            ArrayList<Expression> callArguments = new ArrayList<Expression>(templateCallExpression.getArguments());
            callArguments.addAll(functionDeclaration.getDefaultParameters().subList(callArguments.size(), functionDeclaration.getDefaultParameters().size()));
            for (int i = 0; i < callArguments.size(); ++i) {
                Expression callArgument = (Expression)callArguments.get(i);
                if (callArgument == null) {
                    return false;
                }
                if (callArgument.getType().equals(functionDeclarationSignature.get(i)) || callArgument.getType().isPrimitive() && functionDeclarationSignature.get(i).isPrimitive() && explicitInstantiation.contains(functionDeclaration.getParameters().get(i).getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<Type> getCallSignature(FunctionDeclaration function, Map<ParameterizedType, TypeParamDeclaration> parameterizedTypeResolution, Map<Declaration, Node> initializationSignature) {
        ArrayList<Type> templateCallSignature = new ArrayList<Type>();
        for (ParamVariableDeclaration argument : function.getParameters()) {
            if (argument.getType() instanceof ParameterizedType) {
                templateCallSignature.add(((TypeExpression)initializationSignature.get(parameterizedTypeResolution.get(argument.getType()))).getType());
                continue;
            }
            templateCallSignature.add(argument.getType());
        }
        return templateCallSignature;
    }

    protected void resolveArguments(CallExpression call, RecordDeclaration curClass) {
        ArrayDeque<Node> worklist = new ArrayDeque<Node>();
        call.getArguments().forEach(worklist::push);
        while (!worklist.isEmpty()) {
            Node curr = (Node)worklist.pop();
            if (curr instanceof CallExpression) {
                this.resolve(curr, curClass);
                continue;
            }
            Iterator<Node> it = Strategy.AST_FORWARD(curr);
            while (it.hasNext()) {
                Node astChild = it.next();
                if (astChild instanceof RecordDeclaration) continue;
                worklist.push(astChild);
            }
        }
    }

    protected boolean compatibleSignatures(List<Type> callSignature, List<Type> functionSignature) {
        if (callSignature.size() == functionSignature.size()) {
            for (int i = 0; i < callSignature.size(); ++i) {
                if (callSignature.get(i).isPrimitive() == functionSignature.get(i).isPrimitive() || TypeManager.getInstance().isSupertypeOf(functionSignature.get(i), callSignature.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<CastExpression> signatureWithImplicitCastTransformation(List<Type> callSignature, List<Expression> arguments, List<Type> functionSignature) {
        if (callSignature.size() == functionSignature.size()) {
            ArrayList<CastExpression> implicitCasts = new ArrayList<CastExpression>();
            for (int i = 0; i < callSignature.size(); ++i) {
                Type callType = callSignature.get(i);
                Type funcType = functionSignature.get(i);
                if (callType.isPrimitive() && funcType.isPrimitive() && !callType.equals(funcType)) {
                    CastExpression implicitCast = new CastExpression();
                    implicitCast.setImplicit(true);
                    implicitCast.setCastType(funcType);
                    implicitCast.setExpression(arguments.get(i));
                    implicitCasts.add(implicitCast);
                    continue;
                }
                implicitCasts.add(null);
            }
            return implicitCasts;
        }
        return new ArrayList<CastExpression>();
    }

    protected List<Type> getCallSignatureWithDefaults(CallExpression call, FunctionDeclaration functionDeclaration) {
        ArrayList<Type> callSignature = new ArrayList<Type>(call.getSignature());
        if (call.getSignature().size() < functionDeclaration.getParameters().size()) {
            callSignature.addAll(functionDeclaration.getDefaultParameterSignature().subList(call.getArguments().size(), functionDeclaration.getDefaultParameterSignature().size()));
        }
        return callSignature;
    }

    protected List<FunctionDeclaration> resolveWithImplicitCast(CallExpression call, List<FunctionDeclaration> initialInvocationCandidates) {
        ArrayList<FunctionDeclaration> invocationTargetsWithImplicitCast = new ArrayList<FunctionDeclaration>();
        ArrayList<FunctionDeclaration> invocationTargetsWithImplicitCastAndDefaults = new ArrayList<FunctionDeclaration>();
        List<CastExpression> implicitCasts = null;
        for (FunctionDeclaration functionDeclaration : initialInvocationCandidates) {
            List<Type> callSignature = this.getCallSignatureWithDefaults(call, functionDeclaration);
            if (!this.compatibleSignatures(callSignature, functionDeclaration.getSignatureTypes())) continue;
            List<CastExpression> implicitCastTargets = this.signatureWithImplicitCastTransformation(this.getCallSignatureWithDefaults(call, functionDeclaration), call.getArguments(), functionDeclaration.getSignatureTypes());
            if (implicitCasts == null) {
                implicitCasts = implicitCastTargets;
            } else {
                this.checkMostCommonImplicitCast(implicitCasts, implicitCastTargets);
            }
            if (this.compatibleSignatures(call.getSignature(), functionDeclaration.getSignatureTypes())) {
                invocationTargetsWithImplicitCast.add(functionDeclaration);
                continue;
            }
            invocationTargetsWithImplicitCastAndDefaults.add(functionDeclaration);
        }
        this.applyImplicitCastToArguments(call, implicitCasts);
        if (!invocationTargetsWithImplicitCast.isEmpty()) {
            return invocationTargetsWithImplicitCast;
        }
        return invocationTargetsWithImplicitCastAndDefaults;
    }

    protected List<FunctionDeclaration> resolveWithImplicitCastFunc(CallExpression call) {
        if (this.lang == null) {
            Util.errorWithFileLocation(call, log, "Could not resolve implicit casts: language frontend is null", new Object[0]);
            return Collections.emptyList();
        }
        ArrayList<FunctionDeclaration> initialInvocationCandidates = new ArrayList<FunctionDeclaration>(this.lang.getScopeManager().resolveFunctionStopScopeTraversalOnDefinition(call));
        return this.resolveWithImplicitCast(call, initialInvocationCandidates);
    }

    protected void checkMostCommonImplicitCast(List<CastExpression> implicitCasts, List<CastExpression> implicitCastTargets) {
        for (int i = 0; i < implicitCasts.size(); ++i) {
            CastExpression currentCast = implicitCasts.get(i);
            if (i >= implicitCastTargets.size()) continue;
            CastExpression otherCast = implicitCastTargets.get(i);
            if (currentCast == null || otherCast == null || currentCast.equals(otherCast)) continue;
            CastExpression contradictoryCast = new CastExpression();
            contradictoryCast.setImplicit(true);
            contradictoryCast.setCastType(UnknownType.getUnknownType());
            contradictoryCast.setExpression(currentCast.getExpression());
            implicitCasts.set(i, contradictoryCast);
        }
    }

    protected void applyImplicitCastToArguments(CallExpression call, List<CastExpression> implicitCasts) {
        if (implicitCasts != null) {
            for (int i = 0; i < implicitCasts.size(); ++i) {
                if (implicitCasts.get(i) == null) continue;
                call.setArgument(i, implicitCasts.get(i));
            }
        }
    }

    protected void applyImplicitCastToArguments(ConstructExpression constructExpression, List<CastExpression> implicitCasts) {
        if (implicitCasts != null) {
            for (int i = 0; i < implicitCasts.size(); ++i) {
                if (implicitCasts.get(i) == null) continue;
                constructExpression.setArgument(i, implicitCasts.get(i));
            }
        }
    }

    protected List<FunctionDeclaration> resolveWithDefaultArgs(CallExpression call, List<FunctionDeclaration> initialInvocationCandidates) {
        ArrayList<FunctionDeclaration> invocationCandidatesDefaultArgs = new ArrayList<FunctionDeclaration>();
        for (FunctionDeclaration functionDeclaration : initialInvocationCandidates) {
            if (!functionDeclaration.hasSignature(this.getCallSignatureWithDefaults(call, functionDeclaration))) continue;
            invocationCandidatesDefaultArgs.add(functionDeclaration);
        }
        return invocationCandidatesDefaultArgs;
    }

    protected List<FunctionDeclaration> resolveWithDefaultArgsFunc(CallExpression call) {
        if (this.lang == null) {
            Util.errorWithFileLocation(call, log, "Could not resolve default arguments: language frontend is null", new Object[0]);
            return Collections.emptyList();
        }
        List<FunctionDeclaration> invocationCandidates = this.lang.getScopeManager().resolveFunctionStopScopeTraversalOnDefinition(call).stream().filter(f -> call.getSignature().size() < f.getSignatureTypes().size()).collect(Collectors.toList());
        return this.resolveWithDefaultArgs(call, invocationCandidates);
    }

    protected void handleNormalCalls(RecordDeclaration curClass, CallExpression call) {
        if (curClass == null && this.lang != null) {
            List<FunctionDeclaration> invocationCandidates = null;
            if (this.getLang() instanceof CXXLanguageFrontend) {
                this.handleNormalCallCXX(curClass, call);
            } else {
                invocationCandidates = this.lang.getScopeManager().resolveFunction(call);
                this.createInferredFunction(invocationCandidates, call);
                call.setInvokes(invocationCandidates);
            }
        } else if (!this.handlePossibleStaticImport(call, curClass)) {
            this.handleMethodCall(curClass, call);
        }
    }

    protected void handleNormalCallCXX(RecordDeclaration curClass, CallExpression call) {
        if (this.lang == null) {
            Util.errorWithFileLocation(call, log, "Could not handle normal CXX calls: language frontend is null", new Object[0]);
            return;
        }
        List<FunctionDeclaration> invocationCandidates = this.lang.getScopeManager().resolveFunctionStopScopeTraversalOnDefinition(call).stream().filter(f -> f.hasSignature(call.getSignature())).collect(Collectors.toList());
        if (invocationCandidates.isEmpty()) {
            invocationCandidates.addAll(this.resolveWithDefaultArgsFunc(call));
        }
        if (invocationCandidates.isEmpty()) {
            call.setTemplateParameters(new ArrayList<PropertyEdge<Node>>());
            if (this.handleTemplateFunctionCalls(curClass, call, false)) {
                return;
            }
            call.setTemplateParameters(null);
        }
        if (invocationCandidates.isEmpty()) {
            invocationCandidates.addAll(this.resolveWithImplicitCastFunc(call));
        }
        this.createInferredFunction(invocationCandidates, call);
        call.setInvokes(invocationCandidates);
    }

    protected void createInferredFunction(List<FunctionDeclaration> invocationCandidates, CallExpression call) {
        if (invocationCandidates.isEmpty()) {
            invocationCandidates.add(this.createInferredFunctionDeclaration(null, call.getName(), call.getCode(), false, call.getSignature()));
        }
    }

    protected void handleMethodCall(RecordDeclaration curClass, CallExpression call) {
        String[] nameParts;
        Set<Type> possibleContainingTypes = this.getPossibleContainingTypes(call, curClass);
        List<FunctionDeclaration> invocationCandidates = call.getInvokes().stream().map(f -> this.getOverridingCandidates(possibleContainingTypes, (FunctionDeclaration)f)).flatMap(Collection::stream).collect(Collectors.toList());
        if (invocationCandidates.isEmpty() && this.lang != null) {
            invocationCandidates = this.lang instanceof CXXLanguageFrontend ? this.handleCXXMethodCall(curClass, possibleContainingTypes, call) : this.lang.getScopeManager().resolveFunction(call);
        }
        if (invocationCandidates.isEmpty() && (!(this.lang instanceof CXXLanguageFrontend) || this.shouldSearchForInvokesInParent(call)) && (nameParts = call.getName().split("\\.")).length > 0) {
            Set<RecordDeclaration> records = possibleContainingTypes.stream().map(t -> this.recordMap.get(t.getRoot().getTypeName())).filter(Objects::nonNull).collect(Collectors.toSet());
            invocationCandidates = this.getInvocationCandidatesFromParents(nameParts[nameParts.length - 1], call, records);
        }
        this.createMethodDummies(invocationCandidates, possibleContainingTypes, call);
        call.setInvokes(invocationCandidates);
    }

    protected List<FunctionDeclaration> handleCXXMethodCall(RecordDeclaration curClass, Set<Type> possibleContainingTypes, CallExpression call) {
        if (this.lang == null) {
            Util.errorWithFileLocation(call, log, "Could not handle method CXX calls: language frontend is null", new Object[0]);
            return Collections.emptyList();
        }
        List<FunctionDeclaration> invocationCandidates = new ArrayList<FunctionDeclaration>();
        Set records = possibleContainingTypes.stream().map(t -> this.recordMap.get(t.getRoot().getTypeName())).filter(Objects::nonNull).collect(Collectors.toSet());
        for (RecordDeclaration record : records) {
            invocationCandidates.addAll(this.getInvocationCandidatesFromRecord(record, call.getName(), call));
        }
        if (invocationCandidates.isEmpty()) {
            invocationCandidates.addAll(this.resolveWithDefaultArgsFunc(call));
        }
        if (invocationCandidates.isEmpty()) {
            if (this.handleTemplateFunctionCalls(curClass, call, false)) {
                return call.getInvokes();
            }
            call.setTemplateParameters(null);
        }
        if (invocationCandidates.isEmpty()) {
            invocationCandidates.addAll(this.resolveWithImplicitCastFunc(call));
        }
        if (call instanceof MemberCallExpression) {
            invocationCandidates = invocationCandidates.stream().filter(func -> func instanceof MethodDeclaration).collect(Collectors.toList());
        }
        return invocationCandidates;
    }

    protected void createMethodDummies(List<FunctionDeclaration> invocationCandidates, Set<Type> possibleContainingTypes, CallExpression call) {
        if (invocationCandidates.isEmpty()) {
            possibleContainingTypes.stream().map(t -> {
                RecordDeclaration record = this.recordMap.get(t.getRoot().getTypeName());
                if (record == null && this.lang != null && this.lang.getConfig().getInferenceConfiguration().getInferRecords()) {
                    record = this.inferRecordDeclaration((Type)t);
                }
                return record;
            }).filter(Objects::nonNull).map(r -> this.createInferredFunctionDeclaration((RecordDeclaration)r, call.getName(), call.getCode(), false, call.getSignature())).forEach(invocationCandidates::add);
        }
    }

    protected RecordDeclaration inferRecordDeclaration(Type type) {
        if (type instanceof ObjectType) {
            log.debug("Encountered an unknown record type {} during a call. We are going to infer that record", (Object)type.getTypeName());
            RecordDeclaration declaration = NodeBuilder.newRecordDeclaration(type.getTypeName(), "class", "");
            declaration.setInferred(true);
            ((ObjectType)type).setRecordDeclaration(declaration);
            this.recordMap.put(type.getRoot().getTypeName(), declaration);
            this.lang.getCurrentTU().addDeclaration(declaration);
            return declaration;
        }
        log.error("Trying to infer a record declaration of a non-object type. Not sure what to do? Should we change the type?");
        return null;
    }

    protected boolean shouldSearchForInvokesInParent(CallExpression call) {
        if (this.lang == null) {
            Util.errorWithFileLocation(call, log, "Could not search for invokes in parent: language frontend is null", new Object[0]);
            return false;
        }
        return this.lang.getScopeManager().resolveFunctionStopScopeTraversalOnDefinition(call).isEmpty();
    }

    protected void resolveConstructExpression(ConstructExpression constructExpression) {
        String typeName = constructExpression.getType().getTypeName();
        RecordDeclaration recordDeclaration = this.recordMap.get(typeName);
        constructExpression.setInstantiates(recordDeclaration);
        for (TemplateDeclaration template : this.templateList) {
            int defaultDifference;
            if (!(template instanceof ClassTemplateDeclaration) || !((ClassTemplateDeclaration)template).getRealization().contains(recordDeclaration) || constructExpression.getTemplateParameters() == null || constructExpression.getTemplateParameters().size() > template.getParameters().size() || (defaultDifference = template.getParameters().size() - constructExpression.getTemplateParameters().size()) > template.getParameterDefaults().size()) continue;
            this.addRecursiveDefaultTemplateArgs(constructExpression, (ClassTemplateDeclaration)template);
            List<Node> missingNewParams = template.getParameterDefaults().subList(constructExpression.getTemplateParameters().size(), template.getParameterDefaults().size());
            for (Node missingParam : missingNewParams) {
                constructExpression.addTemplateParameter(missingParam, TemplateDeclaration.TemplateInitialization.DEFAULT);
            }
            constructExpression.setTemplateInstantiation(template);
            break;
        }
        if (recordDeclaration != null) {
            ConstructorDeclaration constructor = this.getConstructorDeclaration(constructExpression, recordDeclaration);
            constructExpression.setConstructor(constructor);
        }
    }

    protected void addRecursiveDefaultTemplateArgs(ConstructExpression constructExpression, ClassTemplateDeclaration template) {
        int templateParameters;
        do {
            templateParameters = constructExpression.getTemplateParameters().size();
            HashMap<Node, Node> templateParametersExplicitInitialization = new HashMap<Node, Node>();
            this.handleExplicitTemplateParameters(constructExpression, template, templateParametersExplicitInitialization);
            HashMap<Node, Node> templateParameterRealDefaultInitialization = new HashMap<Node, Node>();
            this.handleDefaultTemplateParameters(template, templateParameterRealDefaultInitialization);
            this.applyMissingParams(template, constructExpression, templateParametersExplicitInitialization, templateParameterRealDefaultInitialization);
        } while (templateParameters != constructExpression.getTemplateParameters().size());
    }

    protected void applyMissingParams(ClassTemplateDeclaration template, ConstructExpression constructExpression, Map<Node, Node> templateParametersExplicitInitialization, Map<Node, Node> templateParameterRealDefaultInitialization) {
        List<Node> missingParams = template.getParameterDefaults().subList(constructExpression.getTemplateParameters().size(), template.getParameterDefaults().size());
        for (Node missingParam : missingParams) {
            if (missingParam instanceof DeclaredReferenceExpression) {
                missingParam = ((DeclaredReferenceExpression)missingParam).getRefersTo();
            }
            if (templateParametersExplicitInitialization.containsKey(missingParam)) {
                constructExpression.addTemplateParameter(templateParametersExplicitInitialization.get(missingParam), TemplateDeclaration.TemplateInitialization.DEFAULT);
                if (!(templateParametersExplicitInitialization.get(missingParam) instanceof TypeExpression)) continue;
                ((ObjectType)constructExpression.getType()).addGeneric(((TypeExpression)templateParametersExplicitInitialization.get(missingParam)).getType());
                continue;
            }
            if (!templateParameterRealDefaultInitialization.containsKey(missingParam)) continue;
            constructExpression.addTemplateParameter(templateParameterRealDefaultInitialization.get(missingParam), TemplateDeclaration.TemplateInitialization.DEFAULT);
            if (!(templateParametersExplicitInitialization.get(missingParam) instanceof Type)) continue;
            ((ObjectType)constructExpression.getType()).addGeneric(((TypeExpression)templateParametersExplicitInitialization.get(missingParam)).getType());
        }
    }

    protected void handleExplicitTemplateParameters(ConstructExpression constructExpression, ClassTemplateDeclaration template, Map<Node, Node> templateParametersExplicitInitialization) {
        for (int i = 0; i < constructExpression.getTemplateParameters().size(); ++i) {
            Node explicit = constructExpression.getTemplateParameters().get(i);
            if (template.getParameters().get(i) instanceof TypeParamDeclaration) {
                templateParametersExplicitInitialization.put(((TypeParamDeclaration)template.getParameters().get(i)).getType(), explicit);
                continue;
            }
            if (!(template.getParameters().get(i) instanceof ParamVariableDeclaration)) continue;
            templateParametersExplicitInitialization.put(template.getParameters().get(i), explicit);
        }
    }

    protected void handleDefaultTemplateParameters(ClassTemplateDeclaration template, Map<Node, Node> templateParameterRealDefaultInitialization) {
        ArrayList<Type> declaredTemplateTypes = new ArrayList<Type>();
        ArrayList<ParamVariableDeclaration> declaredNonTypeTemplate = new ArrayList<ParamVariableDeclaration>();
        List<Declaration> parametersWithDefaults = template.getParametersWithDefaults();
        for (Declaration declaration : template.getParameters()) {
            if (declaration instanceof TypeParamDeclaration) {
                declaredTemplateTypes.add(((TypeParamDeclaration)declaration).getType());
                if (declaredTemplateTypes.contains(((TypeParamDeclaration)declaration).getDefault()) || !parametersWithDefaults.contains(declaration)) continue;
                templateParameterRealDefaultInitialization.put(((TypeParamDeclaration)declaration).getType(), ((TypeParamDeclaration)declaration).getDefault());
                continue;
            }
            if (!(declaration instanceof ParamVariableDeclaration)) continue;
            declaredNonTypeTemplate.add((ParamVariableDeclaration)declaration);
            if (!parametersWithDefaults.contains(declaration) || ((ParamVariableDeclaration)declaration).getDefault() instanceof DeclaredReferenceExpression && declaredNonTypeTemplate.contains(((DeclaredReferenceExpression)((ParamVariableDeclaration)declaration).getDefault()).getRefersTo())) continue;
            templateParameterRealDefaultInitialization.put(declaration, ((ParamVariableDeclaration)declaration).getDefault());
        }
    }

    protected void handleFunctionPointerCall(CallExpression call, Node pointer) {
        if (!(pointer instanceof HasType) || !(((HasType)((Object)pointer)).getType() instanceof FunctionPointerType)) {
            LOGGER.error("Can't handle a function pointer call without function pointer type");
            return;
        }
        FunctionPointerType pointerType = (FunctionPointerType)((HasType)((Object)pointer)).getType();
        ArrayList<FunctionDeclaration> invocationCandidates = new ArrayList<FunctionDeclaration>();
        ArrayDeque<Node> worklist = new ArrayDeque<Node>();
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        worklist.push(pointer);
        while (!worklist.isEmpty()) {
            Node curr = (Node)worklist.pop();
            if (!seen.add(curr)) continue;
            if (curr instanceof FunctionDeclaration) {
                FunctionDeclaration f = (FunctionDeclaration)curr;
                if (TypeManager.getInstance().isSupertypeOf(pointerType.getReturnType(), f.getType()) && f.hasSignature(pointerType.getParameters())) {
                    invocationCandidates.add((FunctionDeclaration)curr);
                    continue;
                }
            }
            curr.getPrevDFG().forEach(worklist::push);
        }
        call.setInvokes(invocationCandidates);
    }

    protected void resolveExplicitConstructorInvocation(ExplicitConstructorInvocation eci) {
        if (eci.getContainingClass() != null) {
            RecordDeclaration recordDeclaration = this.recordMap.get(eci.getContainingClass());
            List<Type> signature = eci.getArguments().stream().map(Expression::getType).collect(Collectors.toList());
            if (recordDeclaration != null) {
                ConstructorDeclaration constructor = this.getConstructorDeclarationForExplicitInvocation(signature, recordDeclaration);
                ArrayList<FunctionDeclaration> invokes = new ArrayList<FunctionDeclaration>();
                invokes.add(constructor);
                eci.setInvokes(invokes);
            }
        }
    }

    protected boolean handlePossibleStaticImport(@Nullable CallExpression call, RecordDeclaration curClass) {
        if (call == null || curClass == null) {
            return false;
        }
        String name = call.getName().substring(call.getName().lastIndexOf(46) + 1);
        List nameMatches = curClass.getStaticImports().stream().filter(FunctionDeclaration.class::isInstance).map(FunctionDeclaration.class::cast).filter(m -> m.getName().equals(name) || m.getName().endsWith("." + name)).collect(Collectors.toList());
        if (nameMatches.isEmpty()) {
            return false;
        }
        ArrayList<FunctionDeclaration> invokes = new ArrayList<FunctionDeclaration>();
        FunctionDeclaration target = nameMatches.stream().filter(m -> m.hasSignature(call.getSignature())).findFirst().orElse(null);
        if (target == null) {
            this.generateInferredStaticallyImportedMethods(call, name, invokes, curClass);
        } else {
            invokes.add(target);
        }
        call.setInvokes(invokes);
        return true;
    }

    protected void generateInferredStaticallyImportedMethods(@NonNull CallExpression call, @NonNull String name, @NonNull List<FunctionDeclaration> invokes, RecordDeclaration curClass) {
        if (curClass == null) {
            LOGGER.warn("Cannot generate inferred nodes for imports of a null class: {}", (Object)call);
            return;
        }
        List containingRecords = curClass.getStaticImportStatements().stream().filter(i -> i.endsWith("." + name)).map(i -> i.substring(0, i.lastIndexOf(46))).map(c -> this.recordMap.getOrDefault(c, null)).filter(Objects::nonNull).collect(Collectors.toList());
        for (RecordDeclaration recordDeclaration : containingRecords) {
            MethodDeclaration inferredMethod = NodeBuilder.newMethodDeclaration(name, "", true, recordDeclaration);
            inferredMethod.setInferred(true);
            List<ParamVariableDeclaration> params = Util.createInferredParameters(call.getSignature());
            inferredMethod.setParameters(params);
            recordDeclaration.addMethod(inferredMethod);
            curClass.getStaticImports().add(inferredMethod);
            invokes.add(inferredMethod);
        }
    }

    protected FunctionTemplateDeclaration createInferredFunctionTemplate(RecordDeclaration containingRecord, CallExpression call) {
        String name = call.getName();
        String code = call.getCode();
        FunctionTemplateDeclaration inferred = NodeBuilder.newFunctionTemplateDeclaration(name, code);
        inferred.setInferred(true);
        if (containingRecord != null) {
            containingRecord.addDeclaration(inferred);
        } else if (this.currentTU == null) {
            LOGGER.error("No current translation unit when trying to generate inferred function template {}", (Object)inferred.getName());
        } else {
            this.currentTU.addDeclaration(inferred);
        }
        FunctionDeclaration inferredRealization = this.createInferredFunctionDeclaration(containingRecord, name, code, false, call.getSignature());
        inferred.addRealization(inferredRealization);
        int typeCounter = 0;
        int nonTypeCounter = 0;
        for (Node node : call.getTemplateParameters()) {
            if (node instanceof TypeExpression) {
                String inferredTypeIdentifier = "T" + typeCounter;
                TypeParamDeclaration typeParamDeclaration = NodeBuilder.newTypeParamDeclaration(inferredTypeIdentifier, inferredTypeIdentifier);
                typeParamDeclaration.setInferred(true);
                ParameterizedType parameterizedType = new ParameterizedType(inferredTypeIdentifier);
                parameterizedType.setInferred(true);
                typeParamDeclaration.setType(parameterizedType);
                TypeManager.getInstance().addTypeParameter(inferred, parameterizedType);
                ++typeCounter;
                inferred.addParameter(typeParamDeclaration);
                continue;
            }
            if (!(node instanceof Expression)) continue;
            String inferredNonTypeIdentifier = "N" + nonTypeCounter;
            ParamVariableDeclaration paramVariableDeclaration = NodeBuilder.newMethodParameterIn(inferredNonTypeIdentifier, ((Expression)node).getType(), false, inferredNonTypeIdentifier);
            paramVariableDeclaration.setInferred(true);
            paramVariableDeclaration.addPrevDFG(node);
            node.addNextDFG(paramVariableDeclaration);
            ++nonTypeCounter;
            inferred.addParameter(paramVariableDeclaration);
        }
        return inferred;
    }

    protected @NonNull FunctionDeclaration createInferredFunctionDeclaration(RecordDeclaration containingRecord, String name, String code, boolean isStatic, List<Type> signature) {
        List<ParamVariableDeclaration> parameters = Util.createInferredParameters(signature);
        if (containingRecord != null) {
            MethodDeclaration inferred = NodeBuilder.newMethodDeclaration(name, code, isStatic, containingRecord);
            inferred.setInferred(true);
            inferred.setParameters(parameters);
            containingRecord.addMethod(inferred);
            if (this.lang != null && this.lang.getConfig().getInferenceConfiguration().getInferRecords() && containingRecord.isInferred() && containingRecord.getKind().equals("struct")) {
                containingRecord.setKind("class");
            }
            log.debug("Inferring a new method declaration {} with parameter types {}", (Object)inferred.getName(), inferred.getParameters().stream().map(param -> param.getType().getName()).collect(Collectors.toList()));
            return inferred;
        }
        FunctionDeclaration inferred = NodeBuilder.newFunctionDeclaration(name, code);
        inferred.setParameters(parameters);
        inferred.setInferred(true);
        if (this.currentTU == null) {
            LOGGER.error("No current translation unit when trying to generate  inferred function {}", (Object)inferred.getName());
        } else {
            this.currentTU.addDeclaration(inferred);
        }
        return inferred;
    }

    protected ConstructorDeclaration createInferredConstructor(@NonNull RecordDeclaration containingRecord, List<Type> signature) {
        ConstructorDeclaration inferred = NodeBuilder.newConstructorDeclaration(containingRecord.getName(), "", containingRecord);
        inferred.setInferred(true);
        inferred.setParameters(Util.createInferredParameters(signature));
        containingRecord.addConstructor(inferred);
        return inferred;
    }

    protected Set<Type> getPossibleContainingTypes(Node node, RecordDeclaration curClass) {
        HashSet<Type> possibleTypes = new HashSet<Type>();
        if (node instanceof MemberCallExpression) {
            MemberCallExpression memberCall = (MemberCallExpression)node;
            if (memberCall.getBase() instanceof HasType) {
                Expression base = memberCall.getBase();
                possibleTypes.add(base.getType());
                possibleTypes.addAll(base.getPossibleSubTypes());
            }
        } else if (node instanceof StaticCallExpression) {
            StaticCallExpression staticCall = (StaticCallExpression)node;
            if (staticCall.getTargetRecord() != null) {
                possibleTypes.add(TypeParser.createFrom(staticCall.getTargetRecord(), true));
            }
        } else if (curClass != null) {
            possibleTypes.add(TypeParser.createFrom(curClass.getName(), true));
        }
        return possibleTypes;
    }

    protected List<FunctionDeclaration> getInvocationCandidatesFromRecord(RecordDeclaration recordDeclaration, String name, CallExpression call) {
        List<Type> signature = call.getSignature();
        Pattern namePattern = Pattern.compile("(" + Pattern.quote(recordDeclaration.getName()) + "\\.)?" + Pattern.quote(name));
        if (this.lang instanceof CXXLanguageFrontend) {
            ArrayList<FunctionDeclaration> invocationCandidate = new ArrayList<FunctionDeclaration>(recordDeclaration.getMethods().stream().filter(m -> namePattern.matcher(m.getName()).matches() && m.hasSignature(signature)).map(FunctionDeclaration.class::cast).collect(Collectors.toList()));
            if (invocationCandidate.isEmpty()) {
                invocationCandidate.addAll(this.resolveWithDefaultArgs(call, recordDeclaration.getMethods().stream().filter(m -> namePattern.matcher(m.getName()).matches() && call.getSignature().size() < m.getSignatureTypes().size()).map(FunctionDeclaration.class::cast).collect(Collectors.toList())));
            }
            if (invocationCandidate.isEmpty()) {
                invocationCandidate.addAll(this.resolveWithImplicitCast(call, recordDeclaration.getMethods().stream().filter(m -> namePattern.matcher(m.getName()).matches()).map(FunctionDeclaration.class::cast).collect(Collectors.toList())));
            }
            return invocationCandidate;
        }
        return recordDeclaration.getMethods().stream().filter(m -> namePattern.matcher(m.getName()).matches() && m.hasSignature(signature)).map(FunctionDeclaration.class::cast).collect(Collectors.toList());
    }

    protected List<FunctionDeclaration> getInvocationCandidatesFromParents(String name, CallExpression call, Set<RecordDeclaration> possibleTypes) {
        HashSet<RecordDeclaration> workingPossibleTypes = new HashSet<RecordDeclaration>(possibleTypes);
        if (possibleTypes.isEmpty()) {
            return new ArrayList<FunctionDeclaration>();
        }
        List<FunctionDeclaration> firstLevelCandidates = possibleTypes.stream().map(r -> this.getInvocationCandidatesFromRecord((RecordDeclaration)r, name, call)).flatMap(Collection::stream).collect(Collectors.toList());
        if (this.lang instanceof CXXLanguageFrontend) {
            workingPossibleTypes.removeIf(recordDeclaration -> !this.shouldContinueSearchInParent((RecordDeclaration)recordDeclaration, name));
        }
        if (firstLevelCandidates.isEmpty() && !possibleTypes.isEmpty()) {
            return workingPossibleTypes.stream().map(RecordDeclaration::getSuperTypeDeclarations).map(superTypes -> this.getInvocationCandidatesFromParents(name, call, (Set<RecordDeclaration>)superTypes)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return firstLevelCandidates;
    }

    protected boolean shouldContinueSearchInParent(RecordDeclaration recordDeclaration, String name) {
        Pattern namePattern = Pattern.compile("(" + Pattern.quote(recordDeclaration.getName()) + "\\.)?" + Pattern.quote(name));
        List invocationCandidate = recordDeclaration.getMethods().stream().filter(m -> namePattern.matcher(m.getName()).matches()).map(FunctionDeclaration.class::cast).collect(Collectors.toList());
        return invocationCandidate.isEmpty();
    }

    protected Set<FunctionDeclaration> getOverridingCandidates(Set<Type> possibleSubTypes, FunctionDeclaration declaration) {
        return declaration.getOverriddenBy().stream().filter(f -> possibleSubTypes.contains(this.containingType.get(f))).collect(Collectors.toSet());
    }

    protected ConstructorDeclaration getConstructorDeclarationDirectMatch(List<Type> signature, RecordDeclaration recordDeclaration) {
        for (ConstructorDeclaration constructor : recordDeclaration.getConstructors()) {
            if (!constructor.hasSignature(signature)) continue;
            return constructor;
        }
        return null;
    }

    protected ConstructorDeclaration resolveConstructorWithDefaults(ConstructExpression constructExpression, List<Type> signature, RecordDeclaration recordDeclaration) {
        for (ConstructorDeclaration constructor : recordDeclaration.getConstructors()) {
            List<Type> workingSignature;
            if (signature.size() >= constructor.getSignatureTypes().size() || !constructor.hasSignature(workingSignature = this.getCallSignatureWithDefaults(constructExpression, constructor))) continue;
            return constructor;
        }
        return null;
    }

    protected ConstructorDeclaration resolveConstructorWithImplicitCast(ConstructExpression constructExpression, RecordDeclaration recordDeclaration) {
        for (ConstructorDeclaration constructorDeclaration : recordDeclaration.getConstructors()) {
            ArrayList<Type> workingSignature = new ArrayList<Type>(constructExpression.getSignature());
            List<Type> defaultParameterSignature = constructorDeclaration.getDefaultParameterSignature();
            if (constructExpression.getArguments().size() <= defaultParameterSignature.size()) {
                workingSignature.addAll(defaultParameterSignature.subList(constructExpression.getArguments().size(), defaultParameterSignature.size()));
            }
            if (this.compatibleSignatures(constructExpression.getSignature(), constructorDeclaration.getSignatureTypes())) {
                List<CastExpression> implicitCasts = this.signatureWithImplicitCastTransformation(constructExpression.getSignature(), constructExpression.getArguments(), constructorDeclaration.getSignatureTypes());
                this.applyImplicitCastToArguments(constructExpression, implicitCasts);
                return constructorDeclaration;
            }
            if (!this.compatibleSignatures(workingSignature, constructorDeclaration.getSignatureTypes())) continue;
            List<CastExpression> implicitCasts = this.signatureWithImplicitCastTransformation(this.getCallSignatureWithDefaults(constructExpression, constructorDeclaration), constructExpression.getArguments(), constructorDeclaration.getSignatureTypes());
            this.applyImplicitCastToArguments(constructExpression, implicitCasts);
            return constructorDeclaration;
        }
        return null;
    }

    protected @NonNull ConstructorDeclaration getConstructorDeclaration(ConstructExpression constructExpression, RecordDeclaration recordDeclaration) {
        List<Type> signature = constructExpression.getSignature();
        ConstructorDeclaration constructorCandidate = this.getConstructorDeclarationDirectMatch(signature, recordDeclaration);
        if (constructorCandidate == null && this.getLang() instanceof CXXLanguageFrontend) {
            constructorCandidate = this.resolveConstructorWithDefaults(constructExpression, signature, recordDeclaration);
        }
        if (constructorCandidate == null && this.getLang() instanceof CXXLanguageFrontend) {
            constructorCandidate = this.resolveConstructorWithImplicitCast(constructExpression, recordDeclaration);
        }
        if (constructorCandidate == null) {
            constructorCandidate = this.createInferredConstructor(recordDeclaration, signature);
        }
        return constructorCandidate;
    }

    protected @NonNull ConstructorDeclaration getConstructorDeclarationForExplicitInvocation(List<Type> signature, RecordDeclaration recordDeclaration) {
        return recordDeclaration.getConstructors().stream().filter(f -> f.hasSignature(signature)).findFirst().orElseGet(() -> this.createInferredConstructor(recordDeclaration, signature));
    }
}

