/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.helpers.StatisticsHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 '2\u00020\u0001:\u0001'B1\b\u0007\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\"\u0010!\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0005H\u0017J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0005R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R&\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0011\u00a8\u0006("}, d2={"Lde/fraunhofer/aisec/cpg/helpers/MeasurementHolder;", "", "c", "Ljava/lang/Class;", "message", "", "debug", "", "holder", "Lde/fraunhofer/aisec/cpg/helpers/StatisticsHolder;", "(Ljava/lang/Class;Ljava/lang/String;ZLde/fraunhofer/aisec/cpg/helpers/StatisticsHolder;)V", "benchmarkedValues", "", "getBenchmarkedValues", "()Ljava/util/List;", "caller", "getCaller", "()Ljava/lang/String;", "getDebug", "()Z", "setDebug", "(Z)V", "getHolder", "()Lde/fraunhofer/aisec/cpg/helpers/StatisticsHolder;", "setHolder", "(Lde/fraunhofer/aisec/cpg/helpers/StatisticsHolder;)V", "measurements", "", "getMeasurements", "()Ljava/util/Map;", "setMeasurements", "(Ljava/util/Map;)V", "getMessage", "addMeasurement", "measurementKey", "measurementValue", "logDebugMsg", "", "msg", "Companion", "cpg-core"})
public class MeasurementHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String message;
    private boolean debug;
    @Nullable
    private StatisticsHolder holder;
    @NotNull
    private final String caller;
    @NotNull
    private Map<String, String> measurements;
    @NotNull
    private static final Logger log;

    @JvmOverloads
    public MeasurementHolder(@NotNull Class<?> c, @NotNull String message, boolean debug, @Nullable StatisticsHolder holder) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.message = message;
        this.debug = debug;
        this.holder = holder;
        this.measurements = new LinkedHashMap();
        String string = c.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"c.simpleName");
        this.caller = string;
        this.logDebugMsg(this.caller + ": " + this.message);
    }

    public /* synthetic */ MeasurementHolder(Class clazz, String string, boolean bl, StatisticsHolder statisticsHolder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            statisticsHolder = null;
        }
        this(clazz, string, bl, statisticsHolder);
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    protected final boolean getDebug() {
        return this.debug;
    }

    protected final void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Nullable
    protected final StatisticsHolder getHolder() {
        return this.holder;
    }

    protected final void setHolder(@Nullable StatisticsHolder statisticsHolder) {
        this.holder = statisticsHolder;
    }

    @NotNull
    public final String getCaller() {
        return this.caller;
    }

    @NotNull
    public final Map<String, String> getMeasurements() {
        return this.measurements;
    }

    public final void setMeasurements(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.measurements = map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getBenchmarkedValues() {
        void $this$flatMapTo$iv$iv;
        Map<String, String> $this$flatMap$iv = this.measurements;
        boolean $i$f$flatMap = false;
        Map<String, String> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            Object[] objectArray = new String[]{(String)it.getKey(), (String)it.getValue()};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void logDebugMsg(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.debug) {
            log.debug(msg);
        } else {
            log.info(msg);
        }
    }

    @JvmOverloads
    @Nullable
    public Object addMeasurement(@Nullable String measurementKey, @Nullable String measurementValue) {
        block1: {
            if (measurementKey == null || measurementValue == null) {
                return null;
            }
            this.measurements.put("Measured " + measurementKey, measurementValue);
            this.logDebugMsg(this.caller + ' ' + measurementKey + ": result is " + measurementValue);
            StatisticsHolder statisticsHolder = this.holder;
            if (statisticsHolder == null) break block1;
            statisticsHolder.addBenchmark(this);
        }
        return null;
    }

    public static /* synthetic */ Object addMeasurement$default(MeasurementHolder measurementHolder, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addMeasurement");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return measurementHolder.addMeasurement(string, string2);
    }

    @JvmOverloads
    public MeasurementHolder(@NotNull Class<?> c, @NotNull String message, boolean debug) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this(c, message, debug, null, 8, null);
    }

    @JvmOverloads
    public MeasurementHolder(@NotNull Class<?> c, @NotNull String message) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this(c, message, false, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public final Object addMeasurement(@Nullable String measurementKey) {
        return MeasurementHolder.addMeasurement$default(this, measurementKey, null, 2, null);
    }

    @JvmOverloads
    @Nullable
    public final Object addMeasurement() {
        return MeasurementHolder.addMeasurement$default(this, null, null, 3, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(MeasurementHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(MeasurementHolder::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/fraunhofer/aisec/cpg/helpers/MeasurementHolder$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

