/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CastExpression
extends Expression
implements HasType.TypeListener {
    private static final Logger log = LoggerFactory.getLogger(CastExpression.class);
    @SubGraph(value={"AST"})
    private Expression expression;
    private Type castType;

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (this.expression != null) {
            this.removePrevDFG(this.expression);
        }
        this.expression = expression;
        if (expression != null) {
            this.addPrevDFG(expression);
        }
    }

    public Type getCastType() {
        return this.castType;
    }

    public void setCastType(Type castType) {
        this.castType = castType;
        this.type = castType;
    }

    @Override
    public void updateType(Type type) {
        super.updateType(type);
        this.castType = type;
    }

    @Override
    public void typeChanged(HasType src, Collection<HasType> root, Type oldType) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        Type previous = this.type;
        if (TypeManager.getInstance().isSupertypeOf(this.castType, src.getPropagationType())) {
            this.setType(src.getPropagationType(), root);
        } else {
            this.resetTypes(this.getCastType());
        }
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, Collection<HasType> root, Set<Type> oldSubTypes) {
        if (!TypeManager.isTypeSystemActive()) {
            return;
        }
        this.setPossibleSubTypes(src.getPossibleSubTypes(), root);
    }

    public void setCastOperator(int operatorCode) {
        switch (operatorCode) {
            case 0: {
                this.setName("cast");
                break;
            }
            case 1: {
                this.setName("dynamic_cast");
                break;
            }
            case 2: {
                this.setName("static_cast");
                break;
            }
            case 3: {
                this.setName("reinterpret_cast");
                break;
            }
            case 4: {
                this.setName("const_cast");
                break;
            }
            default: {
                log.error("unknown operator {}", (Object)operatorCode);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CastExpression)) {
            return false;
        }
        CastExpression that = (CastExpression)o;
        return Objects.equals(this.expression, that.expression) && Objects.equals(this.castType, that.castType) && Objects.equals(this.getName(), that.getName());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

