/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.typescript;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import de.fraunhofer.aisec.cpg.ExperimentalTypeScript;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.frontends.FrontendUtils;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.typescript.DeclarationHandler;
import de.fraunhofer.aisec.cpg.frontends.typescript.ExpressionHandler;
import de.fraunhofer.aisec.cpg.frontends.typescript.StatementHandler;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeHandler;
import de.fraunhofer.aisec.cpg.frontends.typescript.TypeScriptNode;
import de.fraunhofer.aisec.cpg.graph.Annotation;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalTypeScript
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 B2\u00020\u0001:\u0001BB\u001c\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\"\u001a\u0004\u0018\u00010\t\"\u0004\b\u0000\u0010#2\u0006\u0010$\u001a\u0002H#H\u0016\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b)J\u001d\u0010*\u001a\u0004\u0018\u00010+\"\u0004\b\u0000\u0010#2\u0006\u0010$\u001a\u0002H#H\u0016\u00a2\u0006\u0002\u0010,J \u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000202J\u0016\u00104\u001a\u0002052\u0006\u0010/\u001a\u0002002\u0006\u00106\u001a\u000207J\u0010\u00108\u001a\u0002092\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010:\u001a\u0002072\u0006\u0010/\u001a\u000200H\u0016J\u0016\u0010;\u001a\u0002052\u0006\u0010'\u001a\u00020<2\u0006\u0010$\u001a\u00020(J)\u0010=\u001a\u000205\"\u0004\b\u0000\u0010>\"\u0004\b\u0001\u0010#2\u0006\u0010?\u001a\u0002H>2\u0006\u0010@\u001a\u0002H#H\u0016\u00a2\u0006\u0002\u0010AR\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006C"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptLanguageFrontend;", "Lde/fraunhofer/aisec/cpg/frontends/LanguageFrontend;", "config", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration;", "Lorg/checkerframework/checker/nullness/qual/NonNull;", "scopeManager", "Lde/fraunhofer/aisec/cpg/passes/scopes/ScopeManager;", "(Lde/fraunhofer/aisec/cpg/TranslationConfiguration;Lde/fraunhofer/aisec/cpg/passes/scopes/ScopeManager;)V", "currentFileContent", "", "getCurrentFileContent", "()Ljava/lang/String;", "setCurrentFileContent", "(Ljava/lang/String;)V", "declarationHandler", "Lde/fraunhofer/aisec/cpg/frontends/typescript/DeclarationHandler;", "getDeclarationHandler", "()Lde/fraunhofer/aisec/cpg/frontends/typescript/DeclarationHandler;", "expressionHandler", "Lde/fraunhofer/aisec/cpg/frontends/typescript/ExpressionHandler;", "getExpressionHandler", "()Lde/fraunhofer/aisec/cpg/frontends/typescript/ExpressionHandler;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "statementHandler", "Lde/fraunhofer/aisec/cpg/frontends/typescript/StatementHandler;", "getStatementHandler", "()Lde/fraunhofer/aisec/cpg/frontends/typescript/StatementHandler;", "typeHandler", "Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeHandler;", "getTypeHandler", "()Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeHandler;", "getCodeFromRawNode", "T", "astNode", "(Ljava/lang/Object;)Ljava/lang/String;", "getIdentifierName", "node", "Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptNode;", "getIdentifierName$cpg_core", "getLocationFromRawNode", "Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "(Ljava/lang/Object;)Lde/fraunhofer/aisec/cpg/sarif/PhysicalLocation;", "getRegionFromStartEnd", "Lde/fraunhofer/aisec/cpg/sarif/Region;", "file", "Ljava/io/File;", "start", "", "end", "handleComments", "", "translationUnit", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "handleDecorator", "Lde/fraunhofer/aisec/cpg/graph/Annotation;", "parse", "processAnnotations", "Lde/fraunhofer/aisec/cpg/graph/Node;", "setComment", "S", "s", "ctx", "(Ljava/lang/Object;Ljava/lang/Object;)V", "Companion", "cpg-core"})
public final class TypeScriptLanguageFrontend
extends LanguageFrontend {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final DeclarationHandler declarationHandler;
    @NotNull
    private final StatementHandler statementHandler;
    @NotNull
    private final ExpressionHandler expressionHandler;
    @NotNull
    private final TypeHandler typeHandler;
    @Nullable
    private String currentFileContent;
    @NotNull
    private final ObjectMapper mapper;
    @JvmField
    @NotNull
    public static List<String> TYPESCRIPT_EXTENSIONS;
    @JvmField
    @NotNull
    public static List<String> JAVASCRIPT_EXTENSIONS;
    @NotNull
    private static final File parserFile;

    public TypeScriptLanguageFrontend(@NotNull TranslationConfiguration config, @Nullable ScopeManager scopeManager) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, scopeManager, ".");
        this.declarationHandler = new DeclarationHandler(this);
        this.statementHandler = new StatementHandler(this);
        this.expressionHandler = new ExpressionHandler(this);
        this.typeHandler = new TypeHandler(this);
        this.mapper = ExtensionsKt.jacksonObjectMapper();
    }

    @NotNull
    public final DeclarationHandler getDeclarationHandler() {
        return this.declarationHandler;
    }

    @NotNull
    public final StatementHandler getStatementHandler() {
        return this.statementHandler;
    }

    @NotNull
    public final ExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }

    @NotNull
    public final TypeHandler getTypeHandler() {
        return this.typeHandler;
    }

    @Nullable
    public final String getCurrentFileContent() {
        return this.currentFileContent;
    }

    public final void setCurrentFileContent(@Nullable String string) {
        this.currentFileContent = string;
    }

    @NotNull
    public final ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    @NotNull
    public TranslationUnitDeclaration parse(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.currentFileContent = FilesKt.readText$default((File)file, null, (int)1, null);
        if (!parserFile.exists()) {
            throw new TranslationException("parser.js not found @ " + parserFile.getAbsolutePath());
        }
        String[] stringArray = new String[]{"node", parserFile.getAbsolutePath(), file.getAbsolutePath()};
        Process p = Runtime.getRuntime().exec(stringArray);
        TypeScriptNode node = (TypeScriptNode)this.mapper.readValue(p.getInputStream(), TypeScriptNode.class);
        TypeManager.getInstance().setLanguageFrontend(this);
        Object s = this.declarationHandler.handle(node);
        if (s == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration");
        }
        TranslationUnitDeclaration translationUnit = (TranslationUnitDeclaration)s;
        this.handleComments(file, translationUnit);
        return translationUnit;
    }

    public final void handleComments(@NotNull File file, @NotNull TranslationUnitDeclaration translationUnit) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)translationUnit, (String)"translationUnit");
        Regex regex = new Regex("(?:/\\*((?:[^*]|(?:\\*+[^*/]))*)\\*+/)|(?://(.*))");
        String string = this.currentFileContent;
        Intrinsics.checkNotNull((Object)string);
        Sequence matches = Regex.findAll$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
        Iterable $this$forEach$iv = SequencesKt.toList((Sequence)matches);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchGroup it;
            MatchResult it2 = (MatchResult)element$iv;
            boolean bl = false;
            MatchGroupCollection groups = it2.getGroups();
            if (groups.get(0) == null) continue;
            boolean bl2 = false;
            String comment = it.getValue();
            Region commentRegion = this.getRegionFromStartEnd(file, it.getRange().getFirst(), it.getRange().getLast());
            Object object = groups.get(1);
            if (!(object != null && (object = object.getValue()) != null || (object = groups.get(2)) != null && (object = object.getValue()) != null)) {
                object = it.getValue();
            }
            comment = object;
            comment = ((Object)StringsKt.trim((CharSequence)comment)).toString();
            char[] cArray = new char[]{'\n'};
            comment = StringsKt.trim((String)comment, (char[])cArray);
            Region region = commentRegion;
            if (region == null) {
                PhysicalLocation physicalLocation = translationUnit.getLocation();
                Intrinsics.checkNotNull((Object)physicalLocation);
                Region region2 = physicalLocation.getRegion();
                region = region2;
                Intrinsics.checkNotNullExpressionValue((Object)region2, (String)"translationUnit.location!!.region");
            }
            FrontendUtils.Companion.matchCommentToNode(comment, region, translationUnit);
        }
    }

    @Override
    @Nullable
    public <T> String getCodeFromRawNode(T astNode) {
        if (astNode instanceof TypeScriptNode) {
            return ((TypeScriptNode)astNode).getCode();
        }
        return null;
    }

    @Override
    @Nullable
    public <T> PhysicalLocation getLocationFromRawNode(T astNode) {
        if (astNode instanceof TypeScriptNode) {
            int position = 0;
            position = ((TypeScriptNode)astNode).getLocation().getPos();
            String string = ((TypeScriptNode)astNode).getCode();
            if (string != null) {
                String it = string;
                boolean bl = false;
                String code = it;
                String string2 = this.currentFileContent;
                if (string2 != null) {
                    String it2 = string2;
                    boolean bl2 = false;
                    position = StringsKt.indexOf$default((CharSequence)it2, (String)code, (int)position, (boolean)false, (int)4, null);
                }
            }
            Region region = this.getRegionFromStartEnd(new File(((TypeScriptNode)astNode).getLocation().getFile()), position, ((TypeScriptNode)astNode).getLocation().getEnd());
            URI uRI = new File(((TypeScriptNode)astNode).getLocation().getFile()).toURI();
            Region region2 = region;
            if (region2 == null) {
                region2 = new Region();
            }
            return new PhysicalLocation(uRI, region2);
        }
        return null;
    }

    @Nullable
    public final Region getRegionFromStartEnd(@NotNull File file, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        lineNumberReader.skip(start);
        int startLine = lineNumberReader.getLineNumber() + 1;
        lineNumberReader.skip(end - start);
        int endLine = lineNumberReader.getLineNumber() + 1;
        String string = this.currentFileContent;
        Intrinsics.checkNotNull((Object)string);
        String translationUnitSignature = string;
        Region region = FrontendUtils.Companion.parseColumnPositionsFromFile(translationUnitSignature, end - start, start, startLine, endLine);
        return region;
    }

    @Override
    public <S, T> void setComment(S s, T ctx) {
    }

    @NotNull
    public final String getIdentifierName$cpg_core(@NotNull TypeScriptNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = this.getCodeFromRawNode(node.firstChild("Identifier"));
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void processAnnotations(@NotNull Node node, @NotNull TypeScriptNode astNode) {
        block2: {
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
            List<TypeScriptNode> list = astNode.getChildren();
            if (list == null) break block2;
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TypeScriptNode it = (TypeScriptNode)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"Decorator")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TypeScriptNode bl = (TypeScriptNode)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(this.handleDecorator((TypeScriptNode)it));
            }
            List it = (List)destination$iv$iv2;
            boolean bl = false;
            node.addAnnotations(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Annotation handleDecorator(TypeScriptNode node) {
        TypeScriptNode call = node.firstChild("CallExpression");
        if (call != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object s = this.expressionHandler.handle(call);
            if (s == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression");
            }
            CallExpression call2 = (CallExpression)s;
            String string = call2.getName();
            String string2 = this.getCodeFromRawNode(node);
            if (string2 == null) {
                string2 = "";
            }
            Annotation annotation = NodeBuilder.newAnnotation$default(string, string2, null, null, 12, null);
            List<Expression> list = call2.getArguments();
            Intrinsics.checkNotNullExpressionValue(list, (String)"call.arguments");
            Iterable iterable = list;
            Annotation annotation2 = annotation;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expression expression = (Expression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string3 = it.getCode();
                if (string3 == null) {
                    string3 = "";
                }
                collection.add(NodeBuilder.newAnnotationMember$default("", (Expression)it, string3, null, null, 24, null));
            }
            annotation2.setMembers((List)destination$iv$iv);
            call2.disconnectFromGraph();
            return annotation;
        }
        String name = this.getIdentifierName$cpg_core(node);
        String string = this.getCodeFromRawNode(node);
        if (string == null) {
            string = "";
        }
        Annotation annotation = NodeBuilder.newAnnotation$default(name, string, null, null, 12, null);
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream link;
        Companion = new Companion(null);
        Object[] objectArray = new String[]{".ts", ".tsx"};
        TYPESCRIPT_EXTENSIONS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{".js", ".jsx"};
        JAVASCRIPT_EXTENSIONS = CollectionsKt.listOf((Object[])objectArray);
        File file = File.createTempFile("parser", ".js");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(\"parser\", \".js\")");
        parserFile = file;
        InputStream inputStream = link = Companion.getClass().getResourceAsStream("/nodejs/parser.js");
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                LanguageFrontend.log.info("Extracting parser.js out of resources to {}", (Object)parserFile.getAbsoluteFile().toPath());
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Long l = Files.copy(it, parserFile.getAbsoluteFile().toPath(), copyOptionArray);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/fraunhofer/aisec/cpg/frontends/typescript/TypeScriptLanguageFrontend$Companion;", "", "()V", "JAVASCRIPT_EXTENSIONS", "", "", "TYPESCRIPT_EXTENSIONS", "parserFile", "Ljava/io/File;", "cpg-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

