/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends;

import de.fraunhofer.aisec.cpg.frontends.HandlerInterface;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ProblemNode;
import de.fraunhofer.aisec.cpg.helpers.Util;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.function.Supplier;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Handler<S, T, L extends LanguageFrontend> {
    protected static final Logger log = LoggerFactory.getLogger(Handler.class);
    protected final HashMap<Class<? extends T>, HandlerInterface<S, T>> map = new HashMap();
    private final Supplier<S> configConstructor;
    @NotNull
    protected L lang;
    @Nullable
    private final Class<?> typeOfT;

    public Handler(Supplier<S> configConstructor, @NotNull L lang) {
        this.configConstructor = configConstructor;
        this.lang = lang;
        this.typeOfT = this.retrieveTypeParameter();
    }

    public S handle(T ctx) {
        S ret;
        ASTNode astNode;
        if (ctx == null) {
            log.error("ctx is NULL. This can happen when ast children are optional in {}. Called by {}", this.getClass(), (Object)Thread.currentThread().getStackTrace()[2]);
            return null;
        }
        if (!((LanguageFrontend)this.lang).config.loadIncludes && ctx instanceof ASTNode && (astNode = (ASTNode)ctx).getFileLocation() != null && astNode.getFileLocation().getContextInclusionStatement() != null) {
            log.debug("Skip parsing include file" + astNode.getContainingFilename());
            return null;
        }
        Class<?> toHandle = ctx.getClass();
        HandlerInterface<S, T> handler = this.map.get(toHandle);
        while (handler == null) {
            handler = this.map.get(toHandle = toHandle.getSuperclass());
            if (handler != null && !ctx.getClass().getSimpleName().contains("LiteralExpr")) {
                Util.errorWithFileLocation(this.lang, ctx, log, "No handler for type {}, resolving for its superclass {}.", new Object[]{ctx.getClass(), toHandle});
            }
            if (toHandle != this.typeOfT && (this.typeOfT == null || this.typeOfT.isAssignableFrom(toHandle))) continue;
        }
        if (handler != null) {
            S s = handler.handle(ctx);
            if (s != null) {
                if (((Node)s).getLocation() == null) {
                    ((LanguageFrontend)this.lang).setCodeAndRegion(s, ctx);
                }
                ((LanguageFrontend)this.lang).setComment(s, ctx);
            }
            ret = s;
        } else {
            Util.errorWithFileLocation(this.lang, ctx, log, "Parsing of type {} is not supported (yet)", new Object[]{ctx.getClass()});
            ret = this.configConstructor.get();
            if (ret instanceof ProblemNode) {
                ProblemNode problem = (ProblemNode)ret;
                problem.setProblem(String.format("Parsing of type {} is not supported (yet)", ctx.getClass()));
            }
        }
        ((LanguageFrontend)this.lang).process(ctx, ret);
        return ret;
    }

    private Class<?> retrieveTypeParameter() {
        Class<?> clazz = this.getClass();
        while (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Handler.class)) {
            clazz = clazz.getSuperclass();
        }
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getActualTypeArguments()[1];
            return this.getBaseClass(rawType);
        }
        log.error("Could not determine generic type of raw AST node in handler");
        return null;
    }

    private Class<?> getBaseClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return this.getBaseClass(((ParameterizedType)type).getRawType());
        }
        return null;
    }
}

