/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg;

import de.fraunhofer.aisec.cpg.TestUtils;
import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.TranslationManager;
import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0007J@\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0007J:\u0010\u0011\u001a\u00020\u00052\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0013\u001a\u00020\u000eH\u0007J:\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0007J \u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0007J0\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u0004\"\n\b\u0000\u0010\u001f*\u0004\u0018\u00010\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!2\u0006\u0010\"\u001a\u00020\u0007H\u0007J8\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u0004\"\n\b\u0000\u0010\u001f*\u0004\u0018\u00010\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u0002H\u001f\u0018\u00010%H\u0007J/\u0010&\u001a\u0002H\u001f\"\n\b\u0000\u0010\u001f*\u0004\u0018\u00010\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!2\u0006\u0010\"\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010'J7\u0010(\u001a\u0002H\u001f\"\n\b\u0000\u0010\u001f*\u0004\u0018\u00010\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u0002H\u001f\u0018\u00010%H\u0007\u00a2\u0006\u0002\u0010)JE\u0010*\u001a\u0004\u0018\u0001H\u001f\"\n\b\u0000\u0010\u001f*\u0004\u0018\u00010\u00182\u0010\u0010+\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u00042\u000e\u0010,\u001a\n\u0012\u0004\u0012\u0002H\u001f\u0018\u00010-2\u0006\u0010\"\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010.J=\u0010/\u001a\u0004\u0018\u0001H\u001f\"\n\b\u0000\u0010\u001f*\u0004\u0018\u00010\u00182\b\u00100\u001a\u0004\u0018\u00010\u00182\u000e\u0010,\u001a\n\u0012\u0004\u0012\u0002H\u001f\u0018\u00010-2\u0006\u0010\"\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u00101J?\u00102\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u0004\"\n\b\u0000\u0010\u001f*\u0004\u0018\u00010\u0018\"\b\b\u0001\u00103*\u00020\u00182\u0006\u00104\u001a\u0002H32\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u001f0-H\u0007\u00a2\u0006\u0002\u00105J6\u00102\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u0004\"\n\b\u0000\u0010\u001f*\u0004\u0018\u00010\u00182\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00180!2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u001f0-H\u0007\u00a8\u00067"}, d2={"Lde/fraunhofer/aisec/cpg/TestUtils;", "", "()V", "analyze", "", "Lde/fraunhofer/aisec/cpg/graph/declarations/TranslationUnitDeclaration;", "fileExtension", "", "topLevel", "Ljava/nio/file/Path;", "usePasses", "", "configModifier", "Ljava/util/function/Consumer;", "Lde/fraunhofer/aisec/cpg/TranslationConfiguration$Builder;", "files", "Ljava/io/File;", "analyzeAndGetFirstTU", "analyzeWithBuilder", "builder", "analyzeWithResult", "Lde/fraunhofer/aisec/cpg/TranslationResult;", "compareLineFromLocationIfExists", "n", "Lde/fraunhofer/aisec/cpg/graph/Node;", "startLine", "toCompare", "", "disableTypeManagerCleanup", "", "findByName", "S", "nodes", "", "name", "findByPredicate", "predicate", "Ljava/util/function/Predicate;", "findByUniqueName", "(Ljava/util/Collection;Ljava/lang/String;)Lde/fraunhofer/aisec/cpg/graph/Node;", "findByUniquePredicate", "(Ljava/util/Collection;Ljava/util/function/Predicate;)Lde/fraunhofer/aisec/cpg/graph/Node;", "getOfTypeWithName", "listOfNodes", "specificClass", "Ljava/lang/Class;", "(Ljava/util/List;Ljava/lang/Class;Ljava/lang/String;)Lde/fraunhofer/aisec/cpg/graph/Node;", "getSubnodeOfTypeWithName", "root", "(Lde/fraunhofer/aisec/cpg/graph/Node;Ljava/lang/Class;Ljava/lang/String;)Lde/fraunhofer/aisec/cpg/graph/Node;", "subnodesOfType", "T", "node", "(Lde/fraunhofer/aisec/cpg/graph/Node;Ljava/lang/Class;)Ljava/util/List;", "roots", "cpg-core_testFixtures"})
public final class TestUtils {
    @NotNull
    public static final TestUtils INSTANCE = new TestUtils();

    private TestUtils() {
    }

    @JvmStatic
    public static final <S extends Node> S findByUniquePredicate(@NotNull Collection<? extends S> nodes, @Nullable Predicate<S> predicate) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        List<S> results = TestUtils.findByPredicate(nodes, predicate);
        Assertions.assertEquals((int)1, (int)results.size(), (String)Intrinsics.stringPlus((String)"Expected exactly one node matching the predicate: ", (Object)CollectionsKt.joinToString$default((Iterable)results, (CharSequence)",", null, null, (int)0, null, (Function1)findByUniquePredicate.1.INSTANCE, (int)30, null)));
        return (S)((Node)results.get(0));
    }

    @JvmStatic
    @NotNull
    public static final <S extends Node> List<S> findByPredicate(@NotNull Collection<? extends S> nodes, @Nullable Predicate<S> predicate) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        List list = nodes.stream().filter(predicate).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"nodes.stream().filter(pr\u2026lect(Collectors.toList())");
        return list;
    }

    @JvmStatic
    public static final <S extends Node> S findByUniqueName(@NotNull Collection<? extends S> nodes, @NotNull String name) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (S)TestUtils.findByUniquePredicate(nodes, arg_0 -> TestUtils.findByUniqueName$lambda-0(name, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final <S extends Node> List<S> findByName(@NotNull Collection<? extends S> nodes, @NotNull String name) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TestUtils.findByPredicate(nodes, arg_0 -> TestUtils.findByName$lambda-1(name, arg_0));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<TranslationUnitDeclaration> analyze(@Nullable String fileExtension, @NotNull Path topLevel, boolean usePasses, @Nullable Consumer<TranslationConfiguration.Builder> configModifier) throws Exception {
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        List files = Files.walk(topLevel, Integer.MAX_VALUE, new FileVisitOption[0]).map(TestUtils::analyze$lambda-2).filter(TestUtils::analyze$lambda-3).filter(arg_0 -> TestUtils.analyze$lambda-4(fileExtension, arg_0)).sorted().collect(Collectors.toList());
        return TestUtils.analyze(files, topLevel, usePasses, configModifier);
    }

    public static /* synthetic */ List analyze$default(String string, Path path, boolean bl, Consumer consumer, int n, Object object) throws Exception {
        if ((n & 8) != 0) {
            consumer = null;
        }
        return TestUtils.analyze(string, path, bl, (Consumer<TranslationConfiguration.Builder>)consumer);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<TranslationUnitDeclaration> analyze(@Nullable List<? extends File> files, @NotNull Path topLevel, boolean usePasses, @Nullable Consumer<TranslationConfiguration.Builder> configModifier) throws Exception {
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        List list = TestUtils.analyzeWithResult(files, topLevel, usePasses, configModifier).getTranslationUnits();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"analyzeWithResult(files,\u2026odifier).translationUnits");
        return list;
    }

    public static /* synthetic */ List analyze$default(List list, Path path, boolean bl, Consumer consumer, int n, Object object) throws Exception {
        if ((n & 8) != 0) {
            consumer = null;
        }
        return TestUtils.analyze(list, path, bl, (Consumer<TranslationConfiguration.Builder>)consumer);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final TranslationResult analyzeWithResult(@Nullable List<? extends File> files, @NotNull Path topLevel, boolean usePasses, @Nullable Consumer<TranslationConfiguration.Builder> configModifier) throws Exception {
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        TranslationConfiguration.Builder builder = TranslationConfiguration.builder().sourceLocations(files).topLevel(topLevel.toFile()).loadIncludes(true).disableCleanup().debugParser(true).failOnError(true).typeSystemActiveInFrontend(false).useParallelFrontends(true).defaultLanguages();
        if (usePasses) {
            builder.defaultPasses();
        }
        Consumer<TranslationConfiguration.Builder> consumer = configModifier;
        if (consumer != null) {
            consumer.accept(builder);
        }
        TranslationConfiguration config = builder.build();
        TranslationManager.Builder builder2 = TranslationManager.Companion.builder();
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"config");
        TranslationManager analyzer = builder2.config(config).build();
        Object t = analyzer.analyze().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"analyzer.analyze().get()");
        return (TranslationResult)t;
    }

    public static /* synthetic */ TranslationResult analyzeWithResult$default(List list, Path path, boolean bl, Consumer consumer, int n, Object object) throws Exception {
        if ((n & 8) != 0) {
            consumer = null;
        }
        return TestUtils.analyzeWithResult(list, path, bl, consumer);
    }

    @JvmStatic
    @NotNull
    public static final List<TranslationUnitDeclaration> analyzeWithBuilder(@NotNull TranslationConfiguration.Builder builder) throws Exception {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        TranslationConfiguration config = builder.build();
        TranslationManager.Builder builder2 = TranslationManager.Companion.builder();
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"config");
        TranslationManager analyzer = builder2.config(config).build();
        List list = ((TranslationResult)analyzer.analyze().get()).getTranslationUnits();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"analyzer.analyze().get().translationUnits");
        return list;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final TranslationUnitDeclaration analyzeAndGetFirstTU(@Nullable List<? extends File> files, @NotNull Path topLevel, boolean usePasses, @Nullable Consumer<TranslationConfiguration.Builder> configModifier) throws Exception {
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        List<TranslationUnitDeclaration> translationUnits = TestUtils.analyze(files, topLevel, usePasses, configModifier);
        Object e = translationUnits.stream().findFirst().orElseThrow();
        Intrinsics.checkNotNullExpressionValue(e, (String)"translationUnits.stream(\u2026findFirst().orElseThrow()");
        return (TranslationUnitDeclaration)e;
    }

    public static /* synthetic */ TranslationUnitDeclaration analyzeAndGetFirstTU$default(List list, Path path, boolean bl, Consumer consumer, int n, Object object) throws Exception {
        if ((n & 8) != 0) {
            consumer = null;
        }
        return TestUtils.analyzeAndGetFirstTU(list, path, bl, consumer);
    }

    @JvmStatic
    public static final void disableTypeManagerCleanup() throws IllegalAccessException {
        TypeManager spy = (TypeManager)Mockito.spy((Object)TypeManager.getInstance());
        ((TypeManager)Mockito.doNothing().when((Object)spy)).cleanup();
        FieldUtils.writeStaticField(TypeManager.class, (String)"INSTANCE", (Object)spy, (boolean)true);
    }

    @JvmStatic
    @Nullable
    public static final <S extends Node> S getOfTypeWithName(@Nullable List<? extends Node> listOfNodes, @Nullable Class<S> specificClass, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List listOfNodesWithName = Util.filterCast(listOfNodes, specificClass).stream().filter(arg_0 -> TestUtils.getOfTypeWithName$lambda-5(name, arg_0)).collect(Collectors.toList());
        return (S)(listOfNodesWithName.isEmpty() ? (Node)null : (Node)listOfNodesWithName.get(0));
    }

    @JvmStatic
    @Nullable
    public static final <S extends Node> S getSubnodeOfTypeWithName(@Nullable Node root, @Nullable Class<S> specificClass, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TestUtils.getOfTypeWithName(SubgraphWalker.flattenAST((Node)root), specificClass, name);
    }

    @JvmStatic
    @NotNull
    public static final <S extends Node, T extends Node> List<S> subnodesOfType(@NotNull T node, @NotNull Class<S> specificClass) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter(specificClass, (String)"specificClass");
        List list = Util.filterCast((List)SubgraphWalker.flattenAST(node), specificClass).stream().filter(Util.distinctByIdentity()).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"filterCast(SubgraphWalke\u2026lect(Collectors.toList())");
        return list;
    }

    @JvmStatic
    @NotNull
    public static final <S extends Node> List<S> subnodesOfType(@NotNull Collection<? extends Node> roots, @NotNull Class<S> specificClass) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter(specificClass, (String)"specificClass");
        List list = roots.stream().map(arg_0 -> TestUtils.subnodesOfType$lambda-6(specificClass, arg_0)).flatMap(TestUtils::subnodesOfType$lambda-7).filter(Util.distinctByIdentity()).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"roots\n            .strea\u2026lect(Collectors.toList())");
        return list;
    }

    @JvmStatic
    public static final boolean compareLineFromLocationIfExists(@NotNull Node n, boolean startLine, int toCompare) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        PhysicalLocation physicalLocation = n.getLocation();
        if (physicalLocation == null) {
            return false;
        }
        PhysicalLocation loc = physicalLocation;
        return startLine ? loc.getRegion().getStartLine() == toCompare : loc.getRegion().getEndLine() == toCompare;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<TranslationUnitDeclaration> analyze(@Nullable String fileExtension, @NotNull Path topLevel, boolean usePasses) throws Exception {
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        return TestUtils.analyze$default(fileExtension, topLevel, usePasses, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<TranslationUnitDeclaration> analyze(@Nullable List<? extends File> files, @NotNull Path topLevel, boolean usePasses) throws Exception {
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        return TestUtils.analyze$default(files, topLevel, usePasses, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final TranslationResult analyzeWithResult(@Nullable List<? extends File> files, @NotNull Path topLevel, boolean usePasses) throws Exception {
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        return TestUtils.analyzeWithResult$default(files, topLevel, usePasses, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final TranslationUnitDeclaration analyzeAndGetFirstTU(@Nullable List<? extends File> files, @NotNull Path topLevel, boolean usePasses) throws Exception {
        Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
        return TestUtils.analyzeAndGetFirstTU$default(files, topLevel, usePasses, null, 8, null);
    }

    private static final boolean findByUniqueName$lambda-0(String $name, Node m) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Node node = m;
        Intrinsics.checkNotNull((Object)node);
        return Intrinsics.areEqual((Object)node.getName(), (Object)$name);
    }

    private static final boolean findByName$lambda-1(String $name, Node m) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Node node = m;
        Intrinsics.checkNotNull((Object)node);
        return Intrinsics.areEqual((Object)node.getName(), (Object)$name);
    }

    private static final File analyze$lambda-2(Path obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.toFile();
    }

    private static final boolean analyze$lambda-3(File obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.isFile();
    }

    private static final boolean analyze$lambda-4(String $fileExtension, File f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        String string = f.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.name");
        String string2 = $fileExtension;
        Intrinsics.checkNotNull((Object)string2);
        return StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null);
    }

    private static final boolean getOfTypeWithName$lambda-5(String $name, Node s) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Node node = s;
        Intrinsics.checkNotNull((Object)node);
        return Intrinsics.areEqual((Object)node.getName(), (Object)$name);
    }

    private static final List subnodesOfType$lambda-6(Class $specificClass, Node it) {
        Intrinsics.checkNotNullParameter((Object)$specificClass, (String)"$specificClass");
        return TestUtils.subnodesOfType(it, $specificClass);
    }

    private static final Stream subnodesOfType$lambda-7(List it) {
        return it.stream();
    }
}

